/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.configuration.impl.spark;

import org.osgi.service.cm.ConfigurationAdmin;
import org.pentaho.capabilities.api.ICapability;
import org.pentaho.capabilities.api.ICapabilityManager;
import org.pentaho.capabilities.impl.DefaultCapabilityManager;
import org.pentaho.di.ExecutionConfiguration;
import org.pentaho.di.base.AbstractMeta;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.engine.configuration.api.RunConfiguration;
import org.pentaho.di.engine.configuration.api.RunConfigurationExecutor;
import org.pentaho.di.engine.configuration.impl.spark.SparkRunConfiguration;
import org.pentaho.di.repository.Repository;

public class SparkRunConfigurationExecutor
implements RunConfigurationExecutor {
    public static String JAAS_CAPABILITY_ID = "pentaho-kerberos-jaas";
    public static String AEL_SECURITY_CAPABILITY_ID = "ael-security";
    public static String DEFAULT_SCHEMA = "http";
    public static String DEFAULT_URL = "127.0.0.1:53000";
    private ConfigurationAdmin configurationAdmin;
    private ICapabilityManager capabilityManager = DefaultCapabilityManager.getInstance();

    public SparkRunConfigurationExecutor(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }

    public void execute(RunConfiguration runConfiguration, ExecutionConfiguration configuration, AbstractMeta meta, VariableSpace variableSpace, Repository repository) {
        ICapability securityCapability = this.capabilityManager.getCapabilityById(AEL_SECURITY_CAPABILITY_ID);
        ICapability jaasCapability = this.capabilityManager.getCapabilityById(JAAS_CAPABILITY_ID);
        if (securityCapability != null && securityCapability.isInstalled() && jaasCapability != null && !jaasCapability.isInstalled()) {
            jaasCapability.install();
        }
        SparkRunConfiguration sparkRunConfiguration = (SparkRunConfiguration)runConfiguration;
        String runConfigSchema = Const.NVL((String)sparkRunConfiguration.getSchema(), (String)"");
        String runConfigURL = Const.NVL((String)sparkRunConfiguration.getUrl(), (String)"");
        String engineScheme = Const.NVL((String)runConfigSchema, (String)DEFAULT_SCHEMA).trim();
        String engineUrl = Const.NVL((String)runConfigURL, (String)DEFAULT_URL).trim();
        variableSpace.setVariable("engine.scheme", engineScheme);
        variableSpace.setVariable("engine.url", engineUrl);
        variableSpace.setVariable("engine", "remote");
        variableSpace.setVariable("engine.remote", "spark");
    }
}

