/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.sql;

import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleSQLException;

public class SQLLimit {
    private String limitClause;
    private int limit;
    private int offset;

    public SQLLimit(String limitClause) throws KettleSQLException {
        this.limitClause = limitClause;
        this.parse();
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    private void parse() throws KettleSQLException {
        if (Const.isEmpty((String)this.limitClause)) {
            return;
        }
        this.limitClause = this.limitClause.replaceAll("\\s+", " ");
        if (this.limitClause.contains(",")) {
            String[] limitSplit = this.limitClause.split(",");
            if (limitSplit.length == 2) {
                this.offset = Integer.valueOf(limitSplit[0].trim());
                this.limit = Integer.valueOf(limitSplit[1].trim());
            }
            return;
        }
        if (this.limitClause.toUpperCase().contains("OFFSET")) {
            String[] limitSplit = this.limitClause.split(" ");
            if (limitSplit.length == 3) {
                this.offset = Integer.valueOf(limitSplit[2].trim());
                this.limit = Integer.valueOf(limitSplit[0].trim());
            }
            return;
        }
        try {
            this.limit = Integer.valueOf(this.limitClause.trim());
            this.offset = 0;
        }
        catch (NumberFormatException nfe) {
            throw new KettleSQLException("Invalid limit parameter in : " + this.limitClause);
        }
    }
}

