/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim.common.format.parquet.delegate.twitter;

import java.io.InputStream;
import java.net.URI;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.hadoop.shim.ShimConfigsLoader;
import org.pentaho.hadoop.shim.api.cluster.NamedCluster;
import org.pentaho.hadoop.shim.api.format.IParquetInputField;
import org.pentaho.hadoop.shim.api.format.IPentahoInputFormat;
import org.pentaho.hadoop.shim.api.format.IPentahoParquetInputFormat;
import org.pentaho.hadoop.shim.common.ConfigurationProxy;
import org.pentaho.hadoop.shim.common.format.HadoopFormatBase;
import org.pentaho.hadoop.shim.common.format.ReadFileFilter;
import org.pentaho.hadoop.shim.common.format.ReadFilesFilter;
import org.pentaho.hadoop.shim.common.format.S3NCredentialUtils;
import org.pentaho.hadoop.shim.common.format.parquet.ParquetInputFieldList;
import org.pentaho.hadoop.shim.common.format.parquet.PentahoInputSplitImpl;
import org.pentaho.hadoop.shim.common.format.parquet.delegate.twitter.ParquetConverter;
import org.pentaho.hadoop.shim.common.format.parquet.delegate.twitter.PentahoParquetReadSupport;
import org.pentaho.hadoop.shim.common.format.parquet.delegate.twitter.PentahoParquetRecordReader;
import parquet.hadoop.Footer;
import parquet.hadoop.ParquetFileReader;
import parquet.hadoop.ParquetInputFormat;
import parquet.hadoop.ParquetRecordReader;
import parquet.hadoop.api.ReadSupport;
import parquet.hadoop.metadata.ParquetMetadata;
import parquet.schema.MessageType;

public class PentahoTwitterInputFormat
extends HadoopFormatBase
implements IPentahoParquetInputFormat {
    private static final Logger logger = LogManager.getLogger(PentahoTwitterInputFormat.class);
    private ParquetInputFormat<RowMetaAndData> nativeParquetInputFormat;
    private Job job;

    public PentahoTwitterInputFormat(NamedCluster namedCluster) {
        logger.info("We are initializing parquet input format");
        this.inClassloader(() -> {
            ConfigurationProxy conf = new ConfigurationProxy();
            BiConsumer<InputStream, String> consumer = (is, filename) -> conf.addResource((InputStream)is, (String)filename);
            ShimConfigsLoader.addConfigsAsResources(namedCluster, consumer);
            this.job = Job.getInstance((Configuration)conf);
            this.nativeParquetInputFormat = new ParquetInputFormat();
            ParquetInputFormat.setReadSupportClass((Job)this.job, PentahoParquetReadSupport.class);
            ParquetInputFormat.setTaskSideMetaData((Job)this.job, (boolean)false);
        });
    }

    public void setSchema(List<IParquetInputField> inputFields) throws Exception {
        ParquetInputFieldList fieldList = new ParquetInputFieldList(inputFields);
        this.inClassloader(() -> this.job.getConfiguration().set("PentahoParquetSchema", fieldList.marshall()));
    }

    public void setInputFile(String file) throws Exception {
        this.inClassloader(() -> {
            S3NCredentialUtils util = new S3NCredentialUtils();
            util.applyS3CredentialsToHadoopConfigurationIfNecessary(file, this.job.getConfiguration());
            Path filePath = new Path(S3NCredentialUtils.scrubFilePathIfNecessary(file));
            FileSystem fs = FileSystem.get((URI)filePath.toUri(), (Configuration)this.job.getConfiguration());
            if (!fs.exists(filePath)) {
                throw new NoSuchFileException(file);
            }
            if (fs.getFileStatus(filePath).isDirectory()) {
                ParquetInputFormat.setInputPaths((Job)this.job, (Path[])new Path[]{filePath});
                ParquetInputFormat.setInputDirRecursive((Job)this.job, (boolean)true);
            } else {
                ParquetInputFormat.setInputPaths((Job)this.job, (Path[])new Path[]{filePath.getParent()});
                ParquetInputFormat.setInputDirRecursive((Job)this.job, (boolean)false);
                ParquetInputFormat.setInputPathFilter((Job)this.job, ReadFileFilter.class);
                this.job.getConfiguration().set("PentahoParquetFilterDir", filePath.getParent().toString());
                this.job.getConfiguration().set("PentahoParquetFilterFile", filePath.toString());
            }
        });
    }

    public void setInputFiles(String[] files) throws Exception {
        this.inClassloader(() -> {
            boolean pathIsDir = false;
            CharSequence[] filePaths = new String[files.length];
            int i = 0;
            for (String file : files) {
                S3NCredentialUtils util = new S3NCredentialUtils();
                util.applyS3CredentialsToHadoopConfigurationIfNecessary(file, this.job.getConfiguration());
                Path filePath = new Path(S3NCredentialUtils.scrubFilePathIfNecessary(file));
                FileSystem fs = FileSystem.get((URI)filePath.toUri(), (Configuration)this.job.getConfiguration());
                filePath = fs.makeQualified(filePath);
                if (!fs.exists(filePath)) {
                    throw new NoSuchFileException(file);
                }
                filePaths[i++] = filePath.getName();
                if (!fs.getFileStatus(filePath).isDirectory()) continue;
                pathIsDir = true;
            }
            if (pathIsDir) {
                FileInputFormat.setInputPaths((Job)this.job, (String)String.join((CharSequence)",", filePaths));
                FileInputFormat.setInputDirRecursive((Job)this.job, (boolean)true);
                this.job.getConfiguration().set("PentahoParquetDir", "true");
            } else {
                FileInputFormat.setInputPaths((Job)this.job, (String)String.join((CharSequence)",", filePaths));
                FileInputFormat.setInputDirRecursive((Job)this.job, (boolean)false);
                FileInputFormat.setInputPathFilter((Job)this.job, ReadFilesFilter.class);
                this.job.getConfiguration().set("PentahoParquetFile", "true");
            }
        });
    }

    public void setSplitSize(long blockSize) throws Exception {
        this.inClassloader(() -> {});
    }

    public List<IPentahoInputFormat.IPentahoInputSplit> getSplits() {
        return this.inClassloader(() -> {
            List splits = this.nativeParquetInputFormat.getSplits((JobContext)this.job);
            return splits.stream().map(PentahoInputSplitImpl::new).collect(Collectors.toList());
        });
    }

    public IPentahoInputFormat.IPentahoRecordReader createRecordReader(IPentahoInputFormat.IPentahoInputSplit split) throws Exception {
        return this.inClassloader(() -> {
            PentahoInputSplitImpl pentahoInputSplit = (PentahoInputSplitImpl)split;
            InputSplit inputSplit = pentahoInputSplit.getInputSplit();
            PentahoParquetReadSupport readSupport = new PentahoParquetReadSupport();
            ParquetRecordReader nativeRecordReader = new ParquetRecordReader((ReadSupport)readSupport, ParquetInputFormat.getFilter((Configuration)this.job.getConfiguration()));
            TaskAttemptContextImpl task = new TaskAttemptContextImpl(this.job.getConfiguration(), new TaskAttemptID());
            nativeRecordReader.initialize(inputSplit, (TaskAttemptContext)task);
            return new PentahoParquetRecordReader((ParquetRecordReader<RowMetaAndData>)nativeRecordReader);
        });
    }

    public List<IParquetInputField> readSchema(String file) throws Exception {
        return this.inClassloader(() -> {
            Configuration conf = this.job.getConfiguration();
            S3NCredentialUtils util = new S3NCredentialUtils();
            util.applyS3CredentialsToHadoopConfigurationIfNecessary(file, conf);
            Path filePath = new Path(S3NCredentialUtils.scrubFilePathIfNecessary(file));
            FileSystem fs = FileSystem.get((URI)filePath.toUri(), (Configuration)conf);
            FileStatus fileStatus = fs.getFileStatus(filePath);
            List footers = ParquetFileReader.readFooters((Configuration)conf, (FileStatus)fileStatus, (boolean)true);
            if (footers.isEmpty()) {
                return new ArrayList();
            }
            ParquetMetadata meta = ((Footer)footers.get(0)).getParquetMetadata();
            MessageType schema = meta.getFileMetaData().getSchema();
            return ParquetConverter.buildInputFields(schema);
        });
    }
}

