/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.hbase.factory;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.pentaho.hbase.factory.HBaseAdmin;

class HBase10Admin
implements HBaseAdmin {
    private final Admin admin;

    HBase10Admin(Connection conn) throws IOException {
        this.admin = conn.getAdmin();
    }

    @Override
    public boolean tableExists(String tableName) throws IOException {
        return this.admin.tableExists(TableName.valueOf((String)tableName));
    }

    @Override
    public HTableDescriptor[] listTables() throws IOException {
        return this.admin.listTables();
    }

    @Override
    public boolean isTableDisabled(String tableName) throws IOException {
        return this.admin.isTableDisabled(TableName.valueOf((String)tableName));
    }

    @Override
    public boolean isTableEnabled(String tableName) throws IOException {
        return this.admin.isTableEnabled(TableName.valueOf((String)tableName));
    }

    @Override
    public boolean isTableAvailable(String tableName) throws IOException {
        return this.admin.isTableAvailable(TableName.valueOf((String)tableName));
    }

    @Override
    public HTableDescriptor getTableDescriptor(byte[] tableName) throws IOException {
        return this.admin.getTableDescriptor(TableName.valueOf((byte[])tableName));
    }

    @Override
    public void enableTable(String tableName) throws IOException {
        this.admin.enableTable(TableName.valueOf((String)tableName));
    }

    @Override
    public void disableTable(String tableName) throws IOException {
        this.admin.disableTable(TableName.valueOf((String)tableName));
    }

    @Override
    public void deleteTable(String tableName) throws IOException {
        this.admin.deleteTable(TableName.valueOf((String)tableName));
    }

    @Override
    public void createTable(HTableDescriptor tableDesc) throws IOException {
        boolean useInterface = false;
        String tableDescriptorInterface = "org.apache.hadoop.hbase.client.TableDescriptor";
        for (Class<?> descInterface : tableDesc.getClass().getInterfaces()) {
            if (!descInterface.getName().equals(tableDescriptorInterface)) continue;
            useInterface = true;
            break;
        }
        try {
            if (useInterface) {
                this.admin.getClass().getMethod("createTable", Class.forName(tableDescriptorInterface)).invoke((Object)this.admin, tableDesc);
            } else {
                this.admin.getClass().getMethod("createTable", HTableDescriptor.class).invoke((Object)this.admin, tableDesc);
            }
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    @Override
    public void close() throws IOException {
        this.admin.close();
    }

    @Override
    public List<String> listNamespaces() throws Exception {
        NamespaceDescriptor[] namespaceDescriptors = this.admin.listNamespaceDescriptors();
        return Stream.of(namespaceDescriptors).map(NamespaceDescriptor::getName).collect(Collectors.toList());
    }

    @Override
    public List<String> listTableNamesByNamespace(String namespace) throws Exception {
        TableName[] tableNames = this.admin.listTableNamesByNamespace(namespace);
        return Stream.of(tableNames).map(TableName::getNameAsString).collect(Collectors.toList());
    }
}

