/*
 * Decompiled with CFR 0.152.
 */
package com.hitachivantara.security.web.impl.client.csrf.jaxrsv1.util.internal;

import com.hitachivantara.security.web.impl.client.csrf.jaxrsv1.CsrfToken;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandler;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.filter.ClientFilter;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.net.CookieHandler;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.MultivaluedMap;

public final class CsrfUtil {
    public static final String RESPONSE_HEADER_HEADER = "X-CSRF-HEADER";
    public static final String RESPONSE_HEADER_PARAM = "X-CSRF-PARAM";
    public static final String RESPONSE_HEADER_TOKEN = "X-CSRF-TOKEN";

    private CsrfUtil() {
    }

    public static boolean isTokenResponseSuccessful(@NonNull ClientResponse response) {
        return response.getStatus() == 204;
    }

    public static CsrfToken readResponseToken(@NonNull ClientResponse response) {
        String token = CsrfUtil.getResponseHeaderString(response, RESPONSE_HEADER_TOKEN);
        if (token == null || token.length() == 0) {
            return null;
        }
        String header = CsrfUtil.getResponseHeaderString(response, RESPONSE_HEADER_HEADER);
        String parameter = CsrfUtil.getResponseHeaderString(response, RESPONSE_HEADER_PARAM);
        return new CsrfToken(header, parameter, token);
    }

    private static String getResponseHeaderString(ClientResponse response, String name) {
        List values = (List)response.getHeaders().get((Object)name);
        if (values == null) {
            return null;
        }
        if (values.isEmpty()) {
            return "";
        }
        return String.join((CharSequence)",", values);
    }

    public static boolean hasClientFilter(@NonNull Client client, @NonNull Class<? extends ClientFilter> clientFilterClass) {
        ClientFilter filter;
        ClientHandler handler = client.getHeadHandler();
        do {
            if (!(handler instanceof ClientFilter)) {
                return false;
            }
            filter = (ClientFilter)handler;
            if (!clientFilterClass.isAssignableFrom(filter.getClass())) continue;
            return true;
        } while ((handler = filter.getNext()) != null);
        return false;
    }

    public static Map<String, List<String>> serializeHeaders(MultivaluedMap<String, Object> headers) {
        if (headers == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, List<String>> stringHeaders = new LinkedHashMap<String, List<String>>(headers.size());
        for (Map.Entry entry : headers.entrySet()) {
            stringHeaders.put((String)entry.getKey(), ((List)entry.getValue()).stream().map(ClientRequest::getHeaderValue).collect(Collectors.toList()));
        }
        return stringHeaders;
    }

    public static Stream<Cookie> getCookieStreamForRequest(CookieHandler cookieHandler, ClientRequest request) throws IOException {
        Map<String, List<String>> cookiesHeadersMap = cookieHandler.get(request.getURI(), CsrfUtil.serializeHeaders((MultivaluedMap<String, Object>)request.getHeaders()));
        List<String> cookiesText = cookiesHeadersMap.get("Cookie");
        if (cookiesText == null) {
            cookiesText = Collections.emptyList();
        }
        return cookiesText.stream().filter(cookieText -> !"$Version=\"1\"".equals(cookieText)).map(Cookie::valueOf);
    }
}

