/*
 * Decompiled with CFR 0.152.
 */
package com.hitachivantara.security.web.impl.client.csrf.jaxrsv1.util;

import com.hitachivantara.security.web.impl.client.csrf.jaxrsv1.util.internal.CsrfUtil;
import com.sun.jersey.api.client.ClientHandler;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.filter.ClientFilter;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.core.NewCookie;

public class SessionCookiesFilter
extends ClientFilter {
    @NonNull
    private final CookieHandler cookieHandler;

    public SessionCookiesFilter() {
        this(null);
    }

    public SessionCookiesFilter(@Nullable CookieHandler cookieHandler) {
        this.cookieHandler = cookieHandler != null ? cookieHandler : new CookieManager();
    }

    public ClientResponse handle(ClientRequest request) throws ClientHandlerException {
        try {
            CsrfUtil.getCookieStreamForRequest(this.cookieHandler, request).forEach(cookie -> request.getHeaders().add((Object)"Cookie", cookie));
        }
        catch (IOException e) {
            throw new ClientHandlerException("Could not add cookies to the request.", (Throwable)e);
        }
        ClientResponse response = this.getNextNotFinal().handle(request);
        List newCookiesText = response.getCookies().stream().map(NewCookie::toString).filter(cookieText -> cookieText != null && !cookieText.isEmpty()).collect(Collectors.toList());
        if (!newCookiesText.isEmpty()) {
            HashMap<String, List<String>> responseHeadersMap = new HashMap<String, List<String>>();
            responseHeadersMap.put("Set-Cookie", newCookiesText);
            try {
                this.cookieHandler.put(request.getURI(), responseHeadersMap);
            }
            catch (IOException e) {
                throw new ClientHandlerException("Could not save response cookies.", (Throwable)e);
            }
        }
        return response;
    }

    ClientHandler getNextNotFinal() {
        return this.getNext();
    }
}

