/*
 * Decompiled with CFR 0.152.
 */
package com.hitachivantara.security.web.impl.client.csrf.jaxrsv1;

import com.hitachivantara.security.web.impl.client.csrf.jaxrsv1.CsrfToken;
import com.hitachivantara.security.web.impl.client.csrf.jaxrsv1.util.SessionCookiesFilter;
import com.hitachivantara.security.web.impl.client.csrf.jaxrsv1.util.internal.CsrfUtil;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.filter.ClientFilter;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.URI;
import java.util.Objects;

public class CsrfTokenServiceClient {
    static final String QUERY_PARAM_URL = "url";
    @NonNull
    private final Client client;
    @NonNull
    private final URI serviceUri;

    public CsrfTokenServiceClient(@NonNull URI serviceUri, @NonNull Client client) {
        Objects.requireNonNull(serviceUri);
        Objects.requireNonNull(client);
        this.serviceUri = serviceUri;
        this.client = client;
        if (!CsrfUtil.hasClientFilter(client, SessionCookiesFilter.class)) {
            client.addFilter((ClientFilter)new SessionCookiesFilter());
        }
    }

    public CsrfTokenServiceClient(@NonNull URI serviceUri, @NonNull CookieHandler cookieHandler) {
        Objects.requireNonNull(serviceUri);
        this.serviceUri = serviceUri;
        this.client = Client.create();
        this.client.addFilter((ClientFilter)new SessionCookiesFilter(cookieHandler));
    }

    public CsrfTokenServiceClient(@NonNull URI serviceUri) {
        this(serviceUri, new CookieManager());
    }

    @Nullable
    public CsrfToken getToken(@NonNull URI protectedServiceUri) {
        Objects.requireNonNull(protectedServiceUri);
        ClientResponse response = (ClientResponse)this.client.resource(this.serviceUri).queryParam(QUERY_PARAM_URL, protectedServiceUri.toString()).get(ClientResponse.class);
        if (!CsrfUtil.isTokenResponseSuccessful(response)) {
            return null;
        }
        return CsrfUtil.readResponseToken(response);
    }
}

