/*
 * Decompiled with CFR 0.152.
 */
package com.hitachivantara.security.web.impl.client.csrf.jaxrsv1;

import com.hitachivantara.security.web.impl.client.csrf.jaxrsv1.CsrfToken;
import com.hitachivantara.security.web.impl.client.csrf.jaxrsv1.util.internal.CsrfUtil;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.filter.ClientFilter;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.net.URI;
import java.util.Objects;
import javax.ws.rs.core.UriBuilder;

public class CsrfTokenFilter
extends ClientFilter {
    static final String QUERY_PARAM_URL = "url";
    @NonNull
    private final URI serviceUri;

    public CsrfTokenFilter(@NonNull URI serviceUri) {
        this.serviceUri = Objects.requireNonNull(serviceUri);
    }

    public ClientResponse handle(ClientRequest request) throws ClientHandlerException {
        ClientResponse tokenResponse = this.handleNext(this.createTokenClientRequest(request));
        if (!CsrfUtil.isTokenResponseSuccessful(tokenResponse)) {
            return tokenResponse;
        }
        CsrfToken token = CsrfUtil.readResponseToken(tokenResponse);
        if (token != null) {
            request.getHeaders().add((Object)token.getHeader(), (Object)token.getToken());
        }
        return this.handleNext(request);
    }

    @NonNull
    private ClientRequest createTokenClientRequest(@NonNull ClientRequest request) {
        URI finalServiceUri = UriBuilder.fromUri((URI)this.serviceUri).queryParam(QUERY_PARAM_URL, new Object[]{request.getURI()}).build(new Object[0]);
        ClientRequest tokenRequest = this.newClientRequest(finalServiceUri, "GET");
        tokenRequest.getProperties().putAll(request.getProperties());
        return tokenRequest;
    }

    @NonNull
    ClientRequest newClientRequest(@NonNull URI uri, @NonNull String method) {
        return ClientRequest.create().build(uri, method);
    }

    @NonNull
    ClientResponse handleNext(@NonNull ClientRequest request) {
        return this.getNext().handle(request);
    }
}

