/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.elasticsearchbulk;

import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.ui.core.PropsUI;

public class LabelTimeComposite
extends Composite {
    private static final PropsUI props = PropsUI.getInstance();
    private Label wLabel;
    private Text wText;
    private CCombo wTimeUnit;
    private String lastValidValue = "";

    public LabelTimeComposite(Composite composite, String labelText, String toolTipText) {
        super(composite, 0);
        props.setLook((Control)this);
        int middle = props.getMiddlePct();
        int threeQuarters = (middle + 100) / 2;
        int margin = 4;
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 0;
        formLayout.marginHeight = 0;
        formLayout.marginTop = 0;
        formLayout.marginBottom = 0;
        this.setLayout((Layout)formLayout);
        this.wText = new Text((Composite)this, 18436);
        FormData fdText = new FormData();
        fdText.left = new FormAttachment(middle, margin);
        fdText.right = new FormAttachment(threeQuarters, 0);
        this.wText.setLayoutData((Object)fdText);
        this.wText.setToolTipText(toolTipText);
        this.wTimeUnit = new CCombo((Composite)this, 18436);
        FormData fdCombo = new FormData();
        fdCombo.left = new FormAttachment(threeQuarters, margin);
        fdCombo.right = new FormAttachment(100, 0);
        this.wTimeUnit.setEditable(false);
        this.wTimeUnit.setLayoutData((Object)fdCombo);
        this.wTimeUnit.setItems(this.getTimeUnits());
        this.wTimeUnit.setToolTipText(toolTipText);
        this.wLabel = new Label((Composite)this, 131072);
        props.setLook((Control)this.wLabel);
        this.wLabel.setText(labelText);
        FormData fdLabel = new FormData();
        fdLabel.left = new FormAttachment(0, 0);
        fdLabel.right = new FormAttachment(middle, 0);
        fdLabel.top = new FormAttachment((Control)this.wText, 0, 0x1000000);
        this.wLabel.setLayoutData((Object)fdLabel);
        this.wLabel.setToolTipText(toolTipText);
        this.wText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!StringUtils.isNumeric((String)LabelTimeComposite.this.wText.getText())) {
                    LabelTimeComposite.this.wText.setText(LabelTimeComposite.this.lastValidValue);
                } else {
                    LabelTimeComposite.this.lastValidValue = LabelTimeComposite.this.wText.getText();
                }
            }
        });
    }

    private String[] getTimeUnits() {
        ArrayList<String> timeUnits = new ArrayList<String>();
        for (TimeUnit timeUnit : TimeUnit.values()) {
            timeUnits.add(timeUnit.toString());
        }
        return timeUnits.toArray(new String[timeUnits.size()]);
    }

    public TimeUnit getTimeUnit() {
        return TimeUnit.valueOf(this.wTimeUnit.getItem(this.wTimeUnit.getSelectionIndex()));
    }

    public void setTimeUnit(TimeUnit tu) {
        for (int i = 0; i < this.wTimeUnit.getItemCount(); ++i) {
            if (!tu.toString().equals(this.wTimeUnit.getItem(i))) continue;
            this.wTimeUnit.select(i);
            break;
        }
    }

    public void addModifyListener(ModifyListener lsMod) {
        this.wText.addModifyListener(lsMod);
    }

    public void addSelectionListener(SelectionAdapter lsDef) {
        this.wText.addSelectionListener((SelectionListener)lsDef);
    }

    public void setText(String name) {
        this.wText.setText(name);
    }

    public String getText() {
        return this.wText.getText();
    }

    public void setEchoChar(char c) {
        this.wText.setEchoChar(c);
    }

    public void setEnabled(boolean flag) {
        this.wText.setEnabled(flag);
        this.wLabel.setEnabled(flag);
    }

    public boolean setFocus() {
        return this.wText.setFocus();
    }

    public void addTraverseListener(TraverseListener tl) {
        this.wText.addTraverseListener(tl);
    }

    public Text getTextWidget() {
        return this.wText;
    }

    public Label getLabelWidget() {
        return this.wLabel;
    }
}

