/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim.common.format.parquet.delegate.apache;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.FileAlreadyExistsException;
import java.util.List;
import java.util.function.BiConsumer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.hadoop.ParquetOutputFormat;
import org.apache.parquet.hadoop.ParquetRecordWriter;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.hadoop.shim.ShimConfigsLoader;
import org.pentaho.hadoop.shim.api.cluster.NamedCluster;
import org.pentaho.hadoop.shim.api.format.IParquetOutputField;
import org.pentaho.hadoop.shim.api.format.IPentahoOutputFormat;
import org.pentaho.hadoop.shim.api.format.IPentahoParquetOutputFormat;
import org.pentaho.hadoop.shim.api.format.org.pentaho.hadoop.shim.pvfs.api.PvfsHadoopBridgeFileSystemExtension;
import org.pentaho.hadoop.shim.common.ConfigurationProxy;
import org.pentaho.hadoop.shim.common.format.HadoopFormatBase;
import org.pentaho.hadoop.shim.common.format.S3NCredentialUtils;
import org.pentaho.hadoop.shim.common.format.parquet.delegate.apache.PentahoParquetRecordWriter;
import org.pentaho.hadoop.shim.common.format.parquet.delegate.apache.PentahoParquetWriteSupport;

public class PentahoApacheOutputFormat
extends HadoopFormatBase
implements IPentahoParquetOutputFormat {
    protected static final Logger logger = LogManager.getLogger(PentahoApacheOutputFormat.class);
    protected Job job;
    protected Path outputFile;
    private List<? extends IParquetOutputField> outputFields;

    public PentahoApacheOutputFormat() {
        this(null);
    }

    public PentahoApacheOutputFormat(NamedCluster namedCluster) {
        logger.info("We are initializing parquet output format");
        this.inClassloader(() -> {
            ConfigurationProxy conf = new ConfigurationProxy();
            if (namedCluster != null) {
                BiConsumer<InputStream, String> consumer = (is, filename) -> conf.addResource((InputStream)is, (String)filename);
                ShimConfigsLoader.addConfigsAsResources(namedCluster, consumer);
            }
            this.job = Job.getInstance((Configuration)conf);
            this.job.getConfiguration().set("parquet.enable.summary-metadata", "false");
            ParquetOutputFormat.setEnableDictionary((Job)this.job, (boolean)false);
        });
    }

    public void setFields(List<? extends IParquetOutputField> fields) {
        this.outputFields = fields;
    }

    public void setOutputFile(String file, boolean override) throws Exception {
        this.inClassloader(() -> {
            S3NCredentialUtils util = new S3NCredentialUtils();
            util.applyS3CredentialsToHadoopConfigurationIfNecessary(file, this.job.getConfiguration());
            this.outputFile = new Path(S3NCredentialUtils.scrubFilePathIfNecessary(file));
            FileSystem fs = FileSystem.get((URI)this.outputFile.toUri(), (Configuration)this.job.getConfiguration());
            if (fs.exists(this.outputFile)) {
                if (override) {
                    fs.delete(this.outputFile, true);
                } else {
                    throw new FileAlreadyExistsException(file);
                }
            }
            FileOutputFormat.setOutputPath((Job)this.job, (Path)this.outputFile.getParent());
        });
    }

    public void setVersion(IPentahoParquetOutputFormat.VERSION version) throws Exception {
        this.inClassloader(() -> {
            ParquetProperties.WriterVersion writerVersion;
            switch (version) {
                case VERSION_1_0: {
                    writerVersion = ParquetProperties.WriterVersion.PARQUET_1_0;
                    break;
                }
                case VERSION_2_0: {
                    writerVersion = ParquetProperties.WriterVersion.PARQUET_2_0;
                    break;
                }
                default: {
                    writerVersion = ParquetProperties.WriterVersion.PARQUET_2_0;
                }
            }
            this.job.getConfiguration().set("parquet.writer.version", writerVersion.toString());
        });
    }

    public void setCompression(IPentahoParquetOutputFormat.COMPRESSION comp) throws Exception {
        this.inClassloader(() -> {
            CompressionCodecName codec;
            switch (comp) {
                case SNAPPY: {
                    codec = CompressionCodecName.SNAPPY;
                    break;
                }
                case GZIP: {
                    codec = CompressionCodecName.GZIP;
                    break;
                }
                case LZO: {
                    codec = CompressionCodecName.LZO;
                    break;
                }
                default: {
                    codec = CompressionCodecName.UNCOMPRESSED;
                }
            }
            ParquetOutputFormat.setCompression((Job)this.job, (CompressionCodecName)codec);
        });
    }

    public void enableDictionary(boolean useDictionary) throws Exception {
        this.inClassloader(() -> ParquetOutputFormat.setEnableDictionary((Job)this.job, (boolean)useDictionary));
    }

    public void setRowGroupSize(int size) throws Exception {
        this.inClassloader(() -> ParquetOutputFormat.setBlockSize((Job)this.job, (int)size));
    }

    public void setDataPageSize(int size) throws Exception {
        this.inClassloader(() -> ParquetOutputFormat.setPageSize((Job)this.job, (int)size));
    }

    public void setDictionaryPageSize(int size) throws Exception {
        this.inClassloader(() -> ParquetOutputFormat.setDictionaryPageSize((Job)this.job, (int)size));
    }

    public IPentahoOutputFormat.IPentahoRecordWriter createRecordWriter() throws Exception {
        if (this.outputFile == null) {
            throw new IllegalStateException("Output file is not defined");
        }
        if (this.outputFields == null || this.outputFields.isEmpty()) {
            throw new IllegalStateException("Schema is not defined");
        }
        return this.inClassloader(() -> {
            FixedParquetOutputFormat nativeParquetOutputFormat = new FixedParquetOutputFormat(new PentahoParquetWriteSupport(this.outputFields));
            TaskAttemptID taskAttemptID = new TaskAttemptID("qq", 111, TaskType.MAP, 11, 11);
            TaskAttemptContextImpl task = new TaskAttemptContextImpl(this.job.getConfiguration(), taskAttemptID);
            try {
                ParquetRecordWriter recordWriter = (ParquetRecordWriter)nativeParquetOutputFormat.getRecordWriter((TaskAttemptContext)task);
                return new PentahoParquetRecordWriter((ParquetRecordWriter<RowMetaAndData>)recordWriter, (TaskAttemptContext)task);
            }
            catch (IOException e) {
                throw new IllegalStateException("Some error accessing parquet files", e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.error(e.getMessage(), (Throwable)e);
                throw new IllegalStateException("This should never happen " + e);
            }
        });
    }

    public String generateAlias(String pvfsPath) {
        return this.inClassloader(() -> {
            if (pvfsPath.startsWith("s3")) {
                S3NCredentialUtils util = new S3NCredentialUtils();
                util.applyS3CredentialsToHadoopConfigurationIfNecessary(pvfsPath, this.job.getConfiguration());
                return S3NCredentialUtils.scrubFilePathIfNecessary(pvfsPath);
            }
            FileSystem fs = FileSystem.get((URI)StringUtil.toUri((String)pvfsPath), (Configuration)this.job.getConfiguration());
            if (fs instanceof PvfsHadoopBridgeFileSystemExtension) {
                return ((PvfsHadoopBridgeFileSystemExtension)fs).generateAlias(pvfsPath);
            }
            return null;
        });
    }

    public class FixedParquetOutputFormat
    extends ParquetOutputFormat<RowMetaAndData> {
        public FixedParquetOutputFormat(PentahoParquetWriteSupport writeSupport) {
            super((WriteSupport)writeSupport);
        }

        public Path getDefaultWorkFile(TaskAttemptContext context, String extension) throws IOException {
            return PentahoApacheOutputFormat.this.outputFile;
        }
    }
}

