/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.impl.shim.mapreduce;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.pentaho.big.data.impl.shim.mapreduce.RunningJobMapReduceJobAdvancedImpl;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.hadoop.shim.api.cluster.NamedCluster;
import org.pentaho.hadoop.shim.api.internal.Configuration;
import org.pentaho.hadoop.shim.api.internal.fs.FileSystem;
import org.pentaho.hadoop.shim.api.internal.fs.Path;
import org.pentaho.hadoop.shim.api.mapreduce.MapReduceJobAdvanced;
import org.pentaho.hadoop.shim.api.mapreduce.MapReduceJobBuilder;
import org.pentaho.hadoop.shim.spi.HadoopShim;

public class MapReduceJobBuilderImpl
implements MapReduceJobBuilder {
    private final NamedCluster namedCluster;
    private final HadoopShim hadoopShim;
    private final LogChannelInterface log;
    private final VariableSpace variableSpace;
    private final Map<String, String> userDefined;
    private URL resolvedJarUrl;
    private String jarUrl;
    private String hadoopJobName;
    private String outputKeyClass;
    private String outputValueClass;
    private String mapperClass;
    private String combinerClass;
    private String reducerClass;
    private String inputFormatClass;
    private String outputFormatClass;
    private String[] inputPaths;
    private int numMapTasks;
    private int numReduceTasks;
    private String outputPath;
    private String mapOutputKeyClass;
    private String mapOutputValueClass;
    private String mapRunnerClass;

    public MapReduceJobBuilderImpl(NamedCluster namedCluster, HadoopShim hadoopShim, LogChannelInterface log, VariableSpace variableSpace) {
        this.namedCluster = namedCluster;
        this.hadoopShim = hadoopShim;
        this.log = log;
        this.variableSpace = variableSpace;
        this.userDefined = new HashMap<String, String>();
    }

    public void setResolvedJarUrl(URL resolvedJarUrl) {
        this.resolvedJarUrl = resolvedJarUrl;
    }

    public void setJarUrl(String jarUrl) {
        this.jarUrl = jarUrl;
    }

    public void setHadoopJobName(String hadoopJobName) {
        this.hadoopJobName = hadoopJobName;
    }

    public void setOutputKeyClass(String outputKeyClass) {
        this.outputKeyClass = outputKeyClass;
    }

    public void setMapOutputKeyClass(String mapOutputKeyClass) {
        this.mapOutputKeyClass = mapOutputKeyClass;
    }

    public void setMapOutputValueClass(String mapOutputValueClass) {
        this.mapOutputValueClass = mapOutputValueClass;
    }

    public void setMapRunnerClass(String mapRunnerClass) {
        this.mapRunnerClass = mapRunnerClass;
    }

    public void setOutputValueClass(String outputValueClass) {
        this.outputValueClass = outputValueClass;
    }

    public void setMapperClass(String mapperClass) {
        this.mapperClass = mapperClass;
    }

    public void setCombinerClass(String combinerClass) {
        this.combinerClass = combinerClass;
    }

    public void setReducerClass(String reducerClass) {
        this.reducerClass = reducerClass;
    }

    public void setInputFormatClass(String inputFormatClass) {
        this.inputFormatClass = inputFormatClass;
    }

    public void setOutputFormatClass(String outputFormatClass) {
        this.outputFormatClass = outputFormatClass;
    }

    public void setInputPaths(String[] inputPaths) {
        this.inputPaths = inputPaths;
    }

    public void setNumMapTasks(int numMapTasks) {
        this.numMapTasks = numMapTasks;
    }

    public void setNumReduceTasks(int numReduceTasks) {
        this.numReduceTasks = numReduceTasks;
    }

    public void setOutputPath(String outputPath) {
        this.outputPath = outputPath;
    }

    public void set(String key, String value) {
        this.userDefined.put(key, value);
    }

    protected void configure(Configuration conf) throws Exception {
        URL[] uRLArray;
        FileSystem fs = this.hadoopShim.getFileSystem(conf);
        if (this.resolvedJarUrl == null) {
            uRLArray = new URL[]{};
        } else {
            URL[] uRLArray2 = new URL[1];
            uRLArray = uRLArray2;
            uRLArray2[0] = this.resolvedJarUrl;
        }
        URL[] urls = uRLArray;
        try (URLClassLoader loader = new URLClassLoader(urls, this.hadoopShim.getClass().getClassLoader());){
            Class<?> valueClass;
            Class<?> keyClass;
            conf.setJobName(this.hadoopJobName);
            if (this.outputKeyClass != null) {
                keyClass = loader.loadClass(this.outputKeyClass);
                conf.setOutputKeyClass(keyClass);
            }
            if (this.outputValueClass != null) {
                valueClass = loader.loadClass(this.outputValueClass);
                conf.setOutputValueClass(valueClass);
            }
            if (this.mapOutputKeyClass != null) {
                keyClass = loader.loadClass(this.mapOutputKeyClass);
                conf.setMapOutputKeyClass(keyClass);
            }
            if (this.mapOutputValueClass != null) {
                valueClass = loader.loadClass(this.mapOutputValueClass);
                conf.setMapOutputValueClass(valueClass);
            }
            if (this.mapRunnerClass != null) {
                conf.setMapRunnerClass(this.mapRunnerClass);
            }
            if (this.mapperClass != null) {
                Class<?> mapper = loader.loadClass(this.mapperClass);
                conf.setMapperClass(mapper);
            }
            if (this.combinerClass != null) {
                Class<?> combiner = loader.loadClass(this.combinerClass);
                conf.setCombinerClass(combiner);
            }
            if (this.reducerClass != null) {
                Class<?> reducer = loader.loadClass(this.reducerClass);
                conf.setReducerClass(reducer);
            }
            if (this.inputFormatClass != null) {
                Class<?> inputFormat = loader.loadClass(this.inputFormatClass);
                conf.setInputFormat(inputFormat);
            }
            if (this.outputFormatClass != null) {
                Class<?> outputFormat = loader.loadClass(this.outputFormatClass);
                conf.setOutputFormat(outputFormat);
            }
            String hdfsHostnameS = this.variableSpace.environmentSubstitute(this.namedCluster.getHdfsHost());
            String hdfsPortS = this.variableSpace.environmentSubstitute(this.namedCluster.getHdfsPort());
            String jobTrackerHostnameS = this.variableSpace.environmentSubstitute(this.namedCluster.getJobTrackerHost());
            String jobTrackerPortS = this.variableSpace.environmentSubstitute(this.namedCluster.getJobTrackerPort());
            ArrayList<String> configMessages = new ArrayList<String>();
            this.hadoopShim.configureConnectionInformation(hdfsHostnameS, hdfsPortS, jobTrackerHostnameS, jobTrackerPortS, conf, configMessages);
            for (String string : configMessages) {
                this.log.logBasic(string);
            }
            ArrayList<Path> paths = new ArrayList<Path>();
            for (String path : this.inputPaths) {
                paths.add(this.getPath(conf, fs, path));
            }
            Path[] pathArray = paths.toArray(new Path[paths.size()]);
            conf.setInputPaths(pathArray);
            conf.setOutputPath(this.getOutputPath(conf, fs));
            for (Map.Entry<String, String> stringStringEntry : this.userDefined.entrySet()) {
                String key = stringStringEntry.getKey();
                String value = stringStringEntry.getValue();
                if (key == null || "".equals(key) || value == null || "".equals(value)) continue;
                conf.set(key, value);
            }
            if (this.jarUrl != null) {
                conf.setJar(this.jarUrl);
            }
            conf.setNumMapTasks(this.numMapTasks);
            conf.setNumReduceTasks(this.numReduceTasks);
        }
    }

    public VariableSpace getVariableSpace() {
        return this.variableSpace;
    }

    protected Path getOutputPath(Configuration conf, FileSystem fs) {
        return this.getPath(conf, fs, this.outputPath);
    }

    private Path getPath(Configuration conf, FileSystem fs, String outputPath) {
        return fs.asPath(conf.getDefaultFileSystemURL(), outputPath);
    }

    protected MapReduceJobAdvanced submit(Configuration conf, String shimIdentifier) throws IOException {
        return new RunningJobMapReduceJobAdvancedImpl(this.hadoopShim.submitJob(conf));
    }

    public final MapReduceJobAdvanced submit() throws Exception {
        Configuration conf = this.hadoopShim.createConfiguration(this.namedCluster);
        this.configure(conf);
        return this.submit(conf, this.namedCluster.getShimIdentifier());
    }

    protected String getClusterName() {
        return this.namedCluster.getName();
    }

    protected NamedCluster getNamedCluster() {
        return this.namedCluster;
    }
}

