/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.xul.common.preview;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.TransPreviewFactory;
import org.pentaho.di.trans.debug.BreakPointListener;
import org.pentaho.di.trans.debug.StepDebugMeta;
import org.pentaho.di.trans.debug.TransDebugMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.XulLoader;
import org.pentaho.ui.xul.XulRunner;
import org.pentaho.ui.xul.XulSettingsManager;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.components.XulProgressmeter;
import org.pentaho.ui.xul.containers.XulDialog;
import org.pentaho.ui.xul.impl.AbstractXulEventHandler;
import org.pentaho.ui.xul.impl.XulEventHandler;

public abstract class AbstractPreviewRowsXulDialog
extends AbstractXulEventHandler {
    protected Object parent;
    private String xulFile = "org/pentaho/di/ui/xul/common/preview/xul/preview_rows.xul";
    private XulDomContainer container;
    private XulRunner runner;
    protected XulDialog xulDialog;
    protected BindingFactory bf;
    protected LogChannel log;
    private BaseStepMeta meta = null;
    private int maxRows;
    private XulProgressmeter progressMeter;

    public AbstractPreviewRowsXulDialog(Object parent, BaseStepMeta stepMeta, int maxRows) {
        this.parent = parent;
        this.meta = stepMeta;
        this.maxRows = maxRows;
        this.log = new LogChannel((Object)"Row Preview");
        try {
            this.initializeXul();
            this.progressMeter = (XulProgressmeter)this.document.getElementById("progress");
        }
        catch (Exception e) {
            this.log.logError("Error initializing dialog...", (Throwable)e);
            throw new IllegalStateException("Cannot load dialog due to error in initialization.", e);
        }
    }

    public void init() {
        ArrayList<String> columns = new ArrayList<String>();
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        this.previewStep(data, columns);
        this.createPreviewRows(data, columns);
    }

    protected abstract void createPreviewRows(List<Object[]> var1, List<String> var2);

    protected void previewStep(List<Object[]> data, List<String> columns) {
        TransMeta previewMeta = TransPreviewFactory.generatePreviewTransformation(null, (StepMetaInterface)((StepMetaInterface)this.meta), (String)"data_sync");
        final Trans trans = new Trans(previewMeta);
        try {
            trans.prepareExecution(null);
            TransDebugMeta transDebugMeta = new TransDebugMeta(previewMeta);
            StepMeta stepMeta = previewMeta.findStep("data_sync");
            StepDebugMeta stepDebugMeta = new StepDebugMeta(stepMeta);
            stepDebugMeta.setReadingFirstRows(true);
            stepDebugMeta.setRowCount(this.maxRows);
            transDebugMeta.getStepDebugMetaMap().put(stepMeta, stepDebugMeta);
            transDebugMeta.addRowListenersToTransformation(trans);
            transDebugMeta.addBreakPointListers(new BreakPointListener(){

                public void breakPointHit(TransDebugMeta transDebugMeta, StepDebugMeta stepDebugMeta, RowMetaInterface rowBufferMeta, List<Object[]> rowBuffer) {
                    System.out.println("break point hit...".concat(String.valueOf(stepDebugMeta.getRowCount())));
                    trans.stopAll();
                }
            });
            trans.startThreads();
            int previousPct = 0;
            while (!trans.isFinished()) {
                int nrDone = 0;
                int nrTotal = 0;
                for (StepDebugMeta debug : transDebugMeta.getStepDebugMetaMap().values()) {
                    nrDone += debug.getRowBuffer().size();
                    nrTotal += debug.getRowCount();
                }
                int pct = 100 * nrDone / nrTotal;
                int worked = pct - previousPct;
                if (worked > 0) {
                    this.progressMeter.setValue(worked);
                }
                previousPct = pct;
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
            trans.stopAll();
            data.addAll(stepDebugMeta.getRowBuffer());
            RowMetaInterface rowMeta = stepDebugMeta.getRowBufferMeta();
            for (int i = 0; i < rowMeta.size(); ++i) {
                ValueMetaInterface v = rowMeta.getValueMeta(i);
                columns.add(v.getName());
            }
        }
        catch (KettleException e) {
            this.logError("Data preview failed.", e);
        }
    }

    protected abstract void initializeXul() throws XulException;

    protected void initializeXul(XulLoader loader, BindingFactory bindingFactory, XulRunner runner, Object parent) throws XulException {
        this.bf = bindingFactory;
        this.runner = runner;
        loader.registerClassLoader((Object)((Object)((Object)this)).getClass().getClassLoader());
        loader.setSettingsManager(this.getSettingsManager());
        loader.setOuterContext(parent);
        this.container = loader.loadXul(this.xulFile, (Object)this.getResourceBundle());
        this.bf.setDocument(this.container.getDocumentRoot());
        for (XulEventHandler h : this.getEventHandlers()) {
            this.container.addEventHandler(h);
        }
        this.runner.addContainer(this.container);
        this.xulDialog = (XulDialog)this.container.getDocumentRoot().getRootElement();
        runner.initialize();
    }

    public abstract XulSettingsManager getSettingsManager();

    public abstract ResourceBundle getResourceBundle();

    protected BindingFactory getBindingFactory() {
        return this.bf;
    }

    protected List<XulEventHandler> getEventHandlers() {
        return Collections.singletonList(this);
    }

    public String getName() {
        return "handler";
    }

    public String open() {
        this.xulDialog.show();
        return null;
    }

    public void close() {
        this.xulDialog.hide();
    }

    public abstract void onAccept();

    public abstract void onCancel();

    protected abstract Class<?> getClassForMessages();

    public abstract void dispose();

    public boolean isBasic() {
        return this.log.isBasic();
    }

    public boolean isDetailed() {
        return this.log.isDetailed();
    }

    public boolean isDebug() {
        return this.log.isDebug();
    }

    public boolean isRowLevel() {
        return this.log.isRowLevel();
    }

    public void logMinimal(String message) {
        this.log.logMinimal(message);
    }

    public void logMinimal(String message, Object ... arguments) {
        this.log.logMinimal(message, arguments);
    }

    public void logBasic(String message) {
        this.log.logBasic(message);
    }

    public void logBasic(String message, Object ... arguments) {
        this.log.logBasic(message, arguments);
    }

    public void logDetailed(String message) {
        this.log.logDetailed(message);
    }

    public void logDetailed(String message, Object ... arguments) {
        this.log.logDetailed(message, arguments);
    }

    public void logDebug(String message) {
        this.log.logDebug(message);
    }

    public void logDebug(String message, Object ... arguments) {
        this.log.logDebug(message, arguments);
    }

    public void logRowlevel(String message) {
        this.log.logRowlevel(message);
    }

    public void logRowlevel(String message, Object ... arguments) {
        this.log.logRowlevel(message, arguments);
    }

    public void logError(String message) {
        this.log.logError(message);
    }

    public void logError(String message, Throwable e) {
        this.log.logError(message, e);
    }

    public void logError(String message, Object ... arguments) {
        this.log.logError(message, arguments);
    }
}

