/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.xul;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.SwtUniversalImageSvg;
import org.pentaho.di.core.svg.SvgImage;
import org.pentaho.di.core.svg.SvgSupport;
import org.pentaho.di.ui.xul.KettleXulLoader;
import org.pentaho.ui.xul.XulDomContainer;

public class KettleImageUtil {
    static final int[] IMAGE_SIZES = new int[]{256, 128, 64, 48, 32, 16};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image[] loadImages(XulDomContainer container, Shell shell, String resource) {
        InputStream in;
        Display d = shell.getDisplay();
        if (d == null) {
            Display display = d = Display.getCurrent() != null ? Display.getCurrent() : Display.getDefault();
        }
        if (SvgSupport.isSvgEnabled() && (SvgSupport.isSvgName((String)resource) || SvgSupport.isPngName((String)resource))) {
            in = null;
            try {
                in = KettleImageUtil.getResourceInputStream(resource, container);
                SvgImage svg = SvgSupport.loadSvgImage((InputStream)in);
                SwtUniversalImageSvg image = new SwtUniversalImageSvg(svg);
                Image[] result = new Image[IMAGE_SIZES.length];
                for (int i = 0; i < IMAGE_SIZES.length; ++i) {
                    result[i] = image.getAsBitmapForSize((Device)d, IMAGE_SIZES[i], IMAGE_SIZES[i]);
                }
                Image[] imageArray = result;
                return imageArray;
            }
            catch (Throwable ignored) {
                ignored.printStackTrace();
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
            }
            resource = SvgSupport.toPngName((String)resource);
        }
        in = null;
        try {
            in = KettleImageUtil.getResourceInputStream(resource, container);
            Image[] imageArray = new Image[]{new Image((Device)d, in)};
            return imageArray;
        }
        catch (Throwable throwable) {
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
        return null;
    }

    private static InputStream getResourceInputStream(String resource, XulDomContainer container) throws IOException {
        return ((KettleXulLoader)container.getXulLoader()).getOriginalResourceAsStream(resource);
    }
}

