/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.webservices;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.webservices.WebServiceField;
import org.pentaho.di.trans.steps.webservices.WebServiceMeta;
import org.pentaho.di.trans.steps.webservices.wsdl.ComplexType;
import org.pentaho.di.trans.steps.webservices.wsdl.Wsdl;
import org.pentaho.di.trans.steps.webservices.wsdl.WsdlOpParameter;
import org.pentaho.di.trans.steps.webservices.wsdl.WsdlOpParameterContainer;
import org.pentaho.di.trans.steps.webservices.wsdl.WsdlOpParameterList;
import org.pentaho.di.trans.steps.webservices.wsdl.WsdlOperation;
import org.pentaho.di.trans.steps.webservices.wsdl.WsdlOperationContainer;
import org.pentaho.di.trans.steps.webservices.wsdl.WsdlParamContainer;
import org.pentaho.di.trans.steps.webservices.wsdl.XsdType;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.PasswordTextVar;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class WebServiceDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = WebServiceMeta.class;
    private WebServiceMeta meta;
    private CTabFolder wTabFolder;
    private Label wlURL;
    private Button wbURL;
    private Button wbFile;
    private TextVar wURL;
    private Label wlOperation;
    private CCombo wOperation;
    private Label wlOperationRequest;
    private Text wOperationRequest;
    private Label wlStep;
    private Text wStep;
    private Label wlPassInputData;
    private Button wPassInputData;
    private Label wlCompatible;
    private Button wCompatible;
    private Label wlRepeatingElement;
    private TextVar wRepeatingElement;
    private Label wlReplyAsString;
    private Button wReplyAsString;
    private Label wlHttpLogin;
    private TextVar wHttpLogin;
    private Label wlHttpPassword;
    private TextVar wHttpPassword;
    private Label wlProxyHost;
    private TextVar wProxyHost;
    private Label wlProxyPort;
    private TextVar wProxyPort;
    private TableView fieldInTableView;
    private TableView fieldOutTableView;
    private CTabItem tabItemWebService;
    private CTabItem tabItemFieldIn;
    private CTabItem tabItemFieldOut;
    private Wsdl wsdl;
    private WsdlOperation wsdlOperation;
    private WsdlParamContainer inWsdlParamContainer;
    private WsdlParamContainer outWsdlParamContainer;
    private Button wAddInput;
    private Button wAddOutput;
    private ModifyListener lsMod = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            WebServiceDialog.this.meta.setChanged();
        }
    };
    private List<ColumnInfo> fieldColumns = new ArrayList<ColumnInfo>();
    private RowMetaInterface prevFields;

    private void selectWSDLOperation(String anOperationName) throws KettleException {
        this.loadOperation(anOperationName);
        if (this.inWsdlParamContainer != null) {
            this.wStep.setVisible(true);
            this.wlStep.setVisible(true);
            if (!this.inWsdlParamContainer.isArray()) {
                this.wStep.setText("1");
            }
            this.addTabFieldIn();
            this.setComboValues();
        } else {
            this.wStep.setText("1");
            this.removeTabField(this.tabItemFieldIn);
            this.tabItemFieldIn = null;
        }
        if (this.outWsdlParamContainer != null) {
            this.addTabFieldOut();
        } else {
            this.removeTabField(this.tabItemFieldOut);
            this.tabItemFieldOut = null;
        }
    }

    private void loadWebService(String anURI) throws KettleException {
        anURI = this.transMeta.environmentSubstitute(anURI);
        try {
            if (this.wProxyHost.getText() != null && !"".equals(this.wProxyHost.getText())) {
                Properties systemProperties = System.getProperties();
                systemProperties.setProperty("http.proxyHost", this.transMeta.environmentSubstitute(this.wProxyHost.getText()));
                systemProperties.setProperty("http.proxyPort", this.transMeta.environmentSubstitute(this.wProxyPort.getText()));
            }
            this.wsdl = new Wsdl(new URI(anURI), null, null, this.wHttpLogin.getText(), this.wHttpPassword.getText());
        }
        catch (Exception e) {
            this.wsdl = null;
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"WebServiceDialog.ERROR0009.UnreachableURI", (String[])new String[0]), BaseMessages.getString(PKG, (String)"WebServiceDialog.ErrorDialog.Title", (String[])new String[0]) + anURI, e);
            this.log.logError(BaseMessages.getString(PKG, (String)"WebServiceDialog.ErrorDialog.Title", (String[])new String[0]) + anURI, new Object[]{e.getMessage()});
            return;
        }
        String text = this.wOperation.getText();
        this.wOperation.removeAll();
        if (this.wsdl != null) {
            List listeOperations = this.wsdl.getOperations();
            Collections.sort(listeOperations, new Comparator<WsdlOperation>(){

                @Override
                public int compare(WsdlOperation op1, WsdlOperation op2) {
                    return op1.getOperationQName().getLocalPart().compareTo(op2.getOperationQName().getLocalPart());
                }
            });
            for (WsdlOperation op : listeOperations) {
                this.wOperation.add(op.getOperationQName().getLocalPart());
                if (!op.getOperationQName().getLocalPart().equals(text)) continue;
                this.wOperation.setText(text);
            }
        }
    }

    private void loadOperation(String anOperationName) throws KettleException {
        this.wsdlOperation = null;
        this.inWsdlParamContainer = null;
        this.outWsdlParamContainer = null;
        if (this.wsdl != null) {
            Iterator vItOperation = this.wsdl.getOperations().iterator();
            while (vItOperation.hasNext() && this.wsdlOperation == null) {
                WsdlOperation vCurrentOperation = (WsdlOperation)vItOperation.next();
                if (!vCurrentOperation.getOperationQName().getLocalPart().equals(anOperationName)) continue;
                this.wsdlOperation = vCurrentOperation;
            }
        }
        if (this.wsdlOperation != null) {
            String request = "";
            WsdlOpParameterList parameters = this.wsdlOperation.getParameters();
            if (parameters != null && parameters.getOperation() != null && parameters.getOperation().getInput() != null && parameters.getOperation().getInput().getName() != null) {
                request = this.wsdlOperation.getParameters().getOperation().getInput().getName().toString();
            }
            this.wOperationRequest.setText(request);
            for (int cpt = 0; cpt < this.wsdlOperation.getParameters().size(); ++cpt) {
                WsdlOpParameter param = (WsdlOpParameter)this.wsdlOperation.getParameters().get(cpt);
                if (param.isArray()) {
                    if (param.getItemXmlType() == null) continue;
                    ComplexType type = param.getItemComplexType();
                    if (type != null) {
                        for (String attributeName : type.getElementNames()) {
                            QName attributeType = type.getElementType(attributeName);
                            if ("http://www.w3.org/2001/XMLSchema".equals(attributeType.getNamespaceURI())) continue;
                            throw new KettleStepException(BaseMessages.getString(PKG, (String)"WebServiceDialog.ERROR0007.UnsupporteOperation.ComplexType", (String[])new String[0]));
                        }
                    }
                    if (WsdlOpParameter.ParameterMode.IN.equals(param.getMode()) || WsdlOpParameter.ParameterMode.INOUT.equals(param.getMode()) || WsdlOpParameter.ParameterMode.UNDEFINED.equals(param.getMode())) {
                        if (this.inWsdlParamContainer != null) {
                            throw new KettleStepException(BaseMessages.getString(PKG, (String)"WebServiceDialog.ERROR0006.UnsupportedOperation.MultipleArrays", (String[])new String[0]));
                        }
                        this.inWsdlParamContainer = new WsdlOpParameterContainer(param);
                        continue;
                    }
                    if (!WsdlOpParameter.ParameterMode.OUT.equals(param.getMode()) && !WsdlOpParameter.ParameterMode.INOUT.equals(param.getMode()) && !WsdlOpParameter.ParameterMode.UNDEFINED.equals(param.getMode())) continue;
                    if (this.outWsdlParamContainer != null) {
                        throw new KettleStepException(BaseMessages.getString(PKG, (String)"WebServiceDialog.ERROR0006.UnsupportedOperation.MultipleArrays", (String[])new String[0]));
                    }
                    this.outWsdlParamContainer = new WsdlOpParameterContainer(param);
                    continue;
                }
                if (WsdlOpParameter.ParameterMode.IN.equals(param.getMode()) || WsdlOpParameter.ParameterMode.INOUT.equals(param.getMode()) || WsdlOpParameter.ParameterMode.UNDEFINED.equals(param.getMode())) {
                    if (this.inWsdlParamContainer != null && !(this.inWsdlParamContainer instanceof WsdlOperationContainer)) {
                        throw new KettleStepException(BaseMessages.getString(PKG, (String)"WebServiceDialog.ERROR0008.UnsupportedOperation.IncorrectParams", (String[])new String[0]));
                    }
                    this.inWsdlParamContainer = new WsdlOperationContainer(this.wsdlOperation, param.getMode());
                    continue;
                }
                if (WsdlOpParameter.ParameterMode.OUT.equals(param.getMode()) || WsdlOpParameter.ParameterMode.INOUT.equals(param.getMode()) || WsdlOpParameter.ParameterMode.UNDEFINED.equals(param.getMode())) {
                    if (this.outWsdlParamContainer != null && !(this.outWsdlParamContainer instanceof WsdlOperationContainer)) {
                        throw new KettleStepException(BaseMessages.getString(PKG, (String)"WebServiceDialog.ERROR0008.UnsupportedOperation.IncorrectParams", (String[])new String[0]));
                    }
                    this.outWsdlParamContainer = new WsdlOperationContainer(this.wsdlOperation, param.getMode());
                    continue;
                }
                System.out.println("Parameter : " + param.getName().getLocalPart() + ", mode=" + param.getMode().toString() + ", is not considered");
            }
            if (this.wsdlOperation.getReturnType() != null) {
                ComplexType type;
                this.outWsdlParamContainer = new WsdlOpParameterContainer((WsdlOpParameter)this.wsdlOperation.getReturnType());
                if (this.wsdlOperation.getReturnType().isArray() && this.wsdlOperation.getReturnType().getItemXmlType() != null && (type = this.wsdlOperation.getReturnType().getItemComplexType()) != null) {
                    for (String attributeName : type.getElementNames()) {
                        QName attributeType = type.getElementType(attributeName);
                        if ("http://www.w3.org/2001/XMLSchema".equals(attributeType.getNamespaceURI())) continue;
                        throw new KettleStepException(BaseMessages.getString(PKG, (String)"WebServiceDialog.ERROR0007.UnsupportedOperation.ComplexType", (String[])new String[0]));
                    }
                }
            }
        }
    }

    private void initTreeTabWebService(String anURI) throws KettleException {
        String text = this.wOperation.getText();
        this.loadWebService(anURI);
        this.selectWSDLOperation(text);
        if (this.wsdlOperation != null) {
            this.wOperation.setText(text);
        }
    }

    private void addTabFieldIn() {
        TableView oldTableView = this.fieldInTableView;
        int margin = 4;
        Composite vCompositeTabField = new Composite((Composite)this.wTabFolder, 0);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        vCompositeTabField.setLayout((Layout)formLayout);
        this.props.setLook((Control)vCompositeTabField);
        if (this.tabItemFieldIn == null) {
            this.tabItemFieldIn = new CTabItem(this.wTabFolder, 0);
        }
        ColumnInfo fieldColumn = new ColumnInfo(BaseMessages.getString(PKG, (String)"WebServiceDialog.NameColumn.Column", (String[])new String[0]), 2, new String[0], false);
        this.fieldColumns.add(fieldColumn);
        ColumnInfo[] colinf = new ColumnInfo[]{fieldColumn, new ColumnInfo(BaseMessages.getString(PKG, (String)"WebServiceDialog.WsNameColumn.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"WebServiceDialog.TypeColumn.Column", (String[])new String[0]), 1, false)};
        this.fieldInTableView = new TableView((VariableSpace)this.transMeta, vCompositeTabField, 65538, colinf, 1, this.lsMod, this.props);
        this.fieldInTableView.setReadonly(false);
        this.fieldInTableView.clearAll();
        String containerName = this.inWsdlParamContainer == null ? this.meta.getInFieldContainerName() : this.inWsdlParamContainer.getContainerName();
        this.tabItemFieldIn.setText(containerName == null ? "in" : containerName);
        Button vButton = new Button(vCompositeTabField, 0);
        vButton.setText(BaseMessages.getString(PKG, (String)"System.Button.GetFields", (String[])new String[0]));
        vButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RowMetaInterface r;
                if (WebServiceDialog.this.inWsdlParamContainer == null) {
                    try {
                        WebServiceDialog.this.loadWebService(WebServiceDialog.this.wURL.getText());
                        WebServiceDialog.this.loadOperation(WebServiceDialog.this.wOperation.getText());
                    }
                    catch (KettleException e) {
                        e.printStackTrace();
                    }
                }
                if ((r = WebServiceDialog.this.getInWebServiceFields()) != null) {
                    BaseStepDialog.getFieldsFromPrevious(r, WebServiceDialog.this.fieldInTableView, 2, new int[]{2}, new int[0], -1, -1, null);
                }
                if (WebServiceDialog.this.inWsdlParamContainer != null) {
                    TableItem[] items = ((WebServiceDialog)WebServiceDialog.this).fieldInTableView.table.getItems();
                    for (int i = 0; i < items.length; ++i) {
                        String type = WebServiceDialog.this.inWsdlParamContainer.getParamType(items[i].getText(2));
                        if (type != null) {
                            items[i].setText(3, type);
                            continue;
                        }
                        items[i].dispose();
                    }
                }
            }
        });
        Button[] buttons = new Button[]{vButton};
        BaseStepDialog.positionBottomButtons(vCompositeTabField, buttons, 4, null);
        FormData fdTable = new FormData();
        fdTable.left = new FormAttachment(0, 0);
        fdTable.top = new FormAttachment(0, margin);
        fdTable.right = new FormAttachment(100, 0);
        fdTable.bottom = new FormAttachment((Control)vButton, 0);
        this.fieldInTableView.setLayoutData(fdTable);
        FormData fdInComp = new FormData();
        fdInComp.left = new FormAttachment(0, 0);
        fdInComp.top = new FormAttachment(0, 0);
        fdInComp.right = new FormAttachment(100, 0);
        fdInComp.bottom = new FormAttachment(100, 0);
        vCompositeTabField.setLayoutData((Object)fdInComp);
        vCompositeTabField.layout();
        this.tabItemFieldIn.setControl((Control)vCompositeTabField);
        if (this.inWsdlParamContainer != null) {
            RowMetaInterface r = this.getInWebServiceFields();
            for (int i = 0; i < r.size(); ++i) {
                TableItem[] oldItems;
                String previousField;
                String wsName = r.getValueMeta(i).getName();
                TableItem vTableItem = new TableItem(this.fieldInTableView.table, 0);
                vTableItem.setText(2, Const.NVL((String)wsName, (String)""));
                vTableItem.setText(3, Const.NVL((String)this.inWsdlParamContainer.getParamType(wsName), (String)""));
                if (oldTableView == null || (previousField = this.getField(oldItems = oldTableView.table.getItems(), wsName)) == null) continue;
                vTableItem.setText(1, previousField);
            }
        }
        if (oldTableView != null) {
            oldTableView.dispose();
        }
        this.fieldInTableView.removeEmptyRows();
        this.fieldInTableView.setRowNums();
        this.fieldInTableView.optWidth(true);
    }

    private String getField(TableItem[] items, String wsName) {
        if (wsName == null) {
            return null;
        }
        String ret = null;
        for (int i = 0; i < items.length && ret == null; ++i) {
            if (!items[i].getText(2).equals(wsName)) continue;
            ret = items[i].getText(1);
        }
        return ret;
    }

    private void addTabFieldOut() {
        TableView oldTableView = this.fieldOutTableView;
        int margin = 4;
        Composite vCompositeTabFieldOut = new Composite((Composite)this.wTabFolder, 0);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        vCompositeTabFieldOut.setLayout((Layout)formLayout);
        this.props.setLook((Control)vCompositeTabFieldOut);
        if (this.tabItemFieldOut == null) {
            this.tabItemFieldOut = new CTabItem(this.wTabFolder, 0);
        }
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"WebServiceDialog.NameColumn.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"WebServiceDialog.WsNameColumn.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"WebServiceDialog.TypeColumn.Column", (String[])new String[0]), 1, false)};
        this.fieldOutTableView = new TableView((VariableSpace)this.transMeta, vCompositeTabFieldOut, 65538, colinf, 1, this.lsMod, this.props);
        String outContainerName = this.outWsdlParamContainer == null ? this.meta.getOutFieldContainerName() : this.outWsdlParamContainer.getContainerName();
        this.tabItemFieldOut.setText(outContainerName == null ? "out" : outContainerName);
        this.fieldOutTableView.setReadonly(false);
        Button vButton = new Button(vCompositeTabFieldOut, 0);
        vButton.setText(BaseMessages.getString(PKG, (String)"System.Button.GetFields", (String[])new String[0]));
        vButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RowMetaInterface r;
                if (WebServiceDialog.this.outWsdlParamContainer == null) {
                    try {
                        WebServiceDialog.this.loadWebService(WebServiceDialog.this.wURL.getText());
                        WebServiceDialog.this.loadOperation(WebServiceDialog.this.wOperation.getText());
                    }
                    catch (KettleException e) {
                        e.printStackTrace();
                    }
                }
                if ((r = WebServiceDialog.this.getOutWebServiceFields()) != null) {
                    BaseStepDialog.getFieldsFromPrevious(r, WebServiceDialog.this.fieldOutTableView, 2, new int[]{1, 2}, new int[0], -1, -1, null);
                }
                if (WebServiceDialog.this.outWsdlParamContainer != null) {
                    TableItem[] items = ((WebServiceDialog)WebServiceDialog.this).fieldOutTableView.table.getItems();
                    for (int i = 0; i < items.length; ++i) {
                        items[i].setText(3, WebServiceDialog.this.outWsdlParamContainer.getParamType(items[i].getText(2)));
                    }
                }
            }
        });
        Button[] buttons = new Button[]{vButton};
        BaseStepDialog.positionBottomButtons(vCompositeTabFieldOut, buttons, 4, null);
        FormData fdTable = new FormData();
        fdTable.left = new FormAttachment(0, 0);
        fdTable.top = new FormAttachment(0, margin);
        fdTable.right = new FormAttachment(100, 0);
        fdTable.bottom = new FormAttachment((Control)vButton, 0);
        this.fieldOutTableView.setLayoutData(fdTable);
        FormData fdInComp = new FormData();
        fdInComp.left = new FormAttachment(0, 0);
        fdInComp.top = new FormAttachment(0, 0);
        fdInComp.right = new FormAttachment(100, 0);
        fdInComp.bottom = new FormAttachment(100, 0);
        vCompositeTabFieldOut.setLayoutData((Object)fdInComp);
        vCompositeTabFieldOut.layout();
        this.tabItemFieldOut.setControl((Control)vCompositeTabFieldOut);
        if (this.fieldOutTableView.table.getItemCount() == 0 && this.outWsdlParamContainer != null) {
            RowMetaInterface r = this.getOutWebServiceFields();
            for (int i = 0; i < r.size(); ++i) {
                String wsName = r.getValueMeta(i).getName();
                String wsType = r.getValueMeta(i).getTypeDesc();
                TableItem vTableItem = new TableItem(this.fieldOutTableView.table, 0);
                vTableItem.setText(2, wsName);
                vTableItem.setText(3, wsType);
                if (oldTableView != null) {
                    String previousField = this.getField(oldTableView.table.getItems(), wsName);
                    if (previousField != null && !"".equals(previousField)) {
                        vTableItem.setText(1, previousField);
                        continue;
                    }
                    vTableItem.setText(1, wsName);
                    continue;
                }
                vTableItem.setText(1, wsName);
            }
        }
        this.fieldOutTableView.removeEmptyRows();
        this.fieldOutTableView.setRowNums();
        this.fieldOutTableView.optWidth(true);
    }

    private RowMetaInterface getInWebServiceFields() {
        RowMeta r = null;
        if (this.inWsdlParamContainer != null) {
            r = new RowMeta();
            String[] params = this.inWsdlParamContainer.getParamNames();
            for (int cpt = 0; cpt < params.length; ++cpt) {
                ValueMeta value = new ValueMeta(params[cpt], XsdType.xsdTypeToKettleType((String)this.inWsdlParamContainer.getParamType(params[cpt])));
                r.addValueMeta((ValueMetaInterface)value);
            }
        }
        return r;
    }

    private RowMetaInterface getOutWebServiceFields() {
        RowMeta r = null;
        if (this.outWsdlParamContainer != null) {
            r = new RowMeta();
            String[] outParams = this.outWsdlParamContainer.getParamNames();
            for (int cpt = 0; cpt < outParams.length; ++cpt) {
                ValueMeta value = new ValueMeta(outParams[cpt], XsdType.xsdTypeToKettleType((String)this.outWsdlParamContainer.getParamType(outParams[cpt])));
                r.addValueMeta((ValueMetaInterface)value);
            }
        }
        return r;
    }

    private void removeTabField(CTabItem tab) {
        if (tab != null) {
            tab.dispose();
            tab = null;
        }
    }

    private void getData() {
        TableItem vTableItem;
        this.wStepname.setText(this.stepname);
        this.wURL.setText(this.meta.getUrl() == null ? "" : this.meta.getUrl());
        this.wProxyHost.setText(this.meta.getProxyHost() == null ? "" : this.meta.getProxyHost());
        this.wProxyPort.setText(this.meta.getProxyPort() == null ? "" : this.meta.getProxyPort());
        this.wHttpLogin.setText(this.meta.getHttpLogin() == null ? "" : this.meta.getHttpLogin());
        this.wHttpPassword.setText(this.meta.getHttpPassword() == null ? "" : this.meta.getHttpPassword());
        this.wStep.setText(Integer.toString(this.meta.getCallStep()));
        this.wPassInputData.setSelection(this.meta.isPassingInputData());
        this.wCompatible.setSelection(this.meta.isCompatible());
        this.wRepeatingElement.setText(Const.NVL((String)this.meta.getRepeatingElementName(), (String)""));
        this.wReplyAsString.setSelection(this.meta.isReturningReplyAsString());
        if (this.wURL.getText() != null && !"".equals(this.wURL.getText())) {
            this.wOperation.setText(this.meta.getOperationName() == null ? "" : this.meta.getOperationName());
        }
        this.wOperationRequest.setText(Const.NVL((String)this.meta.getOperationRequestName(), (String)""));
        if (this.meta.getInFieldContainerName() != null || this.meta.getInFieldArgumentName() != null || !this.meta.getFieldsIn().isEmpty()) {
            this.addTabFieldIn();
            for (WebServiceField field : this.meta.getFieldsIn()) {
                vTableItem = new TableItem(this.fieldInTableView.table, 0);
                if (field.getName() != null) {
                    vTableItem.setText(1, field.getName());
                }
                vTableItem.setText(2, field.getWsName());
                vTableItem.setText(3, field.getXsdType());
            }
            this.fieldInTableView.removeEmptyRows();
            this.fieldInTableView.setRowNums();
            this.fieldInTableView.optWidth(true);
        }
        if (!this.meta.getFieldsOut().isEmpty()) {
            this.addTabFieldOut();
            for (WebServiceField field : this.meta.getFieldsOut()) {
                vTableItem = new TableItem(this.fieldOutTableView.table, 0);
                if (field.getName() != null) {
                    vTableItem.setText(1, field.getName());
                }
                vTableItem.setText(2, field.getWsName());
                vTableItem.setText(3, field.getXsdType());
            }
            this.fieldOutTableView.removeEmptyRows();
            this.fieldOutTableView.setRowNums();
            this.fieldOutTableView.optWidth(true);
        }
    }

    private void getInfo(WebServiceMeta webServiceMeta) {
        WebServiceField field;
        TableItem vTableItem;
        int i;
        int nbRow;
        webServiceMeta.setUrl(this.wURL.getText());
        webServiceMeta.setProxyHost(this.wProxyHost.getText());
        webServiceMeta.setProxyPort(this.wProxyPort.getText());
        webServiceMeta.setHttpLogin(this.wHttpLogin.getText());
        webServiceMeta.setHttpPassword(this.wHttpPassword.getText());
        webServiceMeta.setCallStep(Const.toInt((String)this.wStep.getText(), (int)1000));
        webServiceMeta.setPassingInputData(this.wPassInputData.getSelection());
        webServiceMeta.setCompatible(this.wCompatible.getSelection());
        webServiceMeta.setRepeatingElementName(this.wRepeatingElement.getText());
        webServiceMeta.setReturningReplyAsString(this.wReplyAsString.getSelection());
        webServiceMeta.setOperationRequestName(this.wOperationRequest.getText());
        webServiceMeta.setOperationName(this.wOperation.getText());
        if (this.wsdlOperation != null) {
            webServiceMeta.setOperationName(this.wsdlOperation.getOperationQName().getLocalPart());
            webServiceMeta.setOperationNamespace(this.wsdlOperation.getOperationQName().getNamespaceURI());
        } else if (this.wsdl != null) {
            webServiceMeta.setOperationName(null);
            webServiceMeta.setOperationNamespace(null);
        }
        if (this.inWsdlParamContainer != null) {
            webServiceMeta.setInFieldContainerName(this.inWsdlParamContainer.getContainerName());
            webServiceMeta.setInFieldArgumentName(this.inWsdlParamContainer.getItemName());
        } else if (this.wsdl != null) {
            webServiceMeta.setInFieldContainerName(null);
            webServiceMeta.setInFieldArgumentName(null);
        }
        if (this.outWsdlParamContainer != null) {
            webServiceMeta.setOutFieldContainerName(this.outWsdlParamContainer.getContainerName());
            webServiceMeta.setOutFieldArgumentName(this.outWsdlParamContainer.getItemName());
        } else if (this.wsdl != null) {
            webServiceMeta.setOutFieldContainerName(null);
            webServiceMeta.setOutFieldArgumentName(null);
        }
        webServiceMeta.getFieldsIn().clear();
        if (this.tabItemFieldIn != null) {
            nbRow = this.fieldInTableView.nrNonEmpty();
            for (i = 0; i < nbRow; ++i) {
                vTableItem = this.fieldInTableView.getNonEmpty(i);
                field = new WebServiceField();
                field.setName(vTableItem.getText(1));
                field.setWsName(vTableItem.getText(2));
                field.setXsdType(Const.NVL((String)vTableItem.getText(3), (String)"String"));
                webServiceMeta.addFieldIn(field);
            }
        }
        webServiceMeta.getFieldsOut().clear();
        if (this.tabItemFieldOut != null) {
            nbRow = this.fieldOutTableView.nrNonEmpty();
            for (i = 0; i < nbRow; ++i) {
                vTableItem = this.fieldOutTableView.getNonEmpty(i);
                if ("".equals(vTableItem.getText(1))) continue;
                field = new WebServiceField();
                field.setName(vTableItem.getText(1));
                field.setWsName(vTableItem.getText(2));
                field.setXsdType(vTableItem.getText(3));
                webServiceMeta.addFieldOut(field);
            }
        }
    }

    public WebServiceDialog(Shell aShell, Object in, TransMeta transMeta, String sname) {
        super(aShell, (StepMetaInterface)in, transMeta, sname);
        this.meta = (WebServiceMeta)in;
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.meta);
        this.changed = this.meta.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"WebServiceDialog.DialogTitle", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"System.Label.StepName", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.top = new FormAttachment(0, margin);
        this.fdlStepname.right = new FormAttachment(middle, -margin);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(this.lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment(middle, 0);
        this.fdStepname.top = new FormAttachment(0, margin);
        this.fdStepname.right = new FormAttachment(100, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        this.wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        this.props.setLook((Control)this.wTabFolder, 5);
        this.tabItemWebService = new CTabItem(this.wTabFolder, 0);
        this.tabItemWebService.setText(BaseMessages.getString(PKG, (String)"WebServiceDialog.MainTab.TabTitle", (String[])new String[0]));
        Composite compositeTabWebService = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)compositeTabWebService);
        FormLayout fileLayout = new FormLayout();
        fileLayout.marginWidth = 3;
        fileLayout.marginHeight = 3;
        compositeTabWebService.setLayout((Layout)fileLayout);
        this.wlURL = new Label(compositeTabWebService, 131072);
        this.wlURL.setText(BaseMessages.getString(PKG, (String)"WebServiceDialog.URL.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlURL);
        FormData fdlURL = new FormData();
        fdlURL.left = new FormAttachment(0, 0);
        fdlURL.top = new FormAttachment(0, margin);
        fdlURL.right = new FormAttachment(middle, -margin);
        this.wlURL.setLayoutData((Object)fdlURL);
        this.wbURL = new Button(compositeTabWebService, 0x1000008);
        this.props.setLook((Control)this.wbURL);
        this.wbURL.setText(BaseMessages.getString(PKG, (String)"WebServiceDialog.URL.Load", (String[])new String[0]));
        FormData fdbURL = new FormData();
        fdbURL.right = new FormAttachment(100, 0);
        fdbURL.top = new FormAttachment(0, 0);
        this.wbURL.setLayoutData((Object)fdbURL);
        this.wbURL.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!Utils.isEmpty((CharSequence)WebServiceDialog.this.wURL.getText())) {
                    try {
                        WebServiceDialog.this.initTreeTabWebService(WebServiceDialog.this.wURL.getText());
                    }
                    catch (Throwable throwable) {
                        new ErrorDialog(WebServiceDialog.this.shell, BaseMessages.getString((Class)PKG, (String)"WebServiceDialog.Exception.UnableToLoadWebService.Title", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"WebServiceDialog.Exception.UnableToLoadWebService.Message", (String[])new String[0]), throwable);
                    }
                }
            }
        });
        this.wbFile = new Button(compositeTabWebService, 0x1000008);
        this.props.setLook((Control)this.wbFile);
        this.wbFile.setText(BaseMessages.getString(PKG, (String)"WebServiceDialog.File.Load", (String[])new String[0]));
        FormData fdbFile = new FormData();
        fdbFile.right = new FormAttachment((Control)this.wbURL, 0);
        fdbFile.top = new FormAttachment(0, 0);
        this.wbFile.setLayoutData((Object)fdbFile);
        this.wbFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(WebServiceDialog.this.shell, 4096);
                dialog.setFilterExtensions(new String[]{"*.wsdl;*.WSDL", "*.*"});
                dialog.setFilterNames(new String[]{BaseMessages.getString((Class)PKG, (String)"WebServiceDialog.FileType.WsdlFiles", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"System.FileType.CSVFiles", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"System.FileType.TextFiles", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"System.FileType.AllFiles", (String[])new String[0])});
                if (dialog.open() != null) {
                    String filename = dialog.getFilterPath() + System.getProperty("file.separator") + dialog.getFileName();
                    try {
                        WebServiceDialog.this.initTreeTabWebService(new File(filename).toURI().toASCIIString());
                    }
                    catch (Throwable throwable) {
                        new ErrorDialog(WebServiceDialog.this.shell, BaseMessages.getString((Class)PKG, (String)"WebServiceDialog.Exception.UnableToLoadWebService.Title", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"WebServiceDialog.Exception.UnableToLoadWebService.Message", (String[])new String[0]), throwable);
                    }
                }
            }
        });
        this.wURL = new TextVar((VariableSpace)this.transMeta, compositeTabWebService, 18436);
        this.wURL.addModifyListener(this.lsMod);
        this.props.setLook((Control)this.wURL);
        FormData fdURL = new FormData();
        fdURL.left = new FormAttachment(middle, 0);
        fdURL.top = new FormAttachment(0, margin);
        fdURL.right = new FormAttachment((Control)this.wbFile, -margin);
        this.wURL.setLayoutData(fdURL);
        this.wlOperation = new Label(compositeTabWebService, 131072);
        this.wlOperation.setText(BaseMessages.getString(PKG, (String)"WebServiceDialog.Operation.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlOperation);
        FormData fdlOperation = new FormData();
        fdlOperation.left = new FormAttachment(0, 0);
        fdlOperation.top = new FormAttachment((Control)this.wURL, margin);
        fdlOperation.right = new FormAttachment(middle, -margin);
        this.wlOperation.setLayoutData((Object)fdlOperation);
        this.wOperation = new CCombo(compositeTabWebService, 18436);
        this.wOperation.addModifyListener(this.lsMod);
        this.wOperation.setToolTipText(BaseMessages.getString(PKG, (String)"WebServiceDialog.Operation.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wOperation);
        FormData fdOperation = new FormData();
        fdOperation.top = new FormAttachment((Control)this.wURL, margin);
        fdOperation.left = new FormAttachment(middle, 0);
        fdOperation.right = new FormAttachment(100, 0);
        this.wOperation.setLayoutData((Object)fdOperation);
        this.wOperation.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                try {
                    WebServiceDialog.this.selectWSDLOperation(WebServiceDialog.this.wOperation.getText());
                }
                catch (KettleException e) {
                    e.printStackTrace();
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        this.wlOperationRequest = new Label(compositeTabWebService, 131072);
        this.wlOperationRequest.setText(BaseMessages.getString(PKG, (String)"WebServiceDialog.OperationRequest.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlOperationRequest);
        FormData fdlOperationRequest = new FormData();
        fdlOperationRequest.left = new FormAttachment(0, 0);
        fdlOperationRequest.top = new FormAttachment((Control)this.wOperation, margin);
        fdlOperationRequest.right = new FormAttachment(middle, -margin);
        this.wlOperationRequest.setLayoutData((Object)fdlOperationRequest);
        this.wOperationRequest = new Text(compositeTabWebService, 18436);
        this.wOperationRequest.addModifyListener(this.lsMod);
        this.wOperationRequest.setToolTipText(BaseMessages.getString(PKG, (String)"WebServiceDialog.OperationRequest.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wOperationRequest);
        FormData fdOperationRequest = new FormData();
        fdOperationRequest.top = new FormAttachment((Control)this.wOperation, margin);
        fdOperationRequest.left = new FormAttachment(middle, 0);
        fdOperationRequest.right = new FormAttachment(100, 0);
        this.wOperationRequest.setLayoutData((Object)fdOperationRequest);
        this.wlStep = new Label(compositeTabWebService, 131072);
        this.wlStep.setText(BaseMessages.getString(PKG, (String)"WebServiceDialog.Step.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlStep);
        FormData fdlStep = new FormData();
        fdlStep.left = new FormAttachment(0, 0);
        fdlStep.top = new FormAttachment((Control)this.wOperationRequest, margin);
        fdlStep.right = new FormAttachment(middle, -margin);
        this.wlStep.setLayoutData((Object)fdlStep);
        this.wStep = new Text(compositeTabWebService, 18436);
        this.wStep.addModifyListener(this.lsMod);
        this.wStep.setToolTipText(BaseMessages.getString(PKG, (String)"WebServiceDialog.Step.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wStep);
        FormData fdStep = new FormData();
        fdStep.top = new FormAttachment((Control)this.wOperationRequest, margin);
        fdStep.left = new FormAttachment(middle, 0);
        fdStep.right = new FormAttachment(100, 0);
        this.wStep.setLayoutData((Object)fdStep);
        this.wlPassInputData = new Label(compositeTabWebService, 131072);
        this.wlPassInputData.setText(BaseMessages.getString(PKG, (String)"WebServiceDialog.PassInputData.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlPassInputData);
        FormData fdlPassInputData = new FormData();
        fdlPassInputData.left = new FormAttachment(0, 0);
        fdlPassInputData.top = new FormAttachment((Control)this.wStep, margin);
        fdlPassInputData.right = new FormAttachment(middle, -margin);
        this.wlPassInputData.setLayoutData((Object)fdlPassInputData);
        this.wPassInputData = new Button(compositeTabWebService, 32);
        this.wPassInputData.setToolTipText(BaseMessages.getString(PKG, (String)"WebServiceDialog.PassInputData.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wPassInputData);
        FormData fdPassInputData = new FormData();
        fdPassInputData.top = new FormAttachment((Control)this.wStep, margin);
        fdPassInputData.left = new FormAttachment(middle, 0);
        fdPassInputData.right = new FormAttachment(100, 0);
        this.wPassInputData.setLayoutData((Object)fdPassInputData);
        this.wlCompatible = new Label(compositeTabWebService, 131072);
        this.wlCompatible.setText(BaseMessages.getString(PKG, (String)"WebServiceDialog.Compatible.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlCompatible);
        FormData fdlCompatible = new FormData();
        fdlCompatible.left = new FormAttachment(0, 0);
        fdlCompatible.top = new FormAttachment((Control)this.wPassInputData, margin);
        fdlCompatible.right = new FormAttachment(middle, -margin);
        this.wlCompatible.setLayoutData((Object)fdlCompatible);
        this.wCompatible = new Button(compositeTabWebService, 32);
        this.wCompatible.setToolTipText(BaseMessages.getString(PKG, (String)"WebServiceDialog.Compatible.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wCompatible);
        FormData fdCompatible = new FormData();
        fdCompatible.top = new FormAttachment((Control)this.wPassInputData, margin);
        fdCompatible.left = new FormAttachment(middle, 0);
        fdCompatible.right = new FormAttachment(100, 0);
        this.wCompatible.setLayoutData((Object)fdCompatible);
        this.wlRepeatingElement = new Label(compositeTabWebService, 131072);
        this.wlRepeatingElement.setText(BaseMessages.getString(PKG, (String)"WebServiceDialog.RepeatingElement.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlRepeatingElement);
        FormData fdlRepeatingElement = new FormData();
        fdlRepeatingElement.top = new FormAttachment((Control)this.wCompatible, margin);
        fdlRepeatingElement.left = new FormAttachment(0, 0);
        fdlRepeatingElement.right = new FormAttachment(middle, -margin);
        this.wlRepeatingElement.setLayoutData((Object)fdlRepeatingElement);
        this.wRepeatingElement = new TextVar((VariableSpace)this.transMeta, compositeTabWebService, 18436);
        this.wRepeatingElement.addModifyListener(this.lsMod);
        this.wRepeatingElement.setToolTipText(BaseMessages.getString(PKG, (String)"WebServiceDialog.RepeatingElement.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wRepeatingElement);
        FormData fdRepeatingElement = new FormData();
        fdRepeatingElement.top = new FormAttachment((Control)this.wCompatible, margin);
        fdRepeatingElement.left = new FormAttachment(middle, 0);
        fdRepeatingElement.right = new FormAttachment(100, 0);
        this.wRepeatingElement.setLayoutData(fdRepeatingElement);
        this.wlReplyAsString = new Label(compositeTabWebService, 131072);
        this.wlReplyAsString.setText(BaseMessages.getString(PKG, (String)"WebServiceDialog.ReplyAsString.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlReplyAsString);
        FormData fdlBodyAsString = new FormData();
        fdlBodyAsString.left = new FormAttachment(0, 0);
        fdlBodyAsString.top = new FormAttachment((Control)this.wRepeatingElement, margin);
        fdlBodyAsString.right = new FormAttachment(middle, -margin);
        this.wlReplyAsString.setLayoutData((Object)fdlBodyAsString);
        this.wReplyAsString = new Button(compositeTabWebService, 32);
        this.wReplyAsString.setToolTipText(BaseMessages.getString(PKG, (String)"WebServiceDialog.ReplyAsString.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wReplyAsString);
        FormData fdBodyAsString = new FormData();
        fdBodyAsString.top = new FormAttachment((Control)this.wRepeatingElement, margin);
        fdBodyAsString.left = new FormAttachment(middle, 0);
        fdBodyAsString.right = new FormAttachment(100, 0);
        this.wReplyAsString.setLayoutData((Object)fdBodyAsString);
        Group gHttpAuth = new Group(compositeTabWebService, 16);
        gHttpAuth.setText(BaseMessages.getString(PKG, (String)"WebServicesDialog.HttpAuthGroup.Label", (String[])new String[0]));
        FormLayout httpAuthLayout = new FormLayout();
        httpAuthLayout.marginWidth = 3;
        httpAuthLayout.marginHeight = 3;
        gHttpAuth.setLayout((Layout)httpAuthLayout);
        this.props.setLook((Control)gHttpAuth);
        this.wlHttpLogin = new Label((Composite)gHttpAuth, 131072);
        this.wlHttpLogin.setText(BaseMessages.getString(PKG, (String)"WebServiceDialog.HttpLogin.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlHttpLogin);
        FormData fdlHttpLogin = new FormData();
        fdlHttpLogin.top = new FormAttachment(0, margin);
        fdlHttpLogin.left = new FormAttachment(0, 0);
        fdlHttpLogin.right = new FormAttachment(middle, -margin);
        this.wlHttpLogin.setLayoutData((Object)fdlHttpLogin);
        this.wHttpLogin = new TextVar((VariableSpace)this.transMeta, (Composite)gHttpAuth, 18436);
        this.wHttpLogin.addModifyListener(this.lsMod);
        this.wHttpLogin.setToolTipText(BaseMessages.getString(PKG, (String)"WebServiceDialog.HttpLogin.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wHttpLogin);
        FormData fdHttpLogin = new FormData();
        fdHttpLogin.top = new FormAttachment(0, margin);
        fdHttpLogin.left = new FormAttachment(middle, 0);
        fdHttpLogin.right = new FormAttachment(100, 0);
        this.wHttpLogin.setLayoutData(fdHttpLogin);
        this.wlHttpPassword = new Label((Composite)gHttpAuth, 131072);
        this.wlHttpPassword.setText(BaseMessages.getString(PKG, (String)"WebServiceDialog.HttpPassword.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlHttpPassword);
        FormData fdlHttpPassword = new FormData();
        fdlHttpPassword.top = new FormAttachment((Control)this.wHttpLogin, margin);
        fdlHttpPassword.left = new FormAttachment(0, 0);
        fdlHttpPassword.right = new FormAttachment(middle, -margin);
        this.wlHttpPassword.setLayoutData((Object)fdlHttpPassword);
        this.wHttpPassword = new PasswordTextVar((VariableSpace)this.transMeta, (Composite)gHttpAuth, 18436);
        this.wHttpPassword.addModifyListener(this.lsMod);
        this.wHttpPassword.setToolTipText(BaseMessages.getString(PKG, (String)"WebServiceDialog.HttpPassword.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wHttpPassword);
        FormData fdHttpPassword = new FormData();
        fdHttpPassword.top = new FormAttachment((Control)this.wHttpLogin, margin);
        fdHttpPassword.left = new FormAttachment(middle, 0);
        fdHttpPassword.right = new FormAttachment(100, 0);
        this.wHttpPassword.setLayoutData(fdHttpPassword);
        FormData fdHttpAuth = new FormData();
        fdHttpAuth.left = new FormAttachment(0, 0);
        fdHttpAuth.right = new FormAttachment(100, 0);
        fdHttpAuth.top = new FormAttachment((Control)this.wReplyAsString, margin);
        gHttpAuth.setLayoutData((Object)fdHttpAuth);
        Group gProxy = new Group(compositeTabWebService, 16);
        gProxy.setText(BaseMessages.getString(PKG, (String)"WebServicesDialog.ProxyGroup.Label", (String[])new String[0]));
        FormLayout proxyLayout = new FormLayout();
        proxyLayout.marginWidth = 3;
        proxyLayout.marginHeight = 3;
        gProxy.setLayout((Layout)proxyLayout);
        this.props.setLook((Control)gProxy);
        this.wlProxyHost = new Label((Composite)gProxy, 131072);
        this.wlProxyHost.setText(BaseMessages.getString(PKG, (String)"WebServiceDialog.ProxyHost.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlProxyHost);
        FormData fdlProxyHost = new FormData();
        fdlProxyHost.top = new FormAttachment(0, margin);
        fdlProxyHost.left = new FormAttachment(0, 0);
        fdlProxyHost.right = new FormAttachment(middle, -margin);
        this.wlProxyHost.setLayoutData((Object)fdlProxyHost);
        this.wProxyHost = new TextVar((VariableSpace)this.transMeta, (Composite)gProxy, 18436);
        this.wProxyHost.addModifyListener(this.lsMod);
        this.wProxyHost.setToolTipText(BaseMessages.getString(PKG, (String)"WebServiceDialog.ProxyHost.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wProxyHost);
        FormData fdProxyHost = new FormData();
        fdProxyHost.top = new FormAttachment(0, margin);
        fdProxyHost.left = new FormAttachment(middle, 0);
        fdProxyHost.right = new FormAttachment(100, 0);
        this.wProxyHost.setLayoutData(fdProxyHost);
        this.wlProxyPort = new Label((Composite)gProxy, 131072);
        this.wlProxyPort.setText(BaseMessages.getString(PKG, (String)"WebServiceDialog.ProxyPort.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlProxyPort);
        FormData fdlProxyPort = new FormData();
        fdlProxyPort.top = new FormAttachment((Control)this.wProxyHost, margin);
        fdlProxyPort.left = new FormAttachment(0, 0);
        fdlProxyPort.right = new FormAttachment(middle, -margin);
        this.wlProxyPort.setLayoutData((Object)fdlProxyPort);
        this.wProxyPort = new TextVar((VariableSpace)this.transMeta, (Composite)gProxy, 18436);
        this.wProxyPort.addModifyListener(this.lsMod);
        this.wProxyPort.setToolTipText(BaseMessages.getString(PKG, (String)"WebServiceDialog.ProxyPort.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wProxyPort);
        FormData fdProxyPort = new FormData();
        fdProxyPort.top = new FormAttachment((Control)this.wProxyHost, margin);
        fdProxyPort.left = new FormAttachment(middle, 0);
        fdProxyPort.right = new FormAttachment(100, 0);
        this.wProxyPort.setLayoutData(fdProxyPort);
        FormData fdProxy = new FormData();
        fdProxy.left = new FormAttachment(0, 0);
        fdProxy.right = new FormAttachment(100, 0);
        fdProxy.top = new FormAttachment((Control)gHttpAuth, margin);
        gProxy.setLayoutData((Object)fdProxy);
        FormData fdFileComp = new FormData();
        fdFileComp.left = new FormAttachment(0, 0);
        fdFileComp.top = new FormAttachment(0, 0);
        fdFileComp.right = new FormAttachment(100, 0);
        fdFileComp.bottom = new FormAttachment(100, 0);
        compositeTabWebService.setLayoutData((Object)fdFileComp);
        compositeTabWebService.layout();
        this.tabItemWebService.setControl((Control)compositeTabWebService);
        this.wURL.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                WebServiceDialog.this.getData();
            }
        });
        SelectionAdapter selAdapter = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                WebServiceDialog.this.ok();
            }
        };
        this.wHttpPassword.addSelectionListener(selAdapter);
        this.wHttpLogin.addSelectionListener(selAdapter);
        this.wStep.addSelectionListener((SelectionListener)selAdapter);
        this.wProxyHost.addSelectionListener(selAdapter);
        this.wProxyPort.addSelectionListener(selAdapter);
        this.wStepname.addSelectionListener((SelectionListener)selAdapter);
        this.wTabFolder.setSelection(this.tabItemWebService);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)this.wStepname, margin);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment(100, -50);
        this.wTabFolder.setLayoutData((Object)fdTabFolder);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wAddInput = new Button((Composite)this.shell, 8);
        this.wAddInput.setText(BaseMessages.getString(PKG, (String)"WebServiceDialog.Label.AddInputButton", (String[])new String[0]));
        this.wAddOutput = new Button((Composite)this.shell, 8);
        this.wAddOutput.setText(BaseMessages.getString(PKG, (String)"WebServiceDialog.Label.AddOutputButton", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOK, this.wAddInput, this.wAddOutput, this.wCancel}, margin, (Control)this.wTabFolder);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                WebServiceDialog.this.cancel();
            }
        });
        this.wOK.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WebServiceDialog.this.ok();
            }
        });
        this.wAddInput.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WebServiceDialog.this.addTabFieldIn();
                WebServiceDialog.this.wTabFolder.setSelection(WebServiceDialog.this.tabItemFieldIn);
            }
        });
        this.wAddOutput.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WebServiceDialog.this.addTabFieldOut();
                WebServiceDialog.this.wTabFolder.setSelection(WebServiceDialog.this.tabItemFieldOut);
            }
        });
        this.wCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WebServiceDialog.this.cancel();
            }
        });
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                WebServiceDialog.this.ok();
            }
        };
        this.getData();
        this.setComboValues();
        this.setSize();
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wStepname.getText())) {
            return;
        }
        this.stepname = this.wStepname.getText();
        this.getInfo(this.meta);
        this.dispose();
    }

    private void cancel() {
        this.stepname = null;
        this.meta.setChanged(this.changed);
        this.dispose();
    }

    private void setComboValues() {
        Runnable fieldLoader = new Runnable(){

            @Override
            public void run() {
                try {
                    WebServiceDialog.this.prevFields = WebServiceDialog.this.transMeta.getPrevStepFields(WebServiceDialog.this.stepname);
                }
                catch (KettleException e) {
                    WebServiceDialog.this.prevFields = (RowMetaInterface)new RowMeta();
                    String msg = BaseMessages.getString((Class)PKG, (String)"SelectValuesDialog.DoMapping.UnableToFindInput", (String[])new String[0]);
                    WebServiceDialog.this.logError(msg);
                }
                Object[] prevStepFieldNames = WebServiceDialog.this.prevFields.getFieldNames();
                Arrays.sort(prevStepFieldNames);
                for (int i = 0; i < WebServiceDialog.this.fieldColumns.size(); ++i) {
                    ColumnInfo colInfo = (ColumnInfo)WebServiceDialog.this.fieldColumns.get(i);
                    colInfo.setComboValues((String[])prevStepFieldNames);
                }
            }
        };
        this.shell.getDisplay().asyncExec(fieldLoader);
    }
}

