/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.sort;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.sort.SortRowsMeta;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.widget.CheckBoxVar;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.di.ui.trans.step.ComponentSelectionListener;
import org.pentaho.di.ui.trans.step.TableItemInsertListener;

public class SortRowsDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = SortRowsMeta.class;
    private Label wlSortDir;
    private Button wbSortDir;
    private TextVar wSortDir;
    private FormData fdlSortDir;
    private FormData fdbSortDir;
    private FormData fdSortDir;
    private Label wlPrefix;
    private Text wPrefix;
    private FormData fdlPrefix;
    private FormData fdPrefix;
    private Label wlSortSize;
    private TextVar wSortSize;
    private FormData fdlSortSize;
    private FormData fdSortSize;
    private Label wlFreeMemory;
    private TextVar wFreeMemory;
    private FormData fdlFreeMemory;
    private FormData fdFreeMemory;
    private Label wlCompress;
    private CheckBoxVar wCompress;
    private FormData fdlCompress;
    private FormData fdCompress;
    private Label wlUniqueRows;
    private Button wUniqueRows;
    private FormData fdlUniqueRows;
    private FormData fdUniqueRows;
    private Label wlFields;
    private TableView wFields;
    private FormData fdlFields;
    private FormData fdFields;
    private SortRowsMeta input;
    private Map<String, Integer> inputFields;
    private ColumnInfo[] colinf;

    public SortRowsDialog(Shell parent, Object in, TransMeta transMeta, String sname) {
        super(parent, (BaseStepMeta)in, transMeta, sname);
        this.input = (SortRowsMeta)in;
        this.inputFields = new HashMap<String, Integer>();
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.input);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SortRowsDialog.this.input.setChanged();
            }
        };
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"SortRowsDialog.DialogTitle", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"System.Label.StepName", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.right = new FormAttachment(middle, -margin);
        this.fdlStepname.top = new FormAttachment(0, margin);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment(middle, 0);
        this.fdStepname.top = new FormAttachment(0, margin);
        this.fdStepname.right = new FormAttachment(100, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        this.wlSortDir = new Label((Composite)this.shell, 131072);
        this.wlSortDir.setText(BaseMessages.getString(PKG, (String)"SortRowsDialog.SortDir.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlSortDir);
        this.fdlSortDir = new FormData();
        this.fdlSortDir.left = new FormAttachment(0, 0);
        this.fdlSortDir.right = new FormAttachment(middle, -margin);
        this.fdlSortDir.top = new FormAttachment((Control)this.wStepname, margin);
        this.wlSortDir.setLayoutData((Object)this.fdlSortDir);
        this.wbSortDir = new Button((Composite)this.shell, 0x1000008);
        this.props.setLook((Control)this.wbSortDir);
        this.wbSortDir.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        this.fdbSortDir = new FormData();
        this.fdbSortDir.right = new FormAttachment(100, 0);
        this.fdbSortDir.top = new FormAttachment((Control)this.wStepname, margin);
        this.wbSortDir.setLayoutData((Object)this.fdbSortDir);
        this.wSortDir = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.wSortDir.setText("temp");
        this.props.setLook((Control)this.wSortDir);
        this.wSortDir.addModifyListener(lsMod);
        this.fdSortDir = new FormData();
        this.fdSortDir.left = new FormAttachment(middle, 0);
        this.fdSortDir.top = new FormAttachment((Control)this.wStepname, margin);
        this.fdSortDir.right = new FormAttachment((Control)this.wbSortDir, -margin);
        this.wSortDir.setLayoutData(this.fdSortDir);
        this.wbSortDir.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                DirectoryDialog dd = new DirectoryDialog(SortRowsDialog.this.shell, 0);
                dd.setFilterPath(SortRowsDialog.this.wSortDir.getText());
                String dir = dd.open();
                if (dir != null) {
                    SortRowsDialog.this.wSortDir.setText(dir);
                }
            }
        });
        this.wSortDir.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SortRowsDialog.this.wSortDir.setToolTipText(SortRowsDialog.this.transMeta.environmentSubstitute(SortRowsDialog.this.wSortDir.getText()));
            }
        });
        this.wlPrefix = new Label((Composite)this.shell, 131072);
        this.wlPrefix.setText(BaseMessages.getString(PKG, (String)"SortRowsDialog.Prefix.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlPrefix);
        this.fdlPrefix = new FormData();
        this.fdlPrefix.left = new FormAttachment(0, 0);
        this.fdlPrefix.right = new FormAttachment(middle, -margin);
        this.fdlPrefix.top = new FormAttachment((Control)this.wbSortDir, margin * 2);
        this.wlPrefix.setLayoutData((Object)this.fdlPrefix);
        this.wPrefix = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wPrefix);
        this.wPrefix.addModifyListener(lsMod);
        this.fdPrefix = new FormData();
        this.fdPrefix.left = new FormAttachment(middle, 0);
        this.fdPrefix.top = new FormAttachment((Control)this.wbSortDir, margin * 2);
        this.fdPrefix.right = new FormAttachment(100, 0);
        this.wPrefix.setLayoutData((Object)this.fdPrefix);
        this.wPrefix.setText("srt");
        this.wlSortSize = new Label((Composite)this.shell, 131072);
        this.wlSortSize.setText(BaseMessages.getString(PKG, (String)"SortRowsDialog.SortSize.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlSortSize);
        this.fdlSortSize = new FormData();
        this.fdlSortSize.left = new FormAttachment(0, 0);
        this.fdlSortSize.right = new FormAttachment(middle, -margin);
        this.fdlSortSize.top = new FormAttachment((Control)this.wPrefix, margin * 2);
        this.wlSortSize.setLayoutData((Object)this.fdlSortSize);
        this.wSortSize = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wSortSize);
        this.wSortSize.addModifyListener(lsMod);
        this.fdSortSize = new FormData();
        this.fdSortSize.left = new FormAttachment(middle, 0);
        this.fdSortSize.top = new FormAttachment((Control)this.wPrefix, margin * 2);
        this.fdSortSize.right = new FormAttachment(100, 0);
        this.wSortSize.setLayoutData(this.fdSortSize);
        this.wlFreeMemory = new Label((Composite)this.shell, 131072);
        this.wlFreeMemory.setText(BaseMessages.getString(PKG, (String)"SortRowsDialog.FreeMemory.Label", (String[])new String[0]));
        this.wlFreeMemory.setToolTipText(BaseMessages.getString(PKG, (String)"SortRowsDialog.FreeMemory.ToolTip", (String[])new String[0]));
        this.props.setLook((Control)this.wlFreeMemory);
        this.fdlFreeMemory = new FormData();
        this.fdlFreeMemory.left = new FormAttachment(0, 0);
        this.fdlFreeMemory.right = new FormAttachment(middle, -margin);
        this.fdlFreeMemory.top = new FormAttachment((Control)this.wSortSize, margin * 2);
        this.wlFreeMemory.setLayoutData((Object)this.fdlFreeMemory);
        this.wFreeMemory = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.wFreeMemory.setToolTipText(BaseMessages.getString(PKG, (String)"SortRowsDialog.FreeMemory.ToolTip", (String[])new String[0]));
        this.props.setLook((Control)this.wFreeMemory);
        this.wFreeMemory.addModifyListener(lsMod);
        this.fdFreeMemory = new FormData();
        this.fdFreeMemory.left = new FormAttachment(middle, 0);
        this.fdFreeMemory.top = new FormAttachment((Control)this.wSortSize, margin * 2);
        this.fdFreeMemory.right = new FormAttachment(100, 0);
        this.wFreeMemory.setLayoutData(this.fdFreeMemory);
        this.wlCompress = new Label((Composite)this.shell, 131072);
        this.wlCompress.setText(BaseMessages.getString(PKG, (String)"SortRowsDialog.Compress.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlCompress);
        this.fdlCompress = new FormData();
        this.fdlCompress.left = new FormAttachment(0, 0);
        this.fdlCompress.right = new FormAttachment(middle, -margin);
        this.fdlCompress.top = new FormAttachment((Control)this.wFreeMemory, margin * 2);
        this.wlCompress.setLayoutData((Object)this.fdlCompress);
        this.wCompress = new CheckBoxVar((VariableSpace)this.transMeta, (Composite)this.shell, 32, "");
        this.props.setLook((Control)this.wCompress);
        this.fdCompress = new FormData();
        this.fdCompress.left = new FormAttachment(middle, 0);
        this.fdCompress.top = new FormAttachment((Control)this.wFreeMemory, margin * 2);
        this.fdCompress.right = new FormAttachment(100, 0);
        this.wCompress.setLayoutData(this.fdCompress);
        this.wCompress.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SortRowsDialog.this.log.logDetailed("SortRowsDialog", new Object[]{"Selection Listener for compress: " + SortRowsDialog.this.wCompress.getSelection()});
                SortRowsDialog.this.input.setChanged();
            }
        });
        this.wlUniqueRows = new Label((Composite)this.shell, 131072);
        this.wlUniqueRows.setText(BaseMessages.getString(PKG, (String)"SortRowsDialog.UniqueRows.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlUniqueRows);
        this.fdlUniqueRows = new FormData();
        this.fdlUniqueRows.left = new FormAttachment(0, 0);
        this.fdlUniqueRows.right = new FormAttachment(middle, -margin);
        this.fdlUniqueRows.top = new FormAttachment((Control)this.wCompress, margin);
        this.wlUniqueRows.setLayoutData((Object)this.fdlUniqueRows);
        this.wUniqueRows = new Button((Composite)this.shell, 32);
        this.wUniqueRows.setToolTipText(BaseMessages.getString(PKG, (String)"SortRowsDialog.UniqueRows.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wUniqueRows);
        this.fdUniqueRows = new FormData();
        this.fdUniqueRows.left = new FormAttachment(middle, 0);
        this.fdUniqueRows.top = new FormAttachment((Control)this.wCompress, margin);
        this.fdUniqueRows.right = new FormAttachment(100, 0);
        this.wUniqueRows.setLayoutData((Object)this.fdUniqueRows);
        this.wUniqueRows.addSelectionListener((SelectionListener)new ComponentSelectionListener((BaseStepMeta)this.input));
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wGet = new Button((Composite)this.shell, 8);
        this.wGet.setText(BaseMessages.getString(PKG, (String)"System.Button.GetFields", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOK, this.wCancel, this.wGet}, margin, null);
        this.wlFields = new Label((Composite)this.shell, 0);
        this.wlFields.setText(BaseMessages.getString(PKG, (String)"SortRowsDialog.Fields.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlFields);
        this.fdlFields = new FormData();
        this.fdlFields.left = new FormAttachment(0, 0);
        this.fdlFields.top = new FormAttachment((Control)this.wUniqueRows, margin);
        this.wlFields.setLayoutData((Object)this.fdlFields);
        int FieldsRows = this.input.getFieldName().length;
        this.colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"SortRowsDialog.Fieldname.Column", (String[])new String[0]), 2, new String[]{""}, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"SortRowsDialog.Ascending.Column", (String[])new String[0]), 2, new String[]{BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0])}), new ColumnInfo(BaseMessages.getString(PKG, (String)"SortRowsDialog.CaseInsensitive.Column", (String[])new String[0]), 2, new String[]{BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0])}), new ColumnInfo(BaseMessages.getString(PKG, (String)"SortRowsDialog.CollatorDisabled.Column", (String[])new String[0]), 2, new String[]{BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0])}), new ColumnInfo(BaseMessages.getString(PKG, (String)"SortRowsDialog.CollatorStrength.Column", (String[])new String[0]), 2, new String[]{BaseMessages.getString(PKG, (String)"System.Combo.Primary", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.Secondary", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.Tertiary", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.Identical", (String[])new String[0])}, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"SortRowsDialog.PreSortedField.Column", (String[])new String[0]), 2, new String[]{BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0])})};
        this.wFields = new TableView((VariableSpace)this.transMeta, (Composite)this.shell, 67586, this.colinf, FieldsRows, lsMod, this.props);
        this.fdFields = new FormData();
        this.fdFields.left = new FormAttachment(0, 0);
        this.fdFields.top = new FormAttachment((Control)this.wlFields, margin);
        this.fdFields.right = new FormAttachment(100, 0);
        this.fdFields.bottom = new FormAttachment((Control)this.wOK, -2 * margin);
        this.wFields.setLayoutData(this.fdFields);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                StepMeta stepMeta = SortRowsDialog.this.transMeta.findStep(SortRowsDialog.this.stepname);
                if (stepMeta != null) {
                    try {
                        RowMetaInterface row = SortRowsDialog.this.transMeta.getPrevStepFields(stepMeta);
                        for (int i = 0; i < row.size(); ++i) {
                            SortRowsDialog.this.inputFields.put(row.getValueMeta(i).getName(), i);
                        }
                        SortRowsDialog.this.setComboBoxes();
                    }
                    catch (KettleException e) {
                        SortRowsDialog.this.logError(BaseMessages.getString((Class)PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]));
                    }
                }
            }
        };
        new Thread(runnable).start();
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                SortRowsDialog.this.ok();
            }
        };
        this.lsGet = new Listener(){

            public void handleEvent(Event e) {
                SortRowsDialog.this.get();
            }
        };
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                SortRowsDialog.this.cancel();
            }
        };
        this.wOK.addListener(13, this.lsOK);
        this.wGet.addListener(13, this.lsGet);
        this.wCancel.addListener(13, this.lsCancel);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                SortRowsDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.wSortDir.addSelectionListener(this.lsDef);
        this.wPrefix.addSelectionListener((SelectionListener)this.lsDef);
        this.wSortSize.addSelectionListener(this.lsDef);
        this.wFreeMemory.addSelectionListener(this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                SortRowsDialog.this.cancel();
            }
        });
        this.lsResize = new Listener(){

            public void handleEvent(Event event) {
                Point size = SortRowsDialog.this.shell.getSize();
                SortRowsDialog.this.wFields.setSize(size.x - 10, size.y - 50);
                ((SortRowsDialog)SortRowsDialog.this).wFields.table.setSize(size.x - 10, size.y - 50);
                SortRowsDialog.this.wFields.redraw();
            }
        };
        this.shell.addListener(11, this.lsResize);
        this.setSize();
        this.getData();
        this.input.setChanged(this.changed);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    protected void setComboBoxes() {
        HashMap<String, Integer> fields = new HashMap<String, Integer>();
        fields.putAll(this.inputFields);
        Set keySet = fields.keySet();
        ArrayList entries = new ArrayList(keySet);
        String[] fieldNames = entries.toArray(new String[entries.size()]);
        Const.sortStrings((String[])fieldNames);
        this.colinf[0].setComboValues(fieldNames);
    }

    public void getData() {
        if (this.input.getPrefix() != null) {
            this.wPrefix.setText(this.input.getPrefix());
        }
        if (this.input.getDirectory() != null) {
            this.wSortDir.setText(this.input.getDirectory());
        }
        this.wSortSize.setText(Const.NVL((String)this.input.getSortSize(), (String)""));
        this.wFreeMemory.setText(Const.NVL((String)this.input.getFreeMemoryLimit(), (String)""));
        this.wCompress.setSelection(this.input.getCompressFiles());
        this.wCompress.setVariableName(this.input.getCompressFilesVariable());
        this.wUniqueRows.setSelection(this.input.isOnlyPassingUniqueRows());
        Table table = this.wFields.table;
        if (this.input.getFieldName().length > 0) {
            table.removeAll();
        }
        for (int i = 0; i < this.input.getFieldName().length; ++i) {
            TableItem ti = new TableItem(table, 0);
            ti.setText(0, "" + (i + 1));
            ti.setText(1, this.input.getFieldName()[i]);
            ti.setText(2, this.input.getAscending()[i] ? BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0]) : BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]));
            ti.setText(3, this.input.getCaseSensitive()[i] ? BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0]) : BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]));
            ti.setText(4, this.input.getCollatorEnabled()[i] ? BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0]) : BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]));
            ti.setText(5, this.input.getCollatorStrength()[i] == 0 ? BaseMessages.getString(PKG, (String)"System.Combo.Primary", (String[])new String[0]) : Integer.toString(this.input.getCollatorStrength()[i]));
            ti.setText(6, this.input.getPreSortedField()[i] ? BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0]) : BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]));
        }
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
        this.wStepname.selectAll();
        this.wStepname.setFocus();
    }

    private void cancel() {
        this.stepname = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wStepname.getText())) {
            return;
        }
        this.stepname = this.wStepname.getText();
        this.input.setPrefix(this.wPrefix.getText());
        this.input.setDirectory(this.wSortDir.getText());
        this.input.setSortSize(this.wSortSize.getText());
        this.input.setFreeMemoryLimit(this.wFreeMemory.getText());
        this.log.logDetailed("Sort rows", new Object[]{"Compression is set to " + this.wCompress.getSelection()});
        this.input.setCompressFiles(this.wCompress.getSelection());
        this.input.setCompressFilesVariable(this.wCompress.getVariableName());
        this.input.setOnlyPassingUniqueRows(this.wUniqueRows.getSelection());
        int nrfields = this.wFields.nrNonEmpty();
        this.input.allocate(nrfields);
        for (int i = 0; i < nrfields; ++i) {
            TableItem ti = this.wFields.getNonEmpty(i);
            this.input.getFieldName()[i] = ti.getText(1);
            this.input.getAscending()[i] = Utils.isEmpty((CharSequence)ti.getText(2)) || BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0]).equalsIgnoreCase(ti.getText(2));
            this.input.getCaseSensitive()[i] = BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0]).equalsIgnoreCase(ti.getText(3));
            this.input.getCollatorEnabled()[i] = BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0]).equalsIgnoreCase(ti.getText(4));
            this.input.getCollatorStrength()[i] = ti.getText(5) == "" ? Integer.parseInt(BaseMessages.getString(PKG, (String)"System.Combo.Primary", (String[])new String[0])) : Integer.parseInt(ti.getText(5));
            this.input.getPreSortedField()[i] = BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0]).equalsIgnoreCase(ti.getText(6));
        }
        this.dispose();
    }

    private void get() {
        try {
            RowMetaInterface r = this.transMeta.getPrevStepFields(this.stepname);
            if (r != null) {
                TableItemInsertListener insertListener = new TableItemInsertListener(){

                    @Override
                    public boolean tableItemInserted(TableItem tableItem, ValueMetaInterface v) {
                        tableItem.setText(2, BaseMessages.getString((Class)PKG, (String)"System.Combo.Yes", (String[])new String[0]));
                        return true;
                    }
                };
                BaseStepDialog.getFieldsFromPrevious(r, this.wFields, 1, new int[]{1}, new int[0], -1, -1, insertListener);
            }
        }
        catch (KettleException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]), (Exception)((Object)ke));
        }
    }
}

