/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.mapping;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ObjectLocationSpecificationMethod;
import org.pentaho.di.core.SourceToTargetMapping;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryObject;
import org.pentaho.di.repository.RepositoryObjectType;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.mapping.MappingIODefinition;
import org.pentaho.di.trans.steps.mapping.MappingMeta;
import org.pentaho.di.trans.steps.mapping.MappingParameters;
import org.pentaho.di.trans.steps.mapping.MappingValueRename;
import org.pentaho.di.ui.core.dialog.EnterMappingDialog;
import org.pentaho.di.ui.core.dialog.EnterSelectionDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.dialog.WarningDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.ColumnsResizer;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.di.ui.util.DialogHelper;
import org.pentaho.di.ui.util.DialogUtils;
import org.pentaho.di.ui.util.MappingUtil;
import org.pentaho.di.ui.util.SwtSvgImageUtil;
import org.pentaho.vfs.ui.VfsFileChooserDialog;

public class MappingDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = MappingMeta.class;
    private MappingMeta mappingMeta;
    private Label wlPath;
    private TextVar wPath;
    private Button wbBrowse;
    private CTabFolder wTabFolder;
    private TransMeta mappingTransMeta = null;
    protected boolean transModified;
    private ModifyListener lsMod;
    private MappingParameters mappingParameters;
    private List<MappingIODefinition> inputMappings;
    private List<MappingIODefinition> outputMappings;
    private ObjectId referenceObjectId;
    private ObjectLocationSpecificationMethod specificationMethod;
    private ApplyChanges parameterChanges;
    private ApplyChanges tabChanges;
    private static int CONST_WIDTH = 200;

    public MappingDialog(Shell parent, Object in, TransMeta tr, String sname) {
        super(parent, (BaseStepMeta)in, tr, sname);
        int i;
        this.mappingMeta = (MappingMeta)in;
        this.transModified = false;
        this.mappingParameters = (MappingParameters)this.mappingMeta.getMappingParameters().clone();
        this.inputMappings = new ArrayList<MappingIODefinition>();
        this.outputMappings = new ArrayList<MappingIODefinition>();
        for (i = 0; i < this.mappingMeta.getInputMappings().size(); ++i) {
            this.inputMappings.add((MappingIODefinition)((MappingIODefinition)this.mappingMeta.getInputMappings().get(i)).clone());
        }
        for (i = 0; i < this.mappingMeta.getOutputMappings().size(); ++i) {
            this.outputMappings.add((MappingIODefinition)((MappingIODefinition)this.mappingMeta.getOutputMappings().get(i)).clone());
        }
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.mappingMeta);
        this.lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MappingDialog.this.mappingMeta.setChanged();
            }
        };
        this.changed = this.mappingMeta.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 15;
        formLayout.marginHeight = 15;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"MappingDialog.Shell.Title", (String[])new String[0]));
        Label wicon = new Label((Composite)this.shell, 131072);
        wicon.setImage(this.getImage());
        FormData fdlicon = new FormData();
        fdlicon.top = new FormAttachment(0, 0);
        fdlicon.right = new FormAttachment(100, 0);
        wicon.setLayoutData((Object)fdlicon);
        this.props.setLook((Control)wicon);
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"MappingDialog.Stepname.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.top = new FormAttachment(0, 0);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(this.lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.width = 250;
        this.fdStepname.left = new FormAttachment(0, 0);
        this.fdStepname.top = new FormAttachment((Control)this.wlStepname, 5);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        Label spacer = new Label((Composite)this.shell, 258);
        FormData fdSpacer = new FormData();
        fdSpacer.left = new FormAttachment(0, 0);
        fdSpacer.top = new FormAttachment((Control)this.wStepname, 15);
        fdSpacer.right = new FormAttachment(100, 0);
        spacer.setLayoutData((Object)fdSpacer);
        this.wlPath = new Label((Composite)this.shell, 16384);
        this.props.setLook((Control)this.wlPath);
        this.wlPath.setText(BaseMessages.getString(PKG, (String)"MappingDialog.Transformation.Label", (String[])new String[0]));
        FormData fdlTransformation = new FormData();
        fdlTransformation.left = new FormAttachment(0, 0);
        fdlTransformation.top = new FormAttachment((Control)spacer, 20);
        fdlTransformation.right = new FormAttachment(50, 0);
        this.wlPath.setLayoutData((Object)fdlTransformation);
        this.wPath = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wPath);
        FormData fdTransformation = new FormData();
        fdTransformation.left = new FormAttachment(0, 0);
        fdTransformation.top = new FormAttachment((Control)this.wlPath, 5);
        fdTransformation.width = 350;
        this.wPath.setLayoutData(fdTransformation);
        this.wbBrowse = new Button((Composite)this.shell, 8);
        this.props.setLook((Control)this.wbBrowse);
        this.wbBrowse.setText(BaseMessages.getString(PKG, (String)"MappingDialog.Browse.Label", (String[])new String[0]));
        FormData fdBrowse = new FormData();
        fdBrowse.left = new FormAttachment((Control)this.wPath, 5);
        fdBrowse.top = new FormAttachment((Control)this.wlPath, Const.isOSX() ? 0 : 5);
        this.wbBrowse.setLayoutData((Object)fdBrowse);
        this.wbBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MappingDialog.this.repository != null) {
                    MappingDialog.this.selectRepositoryTrans();
                } else {
                    MappingDialog.this.selectFileTrans();
                }
            }
        });
        this.wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        this.props.setLook((Control)this.wTabFolder, 5);
        this.wTabFolder.setSimple(false);
        this.wTabFolder.setUnselectedCloseVisible(true);
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        FormData fdCancel = new FormData();
        fdCancel.right = new FormAttachment(100, 0);
        fdCancel.bottom = new FormAttachment(100, 0);
        this.wCancel.setLayoutData((Object)fdCancel);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        FormData fdOk = new FormData();
        fdOk.right = new FormAttachment((Control)this.wCancel, -5);
        fdOk.bottom = new FormAttachment(100, 0);
        this.wOK.setLayoutData((Object)fdOk);
        Label hSpacer = new Label((Composite)this.shell, 258);
        FormData fdhSpacer = new FormData();
        fdhSpacer.left = new FormAttachment(0, 0);
        fdhSpacer.bottom = new FormAttachment((Control)this.wCancel, -15);
        fdhSpacer.right = new FormAttachment(100, 0);
        hSpacer.setLayoutData((Object)fdhSpacer);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)this.wPath, 20);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment((Control)hSpacer, -15);
        this.wTabFolder.setLayoutData((Object)fdTabFolder);
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                MappingDialog.this.cancel();
            }
        };
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                MappingDialog.this.ok();
            }
        };
        this.wCancel.addListener(13, this.lsCancel);
        this.wOK.addListener(13, this.lsOK);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                MappingDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                MappingDialog.this.cancel();
            }
        });
        MappingDialog.setSize(this.shell, 670, 690);
        this.getData();
        this.mappingMeta.setChanged(this.changed);
        this.wTabFolder.setSelection(0);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    protected Image getImage() {
        return SwtSvgImageUtil.getImage(this.shell.getDisplay(), ((Object)((Object)this)).getClass().getClassLoader(), "MAP.svg", 48, 48);
    }

    private void selectRepositoryTrans() {
        RepositoryObject repositoryObject = DialogHelper.selectRepositoryObject("*.ktr", this.log);
        try {
            if (repositoryObject != null) {
                this.loadRepositoryTrans(repositoryObject.getName(), repositoryObject.getRepositoryDirectory());
                String path = DialogUtils.getPath(this.transMeta.getRepositoryDirectory().getPath(), this.mappingTransMeta.getRepositoryDirectory().getPath());
                String fullPath = (path.equals("/") ? "/" : path + "/") + this.mappingTransMeta.getName();
                this.wPath.setText(fullPath);
                this.specificationMethod = ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME;
            }
        }
        catch (KettleException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"MappingDialog.ErrorSelectingObject.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MappingDialog.ErrorSelectingObject.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private void loadRepositoryTrans(String transName, RepositoryDirectoryInterface repdir) throws KettleException {
        this.mappingTransMeta = this.repository.loadTransformation(this.transMeta.environmentSubstitute(transName), repdir, null, true, null);
        this.mappingTransMeta.clearChanged();
    }

    private void selectFileTrans() {
        String curFile = this.transMeta.environmentSubstitute(this.wPath.getText());
        FileObject root = null;
        String parentFolder = null;
        try {
            parentFolder = KettleVFS.getFileObject((String)this.transMeta.environmentSubstitute(this.transMeta.getFilename())).getParent().toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            root = KettleVFS.getFileObject((String)(curFile != null ? curFile : Const.getUserHomeDirectory()));
            VfsFileChooserDialog vfsFileChooser = Spoon.getInstance().getVfsFileChooserDialog(root.getParent(), root);
            FileObject file = vfsFileChooser.open(this.shell, null, Const.STRING_TRANS_FILTER_EXT, Const.getTransformationFilterNames(), 0);
            if (file == null) {
                return;
            }
            String fileName = file.getName().toString();
            if (fileName != null) {
                this.loadFileTrans(fileName);
                if (parentFolder != null && fileName.startsWith(parentFolder)) {
                    fileName = fileName.replace(parentFolder, "${Internal.Entry.Current.Directory}");
                }
                this.wPath.setText(fileName);
                this.specificationMethod = ObjectLocationSpecificationMethod.FILENAME;
            }
        }
        catch (IOException | KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"MappingDialog.ErrorLoadingTransformation.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MappingDialog.ErrorLoadingTransformation.DialogMessage", (String[])new String[0]), (Exception)e);
        }
    }

    private void loadFileTrans(String fname) throws KettleException {
        this.mappingTransMeta = new TransMeta(this.transMeta.environmentSubstitute(fname));
        this.mappingTransMeta.clearChanged();
    }

    void loadTransformation() throws KettleException {
        String filename = this.wPath.getText();
        this.specificationMethod = this.repository != null ? ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME : ObjectLocationSpecificationMethod.FILENAME;
        switch (this.getSpecificationMethod()) {
            case FILENAME: {
                if (Utils.isEmpty((CharSequence)filename)) {
                    return;
                }
                if (!filename.endsWith(".ktr")) {
                    filename = filename + ".ktr";
                    this.wPath.setText(filename);
                }
                this.loadFileTrans(filename);
                break;
            }
            case REPOSITORY_BY_NAME: {
                String transPath;
                if (Utils.isEmpty((CharSequence)filename)) {
                    return;
                }
                if (filename.endsWith(".ktr")) {
                    filename = filename.replace(".ktr", "");
                    this.wPath.setText(filename);
                }
                String realTransname = transPath = this.transMeta.environmentSubstitute(filename);
                String realDirectory = "";
                int index = transPath.lastIndexOf("/");
                if (index != -1) {
                    realTransname = transPath.substring(index + 1);
                    realDirectory = transPath.substring(0, index);
                }
                if (Utils.isEmpty((CharSequence)realDirectory) || Utils.isEmpty((CharSequence)realTransname)) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"MappingDialog.Exception.NoValidMappingDetailsFound", (String[])new String[0]));
                }
                RepositoryDirectoryInterface repdir = this.repository.findDirectory(realDirectory);
                if (repdir == null) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"MappingDialog.Exception.UnableToFindRepositoryDirectory", (String[])new String[0]));
                }
                this.loadRepositoryTrans(realTransname, repdir);
                break;
            }
        }
    }

    private void getByReferenceData(ObjectId transObjectId) {
        try {
            if (this.repository == null) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"MappingDialog.Exception.NotConnectedToRepository.Message", (String[])new String[0]));
            }
            RepositoryObject transInf = this.repository.getObjectInformation(transObjectId, RepositoryObjectType.TRANSFORMATION);
            String path = DialogUtils.getPath(this.transMeta.getRepositoryDirectory().getPath(), transInf.getRepositoryDirectory().getPath());
            String fullPath = Const.NVL((String)path, (String)"") + "/" + Const.NVL((String)transInf.getName(), (String)"");
            this.wPath.setText(fullPath);
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"MappingDialog.Exception.UnableToReferenceObjectId.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MappingDialog.Exception.UnableToReferenceObjectId.Message", (String[])new String[0]), (Exception)((Object)e));
        }
    }

    public void getData() {
        this.setSpecificationMethod(this.mappingMeta.getSpecificationMethod());
        switch (this.getSpecificationMethod()) {
            case FILENAME: {
                this.wPath.setText(Const.NVL((String)this.mappingMeta.getFileName(), (String)""));
                break;
            }
            case REPOSITORY_BY_NAME: {
                String fullPath = Const.NVL((String)this.mappingMeta.getDirectoryPath(), (String)"") + "/" + Const.NVL((String)this.mappingMeta.getTransName(), (String)"");
                this.wPath.setText(fullPath);
                break;
            }
            case REPOSITORY_BY_REFERENCE: {
                this.referenceObjectId = this.mappingMeta.getTransObjectId();
                this.getByReferenceData(this.referenceObjectId);
                break;
            }
        }
        this.addParametersTab(this.mappingParameters);
        this.wTabFolder.setSelection(0);
        this.addInputMappingDefinitionTab();
        this.addOutputMappingDefinitionTab();
        try {
            this.loadTransformation();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.wStepname.selectAll();
        this.wStepname.setFocus();
    }

    private void addInputMappingDefinitionTab() {
        this.addMappingDefinitionTab(this.inputMappings, BaseMessages.getString(PKG, (String)"MappingDialog.InputTab.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MappingDialog.label.AvailableInputs", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MappingDialog.label.AddInput", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MappingDialog.label.RemoveInput", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MappingDialog.InputTab.label.InputSourceStepName", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MappingDialog.InputTab.label.OutputTargetStepName", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MappingDialog.InputTab.label.Description", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MappingDialog.InputTab.column.SourceField", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MappingDialog.InputTab.column.TargetField", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MappingDialog.InputTab.label.NoItems", (String[])new String[0]), true);
    }

    private void addOutputMappingDefinitionTab() {
        this.addMappingDefinitionTab(this.outputMappings, BaseMessages.getString(PKG, (String)"MappingDialog.OutputTab.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MappingDialog.label.AvailableOutputs", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MappingDialog.label.AddOutput", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MappingDialog.label.RemoveOutput", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MappingDialog.OutputTab.label.InputSourceStepName", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MappingDialog.OutputTab.label.OutputTargetStepName", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MappingDialog.OutputTab.label.Description", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MappingDialog.OutputTab.column.SourceField", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MappingDialog.OutputTab.column.TargetField", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MappingDialog.OutputTab.label.NoItems", (String[])new String[0]), false);
    }

    private void addParametersTab(MappingParameters parameters) {
        CTabItem wParametersTab = new CTabItem(this.wTabFolder, 0);
        wParametersTab.setText(BaseMessages.getString(PKG, (String)"MappingDialog.Parameters.Title", (String[])new String[0]));
        wParametersTab.setToolTipText(BaseMessages.getString(PKG, (String)"MappingDialog.Parameters.Tooltip", (String[])new String[0]));
        Composite wParametersComposite = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)wParametersComposite);
        FormLayout parameterTabLayout = new FormLayout();
        parameterTabLayout.marginWidth = 15;
        parameterTabLayout.marginHeight = 15;
        wParametersComposite.setLayout((Layout)parameterTabLayout);
        Button wInheritAll = new Button(wParametersComposite, 32);
        wInheritAll.setText(BaseMessages.getString(PKG, (String)"MappingDialog.Parameters.InheritAll", (String[])new String[0]));
        this.props.setLook((Control)wInheritAll);
        FormData fdInheritAll = new FormData();
        fdInheritAll.bottom = new FormAttachment(100, 0);
        fdInheritAll.left = new FormAttachment(0, 0);
        fdInheritAll.right = new FormAttachment(100, -30);
        wInheritAll.setLayoutData((Object)fdInheritAll);
        wInheritAll.setSelection(parameters.isInheritingAllVariables());
        ColumnInfo[] colinfo = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"MappingDialog.Parameters.column.Variable", (String[])new String[0]), 1, false, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"MappingDialog.Parameters.column.ValueOrField", (String[])new String[0]), 1, false, false)};
        colinfo[1].setUsingVariables(true);
        TableView wMappingParameters = new TableView((VariableSpace)this.transMeta, wParametersComposite, 67588, colinfo, parameters.getVariable().length, this.lsMod, this.props);
        this.props.setLook((Control)wMappingParameters);
        FormData fdMappings = new FormData();
        fdMappings.left = new FormAttachment(0, 0);
        fdMappings.right = new FormAttachment(100, 0);
        fdMappings.top = new FormAttachment(0, 0);
        fdMappings.bottom = new FormAttachment((Control)wInheritAll, -10);
        wMappingParameters.setLayoutData(fdMappings);
        wMappingParameters.getTable().addListener(11, (Listener)new ColumnsResizer(0, 50, 50));
        for (int i = 0; i < parameters.getVariable().length; ++i) {
            TableItem tableItem = wMappingParameters.table.getItem(i);
            tableItem.setText(1, Const.NVL((String)parameters.getVariable()[i], (String)""));
            tableItem.setText(2, Const.NVL((String)parameters.getInputField()[i], (String)""));
        }
        wMappingParameters.setRowNums();
        wMappingParameters.optWidth(true);
        FormData fdParametersComposite = new FormData();
        fdParametersComposite.left = new FormAttachment(0, 0);
        fdParametersComposite.top = new FormAttachment(0, 0);
        fdParametersComposite.right = new FormAttachment(100, 0);
        fdParametersComposite.bottom = new FormAttachment(100, 0);
        wParametersComposite.setLayoutData((Object)fdParametersComposite);
        wParametersComposite.layout();
        wParametersTab.setControl((Control)wParametersComposite);
        this.parameterChanges = new MappingParametersTab(wMappingParameters, wInheritAll, parameters);
    }

    protected String selectTransformationStepname(boolean getTransformationStep, boolean mappingInput) {
        if (getTransformationStep) {
            String dialogTitle = BaseMessages.getString(PKG, (String)"MappingDialog.SelectTransStep.Title", (String[])new String[0]);
            String dialogMessage = BaseMessages.getString(PKG, (String)"MappingDialog.SelectTransStep.Message", (String[])new String[0]);
            String[] stepnames = mappingInput ? this.transMeta.getPrevStepNames(this.stepMeta) : this.transMeta.getNextStepNames(this.stepMeta);
            EnterSelectionDialog dialog = new EnterSelectionDialog(this.shell, stepnames, dialogTitle, dialogMessage);
            return dialog.open();
        }
        String dialogTitle = BaseMessages.getString(PKG, (String)"MappingDialog.SelectMappingStep.Title", (String[])new String[0]);
        String dialogMessage = BaseMessages.getString(PKG, (String)"MappingDialog.SelectMappingStep.Message", (String[])new String[0]);
        String[] stepnames = MappingDialog.getMappingSteps(this.mappingTransMeta, mappingInput);
        EnterSelectionDialog dialog = new EnterSelectionDialog(this.shell, stepnames, dialogTitle, dialogMessage);
        return dialog.open();
    }

    public static String[] getMappingSteps(TransMeta mappingTransMeta, boolean mappingInput) {
        ArrayList<StepMeta> steps = new ArrayList<StepMeta>();
        for (StepMeta stepMeta : mappingTransMeta.getSteps()) {
            if (mappingInput && stepMeta.getStepID().equals("MappingInput")) {
                steps.add(stepMeta);
            }
            if (mappingInput || !stepMeta.getStepID().equals("MappingOutput")) continue;
            steps.add(stepMeta);
        }
        String[] stepnames = new String[steps.size()];
        for (int i = 0; i < stepnames.length; ++i) {
            stepnames[i] = ((StepMeta)steps.get(i)).getName();
        }
        return stepnames;
    }

    public RowMetaInterface getFieldsFromStep(String stepname, boolean getTransformationStep, boolean mappingInput) throws KettleException {
        if (!(mappingInput ^ getTransformationStep)) {
            if (Utils.isEmpty((CharSequence)stepname)) {
                return this.transMeta.getPrevStepFields(this.stepname);
            }
            StepMeta stepMeta = this.transMeta.findStep(stepname);
            if (stepMeta == null) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"MappingDialog.Exception.SpecifiedStepWasNotFound", (String[])new String[]{stepname}));
            }
            return this.transMeta.getStepFields(stepMeta);
        }
        if (this.mappingTransMeta == null) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"MappingDialog.Exception.NoMappingSpecified", (String[])new String[0]));
        }
        if (Utils.isEmpty((CharSequence)stepname)) {
            String[] stepnames = MappingDialog.getMappingSteps(this.mappingTransMeta, mappingInput);
            if (stepnames.length > 1) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"MappingDialog.Exception.OnlyOneMappingInputStepAllowed", (String[])new String[]{"" + stepnames.length}));
            }
            if (stepnames.length == 0) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"MappingDialog.Exception.OneMappingInputStepRequired", (String[])new String[]{"" + stepnames.length}));
            }
            return this.mappingTransMeta.getStepFields(stepnames[0]);
        }
        StepMeta stepMeta = this.mappingTransMeta.findStep(stepname);
        if (stepMeta == null) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"MappingDialog.Exception.SpecifiedStepWasNotFound", (String[])new String[]{stepname}));
        }
        return this.mappingTransMeta.getStepFields(stepMeta);
    }

    private void addMappingDefinitionTab(final List<MappingIODefinition> definitions, final String tabTitle, String listLabel, String addToolTip, String removeToolTip, String inputStepLabel, String outputStepLabel, String descriptionLabel, String sourceColumnLabel, String targetColumnLabel, String noItemsLabel, final boolean input) {
        Button wRenameOutput;
        CTabItem wTab = new CTabItem(this.wTabFolder, 0);
        wTab.setText(tabTitle);
        Composite wInputComposite = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)wInputComposite);
        FormLayout tabLayout = new FormLayout();
        tabLayout.marginWidth = 15;
        tabLayout.marginHeight = 15;
        wInputComposite.setLayout((Layout)tabLayout);
        Label wAvailableInputs = new Label(wInputComposite, 16384);
        this.props.setLook((Control)wAvailableInputs);
        wAvailableInputs.setText(listLabel);
        FormData fdwAvailableInputs = new FormData();
        fdwAvailableInputs.left = new FormAttachment(0);
        fdwAvailableInputs.top = new FormAttachment(0);
        final Label wRemoveButton = new Label(wInputComposite, 0);
        wRemoveButton.setImage(GUIResource.getInstance().getImage("ui/images/generic-delete.svg"));
        wRemoveButton.setToolTipText(removeToolTip);
        this.props.setLook((Control)wRemoveButton);
        FormData fdwAddInputButton = new FormData();
        fdwAddInputButton.top = new FormAttachment(0);
        fdwAddInputButton.right = new FormAttachment(30);
        wRemoveButton.setLayoutData((Object)fdwAddInputButton);
        Label wAddButton = new Label(wInputComposite, 0);
        wAddButton.setImage(GUIResource.getInstance().getImage("ui/images/Add.svg"));
        wAddButton.setToolTipText(addToolTip);
        this.props.setLook((Control)wAddButton);
        FormData fdwAddButton = new FormData();
        fdwAddButton.top = new FormAttachment(0);
        fdwAddButton.right = new FormAttachment((Control)wRemoveButton, -5);
        wAddButton.setLayoutData((Object)fdwAddButton);
        final org.eclipse.swt.widgets.List wInputList = new org.eclipse.swt.widgets.List(wInputComposite, 2048);
        FormData fdwInputList = new FormData();
        fdwInputList.left = new FormAttachment(0);
        fdwInputList.top = new FormAttachment((Control)wAvailableInputs, 5);
        fdwInputList.bottom = new FormAttachment(100);
        fdwInputList.right = new FormAttachment(30);
        wInputList.setLayoutData((Object)fdwInputList);
        for (int i = 0; i < definitions.size(); ++i) {
            String label = !Utils.isEmpty((CharSequence)definitions.get(i).getInputStepname()) ? definitions.get(i).getInputStepname() : tabTitle + (i > 0 ? String.valueOf(i + 1) : "");
            wInputList.add(label);
        }
        final Label wlNoItems = new Label(wInputComposite, 0x1000000);
        wlNoItems.setText(noItemsLabel);
        this.props.setLook((Control)wlNoItems);
        FormData fdlNoItems = new FormData();
        fdlNoItems.left = new FormAttachment((Control)wInputList, 30);
        fdlNoItems.right = new FormAttachment(100);
        fdlNoItems.top = new FormAttachment(50);
        wlNoItems.setLayoutData((Object)fdlNoItems);
        wlNoItems.setVisible(false);
        final Composite wFieldsComposite = new Composite(wInputComposite, 0);
        this.props.setLook((Control)wFieldsComposite);
        FormLayout fieldLayout = new FormLayout();
        fieldLayout.marginWidth = 0;
        fieldLayout.marginHeight = 0;
        wFieldsComposite.setLayout((Layout)fieldLayout);
        final Button wMainPath = new Button(wFieldsComposite, 32);
        wMainPath.setText(BaseMessages.getString(PKG, (String)"MappingDialog.input.MainDataPath", (String[])new String[0]));
        this.props.setLook((Control)wMainPath);
        FormData fdMainPath = new FormData();
        fdMainPath.top = new FormAttachment(0);
        fdMainPath.left = new FormAttachment(0);
        wMainPath.setLayoutData((Object)fdMainPath);
        wMainPath.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ((MappingIODefinition)definitions.get(wInputList.getSelectionIndex())).setMainDataPath(!((MappingIODefinition)definitions.get(wInputList.getSelectionIndex())).isMainDataPath());
            }
        });
        final Label wlInputStep = new Label(wFieldsComposite, 131072);
        this.props.setLook((Control)wlInputStep);
        wlInputStep.setText(inputStepLabel);
        FormData fdlInputStep = new FormData();
        fdlInputStep.top = new FormAttachment((Control)wMainPath, 10);
        fdlInputStep.left = new FormAttachment(0);
        wlInputStep.setLayoutData((Object)fdlInputStep);
        final Button wbInputStep = new Button(wFieldsComposite, 8);
        this.props.setLook((Control)wbInputStep);
        wbInputStep.setText(BaseMessages.getString(PKG, (String)"MappingDialog.button.SourceStepName", (String[])new String[0]));
        FormData fdbInputStep = new FormData();
        fdbInputStep.top = new FormAttachment((Control)wlInputStep, 5);
        fdbInputStep.right = new FormAttachment(100);
        wbInputStep.setLayoutData((Object)fdbInputStep);
        final Text wInputStep = new Text(wFieldsComposite, 18436);
        this.props.setLook((Control)wInputStep);
        wInputStep.addModifyListener(this.lsMod);
        FormData fdInputStep = new FormData();
        fdInputStep.top = new FormAttachment((Control)wlInputStep, 5);
        fdInputStep.left = new FormAttachment(0);
        fdInputStep.right = new FormAttachment((Control)wbInputStep, -5);
        wInputStep.setLayoutData((Object)fdInputStep);
        wInputStep.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent event) {
                ((MappingIODefinition)definitions.get(wInputList.getSelectionIndex())).setInputStepname(wInputStep.getText());
                String label = !Utils.isEmpty((CharSequence)wInputStep.getText()) ? wInputStep.getText() : tabTitle + (wInputList.getSelectionIndex() > 0 ? String.valueOf(wInputList.getSelectionIndex() + 1) : "");
                wInputList.setItem(wInputList.getSelectionIndex(), label);
            }
        });
        wbInputStep.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String stepName = MappingDialog.this.selectTransformationStepname(input, input);
                if (stepName != null) {
                    wInputStep.setText(stepName);
                    ((MappingIODefinition)definitions.get(wInputList.getSelectionIndex())).setInputStepname(stepName);
                }
            }
        });
        final Label wlOutputStep = new Label(wFieldsComposite, 131072);
        this.props.setLook((Control)wlOutputStep);
        wlOutputStep.setText(outputStepLabel);
        FormData fdlOutputStep = new FormData();
        fdlOutputStep.top = new FormAttachment((Control)wInputStep, 10);
        fdlOutputStep.left = new FormAttachment(0);
        wlOutputStep.setLayoutData((Object)fdlOutputStep);
        final Button wbOutputStep = new Button(wFieldsComposite, 8);
        this.props.setLook((Control)wbOutputStep);
        wbOutputStep.setText(BaseMessages.getString(PKG, (String)"MappingDialog.button.SourceStepName", (String[])new String[0]));
        FormData fdbOutputStep = new FormData();
        fdbOutputStep.top = new FormAttachment((Control)wlOutputStep, 5);
        fdbOutputStep.right = new FormAttachment(100);
        wbOutputStep.setLayoutData((Object)fdbOutputStep);
        final Text wOutputStep = new Text(wFieldsComposite, 18436);
        this.props.setLook((Control)wOutputStep);
        wOutputStep.addModifyListener(this.lsMod);
        FormData fdOutputStep = new FormData();
        fdOutputStep.top = new FormAttachment((Control)wlOutputStep, 5);
        fdOutputStep.left = new FormAttachment(0);
        fdOutputStep.right = new FormAttachment((Control)wbOutputStep, -5);
        wOutputStep.setLayoutData((Object)fdOutputStep);
        final Label wlDescription = new Label(wFieldsComposite, 131072);
        this.props.setLook((Control)wlDescription);
        wlDescription.setText(descriptionLabel);
        FormData fdlDescription = new FormData();
        fdlDescription.top = new FormAttachment((Control)wOutputStep, 5);
        fdlDescription.left = new FormAttachment(0);
        wlDescription.setLayoutData((Object)fdlDescription);
        final Text wDescription = new Text(wFieldsComposite, 18436);
        this.props.setLook((Control)wDescription);
        wDescription.addModifyListener(this.lsMod);
        FormData fdDescription = new FormData();
        fdDescription.top = new FormAttachment((Control)wlDescription, 5);
        fdDescription.left = new FormAttachment(0);
        fdDescription.right = new FormAttachment(100);
        wDescription.setLayoutData((Object)fdDescription);
        wDescription.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent event) {
                ((MappingIODefinition)definitions.get(wInputList.getSelectionIndex())).setDescription(wDescription.getText());
            }
        });
        final Button wbEnterMapping = new Button(wFieldsComposite, 8);
        this.props.setLook((Control)wbEnterMapping);
        wbEnterMapping.setText(BaseMessages.getString(PKG, (String)"MappingDialog.button.EnterMapping", (String[])new String[0]));
        FormData fdbEnterMapping = new FormData();
        fdbEnterMapping.bottom = new FormAttachment(100);
        fdbEnterMapping.right = new FormAttachment(100);
        wbEnterMapping.setLayoutData((Object)fdbEnterMapping);
        wbEnterMapping.setEnabled(input);
        ColumnInfo[] colinfo = new ColumnInfo[]{new ColumnInfo(sourceColumnLabel, 1, false, false), new ColumnInfo(targetColumnLabel, 1, false, false)};
        final TableView wFieldMappings = new TableView((VariableSpace)this.transMeta, wFieldsComposite, 67588, colinfo, 1, false, this.lsMod, this.props, false);
        this.props.setLook((Control)wFieldMappings);
        FormData fdMappings = new FormData();
        fdMappings.top = new FormAttachment((Control)wDescription, 20);
        fdMappings.bottom = new FormAttachment((Control)wbEnterMapping, -5);
        fdMappings.left = new FormAttachment(0);
        fdMappings.right = new FormAttachment(100);
        wFieldMappings.setLayoutData(fdMappings);
        wFieldMappings.getTable().addListener(11, (Listener)new ColumnsResizer(0, 50, 50));
        wbEnterMapping.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                try {
                    RowMetaInterface sourceRowMeta = MappingDialog.this.getFieldsFromStep(wInputStep.getText(), true, input);
                    RowMetaInterface targetRowMeta = MappingDialog.this.getFieldsFromStep(wOutputStep.getText(), false, input);
                    String[] sourceFields = sourceRowMeta.getFieldNames();
                    String[] targetFields = targetRowMeta.getFieldNames();
                    int nrLines = wFieldMappings.nrNonEmpty();
                    ((MappingIODefinition)definitions.get(wInputList.getSelectionIndex())).getValueRenames().clear();
                    for (int i = 0; i < nrLines; ++i) {
                        TableItem item = wFieldMappings.getNonEmpty(i);
                        ((MappingIODefinition)definitions.get(wInputList.getSelectionIndex())).getValueRenames().add(new MappingValueRename(item.getText(1), item.getText(2)));
                    }
                    List mappingValue = ((MappingIODefinition)definitions.get(wInputList.getSelectionIndex())).getValueRenames();
                    List<SourceToTargetMapping> currentMappings = MappingUtil.getCurrentMappings(Arrays.asList(sourceFields), Arrays.asList(targetFields), mappingValue);
                    EnterMappingDialog dialog = new EnterMappingDialog(MappingDialog.this.shell, sourceFields, targetFields, currentMappings);
                    List<SourceToTargetMapping> mappings = dialog.open();
                    if (mappings != null) {
                        wFieldMappings.clearAll(false);
                        mappingValue.clear();
                        for (SourceToTargetMapping mapping : mappings) {
                            TableItem item = new TableItem(wFieldMappings.table, 0);
                            item.setText(1, mapping.getSourceString(sourceFields));
                            item.setText(2, mapping.getTargetString(targetFields));
                            String source = input ? item.getText(1) : item.getText(2);
                            String target = input ? item.getText(2) : item.getText(1);
                            mappingValue.add(new MappingValueRename(source, target));
                        }
                        wFieldMappings.removeEmptyRows();
                        wFieldMappings.setRowNums();
                        wFieldMappings.optWidth(true);
                    }
                }
                catch (KettleException e) {
                    Listener ok = new Listener(){

                        public void handleEvent(Event event) {
                        }
                    };
                    LinkedHashMap<String, Listener> listenerMap = new LinkedHashMap<String, Listener>();
                    listenerMap.put(BaseMessages.getString((String)"System.Button.OK"), ok);
                    new WarningDialog(MappingDialog.this.shell, BaseMessages.getString((Class)PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]), e.getMessage(), listenerMap);
                }
            }
        });
        wOutputStep.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent event) {
                ((MappingIODefinition)definitions.get(wInputList.getSelectionIndex())).setOutputStepname(wOutputStep.getText());
                try {
                    MappingDialog.this.enableMappingButton(wbEnterMapping, input, wInputStep.getText(), wOutputStep.getText());
                }
                catch (KettleException e) {
                    Listener ok = new Listener(){

                        public void handleEvent(Event event) {
                        }
                    };
                    LinkedHashMap<String, Listener> listenerMap = new LinkedHashMap<String, Listener>();
                    listenerMap.put(BaseMessages.getString((String)"System.Button.OK"), ok);
                    new WarningDialog(MappingDialog.this.shell, "Error", e.getMessage(), listenerMap).open();
                }
            }
        });
        wbOutputStep.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String stepName = MappingDialog.this.selectTransformationStepname(!input, input);
                if (stepName != null) {
                    wOutputStep.setText(stepName);
                    ((MappingIODefinition)definitions.get(wInputList.getSelectionIndex())).setOutputStepname(stepName);
                    try {
                        MappingDialog.this.enableMappingButton(wbEnterMapping, input, wInputStep.getText(), wOutputStep.getText());
                    }
                    catch (KettleException e) {
                        new ErrorDialog(MappingDialog.this.shell, "Error", "Unexpected error", (Exception)((Object)e));
                    }
                }
            }
        });
        if (input) {
            wRenameOutput = new Button(wFieldsComposite, 32);
            wRenameOutput.setText(BaseMessages.getString(PKG, (String)"MappingDialog.input.RenamingOnOutput", (String[])new String[0]));
            this.props.setLook((Control)wRenameOutput);
            FormData fdRenameOutput = new FormData();
            fdRenameOutput.top = new FormAttachment((Control)wFieldMappings, 5);
            fdRenameOutput.left = new FormAttachment(0);
            wRenameOutput.setLayoutData((Object)fdRenameOutput);
            wRenameOutput.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ((MappingIODefinition)definitions.get(wInputList.getSelectionIndex())).setRenamingOnOutput(!((MappingIODefinition)definitions.get(wInputList.getSelectionIndex())).isRenamingOnOutput());
                }
            });
        } else {
            wRenameOutput = null;
        }
        FormData fdInputComposite = new FormData();
        fdInputComposite.left = new FormAttachment(0);
        fdInputComposite.top = new FormAttachment(0);
        fdInputComposite.right = new FormAttachment(100);
        fdInputComposite.bottom = new FormAttachment(100);
        wInputComposite.setLayoutData((Object)fdInputComposite);
        FormData fdFieldsComposite = new FormData();
        fdFieldsComposite.left = new FormAttachment((Control)wInputList, 30);
        fdFieldsComposite.right = new FormAttachment(100);
        fdFieldsComposite.bottom = new FormAttachment(100);
        fdFieldsComposite.top = new FormAttachment(0);
        wFieldsComposite.setLayoutData((Object)fdFieldsComposite);
        wInputComposite.layout();
        wTab.setControl((Control)wInputComposite);
        wMainPath.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                MappingDialog.this.setTabFlags(wMainPath, wlInputStep, wInputStep, wbInputStep, wlOutputStep, wOutputStep, wbOutputStep, wlDescription, wDescription);
            }
        });
        wInputList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MappingDialog.this.updateFields((MappingIODefinition)definitions.get(wInputList.getSelectionIndex()), input, wMainPath, wlInputStep, wInputStep, wbInputStep, wlOutputStep, wOutputStep, wbOutputStep, wlDescription, wDescription, wFieldMappings, wRenameOutput);
            }
        });
        wAddButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent mouseEvent) {
                MappingIODefinition definition = new MappingIODefinition();
                definition.setMainDataPath(true);
                definitions.add(definition);
                wInputList.add(tabTitle + (definitions.size() > 1 ? String.valueOf(definitions.size()) : ""));
                wInputList.select(definitions.size() - 1);
                MappingDialog.this.updateFields((MappingIODefinition)definitions.get(wInputList.getSelectionIndex()), input, wMainPath, wlInputStep, wInputStep, wbInputStep, wlOutputStep, wOutputStep, wbOutputStep, wlDescription, wDescription, wFieldMappings, wRenameOutput);
                wlNoItems.setVisible(false);
                wFieldsComposite.setVisible(true);
                wRemoveButton.setEnabled(true);
            }
        });
        wRemoveButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent mouseEvent) {
                MessageBox box = new MessageBox(MappingDialog.this.shell, 192);
                box.setText(BaseMessages.getString((Class)PKG, (String)"MappingDialog.CloseDefinitionTabAreYouSure.Title", (String[])new String[0]));
                box.setMessage(BaseMessages.getString((Class)PKG, (String)"MappingDialog.CloseDefinitionTabAreYouSure.Message", (String[])new String[0]));
                int answer = box.open();
                if (answer != 64) {
                    return;
                }
                int index = wInputList.getSelectionIndex();
                definitions.remove(index);
                wInputList.removeAll();
                for (int i = 0; i < definitions.size(); ++i) {
                    String label = !Utils.isEmpty((CharSequence)((MappingIODefinition)definitions.get(i)).getInputStepname()) ? ((MappingIODefinition)definitions.get(i)).getInputStepname() : tabTitle + (i > 0 ? String.valueOf(i + 1) : "");
                    wInputList.add(label);
                }
                if (index > 0) {
                    wInputList.select(index - 1);
                } else if (definitions.size() > 0) {
                    wInputList.select(index);
                } else {
                    index = -1;
                }
                if (index != -1) {
                    MappingDialog.this.updateFields((MappingIODefinition)definitions.get(wInputList.getSelectionIndex()), input, wMainPath, wlInputStep, wInputStep, wbInputStep, wlOutputStep, wOutputStep, wbOutputStep, wlDescription, wDescription, wFieldMappings, wRenameOutput);
                }
                if (definitions.size() == 0) {
                    wlNoItems.setVisible(true);
                    wFieldsComposite.setVisible(false);
                    wRemoveButton.setEnabled(false);
                }
            }
        });
        if (definitions.size() > 0) {
            wInputList.select(0);
            this.updateFields(definitions.get(0), input, wMainPath, wlInputStep, wInputStep, wbInputStep, wlOutputStep, wOutputStep, wbOutputStep, wlDescription, wDescription, wFieldMappings, wRenameOutput);
        } else {
            wlNoItems.setVisible(true);
            wFieldsComposite.setVisible(false);
            wRemoveButton.setEnabled(false);
        }
        this.setTabFlags(wMainPath, wlInputStep, wInputStep, wbInputStep, wlOutputStep, wOutputStep, wbOutputStep, wlDescription, wDescription);
        this.wTabFolder.setSelection(wTab);
    }

    private void updateFields(MappingIODefinition definition, boolean input, Button wMainPath, Label wlInputStep, Text wInputStep, Button wbInputStep, Label wlOutputStep, Text wOutputStep, Button wbOutputStep, Label wlDescription, Text wDescription, TableView wFieldMappings, Button wRenameOutput) {
        if (this.tabChanges != null) {
            this.tabChanges.applyChanges();
        }
        wMainPath.setSelection(definition.isMainDataPath());
        wInputStep.setText(Const.NVL((String)definition.getInputStepname(), (String)""));
        wOutputStep.setText(Const.NVL((String)definition.getOutputStepname(), (String)""));
        wDescription.setText(Const.NVL((String)definition.getDescription(), (String)""));
        this.setTabFlags(wMainPath, wlInputStep, wInputStep, wbInputStep, wlOutputStep, wOutputStep, wbOutputStep, wlDescription, wDescription);
        wFieldMappings.removeAll();
        for (MappingValueRename valueRename : definition.getValueRenames()) {
            TableItem tableItem = new TableItem(wFieldMappings.table, 0);
            tableItem.setText(1, Const.NVL((String)valueRename.getSourceValueName(), (String)""));
            tableItem.setText(2, Const.NVL((String)valueRename.getTargetValueName(), (String)""));
        }
        wFieldMappings.removeEmptyRows();
        wFieldMappings.setRowNums();
        wFieldMappings.optWidth(true);
        if (input) {
            wRenameOutput.setSelection(definition.isRenamingOnOutput());
        }
        this.tabChanges = new MappingDefinitionTab(definition, wInputStep, wOutputStep, wMainPath, wDescription, wFieldMappings);
    }

    private void setTabFlags(Button wMainPath, Label wlInputStep, Text wInputStep, Button wbInputStep, Label wlOutputStep, Text wOutputStep, Button wbOutputStep, Label wlDescription, Text wDescription) {
        boolean mainPath = wMainPath.getSelection();
        wlInputStep.setEnabled(!mainPath);
        wInputStep.setEnabled(!mainPath);
        wbInputStep.setEnabled(!mainPath);
        wlOutputStep.setEnabled(!mainPath);
        wOutputStep.setEnabled(!mainPath);
        wbOutputStep.setEnabled(!mainPath);
        wlDescription.setEnabled(!mainPath);
        wDescription.setEnabled(!mainPath);
    }

    private void enableMappingButton(Button button, boolean input, String sourceStepname, String targetStepname) throws KettleException {
        StepMeta mappingOutputStep;
        RowMetaInterface requiredFields;
        StepMeta mappingInputStep;
        if (input) {
            return;
        }
        boolean enabled = false;
        if (this.mappingTransMeta != null && (mappingInputStep = this.mappingTransMeta.findMappingInputStep(sourceStepname)) != null && (requiredFields = (mappingOutputStep = this.transMeta.findMappingOutputStep(targetStepname)).getStepMetaInterface().getRequiredFields((VariableSpace)this.transMeta)) != null && requiredFields.size() > 0) {
            enabled = true;
        }
        button.setEnabled(enabled);
    }

    private void cancel() {
        this.stepname = null;
        this.mappingMeta.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wStepname.getText())) {
            return;
        }
        this.stepname = this.wStepname.getText();
        try {
            this.loadTransformation();
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"MappingDialog.ErrorLoadingSpecifiedTransformation.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MappingDialog.ErrorLoadingSpecifiedTransformation.Message", (String[])new String[0]), (Exception)((Object)e));
            return;
        }
        this.mappingMeta.setSpecificationMethod(this.getSpecificationMethod());
        switch (this.getSpecificationMethod()) {
            case FILENAME: {
                this.mappingMeta.setFileName(this.wPath.getText());
                this.mappingMeta.setDirectoryPath(null);
                this.mappingMeta.setTransName(null);
                this.mappingMeta.setTransObjectId(null);
                break;
            }
            case REPOSITORY_BY_NAME: {
                String transPath;
                String transName = transPath = this.wPath.getText();
                String directory = "";
                int index = transPath.lastIndexOf("/");
                if (index != -1) {
                    transName = transPath.substring(index + 1);
                    directory = transPath.substring(0, index);
                }
                this.mappingMeta.setDirectoryPath(directory);
                this.mappingMeta.setTransName(transName);
                this.mappingMeta.setFileName(null);
                this.mappingMeta.setTransObjectId(null);
            }
        }
        this.collectInformation();
        this.mappingMeta.setMappingParameters(this.mappingParameters);
        this.mappingMeta.setInputMappings(this.inputMappings);
        this.mappingMeta.searchInfoAndTargetSteps(this.transMeta.getSteps());
        this.mappingMeta.setOutputMappings(this.outputMappings);
        this.mappingMeta.setAllowingMultipleInputs(true);
        this.mappingMeta.setAllowingMultipleOutputs(true);
        this.mappingMeta.setChanged(true);
        this.dispose();
    }

    private void collectInformation() {
        this.parameterChanges.applyChanges();
        this.tabChanges.applyChanges();
    }

    ObjectId getReferenceObjectId() {
        return this.referenceObjectId;
    }

    private void setReferenceObjectId(ObjectId referenceObjectId) {
        this.referenceObjectId = referenceObjectId;
    }

    ObjectLocationSpecificationMethod getSpecificationMethod() {
        return this.specificationMethod;
    }

    private void setSpecificationMethod(ObjectLocationSpecificationMethod specificationMethod) {
        this.specificationMethod = specificationMethod;
    }

    private class MappingDefinitionTab
    implements ApplyChanges {
        private MappingIODefinition definition;
        private Text wInputStep;
        private Text wOutputStep;
        private Button wMainPath;
        private Text wDescription;
        private TableView wFieldMappings;

        public MappingDefinitionTab(MappingIODefinition definition, Text inputStep, Text outputStep, Button mainPath, Text description, TableView fieldMappings) {
            this.definition = definition;
            this.wInputStep = inputStep;
            this.wOutputStep = outputStep;
            this.wMainPath = mainPath;
            this.wDescription = description;
            this.wFieldMappings = fieldMappings;
        }

        @Override
        public void applyChanges() {
            this.definition.setInputStepname(this.wInputStep.getText());
            this.definition.setOutputStepname(this.wOutputStep.getText());
            this.definition.setDescription(this.wDescription.getText());
            this.definition.setMainDataPath(this.wMainPath.getSelection());
            int nrLines = this.wFieldMappings.nrNonEmpty();
            this.definition.getValueRenames().clear();
            for (int i = 0; i < nrLines; ++i) {
                TableItem item = this.wFieldMappings.getNonEmpty(i);
                this.definition.getValueRenames().add(new MappingValueRename(item.getText(1), item.getText(2)));
            }
        }
    }

    private class MappingParametersTab
    implements ApplyChanges {
        private TableView wMappingParameters;
        private MappingParameters parameters;
        private Button wInheritAll;

        public MappingParametersTab(TableView wMappingParameters, Button wInheritAll, MappingParameters parameters) {
            this.wMappingParameters = wMappingParameters;
            this.wInheritAll = wInheritAll;
            this.parameters = parameters;
        }

        @Override
        public void applyChanges() {
            int nrLines = this.wMappingParameters.nrNonEmpty();
            String[] variables = new String[nrLines];
            String[] inputFields = new String[nrLines];
            this.parameters.setVariable(variables);
            this.parameters.setInputField(inputFields);
            for (int i = 0; i < nrLines; ++i) {
                TableItem item = this.wMappingParameters.getNonEmpty(i);
                this.parameters.getVariable()[i] = item.getText(1);
                this.parameters.getInputField()[i] = item.getText(2);
            }
            this.parameters.setInheritingAllVariables(this.wInheritAll.getSelection());
        }
    }

    private static interface ApplyChanges {
        public void applyChanges();
    }
}

