/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.fileinput.text;

import com.google.common.annotations.VisibleForTesting;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.fileinput.FileInputList;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.util.StringEvaluationResult;
import org.pentaho.di.core.util.StringEvaluator;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.steps.file.BaseFileField;
import org.pentaho.di.trans.steps.file.BaseFileInputAdditionalField;
import org.pentaho.di.trans.steps.fileinput.text.BufferedInputStreamReader;
import org.pentaho.di.trans.steps.fileinput.text.EncodingType;
import org.pentaho.di.trans.steps.fileinput.text.TextFileInputMeta;
import org.pentaho.di.trans.steps.fileinput.text.TextFileInputUtils;
import org.pentaho.di.trans.steps.fileinput.text.TextFileLine;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.trans.step.common.CsvInputAwareImportProgressDialog;

public class TextFileCSVImportProgressDialog
implements CsvInputAwareImportProgressDialog {
    private static Class<?> PKG = TextFileInputMeta.class;
    private Shell shell;
    private TextFileInputMeta meta;
    private int samples;
    private boolean replaceMeta;
    private String message;
    private String debug;
    private long rownumber;
    private BufferedInputStreamReader reader;
    private TransMeta transMeta;
    private LogChannelInterface log;
    private EncodingType encodingType;

    @Deprecated
    public TextFileCSVImportProgressDialog(Shell shell, TextFileInputMeta meta, TransMeta transMeta, InputStreamReader reader, int samples, boolean replaceMeta) {
        this(shell, meta, transMeta, new BufferedInputStreamReader(reader), samples, replaceMeta);
    }

    public TextFileCSVImportProgressDialog(Shell shell, TextFileInputMeta meta, TransMeta transMeta, BufferedInputStreamReader reader, int samples, boolean replaceMeta) {
        this.shell = shell;
        this.meta = meta;
        this.reader = reader;
        this.samples = samples;
        this.replaceMeta = replaceMeta;
        this.transMeta = transMeta;
        this.message = null;
        this.debug = "init";
        this.rownumber = 1L;
        this.log = new LogChannel((Object)transMeta);
        this.encodingType = EncodingType.guessEncodingType((String)reader.getEncoding());
    }

    public String open() {
        return this.open(true);
    }

    @Override
    public String open(final boolean failOnParseError) {
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    TextFileCSVImportProgressDialog.this.message = TextFileCSVImportProgressDialog.this.doScan(monitor, failOnParseError);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new InvocationTargetException(e, BaseMessages.getString((Class)PKG, (String)"TextFileCSVImportProgressDialog.Exception.ErrorScanningFile", (String[])new String[]{"" + TextFileCSVImportProgressDialog.this.rownumber, TextFileCSVImportProgressDialog.this.debug, e.toString()}));
                }
            }
        };
        try {
            ProgressMonitorDialog pmd = new ProgressMonitorDialog(this.shell);
            pmd.run(true, true, op);
        }
        catch (InvocationTargetException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"TextFileCSVImportProgressDialog.ErrorScanningFile.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TextFileCSVImportProgressDialog.ErrorScanningFile.Message", (String[])new String[0]), e);
        }
        catch (InterruptedException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"TextFileCSVImportProgressDialog.ErrorScanningFile.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TextFileCSVImportProgressDialog.ErrorScanningFile.Message", (String[])new String[0]), e);
        }
        return this.message;
    }

    @VisibleForTesting
    String doScan(IProgressMonitor monitor) throws KettleException {
        return this.doScan(monitor, true);
    }

    private String doScan(IProgressMonitor monitor, boolean failOnParseError) throws KettleException {
        if (this.samples > 0) {
            monitor.beginTask(BaseMessages.getString(PKG, (String)"TextFileCSVImportProgressDialog.Task.ScanningFile", (String[])new String[0]), this.samples + 1);
        } else {
            monitor.beginTask(BaseMessages.getString(PKG, (String)"TextFileCSVImportProgressDialog.Task.ScanningFile", (String[])new String[0]), 2);
        }
        String line = "";
        StringBuilder sbLine = new StringBuilder();
        long fileLineNumber = 0L;
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        int nrfields = this.meta.inputFields.length;
        RowMeta outputRowMeta = new RowMeta();
        this.meta.getFields((RowMetaInterface)outputRowMeta, null, null, null, (VariableSpace)this.transMeta, null, null);
        for (ValueMetaInterface valueMeta : outputRowMeta.getValueMetaList()) {
            valueMeta.setStorageMetadata(null);
            valueMeta.setStorageType(0);
        }
        RowMetaInterface convertRowMeta = outputRowMeta.cloneToType(2);
        int[] nrnull = new int[nrfields];
        String[] minstr = new String[nrfields];
        String[] maxstr = new String[nrfields];
        boolean[] firststr = new boolean[nrfields];
        boolean[] isDate = new boolean[nrfields];
        int[] dateFormatCount = new int[nrfields];
        boolean[][] dateFormat = new boolean[nrfields][Const.getDateFormats().length];
        Date[][] minDate = new Date[nrfields][Const.getDateFormats().length];
        Date[][] maxDate = new Date[nrfields][Const.getDateFormats().length];
        boolean[] isNumber = new boolean[nrfields];
        int[] numberFormatCount = new int[nrfields];
        boolean[][] numberFormat = new boolean[nrfields][Const.getNumberFormats().length];
        double[][] minValue = new double[nrfields][Const.getDateFormats().length];
        double[][] maxValue = new double[nrfields][Const.getDateFormats().length];
        int[][] numberPrecision = new int[nrfields][Const.getNumberFormats().length];
        int[][] numberLength = new int[nrfields][Const.getNumberFormats().length];
        for (int i = 0; i < nrfields; ++i) {
            int j;
            BaseFileField field = this.meta.inputFields[i];
            if (this.log.isDebug()) {
                this.debug = "init field #" + i;
            }
            if (this.replaceMeta) {
                field.setName(this.meta.inputFields[i].getName());
                field.setType(this.meta.inputFields[i].getType());
                field.setFormat("");
                field.setLength(-1);
                field.setPrecision(-1);
                field.setCurrencySymbol(dfs.getCurrencySymbol());
                field.setDecimalSymbol("" + dfs.getDecimalSeparator());
                field.setGroupSymbol("" + dfs.getGroupingSeparator());
                field.setNullString("-");
                field.setTrimType(0);
            }
            nrnull[i] = 0;
            minstr[i] = "";
            maxstr[i] = "";
            firststr[i] = true;
            isDate[i] = true;
            for (j = 0; j < Const.getDateFormats().length; ++j) {
                dateFormat[i][j] = true;
                minDate[i][j] = Const.MAX_DATE;
                maxDate[i][j] = Const.MIN_DATE;
            }
            dateFormatCount[i] = Const.getDateFormats().length;
            isNumber[i] = true;
            for (j = 0; j < Const.getNumberFormats().length; ++j) {
                numberFormat[i][j] = true;
                minValue[i][j] = Double.MAX_VALUE;
                maxValue[i][j] = -1.7976931348623157E308;
                numberPrecision[i][j] = -1;
                numberLength[i][j] = -1;
            }
            numberFormatCount[i] = Const.getNumberFormats().length;
        }
        TextFileInputMeta strinfo = (TextFileInputMeta)this.meta.clone();
        for (int i = 0; i < nrfields; ++i) {
            strinfo.inputFields[i].setType(2);
        }
        this.debug = "get first line";
        StringBuilder lineBuffer = new StringBuilder(256);
        int fileFormatType = this.meta.getFileFormatTypeNr();
        if (this.meta.content.header) {
            fileLineNumber = TextFileInputUtils.skipLines((LogChannelInterface)this.log, (BufferedInputStreamReader)this.reader, (EncodingType)this.encodingType, (int)fileFormatType, (StringBuilder)lineBuffer, (int)this.meta.content.nrHeaderLines, (String)this.meta.getEnclosure(), (String)this.meta.getEscapeCharacter(), (long)fileLineNumber);
        }
        line = TextFileInputUtils.getLine((LogChannelInterface)this.log, (BufferedInputStreamReader)this.reader, (EncodingType)this.encodingType, (int)fileFormatType, (StringBuilder)lineBuffer, (String)this.meta.getEnclosure(), (String)this.meta.getEscapeCharacter());
        int linenr = 1;
        ArrayList<StringEvaluator> evaluators = new ArrayList<StringEvaluator>();
        DecimalFormat df2 = (DecimalFormat)NumberFormat.getInstance();
        DecimalFormatSymbols dfs2 = new DecimalFormatSymbols();
        SimpleDateFormat daf2 = new SimpleDateFormat();
        boolean errorFound = false;
        while (!(errorFound || line == null || linenr > this.samples && this.samples != 0 || monitor.isCanceled())) {
            monitor.subTask(BaseMessages.getString(PKG, (String)"TextFileCSVImportProgressDialog.Task.ScanningLine", (String[])new String[]{"" + linenr}));
            if (this.samples > 0) {
                monitor.worked(1);
            }
            if (this.log.isDebug()) {
                this.debug = "convert line #" + linenr + " to row";
            }
            RowMeta rowMeta = new RowMeta();
            this.meta.getFields((RowMetaInterface)rowMeta, "stepname", null, null, (VariableSpace)this.transMeta, null, null);
            for (ValueMetaInterface valueMeta : rowMeta.getValueMetaList()) {
                valueMeta.setStorageMetadata(null);
                valueMeta.setStorageType(0);
            }
            String delimiter = this.transMeta.environmentSubstitute(this.meta.content.separator);
            String enclosure = this.transMeta.environmentSubstitute(this.meta.content.enclosure);
            String escapeCharacter = this.transMeta.environmentSubstitute(this.meta.content.escapeCharacter);
            Object[] r = TextFileInputUtils.convertLineToRow((LogChannelInterface)this.log, (TextFileLine)new TextFileLine(line, fileLineNumber, null), (TextFileInputMeta)strinfo, null, (int)0, (RowMetaInterface)outputRowMeta, (RowMetaInterface)convertRowMeta, (String)FileInputList.createFilePathList((VariableSpace)this.transMeta, (String[])this.meta.inputFiles.fileName, (String[])this.meta.inputFiles.fileMask, (String[])this.meta.inputFiles.excludeFileMask, (String[])this.meta.inputFiles.fileRequired, (boolean[])this.meta.inputFiles.includeSubFolderBoolean())[0], (long)this.rownumber, (String)delimiter, (String)enclosure, (String)escapeCharacter, null, (BaseFileInputAdditionalField)new BaseFileInputAdditionalField(), null, null, (boolean)false, null, null, null, null, null, (boolean)failOnParseError);
            if (r == null) {
                errorFound = true;
                continue;
            }
            ++this.rownumber;
            for (int i = 0; i < nrfields && i < r.length; ++i) {
                StringEvaluator evaluator;
                if (i >= evaluators.size()) {
                    evaluator = new StringEvaluator(true);
                    evaluators.add(evaluator);
                } else {
                    evaluator = (StringEvaluator)evaluators.get(i);
                }
                String string = this.getStringFromRow((RowMetaInterface)rowMeta, r, i, failOnParseError);
                evaluator.evaluateString(string);
            }
            if (r != null) {
                ++linenr;
            }
            TextFileLine textFileLine = TextFileInputUtils.getLine((LogChannelInterface)this.log, (BufferedInputStreamReader)this.reader, (EncodingType)this.encodingType, (int)fileFormatType, (StringBuilder)lineBuffer, (String)enclosure, (String)escapeCharacter, (long)fileLineNumber);
            line = textFileLine.getLine();
            fileLineNumber = textFileLine.getLineNumber();
        }
        monitor.worked(1);
        monitor.setTaskName(BaseMessages.getString(PKG, (String)"TextFileCSVImportProgressDialog.Task.AnalyzingResults", (String[])new String[0]));
        StringBuilder message = new StringBuilder();
        message.append(BaseMessages.getString(PKG, (String)"TextFileCSVImportProgressDialog.Info.ResultAfterScanning", (String[])new String[]{"" + (linenr - 1)}));
        message.append(BaseMessages.getString(PKG, (String)"TextFileCSVImportProgressDialog.Info.HorizontalLine", (String[])new String[0]));
        if (nrfields == evaluators.size()) {
            for (int i = 0; i < nrfields; ++i) {
                BaseFileField field = this.meta.inputFields[i];
                StringEvaluator evaluator = (StringEvaluator)evaluators.get(i);
                List evaluationResults = evaluator.getStringEvaluationResults();
                if (evaluationResults.isEmpty()) {
                    field.setType(2);
                    field.setLength(evaluator.getMaxLength());
                } else {
                    StringEvaluationResult result = evaluator.getAdvicedResult();
                    if (result != null) {
                        ValueMetaInterface conversionMeta = result.getConversionMeta();
                        field.setType(conversionMeta.getType());
                        field.setTrimType(conversionMeta.getTrimType());
                        field.setFormat(conversionMeta.getConversionMask());
                        field.setDecimalSymbol(conversionMeta.getDecimalSymbol());
                        field.setGroupSymbol(conversionMeta.getGroupingSymbol());
                        field.setLength(conversionMeta.getLength());
                        field.setPrecision(conversionMeta.getPrecision());
                        nrnull[i] = result.getNrNull();
                        minstr[i] = result.getMin() == null ? "" : result.getMin().toString();
                        maxstr[i] = result.getMax() == null ? "" : result.getMax().toString();
                    }
                }
                message.append(BaseMessages.getString(PKG, (String)"TextFileCSVImportProgressDialog.Info.FieldNumber", (String[])new String[]{"" + (i + 1)}));
                message.append(BaseMessages.getString(PKG, (String)"TextFileCSVImportProgressDialog.Info.FieldName", (String[])new String[]{field.getName()}));
                message.append(BaseMessages.getString(PKG, (String)"TextFileCSVImportProgressDialog.Info.FieldType", (String[])new String[]{field.getTypeDesc()}));
                switch (field.getType()) {
                    case 1: {
                        message.append(BaseMessages.getString(PKG, (String)"TextFileCSVImportProgressDialog.Info.EstimatedLength", (String[])new String[]{field.getLength() < 0 ? "-" : "" + field.getLength()}));
                        message.append(BaseMessages.getString(PKG, (String)"TextFileCSVImportProgressDialog.Info.EstimatedPrecision", (String[])new String[]{field.getPrecision() < 0 ? "-" : "" + field.getPrecision()}));
                        message.append(BaseMessages.getString(PKG, (String)"TextFileCSVImportProgressDialog.Info.NumberFormat", (String[])new String[]{field.getFormat()}));
                        if (!evaluationResults.isEmpty()) {
                            if (evaluationResults.size() > 1) {
                                message.append(BaseMessages.getString(PKG, (String)"TextFileCSVImportProgressDialog.Info.WarnNumberFormat", (String[])new String[0]));
                            }
                            for (StringEvaluationResult seResult : evaluationResults) {
                                String mask = seResult.getConversionMeta().getConversionMask();
                                message.append(BaseMessages.getString(PKG, (String)"TextFileCSVImportProgressDialog.Info.NumberFormat2", (String[])new String[]{mask}));
                                message.append(BaseMessages.getString(PKG, (String)"TextFileCSVImportProgressDialog.Info.TrimType", (Object[])new Object[]{seResult.getConversionMeta().getTrimType()}));
                                message.append(BaseMessages.getString(PKG, (String)"TextFileCSVImportProgressDialog.Info.NumberMinValue", (Object[])new Object[]{seResult.getMin()}));
                                message.append(BaseMessages.getString(PKG, (String)"TextFileCSVImportProgressDialog.Info.NumberMaxValue", (Object[])new Object[]{seResult.getMax()}));
                                try {
                                    df2.applyPattern(mask);
                                    df2.setDecimalFormatSymbols(dfs2);
                                    double mn = df2.parse(seResult.getMin().toString()).doubleValue();
                                    message.append(BaseMessages.getString(PKG, (String)"TextFileCSVImportProgressDialog.Info.NumberExample", (Object[])new Object[]{mask, seResult.getMin(), Double.toString(mn)}));
                                }
                                catch (Exception e) {
                                    if (!this.log.isDetailed()) continue;
                                    this.log.logDetailed("This is unexpected: parsing [" + seResult.getMin() + "] with format [" + mask + "] did not work.");
                                }
                            }
                        }
                        message.append(BaseMessages.getString(PKG, (String)"TextFileCSVImportProgressDialog.Info.NumberNrNullValues", (String[])new String[]{"" + nrnull[i]}));
                        break;
                    }
                    case 2: {
                        message.append(BaseMessages.getString(PKG, (String)"TextFileCSVImportProgressDialog.Info.StringMaxLength", (String[])new String[]{"" + field.getLength()}));
                        message.append(BaseMessages.getString(PKG, (String)"TextFileCSVImportProgressDialog.Info.StringMinValue", (String[])new String[]{minstr[i]}));
                        message.append(BaseMessages.getString(PKG, (String)"TextFileCSVImportProgressDialog.Info.StringMaxValue", (String[])new String[]{maxstr[i]}));
                        message.append(BaseMessages.getString(PKG, (String)"TextFileCSVImportProgressDialog.Info.StringNrNullValues", (String[])new String[]{"" + nrnull[i]}));
                        break;
                    }
                    case 3: {
                        message.append(BaseMessages.getString(PKG, (String)"TextFileCSVImportProgressDialog.Info.DateMaxLength", (String[])new String[]{field.getLength() < 0 ? "-" : "" + field.getLength()}));
                        message.append(BaseMessages.getString(PKG, (String)"TextFileCSVImportProgressDialog.Info.DateFormat", (String[])new String[]{field.getFormat()}));
                        if (dateFormatCount[i] > 1) {
                            message.append(BaseMessages.getString(PKG, (String)"TextFileCSVImportProgressDialog.Info.WarnDateFormat", (String[])new String[0]));
                        }
                        if (!Utils.isEmpty((CharSequence)minstr[i])) {
                            for (int x = 0; x < Const.getDateFormats().length; ++x) {
                                if (!dateFormat[i][x]) continue;
                                message.append(BaseMessages.getString(PKG, (String)"TextFileCSVImportProgressDialog.Info.DateFormat2", (String[])new String[]{Const.getDateFormats()[x]}));
                                Date mindate = minDate[i][x];
                                Date maxdate = maxDate[i][x];
                                message.append(BaseMessages.getString(PKG, (String)"TextFileCSVImportProgressDialog.Info.DateMinValue", (String[])new String[]{mindate.toString()}));
                                message.append(BaseMessages.getString(PKG, (String)"TextFileCSVImportProgressDialog.Info.DateMaxValue", (String[])new String[]{maxdate.toString()}));
                                daf2.applyPattern(Const.getDateFormats()[x]);
                                try {
                                    Date md = daf2.parse(minstr[i]);
                                    message.append(BaseMessages.getString(PKG, (String)"TextFileCSVImportProgressDialog.Info.DateExample", (String[])new String[]{Const.getDateFormats()[x], minstr[i], md.toString()}));
                                    continue;
                                }
                                catch (Exception e) {
                                    if (!this.log.isDetailed()) continue;
                                    this.log.logDetailed("This is unexpected: parsing [" + minstr[i] + "] with format [" + Const.getDateFormats()[x] + "] did not work.");
                                }
                            }
                        }
                        message.append(BaseMessages.getString(PKG, (String)"TextFileCSVImportProgressDialog.Info.DateNrNullValues", (String[])new String[]{"" + nrnull[i]}));
                        break;
                    }
                }
                if (nrnull[i] == linenr - 1) {
                    message.append(BaseMessages.getString(PKG, (String)"TextFileCSVImportProgressDialog.Info.AllNullValues", (String[])new String[0]));
                }
                message.append(Const.CR);
            }
        }
        monitor.worked(1);
        monitor.done();
        return message.toString();
    }
}

