/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.databasejoin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.databasejoin.DatabaseJoinMeta;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.StyledTextComp;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.di.ui.trans.steps.tableinput.SQLValuesHighlight;

public class DatabaseJoinDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = DatabaseJoinMeta.class;
    private CCombo wConnection;
    private Label wlSQL;
    private StyledTextComp wSQL;
    private FormData fdlSQL;
    private FormData fdSQL;
    private Label wlLimit;
    private Text wLimit;
    private FormData fdlLimit;
    private FormData fdLimit;
    private Label wlOuter;
    private Button wOuter;
    private FormData fdlOuter;
    private FormData fdOuter;
    private Label wlParam;
    private TableView wParam;
    private FormData fdlParam;
    private FormData fdParam;
    private Label wluseVars;
    private Button wuseVars;
    private FormData fdluseVars;
    private FormData fduseVars;
    private Button wGet;
    private Listener lsGet;
    private DatabaseJoinMeta input;
    private Label wlPosition;
    private FormData fdlPosition;
    private ColumnInfo[] ciKey;
    private Map<String, Integer> inputFields;

    public DatabaseJoinDialog(Shell parent, Object in, TransMeta tr, String sname) {
        super(parent, (BaseStepMeta)in, tr, sname);
        this.input = (DatabaseJoinMeta)in;
        this.inputFields = new HashMap<String, Integer>();
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.input);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DatabaseJoinDialog.this.input.setChanged();
            }
        };
        this.backupChanged = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"DatabaseJoinDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"DatabaseJoinDialog.Stepname.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.right = new FormAttachment(middle, -margin);
        this.fdlStepname.top = new FormAttachment(0, margin);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment(middle, 0);
        this.fdStepname.top = new FormAttachment(0, margin);
        this.fdStepname.right = new FormAttachment(100, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        this.wConnection = this.addConnectionLine((Composite)this.shell, (Control)this.wStepname, middle, margin);
        if (this.input.getDatabaseMeta() == null && this.transMeta.nrDatabases() == 1) {
            this.wConnection.select(0);
        }
        this.wConnection.addModifyListener(lsMod);
        this.wlSQL = new Label((Composite)this.shell, 0);
        this.wlSQL.setText(BaseMessages.getString(PKG, (String)"DatabaseJoinDialog.SQL.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlSQL);
        this.fdlSQL = new FormData();
        this.fdlSQL.left = new FormAttachment(0, 0);
        this.fdlSQL.top = new FormAttachment((Control)this.wConnection, margin * 2);
        this.wlSQL.setLayoutData((Object)this.fdlSQL);
        this.wSQL = new StyledTextComp((VariableSpace)this.transMeta, (Composite)this.shell, 19202, "");
        this.props.setLook((Control)this.wSQL, 1);
        this.wSQL.addModifyListener(lsMod);
        this.fdSQL = new FormData();
        this.fdSQL.left = new FormAttachment(0, 0);
        this.fdSQL.top = new FormAttachment((Control)this.wlSQL, margin);
        this.fdSQL.right = new FormAttachment(100, -2 * margin);
        this.fdSQL.bottom = new FormAttachment(60, 0);
        this.wSQL.setLayoutData(this.fdSQL);
        this.wSQL.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                DatabaseJoinDialog.this.setPosition();
            }
        });
        this.wSQL.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                DatabaseJoinDialog.this.setPosition();
            }

            public void keyReleased(KeyEvent e) {
                DatabaseJoinDialog.this.setPosition();
            }
        });
        this.wSQL.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                DatabaseJoinDialog.this.setPosition();
            }

            public void focusLost(FocusEvent e) {
                DatabaseJoinDialog.this.setPosition();
            }
        });
        this.wSQL.addMouseListener(new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                DatabaseJoinDialog.this.setPosition();
            }

            public void mouseDown(MouseEvent e) {
                DatabaseJoinDialog.this.setPosition();
            }

            public void mouseUp(MouseEvent e) {
                DatabaseJoinDialog.this.setPosition();
            }
        });
        this.wSQL.addLineStyleListener(new SQLValuesHighlight());
        this.wlPosition = new Label((Composite)this.shell, 0);
        this.props.setLook((Control)this.wlPosition);
        this.fdlPosition = new FormData();
        this.fdlPosition.left = new FormAttachment(0, 0);
        this.fdlPosition.top = new FormAttachment((Control)this.wSQL, margin);
        this.fdlPosition.right = new FormAttachment(100, 0);
        this.wlPosition.setLayoutData((Object)this.fdlPosition);
        this.wlLimit = new Label((Composite)this.shell, 131072);
        this.wlLimit.setText(BaseMessages.getString(PKG, (String)"DatabaseJoinDialog.Limit.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlLimit);
        this.fdlLimit = new FormData();
        this.fdlLimit.left = new FormAttachment(0, 0);
        this.fdlLimit.right = new FormAttachment(middle, -margin);
        this.fdlLimit.top = new FormAttachment((Control)this.wlPosition, margin);
        this.wlLimit.setLayoutData((Object)this.fdlLimit);
        this.wLimit = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wLimit);
        this.wLimit.addModifyListener(lsMod);
        this.fdLimit = new FormData();
        this.fdLimit.left = new FormAttachment(middle, 0);
        this.fdLimit.right = new FormAttachment(100, 0);
        this.fdLimit.top = new FormAttachment((Control)this.wlPosition, margin);
        this.wLimit.setLayoutData((Object)this.fdLimit);
        this.wlOuter = new Label((Composite)this.shell, 131072);
        this.wlOuter.setText(BaseMessages.getString(PKG, (String)"DatabaseJoinDialog.Outerjoin.Label", (String[])new String[0]));
        this.wlOuter.setToolTipText(BaseMessages.getString(PKG, (String)"DatabaseJoinDialog.Outerjoin.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wlOuter);
        this.fdlOuter = new FormData();
        this.fdlOuter.left = new FormAttachment(0, 0);
        this.fdlOuter.right = new FormAttachment(middle, -margin);
        this.fdlOuter.top = new FormAttachment((Control)this.wLimit, margin);
        this.wlOuter.setLayoutData((Object)this.fdlOuter);
        this.wOuter = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.wOuter);
        this.wOuter.setToolTipText(this.wlOuter.getToolTipText());
        this.fdOuter = new FormData();
        this.fdOuter.left = new FormAttachment(middle, 0);
        this.fdOuter.top = new FormAttachment((Control)this.wLimit, margin);
        this.wOuter.setLayoutData((Object)this.fdOuter);
        this.wOuter.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatabaseJoinDialog.this.input.setChanged();
            }
        });
        this.wluseVars = new Label((Composite)this.shell, 131072);
        this.wluseVars.setText(BaseMessages.getString(PKG, (String)"DatabaseJoinDialog.useVarsjoin.Label", (String[])new String[0]));
        this.wluseVars.setToolTipText(BaseMessages.getString(PKG, (String)"DatabaseJoinDialog.useVarsjoin.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wluseVars);
        this.fdluseVars = new FormData();
        this.fdluseVars.left = new FormAttachment(0, 0);
        this.fdluseVars.right = new FormAttachment(middle, -margin);
        this.fdluseVars.top = new FormAttachment((Control)this.wOuter, margin);
        this.wluseVars.setLayoutData((Object)this.fdluseVars);
        this.wuseVars = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.wuseVars);
        this.wuseVars.setToolTipText(this.wluseVars.getToolTipText());
        this.fduseVars = new FormData();
        this.fduseVars.left = new FormAttachment(middle, 0);
        this.fduseVars.top = new FormAttachment((Control)this.wOuter, margin);
        this.wuseVars.setLayoutData((Object)this.fduseVars);
        this.wuseVars.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatabaseJoinDialog.this.input.setChanged();
            }
        });
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wGet = new Button((Composite)this.shell, 8);
        this.wGet.setText(BaseMessages.getString(PKG, (String)"DatabaseJoinDialog.GetFields.Button", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOK, this.wCancel, this.wGet}, margin, null);
        this.wlParam = new Label((Composite)this.shell, 0);
        this.wlParam.setText(BaseMessages.getString(PKG, (String)"DatabaseJoinDialog.Param.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlParam);
        this.fdlParam = new FormData();
        this.fdlParam.left = new FormAttachment(0, 0);
        this.fdlParam.top = new FormAttachment((Control)this.wuseVars, margin);
        this.wlParam.setLayoutData((Object)this.fdlParam);
        int nrKeyCols = 2;
        int nrKeyRows = this.input.getParameterField() != null ? this.input.getParameterField().length : 1;
        this.ciKey = new ColumnInfo[nrKeyCols];
        this.ciKey[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"DatabaseJoinDialog.ColumnInfo.ParameterFieldname", (String[])new String[0]), 2, new String[]{""}, false);
        this.ciKey[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"DatabaseJoinDialog.ColumnInfo.ParameterType", (String[])new String[0]), 2, ValueMetaFactory.getValueMetaNames());
        this.wParam = new TableView((VariableSpace)this.transMeta, (Composite)this.shell, 68354, this.ciKey, nrKeyRows, lsMod, this.props);
        this.fdParam = new FormData();
        this.fdParam.left = new FormAttachment(0, 0);
        this.fdParam.top = new FormAttachment((Control)this.wlParam, margin);
        this.fdParam.right = new FormAttachment(100, 0);
        this.fdParam.bottom = new FormAttachment((Control)this.wOK, -2 * margin);
        this.wParam.setLayoutData(this.fdParam);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                StepMeta stepMeta = DatabaseJoinDialog.this.transMeta.findStep(DatabaseJoinDialog.this.stepname);
                if (stepMeta != null) {
                    try {
                        RowMetaInterface row = DatabaseJoinDialog.this.transMeta.getPrevStepFields(stepMeta);
                        for (int i = 0; i < row.size(); ++i) {
                            DatabaseJoinDialog.this.inputFields.put(row.getValueMeta(i).getName(), i);
                        }
                        DatabaseJoinDialog.this.setComboBoxes();
                    }
                    catch (KettleException e) {
                        DatabaseJoinDialog.this.logError(BaseMessages.getString((Class)PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]));
                    }
                }
            }
        };
        new Thread(runnable).start();
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                DatabaseJoinDialog.this.ok();
            }
        };
        this.lsGet = new Listener(){

            public void handleEvent(Event e) {
                DatabaseJoinDialog.this.get();
            }
        };
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                DatabaseJoinDialog.this.cancel();
            }
        };
        this.wOK.addListener(13, this.lsOK);
        this.wGet.addListener(13, this.lsGet);
        this.wCancel.addListener(13, this.lsCancel);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                DatabaseJoinDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.wLimit.addSelectionListener((SelectionListener)this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                DatabaseJoinDialog.this.cancel();
            }
        });
        this.setSize();
        this.getData();
        this.input.setChanged(this.backupChanged);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    protected void setComboBoxes() {
        HashMap<String, Integer> fields = new HashMap<String, Integer>();
        fields.putAll(this.inputFields);
        Set keySet = fields.keySet();
        ArrayList entries = new ArrayList(keySet);
        String[] fieldNames = entries.toArray(new String[entries.size()]);
        Const.sortStrings((String[])fieldNames);
        this.ciKey[0].setComboValues(fieldNames);
    }

    public void setPosition() {
        String scr = this.wSQL.getText();
        int linenr = this.wSQL.getLineAtOffset(this.wSQL.getCaretOffset()) + 1;
        int posnr = this.wSQL.getCaretOffset();
        int colnr = 0;
        while (posnr > 0 && scr.charAt(posnr - 1) != '\n' && scr.charAt(posnr - 1) != '\r') {
            --posnr;
            ++colnr;
        }
        this.wlPosition.setText(BaseMessages.getString(PKG, (String)"DatabaseJoinDialog.Position.Label", (String[])new String[]{"" + linenr, "" + colnr}));
    }

    public void getData() {
        this.logDebug(BaseMessages.getString(PKG, (String)"DatabaseJoinDialog.Log.GettingKeyInfo", (String[])new String[0]));
        this.wSQL.setText(Const.NVL((String)this.input.getSql(), (String)""));
        this.wLimit.setText("" + this.input.getRowLimit());
        this.wOuter.setSelection(this.input.isOuterJoin());
        this.wuseVars.setSelection(this.input.isVariableReplace());
        if (this.input.getParameterField() != null) {
            for (int i = 0; i < this.input.getParameterField().length; ++i) {
                TableItem item = this.wParam.table.getItem(i);
                if (this.input.getParameterField()[i] != null) {
                    item.setText(1, this.input.getParameterField()[i]);
                }
                if (this.input.getParameterType()[i] == 0) continue;
                item.setText(2, ValueMetaFactory.getValueMetaName((int)this.input.getParameterType()[i]));
            }
        }
        if (this.input.getDatabaseMeta() != null) {
            this.wConnection.setText(this.input.getDatabaseMeta().getName());
        } else if (this.transMeta.nrDatabases() == 1) {
            this.wConnection.setText(this.transMeta.getDatabase(0).getName());
        }
        this.wParam.setRowNums();
        this.wParam.optWidth(true);
        this.wStepname.selectAll();
        this.wStepname.setFocus();
    }

    private void cancel() {
        this.stepname = null;
        this.input.setChanged(this.backupChanged);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wStepname.getText())) {
            return;
        }
        int nrparam = this.wParam.nrNonEmpty();
        this.input.allocate(nrparam);
        this.input.setRowLimit(Const.toInt((String)this.wLimit.getText(), (int)0));
        this.input.setSql(this.wSQL.getText());
        this.input.setOuterJoin(this.wOuter.getSelection());
        this.input.setVariableReplace(this.wuseVars.getSelection());
        this.logDebug(BaseMessages.getString(PKG, (String)"DatabaseJoinDialog.Log.ParametersFound", (String[])new String[0]) + nrparam + " parameters");
        for (int i = 0; i < nrparam; ++i) {
            TableItem item = this.wParam.getNonEmpty(i);
            this.input.getParameterField()[i] = item.getText(1);
            this.input.getParameterType()[i] = ValueMetaFactory.getIdForValueMeta((String)item.getText(2));
        }
        this.input.setDatabaseMeta(this.transMeta.findDatabase(this.wConnection.getText()));
        this.stepname = this.wStepname.getText();
        if (this.transMeta.findDatabase(this.wConnection.getText()) == null) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"DatabaseJoinDialog.InvalidConnection.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"DatabaseJoinDialog.InvalidConnection.DialogTitle", (String[])new String[0]));
            mb.open();
        }
        this.dispose();
    }

    private void get() {
        try {
            RowMetaInterface r = this.transMeta.getPrevStepFields(this.stepname);
            if (r != null && !r.isEmpty()) {
                BaseStepDialog.getFieldsFromPrevious(r, this.wParam, 1, new int[]{1}, new int[]{2}, -1, -1, null);
            }
        }
        catch (KettleException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"DatabaseJoinDialog.GetFieldsFailed.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DatabaseJoinDialog.GetFieldsFailed.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }
}

