/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.spoon.tree.provider;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.base.AbstractMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.partition.PartitionSchema;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.widget.tree.TreeNode;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.spoon.tree.TreeFolderProvider;

public class PartitionsFolderProvider
extends TreeFolderProvider {
    private static Class<?> PKG = Spoon.class;
    public static final String STRING_PARTITIONS = BaseMessages.getString(PKG, (String)"Spoon.STRING_PARTITIONS", (String[])new String[0]);
    private GUIResource guiResource;
    private Spoon spoon;

    public PartitionsFolderProvider(GUIResource guiResource, Spoon spoon) {
        this.guiResource = guiResource;
        this.spoon = spoon;
    }

    public PartitionsFolderProvider() {
        this(GUIResource.getInstance(), Spoon.getInstance());
    }

    @Override
    public void refresh(AbstractMeta meta, TreeNode treeNode, String filter) {
        List<PartitionSchema> partitionSchemas;
        TransMeta transMeta = (TransMeta)meta;
        try {
            partitionSchemas = this.pickupPartitionSchemas(transMeta);
        }
        catch (KettleException e) {
            new ErrorDialog(Spoon.getInstance().getShell(), BaseMessages.getString(PKG, (String)"Spoon.ErrorDialog.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Spoon.ErrorDialog.ErrorFetchingFromRepo.PartitioningSchemas", (String[])new String[0]), (Exception)((Object)e));
            return;
        }
        for (PartitionSchema partitionSchema : partitionSchemas) {
            if (!this.filterMatch(partitionSchema.getName(), filter)) continue;
            TreeNode childTreeNode = this.createTreeNode(treeNode, partitionSchema.getName(), this.guiResource.getImagePartitionSchema());
            if (!partitionSchema.isShared()) continue;
            childTreeNode.setFont(this.guiResource.getFontBold());
        }
    }

    private List<PartitionSchema> pickupPartitionSchemas(TransMeta transMeta) throws KettleException {
        Repository rep = this.spoon.getRepository();
        if (rep != null) {
            ObjectId[] ids = rep.getPartitionSchemaIDs(false);
            ArrayList<PartitionSchema> result = new ArrayList<PartitionSchema>(ids.length);
            for (ObjectId id : ids) {
                PartitionSchema schema = rep.loadPartitionSchema(id, null);
                result.add(schema);
            }
            return result;
        }
        return transMeta.getPartitionSchemas();
    }

    @Override
    public String getTitle() {
        return STRING_PARTITIONS;
    }

    @Override
    public Class getType() {
        return PartitionSchema.class;
    }
}

