/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.spoon.dialog;

import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.logging.DefaultLogLevel;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class LogSettingsDialog
extends Dialog {
    private static Class<?> PKG = LogSettingsDialog.class;
    private Label wlLoglevel;
    private CCombo wLoglevel;
    private FormData fdlLoglevel;
    private FormData fdLoglevel;
    private Button wOK;
    private Button wCancel;
    private Listener lsOK;
    private Listener lsCancel;
    private Shell shell;
    private Shell parent;
    private PropsUI props;

    public LogSettingsDialog(Shell par, int style, PropsUI pr) {
        super(par, style);
        this.parent = par;
        this.props = pr;
    }

    public void open() {
        Display display = this.parent.getDisplay();
        this.shell = new Shell(this.parent, 3312);
        this.props.setLook((Control)this.shell);
        this.shell.setImage(GUIResource.getInstance().getImageLogoSmall());
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"LogSettingsDialog.Dialog.LoggingParameters.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlLoglevel = new Label((Composite)this.shell, 131072);
        this.wlLoglevel.setText(BaseMessages.getString(PKG, (String)"LogSettingsDialog.Label.LogLevel", (String[])new String[0]));
        this.props.setLook((Control)this.wlLoglevel);
        this.fdlLoglevel = new FormData();
        this.fdlLoglevel.left = new FormAttachment(0, 0);
        this.fdlLoglevel.right = new FormAttachment(middle, -margin);
        this.fdlLoglevel.top = new FormAttachment(0, margin);
        this.wlLoglevel.setLayoutData((Object)this.fdlLoglevel);
        this.wLoglevel = new CCombo((Composite)this.shell, 2060);
        this.wLoglevel.setItems(LogLevel.getLogLevelDescriptions());
        this.props.setLook((Control)this.wLoglevel);
        this.fdLoglevel = new FormData();
        this.fdLoglevel.left = new FormAttachment(middle, 0);
        this.fdLoglevel.top = new FormAttachment(0, margin);
        this.fdLoglevel.right = new FormAttachment(100, 0);
        this.wLoglevel.setLayoutData((Object)this.fdLoglevel);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        BaseStepDialog.positionBottomButtons((Composite)this.shell, new Button[]{this.wOK, this.wCancel}, margin, (Control)this.wLoglevel);
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                LogSettingsDialog.this.cancel();
            }
        };
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                LogSettingsDialog.this.ok();
            }
        };
        this.wCancel.addListener(13, this.lsCancel);
        this.wOK.addListener(13, this.lsOK);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                LogSettingsDialog.this.cancel();
            }
        });
        BaseStepDialog.setSize(this.shell);
        this.getData();
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    public void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }

    public void getData() {
        this.wLoglevel.select(DefaultLogLevel.getLogLevel().getLevel());
    }

    private void cancel() {
        this.dispose();
    }

    private void ok() {
        int idx = this.wLoglevel.getSelectionIndex();
        DefaultLogLevel.setLogLevel((LogLevel)LogLevel.values()[idx]);
        this.props.setLogLevel(this.wLoglevel.getText());
        this.props.saveProps();
        this.dispose();
    }
}

