/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.spoon.dialog;

import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.dialog.PreviewRowsDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class EnterPreviewRowsDialog
extends Dialog {
    private static Class<?> PKG = EnterPreviewRowsDialog.class;
    private String stepname;
    private Label wlStepList;
    private org.eclipse.swt.widgets.List wStepList;
    private FormData fdlStepList;
    private FormData fdStepList;
    private Button wShow;
    private Button wClose;
    private Listener lsShow;
    private Listener lsClose;
    private Shell shell;
    private List<String> stepNames;
    private List<RowMetaInterface> rowMetas;
    private List<List<Object[]>> rowDatas;
    private PropsUI props;

    public EnterPreviewRowsDialog(Shell parent, int style, List<String> stepNames, List<RowMetaInterface> rowMetas, List<List<Object[]>> rowBuffers) {
        super(parent, style);
        this.stepNames = stepNames;
        this.rowDatas = rowBuffers;
        this.rowMetas = rowMetas;
        this.props = PropsUI.getInstance();
    }

    public Object open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3184);
        this.props.setLook((Control)this.shell);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"EnterPreviewRowsDialog.Dialog.PreviewStep.Title", (String[])new String[0]));
        this.shell.setImage(GUIResource.getInstance().getImageLogoSmall());
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlStepList = new Label((Composite)this.shell, 0);
        this.wlStepList.setText(BaseMessages.getString(PKG, (String)"EnterPreviewRowsDialog.Dialog.PreviewStep.Message", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepList);
        this.fdlStepList = new FormData();
        this.fdlStepList.left = new FormAttachment(0, 0);
        this.fdlStepList.top = new FormAttachment(0, margin);
        this.wlStepList.setLayoutData((Object)this.fdlStepList);
        this.wStepList = new org.eclipse.swt.widgets.List((Composite)this.shell, 19212);
        for (int i = 0; i < this.stepNames.size(); ++i) {
            this.wStepList.add(this.stepNames.get(i));
        }
        this.wStepList.select(0);
        this.props.setLook((Control)this.wStepList);
        this.fdStepList = new FormData();
        this.fdStepList.left = new FormAttachment(middle, 0);
        this.fdStepList.top = new FormAttachment(0, margin);
        this.fdStepList.bottom = new FormAttachment(100, -60);
        this.fdStepList.right = new FormAttachment(100, 0);
        this.wStepList.setLayoutData((Object)this.fdStepList);
        this.wStepList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
                EnterPreviewRowsDialog.this.show();
            }
        });
        this.wShow = new Button((Composite)this.shell, 8);
        this.wShow.setText(BaseMessages.getString(PKG, (String)"System.Button.Show", (String[])new String[0]));
        this.wClose = new Button((Composite)this.shell, 8);
        this.wClose.setText(BaseMessages.getString(PKG, (String)"System.Button.Close", (String[])new String[0]));
        BaseStepDialog.positionBottomButtons((Composite)this.shell, new Button[]{this.wShow, this.wClose}, margin, null);
        this.lsShow = new Listener(){

            public void handleEvent(Event e) {
                EnterPreviewRowsDialog.this.show();
            }
        };
        this.lsClose = new Listener(){

            public void handleEvent(Event e) {
                EnterPreviewRowsDialog.this.close();
            }
        };
        this.wShow.addListener(13, this.lsShow);
        this.wClose.addListener(13, this.lsClose);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                EnterPreviewRowsDialog.this.close();
            }
        });
        this.getData();
        BaseStepDialog.setSize(this.shell);
        if (this.stepNames.size() == 1) {
            this.wStepList.select(0);
            this.show();
        }
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    public void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }

    public void getData() {
    }

    private void close() {
        this.dispose();
    }

    private void show() {
        if (this.rowDatas.size() == 0) {
            return;
        }
        int nr = this.wStepList.getSelectionIndex();
        List<Object[]> buffer = this.rowDatas.get(nr);
        RowMetaInterface rowMeta = this.rowMetas.get(nr);
        String name = this.stepNames.get(nr);
        if (rowMeta != null && buffer != null && buffer.size() > 0) {
            PreviewRowsDialog prd = new PreviewRowsDialog(this.shell, Variables.getADefaultVariableSpace(), 0, name, rowMeta, buffer);
            prd.open();
        } else {
            MessageBox mb = new MessageBox(this.shell, 34);
            mb.setText(BaseMessages.getString(PKG, (String)"EnterPreviewRowsDialog.Dialog.NoPreviewRowsFound.Title", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"EnterPreviewRowsDialog.Dialog.NoPreviewRowsFound.Message", (String[])new String[0]));
            mb.open();
        }
    }
}

