/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.spoon;

import java.util.Locale;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.swt.graphics.Image;
import org.pentaho.di.core.EngineMetaInterface;
import org.pentaho.di.core.ObjectLocationSpecificationMethod;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleMissingPluginsException;
import org.pentaho.di.core.extension.ExtensionPointHandler;
import org.pentaho.di.core.extension.KettleExtensionPoint;
import org.pentaho.di.core.gui.OverwritePrompter;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.RepositoryElementInterface;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.steps.jobexecutor.JobExecutorMeta;
import org.pentaho.di.trans.steps.transexecutor.TransExecutorMeta;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.spoon.ConnectionListener;
import org.pentaho.di.ui.spoon.FileListener;
import org.pentaho.di.ui.spoon.MainSpoonPerspective;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.spoon.SpoonPerspectiveManager;
import org.pentaho.di.ui.trans.steps.missing.MissingTransDialog;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class TransFileListener
implements FileListener,
ConnectionListener {
    private static Class<?> PKG = Spoon.class;

    @Override
    public boolean open(Node transNode, String fname, boolean importfile) throws KettleMissingPluginsException {
        return this.open(transNode, fname, null, importfile);
    }

    @Override
    public boolean open(Node transNode, String fname, String connection, boolean importfile) throws KettleMissingPluginsException {
        final Spoon spoon = Spoon.getInstance();
        final PropsUI props = PropsUI.getInstance();
        try {
            ExtensionPointHandler.callExtensionPoint((LogChannelInterface)spoon.getLog(), (String)KettleExtensionPoint.TransBeforeOpen.id, (Object)fname);
            TransMeta transMeta = new TransMeta();
            transMeta.loadXML(transNode, fname, (IMetaStore)spoon.getMetaStore(), spoon.getRepository(), true, (VariableSpace)new Variables(), new OverwritePrompter(){

                public boolean overwritePrompt(String message, String rememberText, String rememberPropertyName) {
                    MessageDialogWithToggle.setDefaultImage((Image)GUIResource.getInstance().getImageSpoon());
                    Object[] res = spoon.messageDialogWithToggle(BaseMessages.getString((Class)PKG, (String)"System.Button.Yes", (String[])new String[0]), null, message, 1, new String[]{BaseMessages.getString((Class)PKG, (String)"System.Button.Yes", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"System.Button.No", (String[])new String[0])}, 1, rememberText, !props.askAboutReplacingDatabaseConnections());
                    int idx = (Integer)res[0];
                    boolean toggleState = (Boolean)res[1];
                    props.setAskAboutReplacingDatabaseConnections(!toggleState);
                    return (idx & 0xFF) == 0;
                }
            });
            if (transMeta.hasMissingPlugins()) {
                StepMeta stepMeta = transMeta.getStep(0);
                MissingTransDialog missingDialog = new MissingTransDialog(spoon.getShell(), transMeta.getMissingTrans(), stepMeta.getStepMetaInterface(), transMeta, stepMeta.getName());
                if (missingDialog.open() == null) {
                    return true;
                }
            }
            transMeta.setRepositoryDirectory(spoon.getDefaultSaveLocation((RepositoryElementInterface)transMeta));
            transMeta.setRepository(spoon.getRepository());
            transMeta.setMetaStore((IMetaStore)spoon.getMetaStore());
            if (connection != null) {
                transMeta.setVariable("connection", connection);
            }
            spoon.setTransMetaVariables(transMeta);
            spoon.getProperties().addLastFile("Trans", fname, null, false, null);
            spoon.addMenuLast();
            if (importfile) {
                if (spoon.getRepository() != null) {
                    transMeta = this.fixLinks(transMeta);
                }
            } else {
                transMeta.clearChanged();
            }
            transMeta.setFilename(fname);
            spoon.addTransGraph(transMeta);
            spoon.sharedObjectsFileMap.put(transMeta.getSharedObjects().getFilename(), transMeta.getSharedObjects());
            ExtensionPointHandler.callExtensionPoint((LogChannelInterface)spoon.getLog(), (String)KettleExtensionPoint.TransAfterOpen.id, (Object)transMeta);
            SpoonPerspectiveManager.getInstance().activatePerspective(MainSpoonPerspective.class);
            spoon.refreshTree();
            return true;
        }
        catch (KettleMissingPluginsException e) {
            throw e;
        }
        catch (KettleException e) {
            new ErrorDialog(spoon.getShell(), BaseMessages.getString(PKG, (String)"Spoon.Dialog.ErrorOpening.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Spoon.Dialog.ErrorOpening.Message", (String[])new String[0]) + fname, (Exception)((Object)e));
            return false;
        }
    }

    private TransMeta fixLinks(TransMeta transMeta) {
        transMeta = this.processLinkedJobs(transMeta);
        transMeta = this.processLinkedTrans(transMeta);
        return transMeta;
    }

    protected TransMeta processLinkedJobs(TransMeta transMeta) {
        for (StepMeta stepMeta : transMeta.getSteps()) {
            JobExecutorMeta jem;
            ObjectLocationSpecificationMethod specMethod;
            if (!stepMeta.getStepID().equalsIgnoreCase("JobExecutor") || (specMethod = (jem = (JobExecutorMeta)stepMeta.getStepMetaInterface()).getSpecificationMethod()) != ObjectLocationSpecificationMethod.FILENAME) continue;
            jem.setSpecificationMethod(ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME);
            String filename = jem.getFileName();
            String jobname = filename.substring(filename.lastIndexOf("/") + 1, filename.lastIndexOf(46));
            String directory = filename.substring(0, filename.lastIndexOf("/"));
            jem.setJobName(jobname);
            jem.setDirectoryPath(directory);
        }
        return transMeta;
    }

    protected TransMeta processLinkedTrans(TransMeta transMeta) {
        for (StepMeta stepMeta : transMeta.getSteps()) {
            TransExecutorMeta tem;
            ObjectLocationSpecificationMethod specMethod;
            if (!stepMeta.getStepID().equalsIgnoreCase("TransExecutor") || (specMethod = (tem = (TransExecutorMeta)stepMeta.getStepMetaInterface()).getSpecificationMethod()) != ObjectLocationSpecificationMethod.FILENAME) continue;
            tem.setSpecificationMethod(ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME);
            String filename = tem.getFileName();
            String jobname = filename.substring(filename.lastIndexOf("/") + 1, filename.lastIndexOf(46));
            String directory = filename.substring(0, filename.lastIndexOf("/"));
            tem.setTransName(jobname);
            tem.setDirectoryPath(directory);
        }
        return transMeta;
    }

    @Override
    public boolean save(EngineMetaInterface meta, String fname, boolean export) {
        Spoon spoon = Spoon.getInstance();
        Object lmeta = export ? (TransMeta)((TransMeta)meta).realClone(false) : meta;
        try {
            ExtensionPointHandler.callExtensionPoint((LogChannelInterface)spoon.getLog(), (String)KettleExtensionPoint.TransBeforeSave.id, (Object)lmeta);
        }
        catch (KettleException kettleException) {
            // empty catch block
        }
        boolean saveStatus = spoon.saveMeta((EngineMetaInterface)lmeta, fname);
        if (saveStatus) {
            try {
                ExtensionPointHandler.callExtensionPoint((LogChannelInterface)spoon.getLog(), (String)KettleExtensionPoint.TransAfterSave.id, (Object)lmeta);
            }
            catch (KettleException kettleException) {
                // empty catch block
            }
        }
        return saveStatus;
    }

    @Override
    public void syncMetaName(EngineMetaInterface meta, String name) {
        ((TransMeta)meta).setName(name);
    }

    @Override
    public boolean accepts(String fileName) {
        if (fileName == null || fileName.indexOf(46) == -1) {
            return false;
        }
        String extension = fileName.substring(fileName.lastIndexOf(46) + 1);
        return extension.equals("ktr");
    }

    @Override
    public boolean acceptsXml(String nodeName) {
        return "transformation".equals(nodeName);
    }

    @Override
    public String[] getFileTypeDisplayNames(Locale locale) {
        return new String[]{"Transformations", "XML"};
    }

    @Override
    public String getRootNodeName() {
        return "transformation";
    }

    @Override
    public String[] getSupportedExtensions() {
        return new String[]{"ktr", "xml"};
    }
}

