/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.spoon;

import com.google.common.annotations.VisibleForTesting;
import java.util.Date;
import java.util.Locale;
import org.pentaho.di.core.EngineMetaInterface;
import org.pentaho.di.core.ObjectLocationSpecificationMethod;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.extension.ExtensionPointHandler;
import org.pentaho.di.core.extension.KettleExtensionPoint;
import org.pentaho.di.core.gui.OverwritePrompter;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.job.JobEntryJob;
import org.pentaho.di.job.entries.trans.JobEntryTrans;
import org.pentaho.di.job.entry.JobEntryCopy;
import org.pentaho.di.repository.RepositoryElementInterface;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.job.entries.missing.MissingEntryDialog;
import org.pentaho.di.ui.spoon.ConnectionListener;
import org.pentaho.di.ui.spoon.FileListener;
import org.pentaho.di.ui.spoon.MainSpoonPerspective;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.spoon.SpoonPerspectiveManager;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class JobFileListener
implements FileListener,
ConnectionListener {
    private static Class<?> PKG = Spoon.class;

    @Override
    public boolean open(Node jobNode, String fname, boolean importfile) {
        return this.open(jobNode, fname, null, importfile);
    }

    @Override
    public boolean open(Node jobNode, String fname, String connection, boolean importfile) {
        Spoon spoon = Spoon.getInstance();
        try {
            MissingEntryDialog missingDialog;
            ExtensionPointHandler.callExtensionPoint((LogChannelInterface)spoon.getLog(), (String)KettleExtensionPoint.JobBeforeOpen.id, (Object)fname);
            JobMeta jobMeta = new JobMeta();
            jobMeta.loadXML(jobNode, fname, spoon.getRepository(), (IMetaStore)spoon.getMetaStore(), false, (OverwritePrompter)spoon);
            if (jobMeta.hasMissingPlugins() && (missingDialog = new MissingEntryDialog(spoon.getShell(), jobMeta.getMissingEntries())).open() == null) {
                return true;
            }
            this.clearCurrentDirectoryChangedListenersWhenImporting(importfile, jobMeta);
            jobMeta.setRepositoryDirectory(spoon.getDefaultSaveLocation((RepositoryElementInterface)jobMeta));
            jobMeta.setRepository(spoon.getRepository());
            jobMeta.setMetaStore((IMetaStore)spoon.getMetaStore());
            if (connection != null) {
                jobMeta.setVariable("connection", connection);
            }
            spoon.setJobMetaVariables(jobMeta);
            spoon.getProperties().addLastFile("Job", fname, null, false, null, null, new Date(), connection);
            spoon.addMenuLast();
            if (importfile) {
                if (spoon.getRepository() != null) {
                    jobMeta = this.fixLinks(jobMeta);
                }
            } else {
                jobMeta.clearChanged();
            }
            jobMeta.setFilename(fname);
            spoon.delegates.jobs.addJobGraph(jobMeta);
            ExtensionPointHandler.callExtensionPoint((LogChannelInterface)spoon.getLog(), (String)KettleExtensionPoint.JobAfterOpen.id, (Object)jobMeta);
            spoon.refreshTree();
            SpoonPerspectiveManager.getInstance().activatePerspective(MainSpoonPerspective.class);
            return true;
        }
        catch (KettleException e) {
            new ErrorDialog(spoon.getShell(), BaseMessages.getString(PKG, (String)"Spoon.Dialog.ErrorOpening.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Spoon.Dialog.ErrorOpening.Message", (String[])new String[0]) + fname, (Exception)((Object)e));
            return false;
        }
    }

    @VisibleForTesting
    void clearCurrentDirectoryChangedListenersWhenImporting(boolean importfile, JobMeta jobMeta) {
        if (importfile) {
            jobMeta.clearCurrentDirectoryChangedListeners();
        }
    }

    private JobMeta fixLinks(JobMeta jobMeta) {
        jobMeta = this.processLinkedJobs(jobMeta);
        jobMeta = this.processLinkedTrans(jobMeta);
        return jobMeta;
    }

    protected JobMeta processLinkedJobs(JobMeta jobMeta) {
        for (int i = 0; i < jobMeta.nrJobEntries(); ++i) {
            JobEntryJob jej;
            ObjectLocationSpecificationMethod specMethod;
            JobEntryCopy jec = jobMeta.getJobEntry(i);
            if (!(jec.getEntry() instanceof JobEntryJob) || (specMethod = (jej = (JobEntryJob)jec.getEntry()).getSpecificationMethod()) != ObjectLocationSpecificationMethod.FILENAME) continue;
            jej.setSpecificationMethod(ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME);
            String filename = jej.getFilename();
            if (filename != null) {
                if (filename.indexOf("/") > -1) {
                    String jobname = filename.substring(filename.lastIndexOf("/") + 1, filename.lastIndexOf(46));
                    String directory = filename.substring(0, filename.lastIndexOf("/"));
                    jej.setJobName(jobname);
                    jej.setDirectory(directory);
                } else {
                    jej.setJobName(filename);
                }
            }
            jobMeta.setJobEntry(i, jec);
        }
        return jobMeta;
    }

    protected JobMeta processLinkedTrans(JobMeta jobMeta) {
        for (int i = 0; i < jobMeta.nrJobEntries(); ++i) {
            JobEntryTrans jet;
            ObjectLocationSpecificationMethod specMethod;
            JobEntryCopy jec = jobMeta.getJobEntry(i);
            if (!(jec.getEntry() instanceof JobEntryTrans) || (specMethod = (jet = (JobEntryTrans)jec.getEntry()).getSpecificationMethod()) != ObjectLocationSpecificationMethod.FILENAME) continue;
            jet.setSpecificationMethod(ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME);
            String filename = jet.getFilename();
            if (filename != null) {
                if (filename.indexOf("/") > -1) {
                    String jobname = filename.substring(filename.lastIndexOf("/") + 1, filename.lastIndexOf(46));
                    String directory = filename.substring(0, filename.lastIndexOf("/"));
                    jet.setTransname(jobname);
                    jet.setDirectory(directory);
                } else {
                    jet.setTransname(filename);
                }
            }
            jobMeta.setJobEntry(i, jec);
        }
        return jobMeta;
    }

    @Override
    public boolean save(EngineMetaInterface meta, String fname, boolean export) {
        Spoon spoon = Spoon.getInstance();
        Object lmeta = export ? (JobMeta)((JobMeta)meta).realClone(false) : meta;
        try {
            ExtensionPointHandler.callExtensionPoint((LogChannelInterface)spoon.getLog(), (String)KettleExtensionPoint.JobBeforeSave.id, (Object)lmeta);
        }
        catch (KettleException kettleException) {
            // empty catch block
        }
        boolean saveStatus = spoon.saveMeta((EngineMetaInterface)lmeta, fname);
        if (saveStatus) {
            try {
                ExtensionPointHandler.callExtensionPoint((LogChannelInterface)spoon.getLog(), (String)KettleExtensionPoint.JobAfterSave.id, (Object)lmeta);
            }
            catch (KettleException kettleException) {
                // empty catch block
            }
        }
        return saveStatus;
    }

    @Override
    public void syncMetaName(EngineMetaInterface meta, String name) {
        ((JobMeta)meta).setName(name);
    }

    @Override
    public boolean accepts(String fileName) {
        if (fileName == null || fileName.indexOf(46) == -1) {
            return false;
        }
        String extension = fileName.substring(fileName.lastIndexOf(46) + 1);
        return extension.equals("kjb");
    }

    @Override
    public boolean acceptsXml(String nodeName) {
        return "job".equals(nodeName);
    }

    @Override
    public String[] getFileTypeDisplayNames(Locale locale) {
        return new String[]{"Jobs", "XML"};
    }

    @Override
    public String[] getSupportedExtensions() {
        return new String[]{"kjb", "xml"};
    }

    @Override
    public String getRootNodeName() {
        return "job";
    }
}

