/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.repository.repositoryexplorer.controllers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.KettleRepositoryLostException;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.repository.dialog.RepositoryExplorerDialog;
import org.pentaho.di.ui.repository.repositoryexplorer.RepositoryExplorerCallback;
import org.pentaho.di.ui.spoon.SharedObjectSyncUtil;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.containers.XulDialog;
import org.pentaho.ui.xul.impl.AbstractXulEventHandler;
import org.pentaho.ui.xul.stereotype.Bindable;
import org.pentaho.ui.xul.swt.SwtBindingFactory;
import org.pentaho.ui.xul.swt.tags.SwtDialog;
import org.pentaho.ui.xul.util.DialogController;

public class MainController
extends AbstractXulEventHandler
implements DialogController<Object> {
    private static Class<?> PKG = RepositoryExplorerDialog.class;
    private RepositoryExplorerCallback callback;
    public static final int CANCELLED = 0;
    public static final int OK = 1;
    private int lastClicked = 0;
    private XulDialog dialog;
    private List<DialogController.DialogListener<Object>> listeners = new ArrayList<DialogController.DialogListener<Object>>();
    private Shell shell;
    private Repository repository = null;
    BindingFactory bf;
    private boolean aborting = false;
    private SharedObjectSyncUtil sharedObjectSyncUtil;

    public boolean getOkClicked() {
        return this.lastClicked == 1;
    }

    public void init() {
        this.bf = new SwtBindingFactory();
        this.bf.setDocument(this.getXulDomContainer().getDocumentRoot());
        this.createBindings();
        if (this.dialog != null && this.repository != null) {
            this.dialog.setTitle(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.DevTitle", (String[])new String[]{this.repository.getName()}));
        }
    }

    public void showDialog() {
        this.dialog.show();
    }

    private void createBindings() {
        this.dialog = (XulDialog)this.document.getElementById("repository-explorer-dialog");
        this.shell = ((SwtDialog)this.document.getElementById("repository-explorer-dialog")).getShell();
    }

    public RepositoryExplorerCallback getCallback() {
        return this.callback;
    }

    public void setCallback(RepositoryExplorerCallback callback) {
        this.callback = callback;
    }

    public void setRepository(Repository rep) {
        this.repository = rep;
    }

    public String getName() {
        return "mainController";
    }

    @Bindable
    public void closeDialog() {
        this.lastClicked = 0;
        this.dialog.hide();
        Spoon.getInstance().refreshTree();
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).onDialogCancel();
        }
    }

    public void addDialogListener(DialogController.DialogListener<Object> listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeDialogListener(DialogController.DialogListener<Object> listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    public void hideDialog() {
        this.closeDialog();
    }

    private synchronized boolean isAborting() {
        if (!this.aborting) {
            this.aborting = true;
            return false;
        }
        return true;
    }

    public boolean handleLostRepository(Throwable e) {
        KettleRepositoryLostException repLost = KettleRepositoryLostException.lookupStackStrace((Throwable)e);
        try {
            if (repLost != null) {
                if (!this.isAborting()) {
                    new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"RepositoryExplorer.Dialog.Error.Title", (String[])new String[0]), repLost.getPrefaceMessage(), (Exception)((Object)repLost));
                    if (this.callback != null && this.callback.error(null)) {
                        this.closeDialog();
                    }
                }
                return true;
            }
        }
        catch (Exception ex) {
            return true;
        }
        return false;
    }

    public SharedObjectSyncUtil getSharedObjectSyncUtil() {
        return this.sharedObjectSyncUtil;
    }

    public void setSharedObjectSyncUtil(SharedObjectSyncUtil sharedObjectSyncUtil) {
        this.sharedObjectSyncUtil = sharedObjectSyncUtil;
    }
}

