/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.repository.repositoryexplorer;

import java.util.ArrayList;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.gui.SpoonFactory;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.IRepositoryService;
import org.pentaho.di.repository.KettleRepositoryLostException;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.repository.repositoryexplorer.ControllerInitializationException;
import org.pentaho.di.ui.repository.repositoryexplorer.RepositoryExplorerCallback;
import org.pentaho.di.ui.repository.repositoryexplorer.UISupportRegistery;
import org.pentaho.di.ui.repository.repositoryexplorer.controllers.MainController;
import org.pentaho.di.ui.repository.repositoryexplorer.uisupport.IRepositoryExplorerUISupport;
import org.pentaho.di.ui.spoon.SharedObjectSyncUtil;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.spoon.SpoonPluginManager;
import org.pentaho.di.ui.spoon.XulSpoonResourceBundle;
import org.pentaho.di.ui.spoon.XulSpoonSettingsManager;
import org.pentaho.di.ui.xul.KettleXulLoader;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.containers.XulDialog;
import org.pentaho.ui.xul.impl.XulEventHandler;
import org.pentaho.ui.xul.swt.SwtXulRunner;
import org.pentaho.ui.xul.swt.tags.SwtDialog;

public class RepositoryExplorer {
    private static Log log = LogFactory.getLog(RepositoryExplorer.class);
    private static final Class<?> CLZ = RepositoryExplorer.class;
    private MainController mainController = new MainController();
    private XulDomContainer container;
    private boolean initialized = false;
    private ResourceBundle resourceBundle = new XulSpoonResourceBundle(CLZ);

    public RepositoryExplorer(Shell shell, Repository rep, RepositoryExplorerCallback callback, VariableSpace variableSpace) throws XulException {
        KettleXulLoader xulLoader = new KettleXulLoader();
        xulLoader.setIconsSize(24, 24);
        xulLoader.setOuterContext(shell);
        xulLoader.setSettingsManager(XulSpoonSettingsManager.getInstance());
        this.container = xulLoader.loadXul("org/pentaho/di/ui/repository/repositoryexplorer/xul/explorer-layout.xul", this.resourceBundle);
        SpoonPluginManager.getInstance().applyPluginsForContainer("repository-explorer", this.container);
        SwtXulRunner runner = new SwtXulRunner();
        runner.addContainer(this.container);
        this.mainController.setRepository(rep);
        this.mainController.setCallback(callback);
        this.container.addEventHandler((XulEventHandler)this.mainController);
        ArrayList<IRepositoryExplorerUISupport> uiSupportList = new ArrayList<IRepositoryExplorerUISupport>();
        try {
            for (Object sevice : rep.getServiceInterfaces()) {
                IRepositoryExplorerUISupport uiSupport = UISupportRegistery.getInstance().createUISupport((Class<? extends IRepositoryService>)sevice);
                if (uiSupport == null) continue;
                uiSupportList.add(uiSupport);
                uiSupport.apply(this.container);
            }
        }
        catch (Exception e) {
            log.error((Object)this.resourceBundle.getString("RepositoryExplorer.ErrorStartingXulApplication"), (Throwable)e);
            new ErrorDialog(((Spoon)SpoonFactory.getInstance()).getShell(), BaseMessages.getString(Spoon.class, (String)"Spoon.Error", (String[])new String[0]), e.getMessage(), e);
        }
        KettleRepositoryLostException krle = null;
        for (IRepositoryExplorerUISupport uiSupport : uiSupportList) {
            try {
                uiSupport.initControllers(rep);
            }
            catch (ControllerInitializationException e) {
                log.error((Object)this.resourceBundle.getString("RepositoryExplorer.ErrorStartingXulApplication"), (Throwable)e);
                krle = KettleRepositoryLostException.lookupStackStrace((Throwable)e);
                if (krle != null) break;
                new ErrorDialog(((Spoon)SpoonFactory.getInstance()).getShell(), BaseMessages.getString(Spoon.class, (String)"Spoon.Error", (String[])new String[0]), e.getMessage(), e);
            }
        }
        if (krle != null) {
            this.dispose();
            throw krle;
        }
        try {
            runner.initialize();
        }
        catch (XulException e) {
            log.error((Object)this.resourceBundle.getString("RepositoryExplorer.ErrorStartingXulApplication"), (Throwable)e);
            new ErrorDialog(((Spoon)SpoonFactory.getInstance()).getShell(), BaseMessages.getString(Spoon.class, (String)"Spoon.Error", (String[])new String[0]), e.getMessage(), (Exception)((Object)e));
        }
        this.initialized = true;
    }

    public RepositoryExplorer(Shell shell, Repository rep, RepositoryExplorerCallback callback, VariableSpace variableSpace, SharedObjectSyncUtil syncUtil) throws XulException {
        this(shell, rep, callback, variableSpace);
        this.mainController.setSharedObjectSyncUtil(syncUtil);
    }

    public void show() {
        XulDialog dialog = (XulDialog)this.container.getDocumentRoot().getElementById("repository-explorer-dialog");
        dialog.show();
    }

    public void dispose() {
        SwtDialog dialog = (SwtDialog)this.container.getDocumentRoot().getElementById("repository-explorer-dialog");
        dialog.dispose();
        this.initialized = false;
    }

    public boolean isInitialized() {
        return this.initialized;
    }
}

