/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.i18n;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSelector;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.fileinput.FileInputList;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.i18n.KeyOccurrence;
import org.pentaho.di.ui.i18n.SourceCrawlerPackageException;
import org.pentaho.di.ui.i18n.SourceCrawlerXMLElement;
import org.pentaho.di.ui.i18n.SourceCrawlerXMLFolder;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MessagesSourceCrawler {
    private static final String SPLIT_CHARACTERS_STRING = ".(,";
    private static final char[] SPLIT_CHARACTERS = ".(,".toCharArray();
    private static final String SPLITTER_AND_WHITESPACES_PATTERN = "\\s*[%c]\\s*";
    private static final String SPLIT_AND_KEEP_DELIMITER_PATTERN = "((?<=[%1$c])|(?=[%1$c]))";
    private static final String SPLIT_LINE_PHRASE_FORMAT = ".*%s$";
    private static final String EMPTY_STRING = "";
    private static final String ASTERISK = "*";
    private static final String DOLLAR_SIGN = "$";
    private static final String DOT = ".";
    private static final String QUESTION_MARK = "?";
    private static final String SPACE = " ";
    private static final String TAB = "\t";
    private static final String N = "N";
    private static final String YES = "yes";
    private static final String DOT_CLASS = ".class";
    private static final String IMPORT_TOKEN = "import";
    private static final int IMPORT_TOKEN_LENGTH = "import".length();
    private static final String JAVA_EXTENSION = "java";
    private static final String PACKAGE_END_MESSAGES = ".Messages;";
    private static final String PACKAGE_START_ORG_PENTAHO = "org.pentaho.";
    private static final String PACKAGE_START_SYSTEM = "System.";
    private static final String PATTERN_PACKAGE_DECLARATION = "^\\s*package\\s*.*;\\s*$";
    private static final String PATTERN_ANY_PACKAGE_IMPORT = "^\\s*import\\s*[a-z._0-9]*\\.([*]|([A-Z][a-z._0-9]*))\\s*;\\s*$";
    private static final String PATTERN_MESSAGES_PACKAGE_IMPORT = "^\\s*import\\s*[a-z._0-9]*\\.Messages;\\s*$";
    private static final String PATTERN_STRING_PKG_VARIABLE_DECLARATION = "^.*private static String PKG.*=.*$";
    private static final String PATTERN_CLASS_PKG_VARIABLE_DECLARATION = "^.*private static Class.*\\sPKG\\s*=.*$";
    private String[] scanPhrases = new String[0];
    private List<String> sourceDirectories;
    private Map<String, Map<String, List<KeyOccurrence>>> sourcePackageOccurrences = new HashMap<String, Map<String, List<KeyOccurrence>>>();
    private List<String> filesToAvoid = new ArrayList<String>();
    private String singleMessagesFile;
    private List<SourceCrawlerXMLFolder> xmlFolders;
    private static Pattern packagePattern = Pattern.compile("^\\s*package\\s*.*;\\s*$");
    private static Pattern importPattern = Pattern.compile("^\\s*import\\s*[a-z._0-9]*\\.([*]|([A-Z][a-z._0-9]*))\\s*;\\s*$");
    private static Pattern importMessagesPattern = Pattern.compile("^\\s*import\\s*[a-z._0-9]*\\.Messages;\\s*$");
    private static Pattern stringPkgPattern = Pattern.compile("^.*private static String PKG.*=.*$");
    private static Pattern classPkgPattern = Pattern.compile("^.*private static Class.*\\sPKG\\s*=.*$");
    private LogChannelInterface log;

    public MessagesSourceCrawler(LogChannelInterface log, List<String> sourceDirectories, String singleMessagesFile, List<SourceCrawlerXMLFolder> xmlFolders) {
        this.log = log;
        this.sourceDirectories = null != sourceDirectories ? sourceDirectories : new ArrayList();
        this.singleMessagesFile = singleMessagesFile;
        this.xmlFolders = null != xmlFolders ? xmlFolders : new ArrayList();
    }

    public void addKeyOccurrence(KeyOccurrence occ) {
        if (null != occ) {
            List<KeyOccurrence> occurrences;
            String sourceFolder = occ.getSourceFolder();
            if (sourceFolder == null) {
                throw new RuntimeException("No source folder found for key: " + occ.getKey() + " in package " + occ.getMessagesPackage());
            }
            String messagesPackage = occ.getMessagesPackage();
            Map<String, List<KeyOccurrence>> packageOccurrences = this.sourcePackageOccurrences.get(sourceFolder);
            if (packageOccurrences == null) {
                packageOccurrences = new HashMap<String, List<KeyOccurrence>>();
                this.sourcePackageOccurrences.put(sourceFolder, packageOccurrences);
            }
            if ((occurrences = packageOccurrences.get(messagesPackage)) == null) {
                occurrences = new ArrayList<KeyOccurrence>();
                occurrences.add(occ);
                packageOccurrences.put(messagesPackage, occurrences);
            } else {
                int index = Collections.binarySearch(occurrences, occ);
                if (index < 0) {
                    occurrences.add(-index - 1, occ);
                }
            }
        }
    }

    public void crawl() throws Exception {
        this.crawlSourceDirectories();
        this.crawlXmlFolders();
    }

    public void crawlSourceDirectories() throws Exception {
        for (String sourceDirectory : this.sourceDirectories) {
            FileObject[] javaFiles;
            FileObject folder = KettleVFS.getFileObject((String)sourceDirectory);
            for (FileObject javaFile : javaFiles = folder.findFiles(new FileSelector(){

                public boolean traverseDescendents(FileSelectInfo info) throws Exception {
                    return true;
                }

                public boolean includeFile(FileSelectInfo info) throws Exception {
                    FileObject file = info.getFile();
                    FileName fileName = file.getName();
                    return file.isFile() && MessagesSourceCrawler.JAVA_EXTENSION.equals(fileName.getExtension()) && !MessagesSourceCrawler.this.filesToAvoid.contains(fileName.getBaseName());
                }
            })) {
                this.lookForOccurrencesInFile(sourceDirectory, javaFile);
            }
        }
    }

    protected void crawlXmlFolders() throws Exception {
        for (SourceCrawlerXMLFolder xmlFolder : this.xmlFolders) {
            String[] xmlDirs = new String[]{xmlFolder.getFolder()};
            String[] xmlMasks = new String[]{xmlFolder.getWildcard()};
            String[] xmlReq = new String[]{N};
            boolean[] xmlSubdirs = new boolean[]{true};
            FileInputList xulFileInputList = FileInputList.createFileList((VariableSpace)new Variables(), (String[])xmlDirs, (String[])xmlMasks, (String[])xmlReq, (boolean[])xmlSubdirs);
            for (FileObject fileObject : xulFileInputList.getFiles()) {
                try {
                    Document doc = XMLHandler.loadXMLFile((FileObject)fileObject);
                    for (SourceCrawlerXMLElement xmlElement : xmlFolder.getElements()) {
                        this.addLabelOccurrences(xmlFolder.getDefaultSourceFolder(), fileObject, doc.getElementsByTagName(xmlElement.getSearchElement()), xmlFolder.getKeyPrefix(), xmlElement.getKeyTag(), xmlElement.getKeyAttribute(), xmlFolder.getDefaultPackage(), xmlFolder.getPackageExceptions());
                    }
                }
                catch (KettleXMLException e) {
                    this.log.logError("Unable to open XUL / XML document: " + fileObject);
                }
            }
        }
    }

    private void addLabelOccurrences(String sourceFolder, FileObject fileObject, NodeList nodeList, String keyPrefix, String tag, String attribute, String defaultPackage, List<SourceCrawlerPackageException> packageExcpeptions) throws Exception {
        if (nodeList == null) {
            return;
        }
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", YES);
        transformer.setOutputProperty("indent", YES);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            String labelString = null;
            if (!Utils.isEmpty((CharSequence)attribute)) {
                labelString = XMLHandler.getTagAttribute((Node)node, (String)attribute);
            } else if (!Utils.isEmpty((CharSequence)tag)) {
                labelString = XMLHandler.getTagValue((Node)node, (String)tag);
            }
            if (labelString == null || !labelString.startsWith(DOLLAR_SIGN)) continue;
            String key = labelString.substring(2, labelString.length() - 1).trim();
            String messagesPackage = defaultPackage;
            for (SourceCrawlerPackageException packageException : packageExcpeptions) {
                if (!key.startsWith(packageException.getStartsWith())) continue;
                messagesPackage = packageException.getPackageName();
            }
            StringWriter bodyXML = new StringWriter();
            transformer.transform(new DOMSource(node), new StreamResult(bodyXML));
            String xml = bodyXML.getBuffer().toString();
            KeyOccurrence keyOccurrence = new KeyOccurrence(fileObject, sourceFolder, messagesPackage, -1, -1, key, QUESTION_MARK, xml);
            this.addKeyOccurrence(keyOccurrence);
        }
    }

    public void lookForOccurrencesInFile(String sourceFolder, FileObject javaFile) throws IOException {
        try (InputStreamReader is = new InputStreamReader(KettleVFS.getInputStream((FileObject)javaFile));
             BufferedReader reader = new BufferedReader(is);){
            String messagesPackage = null;
            String classPackage = null;
            int row = 0;
            HashMap<String, String> importedClasses = new HashMap<String, String>();
            String line = reader.readLine();
            List<String> splitLinePhrases = this.getSplitLinePhrases(this.scanPhrases);
            while (line != null) {
                int endIndex;
                ++row;
                line = this.getCompleteLine(reader, line, splitLinePhrases);
                for (String scanPhrase : this.scanPhrases) {
                    line = line.replaceAll(this.getWhitespacesSanitizeRegex(scanPhrase), scanPhrase);
                }
                if (packagePattern.matcher(line).matches()) {
                    int beginIndex = line.indexOf(PACKAGE_START_ORG_PENTAHO);
                    endIndex = line.indexOf(59);
                    if (beginIndex >= 0 && endIndex > beginIndex) {
                        classPackage = messagesPackage = line.substring(beginIndex, endIndex);
                    }
                }
                if (importPattern.matcher(line).matches()) {
                    String expression;
                    int lastDotIndex;
                    int beginIndex = line.indexOf(IMPORT_TOKEN) + IMPORT_TOKEN_LENGTH + 1;
                    endIndex = line.indexOf(59, beginIndex);
                    if (beginIndex >= 0 && endIndex > beginIndex && (lastDotIndex = (expression = line.substring(beginIndex, endIndex)).lastIndexOf(46)) > 0) {
                        String packageName = expression.substring(0, lastDotIndex);
                        String className = expression.substring(lastDotIndex + 1);
                        if (!ASTERISK.equals(className)) {
                            importedClasses.put(className, packageName);
                        }
                    }
                }
                if (importMessagesPattern.matcher(line).matches()) {
                    int beginIndex = line.indexOf(PACKAGE_START_ORG_PENTAHO);
                    endIndex = line.indexOf(PACKAGE_END_MESSAGES);
                    if (beginIndex >= 0 && endIndex > beginIndex) {
                        messagesPackage = line.substring(beginIndex, endIndex);
                    }
                }
                if (stringPkgPattern.matcher(line).matches()) {
                    int beginIndex = line.indexOf(34) + 1;
                    endIndex = line.indexOf(34, beginIndex);
                    if (beginIndex >= 0 && endIndex > beginIndex) {
                        messagesPackage = line.substring(beginIndex, endIndex);
                    }
                }
                if (classPackage != null && classPkgPattern.matcher(line).matches()) {
                    int toIndex;
                    int fromIndex = line.indexOf(61) + 1;
                    String expression = Const.trim((String)line.substring(fromIndex, toIndex = line.indexOf(DOT_CLASS, fromIndex)));
                    if (expression.contains(DOT)) {
                        int lastDotIndex = expression.lastIndexOf(46);
                        messagesPackage = expression.substring(0, lastDotIndex);
                    } else {
                        String packageName = (String)importedClasses.get(expression);
                        messagesPackage = packageName == null ? classPackage : packageName;
                    }
                }
                this.lookForOccurrencesInLine(sourceFolder, javaFile, messagesPackage, row, line);
                line = reader.readLine();
            }
        }
    }

    protected String getCompleteLine(BufferedReader reader, String line, List<String> splitLinePhrases) throws IOException {
        boolean extraLine;
        do {
            String line2 = line;
            extraLine = false;
            for (String joinPhrase : splitLinePhrases) {
                if (!line2.matches(joinPhrase)) continue;
                extraLine = true;
                break;
            }
            if (!extraLine) continue;
            line2 = reader.readLine();
            if (null == line2) break;
            line = line + line2;
        } while (extraLine);
        return line;
    }

    protected void lookForOccurrencesInLine(String sourceFolder, FileObject javaFile, String messagesPackage, int row, String line) {
        for (String scanPhrase : this.scanPhrases) {
            int index = line.indexOf(scanPhrase);
            while (index >= 0) {
                if (index == 0 || !Character.isJavaIdentifierPart(line.charAt(index - 1))) {
                    this.addLineOccurrence(sourceFolder, javaFile, messagesPackage, line, row, index, scanPhrase);
                }
                index = line.indexOf(scanPhrase, index + 1);
            }
        }
    }

    private List<String> getSplitLinePhrases(String[] scanPhrases) {
        ArrayList<String> joinPhrases = new ArrayList<String>();
        if (null != scanPhrases) {
            for (String scanPhrase : scanPhrases) {
                joinPhrases.addAll(this.getSplitLinePhrases(scanPhrase));
            }
        }
        return joinPhrases;
    }

    protected List<String> getSplitLinePhrases(String scanPhrase) {
        String[] splitTmp;
        ArrayList<String> joinPhrases = new ArrayList<String>();
        String regex = this.getSplitWithDelimitersRegex(SPLIT_CHARACTERS);
        for (String splitPart : splitTmp = scanPhrase.split(regex)) {
            StringBuilder sb = new StringBuilder();
            if (1 != splitPart.length() && !SPLIT_CHARACTERS_STRING.contains(splitPart)) {
                sb.append(splitPart.trim()).append("\\s*");
            } else {
                sb.append(String.format("[%s]\\s*", splitPart));
            }
            joinPhrases.add(String.format(SPLIT_LINE_PHRASE_FORMAT, sb.toString()));
        }
        return joinPhrases;
    }

    private String getSplitWithDelimitersRegex(char[] delimiters) {
        StringBuilder regex = new StringBuilder();
        boolean notFirstTime = false;
        for (char delimiter : delimiters) {
            if (notFirstTime) {
                regex.append('|');
            }
            regex.append(String.format(SPLIT_AND_KEEP_DELIMITER_PATTERN, Character.valueOf(delimiter)));
            notFirstTime = true;
        }
        return regex.toString();
    }

    protected String getWhitespacesSanitizeRegex(String str) {
        String whitespacesSanitizeRegex = str;
        if (null != whitespacesSanitizeRegex) {
            for (char splitChar : SPLIT_CHARACTERS) {
                String patternMatcher = String.format(SPLITTER_AND_WHITESPACES_PATTERN, Character.valueOf(splitChar));
                whitespacesSanitizeRegex = whitespacesSanitizeRegex.replaceAll(patternMatcher, Matcher.quoteReplacement(patternMatcher));
            }
        }
        return whitespacesSanitizeRegex;
    }

    private void addLineOccurrence(String sourceFolder, FileObject fileObject, String messagesPackage, String line, int row, int index, String scanPhrase) {
        String key;
        int column = index + scanPhrase.length();
        String arguments = EMPTY_STRING;
        int startKeyIndex = line.indexOf(34, column) + 1;
        int endKeyIndex = line.indexOf(34, startKeyIndex);
        if (endKeyIndex >= 0) {
            int bracketIndex;
            key = line.substring(startKeyIndex, endKeyIndex);
            int nrOpen = 1;
            for (bracketIndex = endKeyIndex; nrOpen != 0 && bracketIndex < line.length(); ++bracketIndex) {
                char c = line.charAt(bracketIndex);
                if (c == '(') {
                    ++nrOpen;
                }
                if (c != ')') continue;
                --nrOpen;
            }
            arguments = bracketIndex + 1 < line.length() ? line.substring(endKeyIndex + 1, bracketIndex) : line.substring(endKeyIndex + 1);
        } else {
            key = line.substring(startKeyIndex);
        }
        if (key.contains(TAB) || key.contains(SPACE)) {
            System.out.println("Suspect key found: [" + key + "] in file [" + fileObject + "]");
        }
        if (key.startsWith(PACKAGE_START_SYSTEM)) {
            String i18nPackage = BaseMessages.class.getPackage().getName();
            KeyOccurrence keyOccurrence = new KeyOccurrence(fileObject, sourceFolder, i18nPackage, row, column, key, arguments, line);
            KeyOccurrence lookup = this.getKeyOccurrence(key, i18nPackage);
            if (lookup == null) {
                this.addKeyOccurrence(keyOccurrence);
            } else {
                lookup.setSourceLine(lookup.getSourceLine() + Const.CR + keyOccurrence.getSourceLine());
                lookup.incrementOccurrences();
            }
        } else {
            KeyOccurrence keyOccurrence = new KeyOccurrence(fileObject, sourceFolder, messagesPackage, row, column, key, arguments, line);
            this.addKeyOccurrence(keyOccurrence);
        }
    }

    public List<String> getMessagesPackagesList(String sourceFolder) {
        Map<String, List<KeyOccurrence>> packageOccurrences = this.sourcePackageOccurrences.get(sourceFolder);
        ArrayList<String> list = new ArrayList<String>(packageOccurrences.keySet());
        Collections.sort(list);
        return list;
    }

    public List<KeyOccurrence> getOccurrencesForPackage(String messagesPackage) {
        ArrayList<KeyOccurrence> list = new ArrayList<KeyOccurrence>();
        for (Map<String, List<KeyOccurrence>> po : this.sourcePackageOccurrences.values()) {
            List<KeyOccurrence> occurrences = po.get(messagesPackage);
            if (occurrences == null) continue;
            list.addAll(occurrences);
        }
        return list;
    }

    public KeyOccurrence getKeyOccurrence(String key, String selectedMessagesPackage) {
        for (Map<String, List<KeyOccurrence>> po : this.sourcePackageOccurrences.values()) {
            List<KeyOccurrence> occurrences;
            if (po == null || (occurrences = po.get(selectedMessagesPackage)) == null) continue;
            for (KeyOccurrence keyOccurrence : occurrences) {
                if (!keyOccurrence.getKey().equals(key) || !keyOccurrence.getMessagesPackage().equals(selectedMessagesPackage)) continue;
                return keyOccurrence;
            }
        }
        return null;
    }

    public List<KeyOccurrence> getKeyOccurrences(String sourceFolder) {
        HashMap<String, KeyOccurrence> map = new HashMap<String, KeyOccurrence>();
        Map<String, List<KeyOccurrence>> po = this.sourcePackageOccurrences.get(sourceFolder);
        if (po != null) {
            for (List<KeyOccurrence> keyOccurrences : po.values()) {
                for (KeyOccurrence keyOccurrence : keyOccurrences) {
                    String key = keyOccurrence.getMessagesPackage() + " - " + keyOccurrence.getKey();
                    map.put(key, keyOccurrence);
                }
            }
        }
        return new ArrayList<KeyOccurrence>(map.values());
    }

    public List<String> getSourceDirectories() {
        return this.sourceDirectories;
    }

    public void setSourceDirectories(List<String> sourceDirectories) {
        this.sourceDirectories = null != sourceDirectories ? sourceDirectories : new ArrayList();
    }

    public List<String> getFilesToAvoid() {
        return this.filesToAvoid;
    }

    public void setFilesToAvoid(List<String> filesToAvoid) {
        this.filesToAvoid = null != filesToAvoid ? filesToAvoid : new ArrayList();
    }

    public String getSingleMessagesFile() {
        return this.singleMessagesFile;
    }

    public void setSingleMessagesFile(String singleMessagesFile) {
        this.singleMessagesFile = singleMessagesFile;
    }

    public String[] getScanPhrases() {
        return this.scanPhrases;
    }

    public void setScanPhrases(String[] scanPhrases) {
        this.scanPhrases = null != scanPhrases ? scanPhrases : new String[]{};
    }

    public Map<String, Map<String, List<KeyOccurrence>>> getSourcePackageOccurrences() {
        return this.sourcePackageOccurrences;
    }

    public void setSourcePackageOccurrences(Map<String, Map<String, List<KeyOccurrence>>> sourcePackageOccurrences) {
        this.sourcePackageOccurrences = null != sourcePackageOccurrences ? sourcePackageOccurrences : new HashMap();
    }
}

