/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.dialog;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.Const;
import org.pentaho.di.ui.core.FormDataBuilder;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.gui.WindowProperty;

public abstract class BaseDialog
extends Dialog {
    public static final int MARGIN_SIZE = 15;
    public static final int LABEL_SPACING = 5;
    public static final int ELEMENT_SPACING = 10;
    public static final int MEDIUM_FIELD = 250;
    public static final int MEDIUM_SMALL_FIELD = 150;
    public static final int SMALL_FIELD = 50;
    public static final int SHELL_WIDTH_OFFSET = 16;
    public static final int VAR_ICON_WIDTH = GUIResource.getInstance().getImageVariable().getBounds().width;
    public static final int VAR_ICON_HEIGHT = GUIResource.getInstance().getImageVariable().getBounds().height;
    protected Map<String, Listener> buttons = new HashMap<String, Listener>();
    protected Shell shell;
    protected PropsUI props = PropsUI.getInstance();
    protected int width = -1;
    protected String title;
    private int footerTopPadding = 40;

    public BaseDialog(Shell shell) {
        this(shell, null, -1);
    }

    public BaseDialog(Shell shell, String title, int width) {
        super(shell, 0);
        this.title = title;
        this.width = width;
    }

    private Display prepareLayout() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 268503136);
        this.shell.setImage(GUIResource.getInstance().getImageSpoon());
        this.props.setLook((Control)this.shell);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                BaseDialog.this.dispose();
            }
        });
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 15;
        formLayout.marginHeight = 15;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(this.title);
        return display;
    }

    protected abstract Control buildBody();

    public int open() {
        Display display = this.prepareLayout();
        Control lastBodyElement = this.buildBody();
        this.buildFooter(lastBodyElement);
        this.open(display);
        return 1;
    }

    private void open(Display display) {
        this.shell.pack();
        if (this.width > 0) {
            int height = this.shell.computeSize((int)this.width, (int)-1).y;
            this.shell.setMinimumSize(this.width + 16, height);
            this.shell.setSize(this.width + 16, height);
        }
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    protected void buildFooter(Control anchorElement) {
        Button button;
        Button[] buttonArr = new Button[this.buttons == null ? 0 : this.buttons.size()];
        int index = 0;
        if (this.buttons != null) {
            for (String buttonName : this.buttons.keySet()) {
                button = new Button((Composite)this.shell, 8);
                button.setText(buttonName);
                Listener listener = this.buttons.get(buttonName);
                if (listener != null) {
                    button.addListener(13, listener);
                } else {
                    button.addListener(13, event -> this.dispose());
                }
                buttonArr[index++] = button;
            }
        }
        Button previousButton = null;
        for (int i = buttonArr.length - 1; i >= 0; --i) {
            button = buttonArr[i];
            if (previousButton == null) {
                button.setLayoutData((Object)new FormDataBuilder().top(anchorElement, this.footerTopPadding).right(100, 0).result());
            } else {
                button.setLayoutData((Object)new FormDataBuilder().top(anchorElement, this.footerTopPadding).right((Control)previousButton, Const.isOSX() ? 0 : -5).result());
            }
            previousButton = button;
        }
    }

    public void setFooterTopPadding(int footerTopPadding) {
        this.footerTopPadding = footerTopPadding;
    }

    public void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }

    public void setButtons(Map<String, Listener> buttons) {
        this.buttons = buttons;
    }
}

