/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.database.dialog;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.ProgressMonitorAdapter;
import org.pentaho.di.core.ProgressMonitorListener;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.database.DatabaseMetaInformation;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.database.dialog.DatabaseInfoProgressListener;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.spoon.Spoon;

public class GetDatabaseInfoProgressDialog {
    private static Class<?> PKG = GetDatabaseInfoProgressDialog.class;
    private Shell shell;
    private DatabaseMeta dbInfo;
    private List<DatabaseInfoProgressListener> listeners;

    public GetDatabaseInfoProgressDialog(Shell shell, DatabaseMeta dbInfo) {
        this.shell = shell;
        this.dbInfo = dbInfo;
        this.listeners = new ArrayList<DatabaseInfoProgressListener>();
    }

    public void addDatabaseProgressListener(DatabaseInfoProgressListener listener) {
        this.listeners.add(listener);
    }

    public boolean removeDatabaseProgressListener(DatabaseInfoProgressListener listener) {
        return this.listeners.remove(listener);
    }

    private void notifyDatabaseProgress(IProgressMonitor progressMonitor) {
        this.listeners.forEach(listener -> listener.databaseInfoProgressFinished(progressMonitor));
    }

    public DatabaseMetaInformation open() {
        final DatabaseMetaInformation dmi = new DatabaseMetaInformation(this.dbInfo);
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    dmi.getData(Spoon.loggingObject, (ProgressMonitorListener)new ProgressMonitorAdapter(monitor));
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e, BaseMessages.getString((Class)PKG, (String)"GetDatabaseInfoProgressDialog.Error.GettingInfoTable", (String[])new String[]{e.toString()}));
                }
            }
        };
        try {
            ProgressMonitorDialog pmd = new ProgressMonitorDialog(this.shell);
            pmd.run(true, true, op);
            this.notifyDatabaseProgress(pmd.getProgressMonitor());
        }
        catch (InvocationTargetException e) {
            this.showErrorDialog(e);
            return null;
        }
        catch (InterruptedException e) {
            this.showErrorDialog(e);
            return null;
        }
        return dmi;
    }

    private void showErrorDialog(Exception e) {
        new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"GetDatabaseInfoProgressDialog.Error.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GetDatabaseInfoProgressDialog.Error.Message", (String[])new String[0]), e);
    }
}

