/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.sapinput;

import java.util.ArrayList;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.sapinput.SapInputData;
import org.pentaho.di.trans.steps.sapinput.SapInputMeta;
import org.pentaho.di.trans.steps.sapinput.SapOutputField;
import org.pentaho.di.trans.steps.sapinput.SapParameter;
import org.pentaho.di.trans.steps.sapinput.sap.SAPConnectionFactory;
import org.pentaho.di.trans.steps.sapinput.sap.SAPException;
import org.pentaho.di.trans.steps.sapinput.sap.SAPField;
import org.pentaho.di.trans.steps.sapinput.sap.SAPRow;
import org.pentaho.di.trans.steps.sapinput.sap.impl.SAPRowIterator;

public class SapInput
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = SapInputMeta.class;
    private SapInputMeta meta;
    private SapInputData data;

    public SapInput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        SAPRowIterator resultSet;
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            this.data.outputRowMeta = new RowMeta();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, (VariableSpace)this, this.repository, this.metaStore);
            this.data.parameterIndexes = new ArrayList<Integer>();
            for (SapParameter parameter : this.meta.getParameters()) {
                int index = this.getInputRowMeta().indexOfValue(parameter.getFieldName());
                if (index < 0) {
                    throw new KettleException("Unable to find field '" + parameter.getFieldName() + "'");
                }
                this.data.parameterIndexes.add(index);
            }
            this.data.output = new ArrayList<SAPField>();
            for (SapOutputField outputField : this.meta.getOutputFields()) {
                SAPField field = new SAPField(outputField.getSapFieldName(), outputField.getTableName(), "output_" + outputField.getSapType().getDescription());
                this.data.output.add(field);
            }
        }
        ArrayList<SAPField> input = new ArrayList<SAPField>();
        for (int i = 0; i < this.meta.getParameters().size(); ++i) {
            SapParameter parameter = this.meta.getParameters().get(i);
            int fieldIndex = this.data.parameterIndexes.get(i);
            ValueMetaInterface valueMeta = this.getInputRowMeta().getValueMeta(fieldIndex);
            Object value = valueMeta.convertToNormalStorageType(r[fieldIndex]);
            SAPField field = new SAPField(parameter.getParameterName(), parameter.getTableName(), "input_" + parameter.getSapType().getDescription(), value);
            input.add(field);
        }
        try {
            resultSet = this.data.sapConnection.executeFunctionCursored(this.meta.getFunction(), input, this.data.output);
        }
        catch (SAPException e) {
            throw new KettleException((Throwable)((Object)e));
        }
        while (resultSet.hasNext()) {
            SAPRow sapRow = resultSet.next();
            Object[] outputRowData = RowDataUtil.allocateRowData((int)this.data.outputRowMeta.size());
            int outputIndex = 0;
            for (SAPField field : sapRow.getFields()) {
                outputRowData[outputIndex++] = field.getValue();
            }
            this.putRow(this.data.outputRowMeta, outputRowData);
            if (!this.getTrans().isStopped()) continue;
            break;
        }
        return true;
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        if (this.data.sapConnection != null) {
            this.data.sapConnection.close();
        }
        super.dispose(smi, sdi);
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (SapInputMeta)smi;
        this.data = (SapInputData)sdi;
        if (super.init(smi, sdi)) {
            boolean passed = true;
            if (this.meta.getFunction() == null) {
                this.logError(BaseMessages.getString(PKG, (String)"SapInput.Exception.FunctionIsNeeded", (String[])new String[0]));
                passed = false;
            }
            if (this.meta.getDatabaseMeta() == null) {
                this.logError(BaseMessages.getString(PKG, (String)"SapInput.Exception.DatabaseConnectionsIsNeeded", (String[])new String[0]));
                passed = false;
            }
            if (!passed) {
                return false;
            }
            try {
                this.data.sapConnection = SAPConnectionFactory.create();
                this.data.sapConnection.open(this.meta.getDatabaseMeta());
                return true;
            }
            catch (SAPException e) {
                this.logError("An error occurred while connecting to SAP ERP, processing will be stopped:", (Throwable)((Object)e));
                this.setErrors(1L);
                this.stopAll();
            }
        }
        return false;
    }
}

