/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.cubeinput;

import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.annotations.Step;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceDefinition;
import org.pentaho.di.resource.ResourceNamingInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.cubeinput.CubeInput;
import org.pentaho.di.trans.steps.cubeinput.CubeInputData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

@Step(id="CubeInput", i18nPackageName="org.pentaho.di.trans.steps.cubeinput", name="CubeInput.Name", description="CubeInput.Description", categoryDescription="i18n:org.pentaho.di.trans.step:BaseStep.Category.Input")
public class CubeInputMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = CubeInputMeta.class;
    private String filename;
    private String rowLimit;
    private boolean addfilenameresult;

    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode);
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    @Deprecated
    public void setRowLimit(int rowLimit) {
        this.rowLimit = String.valueOf(rowLimit);
    }

    public void setRowLimit(String rowLimit) {
        this.rowLimit = rowLimit;
    }

    public String getRowLimit() {
        return this.rowLimit;
    }

    public boolean isAddResultFile() {
        return this.addfilenameresult;
    }

    public void setAddResultFile(boolean addfilenameresult) {
        this.addfilenameresult = addfilenameresult;
    }

    public Object clone() {
        CubeInputMeta retval = (CubeInputMeta)((Object)super.clone());
        return retval;
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            this.filename = XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"name");
            this.rowLimit = XMLHandler.getTagValue((Node)stepnode, (String)"limit");
            this.addfilenameresult = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"addfilenameresult"));
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"CubeInputMeta.Exception.UnableToLoadStepInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    public void setDefault() {
        this.filename = "file";
        this.rowLimit = "0";
        this.addfilenameresult = false;
    }

    public void getFields(RowMetaInterface r, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        GZIPInputStream fis = null;
        FilterInputStream dis = null;
        try {
            InputStream is = KettleVFS.getInputStream((String)space.environmentSubstitute(this.filename), (VariableSpace)space);
            fis = new GZIPInputStream(is);
            dis = new DataInputStream(fis);
            RowMeta add = new RowMeta((DataInputStream)dis);
            for (int i = 0; i < add.size(); ++i) {
                add.getValueMeta(i).setOrigin(name);
            }
            r.mergeRowMeta((RowMetaInterface)add);
        }
        catch (KettleFileException kfe) {
            throw new KettleStepException(BaseMessages.getString(PKG, (String)"CubeInputMeta.Exception.UnableToReadMetaData", (String[])new String[0]), (Throwable)kfe);
        }
        catch (IOException e) {
            throw new KettleStepException(BaseMessages.getString(PKG, (String)"CubeInputMeta.Exception.ErrorOpeningOrReadingCubeFile", (String[])new String[0]), (Throwable)e);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
                if (dis != null) {
                    dis.close();
                }
            }
            catch (IOException ioe) {
                throw new KettleStepException(BaseMessages.getString(PKG, (String)"CubeInputMeta.Exception.UnableToCloseCubeFile", (String[])new String[0]), (Throwable)ioe);
            }
        }
    }

    public String getXML() {
        StringBuilder retval = new StringBuilder(300);
        retval.append("    <file>").append(Const.CR);
        retval.append("      ").append(XMLHandler.addTagValue((String)"name", (String)this.filename));
        retval.append("    </file>").append(Const.CR);
        retval.append("    ").append(XMLHandler.addTagValue((String)"limit", (String)this.rowLimit));
        retval.append("    ").append(XMLHandler.addTagValue((String)"addfilenameresult", (boolean)this.addfilenameresult));
        return retval.toString();
    }

    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.filename = rep.getStepAttributeString(id_step, "file_name");
            try {
                this.rowLimit = rep.getStepAttributeString(id_step, "limit");
            }
            catch (KettleException readOldAttributeType) {
                this.rowLimit = String.valueOf(rep.getStepAttributeInteger(id_step, "limit"));
            }
            this.addfilenameresult = rep.getStepAttributeBoolean(id_step, "addfilenameresult");
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"CubeInputMeta.Exception.UnexpectedErrorWhileReadingStepInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "file_name", this.filename);
            rep.saveStepAttribute(id_transformation, id_step, "limit", this.rowLimit);
            rep.saveStepAttribute(id_transformation, id_step, "addfilenameresult", this.addfilenameresult);
        }
        catch (KettleException e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"CubeInputMeta.Exception.UnableToSaveStepInfo", (String[])new String[0]) + id_step, (Throwable)e);
        }
    }

    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr = new CheckResult(2, BaseMessages.getString(PKG, (String)"CubeInputMeta.CheckResult.FileSpecificationsNotChecked", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
        remarks.add((CheckResultInterface)cr);
    }

    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new CubeInput(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    public StepDataInterface getStepData() {
        return new CubeInputData();
    }

    public String exportResources(VariableSpace space, Map<String, ResourceDefinition> definitions, ResourceNamingInterface resourceNamingInterface, Repository repository, IMetaStore metaStore) throws KettleException {
        try {
            FileObject fileObject = KettleVFS.getFileObject((String)space.environmentSubstitute(this.filename), (VariableSpace)space);
            if (fileObject.exists()) {
                this.filename = resourceNamingInterface.nameResource(fileObject, space, true);
                return this.filename;
            }
            return null;
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }
}

