/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.autodoc;

import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.annotations.Step;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaBinary;
import org.pentaho.di.core.row.value.ValueMetaSerializable;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.autodoc.AutoDoc;
import org.pentaho.di.trans.steps.autodoc.AutoDocData;
import org.pentaho.di.trans.steps.autodoc.AutoDocOptionsInterface;
import org.pentaho.di.trans.steps.autodoc.KettleReportBuilder;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

@Step(id="AutoDoc", i18nPackageName="org.pentaho.di.trans.steps.autodoc", name="AutoDoc.Name", description="AutoDoc.Description", categoryDescription="i18n:org.pentaho.di.trans.step:BaseStep.Category.Output")
public class AutoDocMeta
extends BaseStepMeta
implements StepMetaInterface,
AutoDocOptionsInterface {
    private static Class<?> PKG = AutoDocMeta.class;
    private String filenameField;
    private String fileTypeField;
    private String targetFilename;
    private KettleReportBuilder.OutputType outputType = KettleReportBuilder.OutputType.PDF;
    private boolean includingName;
    private boolean includingDescription;
    private boolean includingExtendedDescription;
    private boolean includingCreated;
    private boolean includingModified;
    private boolean includingImage;
    private boolean includingLoggingConfiguration;
    private boolean includingLastExecutionResult;
    private boolean includingImageAreaList;

    public boolean isIncludingImageAreaList() {
        return this.includingImageAreaList;
    }

    public void setIncludingImageAreaList(boolean includingImageAreaList) {
        this.includingImageAreaList = includingImageAreaList;
    }

    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode);
    }

    public Object clone() {
        Object retval = super.clone();
        return retval;
    }

    public void setDefault() {
        this.outputType = KettleReportBuilder.OutputType.PDF;
        this.targetFilename = "${Internal.Entry.Current.Directory}/kettle-autodoc.pdf";
        this.includingName = true;
        this.includingDescription = true;
        this.includingExtendedDescription = true;
        this.includingCreated = true;
        this.includingModified = true;
        this.includingImage = true;
        this.includingLoggingConfiguration = true;
        this.includingLastExecutionResult = true;
        this.includingLastExecutionResult = false;
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            this.filenameField = XMLHandler.getTagValue((Node)stepnode, (String)"filename_field");
            this.fileTypeField = XMLHandler.getTagValue((Node)stepnode, (String)"file_type_field");
            this.targetFilename = XMLHandler.getTagValue((Node)stepnode, (String)"target_file");
            this.includingName = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"include_name"));
            this.includingDescription = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"include_description"));
            this.includingExtendedDescription = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"include_extended_description"));
            this.includingCreated = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"include_creation"));
            this.includingModified = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"include_modification"));
            this.includingImage = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"include_image"));
            this.includingLoggingConfiguration = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"include_logging_config"));
            this.includingLastExecutionResult = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"include_last_exec_result"));
            this.includingImageAreaList = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"include_image_area_list"));
            try {
                this.outputType = KettleReportBuilder.OutputType.valueOf(XMLHandler.getTagValue((Node)stepnode, (String)"output_type"));
            }
            catch (Exception e) {
                this.outputType = KettleReportBuilder.OutputType.PDF;
            }
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load step info from XML", (Throwable)e);
        }
    }

    public void allocate() {
    }

    public String getXML() {
        StringBuilder retval = new StringBuilder(500);
        retval.append("    ").append(XMLHandler.addTagValue((String)"filename_field", (String)this.filenameField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"file_type_field", (String)this.fileTypeField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"target_file", (String)this.targetFilename));
        retval.append("    ").append(XMLHandler.addTagValue((String)"output_type", (String)this.outputType.name()));
        retval.append("    ").append(XMLHandler.addTagValue((String)"include_name", (boolean)this.includingName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"include_description", (boolean)this.includingDescription));
        retval.append("    ").append(XMLHandler.addTagValue((String)"include_extended_description", (boolean)this.includingExtendedDescription));
        retval.append("    ").append(XMLHandler.addTagValue((String)"include_creation", (boolean)this.includingCreated));
        retval.append("    ").append(XMLHandler.addTagValue((String)"include_modification", (boolean)this.includingModified));
        retval.append("    ").append(XMLHandler.addTagValue((String)"include_image", (boolean)this.includingImage));
        retval.append("    ").append(XMLHandler.addTagValue((String)"include_logging_config", (boolean)this.includingLoggingConfiguration));
        retval.append("    ").append(XMLHandler.addTagValue((String)"include_last_exec_result", (boolean)this.includingLastExecutionResult));
        retval.append("    ").append(XMLHandler.addTagValue((String)"include_image_area_list", (boolean)this.includingImageAreaList));
        return retval.toString();
    }

    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.filenameField = rep.getStepAttributeString(id_step, "filename_field");
            this.fileTypeField = rep.getStepAttributeString(id_step, "file_type_field");
            this.targetFilename = rep.getStepAttributeString(id_step, "target_file");
            try {
                this.outputType = KettleReportBuilder.OutputType.valueOf(rep.getStepAttributeString(id_step, "output_type"));
            }
            catch (Exception e) {
                this.outputType = KettleReportBuilder.OutputType.PDF;
            }
            this.includingName = rep.getStepAttributeBoolean(id_step, "include_name");
            this.includingDescription = rep.getStepAttributeBoolean(id_step, "include_description");
            this.includingExtendedDescription = rep.getStepAttributeBoolean(id_step, "include_extended_description");
            this.includingCreated = rep.getStepAttributeBoolean(id_step, "include_creation");
            this.includingModified = rep.getStepAttributeBoolean(id_step, "include_modification");
            this.includingImage = rep.getStepAttributeBoolean(id_step, "include_image");
            this.includingLoggingConfiguration = rep.getStepAttributeBoolean(id_step, "include_logging_config");
            this.includingLastExecutionResult = rep.getStepAttributeBoolean(id_step, "include_last_exec_result");
            this.includingImageAreaList = rep.getStepAttributeBoolean(id_step, "include_image_area_list");
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "filename_field", this.filenameField);
            rep.saveStepAttribute(id_transformation, id_step, "file_type_field", this.fileTypeField);
            rep.saveStepAttribute(id_transformation, id_step, "target_file", this.targetFilename);
            rep.saveStepAttribute(id_transformation, id_step, "output_type", this.outputType.name());
            rep.saveStepAttribute(id_transformation, id_step, "include_name", this.includingName);
            rep.saveStepAttribute(id_transformation, id_step, "include_description", this.includingDescription);
            rep.saveStepAttribute(id_transformation, id_step, "include_extended_description", this.includingExtendedDescription);
            rep.saveStepAttribute(id_transformation, id_step, "include_creation", this.includingCreated);
            rep.saveStepAttribute(id_transformation, id_step, "include_modification", this.includingModified);
            rep.saveStepAttribute(id_transformation, id_step, "include_image", this.includingImage);
            rep.saveStepAttribute(id_transformation, id_step, "include_logging_config", this.includingLoggingConfiguration);
            rep.saveStepAttribute(id_transformation, id_step, "include_last_exec_result", this.includingLastExecutionResult);
            rep.saveStepAttribute(id_transformation, id_step, "include_image_area_list", this.includingImageAreaList);
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step information to the repository for id_step=" + id_step, (Throwable)e);
        }
    }

    public void getFields(RowMetaInterface rowMeta, String origin, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        if (this.outputType == KettleReportBuilder.OutputType.METADATA) {
            ValueMetaSerializable valueMeta = new ValueMetaSerializable("meta");
            valueMeta.setOrigin(origin);
            rowMeta.addValueMeta((ValueMetaInterface)valueMeta);
            if (this.includingName) {
                valueMeta = new ValueMetaString("name");
                valueMeta.setOrigin(origin);
                rowMeta.addValueMeta((ValueMetaInterface)valueMeta);
            }
            if (this.includingDescription) {
                valueMeta = new ValueMetaString("description");
                valueMeta.setOrigin(origin);
                rowMeta.addValueMeta((ValueMetaInterface)valueMeta);
            }
            if (this.includingExtendedDescription) {
                valueMeta = new ValueMetaString("extended_description");
                valueMeta.setOrigin(origin);
                rowMeta.addValueMeta((ValueMetaInterface)valueMeta);
            }
            if (this.includingCreated) {
                valueMeta = new ValueMetaString("created");
                valueMeta.setOrigin(origin);
                rowMeta.addValueMeta((ValueMetaInterface)valueMeta);
            }
            if (this.includingModified) {
                valueMeta = new ValueMetaString("modified");
                valueMeta.setOrigin(origin);
                rowMeta.addValueMeta((ValueMetaInterface)valueMeta);
            }
            if (this.includingImage) {
                valueMeta = new ValueMetaBinary("image");
                valueMeta.setOrigin(origin);
                rowMeta.addValueMeta((ValueMetaInterface)valueMeta);
            }
            if (this.includingLoggingConfiguration) {
                valueMeta = new ValueMetaString("logging");
                valueMeta.setOrigin(origin);
                rowMeta.addValueMeta((ValueMetaInterface)valueMeta);
            }
            if (this.includingLastExecutionResult) {
                valueMeta = new ValueMetaString("last_result");
                valueMeta.setOrigin(origin);
                rowMeta.addValueMeta((ValueMetaInterface)valueMeta);
            }
            if (this.includingImageAreaList) {
                valueMeta = new ValueMetaSerializable("area");
                valueMeta.setOrigin(origin);
                rowMeta.addValueMeta((ValueMetaInterface)valueMeta);
            }
        } else {
            rowMeta.clear();
            ValueMetaString valueMeta = new ValueMetaString("filename");
            valueMeta.setOrigin(origin);
            rowMeta.addValueMeta((ValueMetaInterface)valueMeta);
        }
    }

    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepinfo, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr;
        if (prev == null || prev.size() == 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"AutoDocMeta.CheckResult.NotReceivingFields", (String[])new String[0]), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"AutoDocMeta.CheckResult.StepRecevingData", (String[])new String[]{prev.size() + ""}), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"AutoDocMeta.CheckResult.StepRecevingData2", (String[])new String[0]), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"AutoDocMeta.CheckResult.NoInputReceivedFromOtherSteps", (String[])new String[0]), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        }
    }

    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new AutoDoc(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    public StepDataInterface getStepData() {
        return new AutoDocData();
    }

    public String getFilenameField() {
        return this.filenameField;
    }

    public void setFilenameField(String filenameField) {
        this.filenameField = filenameField;
    }

    public String getTargetFilename() {
        return this.targetFilename;
    }

    public void setTargetFilename(String targetFilename) {
        this.targetFilename = targetFilename;
    }

    @Override
    public KettleReportBuilder.OutputType getOutputType() {
        return this.outputType;
    }

    public void setOutputType(KettleReportBuilder.OutputType outputType) {
        this.outputType = outputType;
    }

    @Override
    public boolean isIncludingDescription() {
        return this.includingDescription;
    }

    public void setIncludingDescription(boolean includingDescription) {
        this.includingDescription = includingDescription;
    }

    @Override
    public boolean isIncludingCreated() {
        return this.includingCreated;
    }

    public void setIncludingCreated(boolean includingCreated) {
        this.includingCreated = includingCreated;
    }

    @Override
    public boolean isIncludingModified() {
        return this.includingModified;
    }

    public void setIncludingModified(boolean includingModified) {
        this.includingModified = includingModified;
    }

    @Override
    public boolean isIncludingImage() {
        return this.includingImage;
    }

    public void setIncludingImage(boolean includingImage) {
        this.includingImage = includingImage;
    }

    @Override
    public boolean isIncludingLoggingConfiguration() {
        return this.includingLoggingConfiguration;
    }

    public void setIncludingLoggingConfiguration(boolean includingLoggingConfiguration) {
        this.includingLoggingConfiguration = includingLoggingConfiguration;
    }

    @Override
    public boolean isIncludingLastExecutionResult() {
        return this.includingLastExecutionResult;
    }

    public void setIncludingLastExecutionResult(boolean includingLastExecutionResult) {
        this.includingLastExecutionResult = includingLastExecutionResult;
    }

    @Override
    public boolean isIncludingExtendedDescription() {
        return this.includingExtendedDescription;
    }

    public void setIncludingExtendedDescription(boolean includingExtendedDescription) {
        this.includingExtendedDescription = includingExtendedDescription;
    }

    @Override
    public boolean isIncludingName() {
        return this.includingName;
    }

    public void setIncludingName(boolean includingName) {
        this.includingName = includingName;
    }

    public String getFileTypeField() {
        return this.fileTypeField;
    }

    public void setFileTypeField(String fileTypeField) {
        this.fileTypeField = fileTypeField;
    }
}

