/*
 * Decompiled with CFR 0.152.
 */
package mondrian.web.servlet;

import java.io.IOException;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import mondrian.olap.Cell;
import mondrian.olap.Connection;
import mondrian.olap.DriverManager;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Position;
import mondrian.olap.Query;
import mondrian.olap.Result;
import mondrian.olap.Util;
import mondrian.spi.CatalogLocator;
import mondrian.spi.impl.ServletContextCatalogLocator;
import mondrian.web.taglib.ResultCache;

public class MdxQueryServlet
extends HttpServlet {
    private String connectString;
    private CatalogLocator locator;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.connectString = config.getInitParameter("connectString");
        Enumeration initParameterNames = config.getInitParameterNames();
        while (initParameterNames.hasMoreElements()) {
            String name = (String)initParameterNames.nextElement();
            String value = config.getInitParameter(name);
            MondrianProperties.instance().setProperty(name, value);
        }
        this.locator = new ServletContextCatalogLocator(config.getServletContext());
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String queryName = request.getParameter("query");
        request.setAttribute("query", (Object)queryName);
        if (queryName != null) {
            this.processTransform(request, response);
            return;
        }
        String queryString = request.getParameter("queryString");
        request.setAttribute("queryString", (Object)queryString);
        StringBuilder html = new StringBuilder();
        try (Connection mdxConnection = null;){
            int i;
            mdxConnection = DriverManager.getConnection(this.connectString, this.locator);
            Query q = mdxConnection.parseQuery(queryString);
            Result result = mdxConnection.execute(q);
            List<Position> slicers = result.getSlicerAxis().getPositions();
            html.append("<table class='resulttable' cellspacing=1 border=0>");
            html.append(Util.nl);
            List<Position> columns = result.getAxes()[0].getPositions();
            List<Position> rows = null;
            if (result.getAxes().length == 2) {
                rows = result.getAxes()[1].getPositions();
            }
            int columnWidth = columns.get(0).size();
            int rowWidth = 0;
            if (result.getAxes().length == 2) {
                rowWidth = result.getAxes()[1].getPositions().get(0).size();
            }
            for (int j = 0; j < columnWidth; ++j) {
                html.append("<tr>");
                if (j == 0 && result.getAxes().length > 1) {
                    html.append("<td nowrap class='slicer' rowspan='").append(columnWidth).append("' colspan='").append(rowWidth).append("'>");
                    for (Position position : slicers) {
                        int k = 0;
                        for (Member member : position) {
                            if (k > 0) {
                                html.append("<br/>");
                            }
                            html.append(member.getUniqueName());
                            ++k;
                        }
                    }
                    html.append("&nbsp;</td>").append(Util.nl);
                }
                for (int i2 = 0; i2 < columns.size(); ++i2) {
                    Position position;
                    position = columns.get(i2);
                    Member member = (Member)position.get(j);
                    int width = 1;
                    while (i2 + 1 < columns.size() && columns.get(i2 + 1).get(j) == member) {
                        ++i2;
                        ++width;
                    }
                    html.append("<td nowrap class='columnheading' colspan='").append(width).append("'>").append(member.getUniqueName()).append("</td>");
                }
                html.append("</tr>").append(Util.nl);
            }
            if (result.getAxes().length > 1) {
                for (i = 0; i < rows.size(); ++i) {
                    html.append("<tr>");
                    Position row = rows.get(i);
                    for (Member member : row) {
                        html.append("<td nowrap class='rowheading'>").append(member.getUniqueName()).append("</td>");
                    }
                    int j = 0;
                    while (j < columns.size()) {
                        this.showCell(html, result.getCell(new int[]{j++, i}));
                    }
                    html.append("</tr>");
                }
            } else {
                html.append("<tr>");
                i = 0;
                while (i < columns.size()) {
                    this.showCell(html, result.getCell(new int[]{i++}));
                }
                html.append("</tr>");
            }
            html.append("</table>");
        }
        request.setAttribute("result", (Object)html.toString());
        response.setHeader("Content-Type", "text/html");
        this.getServletContext().getRequestDispatcher("/adhoc.jsp").include((ServletRequest)request, (ServletResponse)response);
    }

    private void showCell(StringBuilder out, Cell cell) {
        out.append("<td class='cell'>").append(cell.getFormattedValue()).append("</td>");
    }

    private void processTransform(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String queryName = request.getParameter("query");
        ResultCache rc = ResultCache.getInstance(request.getSession(), this.getServletContext(), queryName);
        Query query = rc.getQuery();
        query = query.clone();
        rc.setDirty();
        String operation = request.getParameter("operation");
        if (operation.equals("expand")) {
            String memberName = request.getParameter("member");
            boolean fail = true;
            Member member = query.getSchemaReader(true).getMemberByUniqueName(Util.parseIdentifier(memberName), fail);
            throw new UnsupportedOperationException("query.toggleDrillState(member) has been de-supported");
        }
        throw Util.newInternal("unkown operation '" + operation + "'");
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "Process an MDX query and return the result formatted as an HTML table";
    }
}

