/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import mondrian.mdx.DimensionExpr;
import mondrian.mdx.HierarchyExpr;
import mondrian.mdx.LevelExpr;
import mondrian.mdx.MemberExpr;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.ExpCacheDescriptor;
import mondrian.olap.FunCall;
import mondrian.olap.Literal;
import mondrian.olap.Member;
import mondrian.olap.MondrianDef;
import mondrian.olap.fun.MondrianEvaluationException;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.StringType;
import mondrian.rolap.RolapAggregator;
import mondrian.rolap.RolapCalculatedMember;
import mondrian.rolap.RolapCubeDimension;
import mondrian.rolap.RolapCubeHierarchy;
import mondrian.rolap.RolapCubeLevel;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapStar;
import mondrian.rolap.RolapStoredMeasure;
import mondrian.rolap.aggmatcher.AggStar;
import mondrian.rolap.sql.SqlQuery;
import mondrian.spi.Dialect;

public class RolapNativeSql {
    private static final Pattern DECIMAL = Pattern.compile("[+-]?((\\d+(\\.\\d*)?)|(\\.\\d+))");
    private SqlQuery sqlQuery;
    private Dialect dialect;
    CompositeSqlCompiler numericCompiler;
    CompositeSqlCompiler booleanCompiler;
    RolapStoredMeasure storedMeasure;
    final AggStar aggStar;
    final Evaluator evaluator;
    final RolapLevel rolapLevel;

    private boolean saveStoredMeasure(RolapStoredMeasure m) {
        RolapStar star2;
        RolapStar star1;
        if (this.aggStar != null && !this.storedMeasureIsPresentOnAggStar(m)) {
            return false;
        }
        if (this.storedMeasure != null && (star1 = this.getStar(this.storedMeasure)) != (star2 = this.getStar(m))) {
            return false;
        }
        this.storedMeasure = m;
        return true;
    }

    private boolean storedMeasureIsPresentOnAggStar(RolapStoredMeasure m) {
        RolapStar.Column column = (RolapStar.Column)m.getStarMeasure();
        int bitPos = column.getBitPosition();
        return this.aggStar.lookupColumn(bitPos) != null;
    }

    private RolapStar getStar(RolapStoredMeasure m) {
        return ((RolapStar.Measure)m.getStarMeasure()).getStar();
    }

    public RolapNativeSql(SqlQuery sqlQuery, AggStar aggStar, Evaluator evaluator, RolapLevel rolapLevel) {
        this.sqlQuery = sqlQuery;
        this.rolapLevel = rolapLevel;
        this.evaluator = evaluator;
        this.dialect = sqlQuery.getDialect();
        this.aggStar = aggStar;
        this.numericCompiler = new CompositeSqlCompiler();
        this.booleanCompiler = new CompositeSqlCompiler();
        this.numericCompiler.add(new NumberSqlCompiler());
        this.numericCompiler.add(new StoredMeasureSqlCompiler());
        this.numericCompiler.add(new CalculatedMemberSqlCompiler(this.numericCompiler));
        this.numericCompiler.add(new ParenthesisSqlCompiler(7, this.numericCompiler));
        this.numericCompiler.add(new InfixOpSqlCompiler(7, "+", "+", this.numericCompiler));
        this.numericCompiler.add(new InfixOpSqlCompiler(7, "-", "-", this.numericCompiler));
        this.numericCompiler.add(new InfixOpSqlCompiler(7, "/", "/", this.numericCompiler));
        this.numericCompiler.add(new InfixOpSqlCompiler(7, "*", "*", this.numericCompiler));
        this.numericCompiler.add(new IifSqlCompiler(7, this.numericCompiler));
        this.booleanCompiler.add(new InfixOpSqlCompiler(5, "<", "<", this.numericCompiler));
        this.booleanCompiler.add(new InfixOpSqlCompiler(5, "<=", "<=", this.numericCompiler));
        this.booleanCompiler.add(new InfixOpSqlCompiler(5, ">", ">", this.numericCompiler));
        this.booleanCompiler.add(new InfixOpSqlCompiler(5, ">=", ">=", this.numericCompiler));
        this.booleanCompiler.add(new InfixOpSqlCompiler(5, "=", "=", this.numericCompiler));
        this.booleanCompiler.add(new InfixOpSqlCompiler(5, "<>", "<>", this.numericCompiler));
        this.booleanCompiler.add(new IsEmptySqlCompiler(5, "IsEmpty", this.numericCompiler));
        this.booleanCompiler.add(new InfixOpSqlCompiler(5, "and", "AND", this.booleanCompiler));
        this.booleanCompiler.add(new InfixOpSqlCompiler(5, "or", "OR", this.booleanCompiler));
        this.booleanCompiler.add(new UnaryOpSqlCompiler(5, "not", "NOT", this.booleanCompiler));
        this.booleanCompiler.add(new MatchingSqlCompiler());
        this.booleanCompiler.add(new ParenthesisSqlCompiler(5, this.booleanCompiler));
        this.booleanCompiler.add(new IifSqlCompiler(5, this.booleanCompiler));
    }

    public String generateTopCountOrderBy(Exp exp) {
        return this.numericCompiler.compile(exp);
    }

    public String generateFilterCondition(Exp exp) {
        return this.booleanCompiler.compile(exp);
    }

    public RolapStoredMeasure getStoredMeasure() {
        return this.storedMeasure;
    }

    class IifSqlCompiler
    extends FunCallSqlCompilerBase {
        SqlCompiler valueCompiler;

        IifSqlCompiler(int category, SqlCompiler valueCompiler) {
            super(category, "iif", 3);
            this.valueCompiler = valueCompiler;
        }

        @Override
        public String compile(Exp exp) {
            if (!this.match(exp)) {
                return null;
            }
            Exp[] args = ((FunCall)exp).getArgs();
            String cond = RolapNativeSql.this.booleanCompiler.compile(args[0]);
            String val1 = this.valueCompiler.compile(args[1]);
            String val2 = this.valueCompiler.compile(args[2]);
            if (cond == null || val1 == null || val2 == null) {
                return null;
            }
            return RolapNativeSql.this.sqlQuery.getDialect().caseWhenElse(cond, val1, val2);
        }
    }

    class IsEmptySqlCompiler
    extends FunCallSqlCompilerBase {
        private final SqlCompiler compiler;

        protected IsEmptySqlCompiler(int category, String mdx, SqlCompiler argumentCompiler) {
            super(category, mdx, 1);
            this.compiler = argumentCompiler;
        }

        @Override
        public String compile(Exp exp) {
            String[] args = this.compileArgs(exp, this.compiler);
            if (args == null) {
                return null;
            }
            return "(" + args[0] + " is null)";
        }

        public String toString() {
            return "IsEmptySqlCompiler[" + this.mdx + "]";
        }
    }

    class InfixOpSqlCompiler
    extends FunCallSqlCompilerBase {
        private final String sql;
        private final SqlCompiler compiler;

        protected InfixOpSqlCompiler(int category, String mdx, String sql, SqlCompiler argumentCompiler) {
            super(category, mdx, 2);
            this.sql = sql;
            this.compiler = argumentCompiler;
        }

        @Override
        public String compile(Exp exp) {
            String[] args = this.compileArgs(exp, this.compiler);
            if (args == null) {
                return null;
            }
            return "(" + args[0] + " " + this.sql + " " + args[1] + ")";
        }

        public String toString() {
            return "InfixSqlCompiler[" + this.mdx + "]";
        }
    }

    class ParenthesisSqlCompiler
    extends FunCallSqlCompiler {
        protected ParenthesisSqlCompiler(int category, SqlCompiler argumentCompiler) {
            super(category, "()", "", 1, argumentCompiler);
        }

        @Override
        public String toString() {
            return "ParenthesisSqlCompiler";
        }
    }

    class UnaryOpSqlCompiler
    extends FunCallSqlCompiler {
        protected UnaryOpSqlCompiler(int category, String mdx, String sql, SqlCompiler argumentCompiler) {
            super(category, mdx, sql, 1, argumentCompiler);
        }
    }

    class FunCallSqlCompiler
    extends FunCallSqlCompilerBase {
        SqlCompiler compiler;
        String sql;

        protected FunCallSqlCompiler(int category, String mdx, String sql, int argCount, SqlCompiler argumentCompiler) {
            super(category, mdx, argCount);
            this.sql = sql;
            this.compiler = argumentCompiler;
        }

        @Override
        public String compile(Exp exp) {
            String[] args = this.compileArgs(exp, this.compiler);
            if (args == null) {
                return null;
            }
            StringBuilder buf = new StringBuilder();
            buf.append(this.sql);
            buf.append("(");
            for (int i = 0; i < args.length; ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append(args[i]);
            }
            buf.append(") ");
            return buf.toString();
        }

        public String toString() {
            return "FunCallSqlCompiler[" + this.mdx + "]";
        }
    }

    abstract class FunCallSqlCompilerBase
    implements SqlCompiler {
        int category;
        String mdx;
        int argCount;

        FunCallSqlCompilerBase(int category, String mdx, int argCount) {
            this.category = category;
            this.mdx = mdx;
            this.argCount = argCount;
        }

        protected boolean match(Exp exp) {
            if ((exp.getCategory() & this.category) == 0) {
                return false;
            }
            if (!(exp instanceof FunCall)) {
                return false;
            }
            FunCall fc = (FunCall)exp;
            if (!this.mdx.equalsIgnoreCase(fc.getFunName())) {
                return false;
            }
            Exp[] args = fc.getArgs();
            return args.length == this.argCount;
        }

        protected String[] compileArgs(Exp exp, SqlCompiler compiler) {
            if (!this.match(exp)) {
                return null;
            }
            Exp[] args = ((FunCall)exp).getArgs();
            String[] sqls = new String[args.length];
            for (int i = 0; i < args.length; ++i) {
                sqls[i] = compiler.compile(args[i]);
                if (sqls[i] != null) continue;
                return null;
            }
            return sqls;
        }
    }

    class CalculatedMemberSqlCompiler
    extends MemberSqlCompiler {
        SqlCompiler compiler;

        CalculatedMemberSqlCompiler(SqlCompiler argumentCompiler) {
            this.compiler = argumentCompiler;
        }

        @Override
        public String compile(Exp exp) {
            if (!((exp = this.unwind(exp)) instanceof MemberExpr)) {
                return null;
            }
            Member member = ((MemberExpr)exp).getMember();
            if (!(member instanceof RolapCalculatedMember)) {
                return null;
            }
            exp = member.getExpression();
            if (exp == null) {
                return null;
            }
            return this.compiler.compile(exp);
        }

        public String toString() {
            return "CalculatedMemberSqlCompiler";
        }
    }

    class MatchingSqlCompiler
    extends FunCallSqlCompilerBase {
        protected MatchingSqlCompiler() {
            super(5, "MATCHES", 2);
        }

        @Override
        public String compile(Exp exp) {
            RolapCubeDimension dimension;
            if (!this.match(exp)) {
                return null;
            }
            if (!RolapNativeSql.this.dialect.allowsRegularExpressionInWhereClause() || !(exp instanceof ResolvedFunCall) || RolapNativeSql.this.evaluator == null) {
                return null;
            }
            Exp arg0 = ((ResolvedFunCall)exp).getArg(0);
            Exp arg1 = ((ResolvedFunCall)exp).getArg(1);
            if (!(arg0 instanceof ResolvedFunCall) || ((ResolvedFunCall)arg0).getArgCount() != 1 || !(arg0.getType() instanceof StringType) || !((ResolvedFunCall)arg0).getFunName().equals("Name") && !((ResolvedFunCall)arg0).getFunName().equals("Caption")) {
                return null;
            }
            boolean useCaption = !((ResolvedFunCall)arg0).getFunName().equals("Name");
            Exp currMemberExpr = ((ResolvedFunCall)arg0).getArg(0);
            if (!(currMemberExpr instanceof ResolvedFunCall && ((ResolvedFunCall)currMemberExpr).getArgCount() == 1 && currMemberExpr.getType() instanceof MemberType && ((ResolvedFunCall)currMemberExpr).getFunName().equals("CurrentMember"))) {
                return null;
            }
            Exp dimExpr = ((ResolvedFunCall)currMemberExpr).getArg(0);
            if (dimExpr instanceof DimensionExpr) {
                dimension = (RolapCubeDimension)RolapNativeSql.this.evaluator.getCachedResult(new ExpCacheDescriptor(dimExpr, RolapNativeSql.this.evaluator));
            } else if (dimExpr instanceof HierarchyExpr) {
                RolapCubeHierarchy hierarchy = (RolapCubeHierarchy)RolapNativeSql.this.evaluator.getCachedResult(new ExpCacheDescriptor(dimExpr, RolapNativeSql.this.evaluator));
                dimension = (RolapCubeDimension)hierarchy.getDimension();
            } else if (dimExpr instanceof LevelExpr) {
                RolapCubeLevel level = (RolapCubeLevel)RolapNativeSql.this.evaluator.getCachedResult(new ExpCacheDescriptor(dimExpr, RolapNativeSql.this.evaluator));
                dimension = level.getDimension();
            } else {
                return null;
            }
            if (RolapNativeSql.this.rolapLevel != null && dimension.equals(RolapNativeSql.this.rolapLevel.getDimension())) {
                String sourceExp;
                MondrianDef.Expression expression;
                MondrianDef.Expression expression2 = useCaption ? (RolapNativeSql.this.rolapLevel.captionExp == null ? (RolapNativeSql.this.rolapLevel.nameExp == null ? RolapNativeSql.this.rolapLevel.keyExp : RolapNativeSql.this.rolapLevel.nameExp) : RolapNativeSql.this.rolapLevel.captionExp) : (expression = RolapNativeSql.this.rolapLevel.nameExp == null ? RolapNativeSql.this.rolapLevel.keyExp : RolapNativeSql.this.rolapLevel.nameExp);
                if (RolapNativeSql.this.aggStar != null && RolapNativeSql.this.rolapLevel instanceof RolapCubeLevel && expression == RolapNativeSql.this.rolapLevel.keyExp) {
                    int bitPos = ((RolapCubeLevel)RolapNativeSql.this.rolapLevel).getStarKeyColumn().getBitPosition();
                    AggStar.Table.Column col = RolapNativeSql.this.aggStar.lookupColumn(bitPos);
                    if (col != null) {
                        sourceExp = col.generateExprString(RolapNativeSql.this.sqlQuery);
                    } else {
                        RolapNativeSql.this.rolapLevel.getHierarchy().addToFrom(RolapNativeSql.this.sqlQuery, expression);
                        sourceExp = expression.getExpression(RolapNativeSql.this.sqlQuery);
                    }
                } else if (RolapNativeSql.this.aggStar != null) {
                    RolapNativeSql.this.rolapLevel.getHierarchy().addToFrom(RolapNativeSql.this.sqlQuery, expression);
                    sourceExp = expression.getExpression(RolapNativeSql.this.sqlQuery);
                } else {
                    sourceExp = expression.getExpression(RolapNativeSql.this.sqlQuery);
                }
                if (RolapNativeSql.this.dialect.requiresHavingAlias()) {
                    sourceExp = RolapNativeSql.this.sqlQuery.getAlias(sourceExp);
                }
                return RolapNativeSql.this.dialect.generateRegularExpression(sourceExp, String.valueOf(RolapNativeSql.this.evaluator.getCachedResult(new ExpCacheDescriptor(arg1, RolapNativeSql.this.evaluator))));
            }
            return null;
        }

        public String toString() {
            return "MatchingSqlCompiler";
        }
    }

    class StoredMeasureSqlCompiler
    extends MemberSqlCompiler {
        StoredMeasureSqlCompiler() {
        }

        @Override
        public String compile(Exp exp) {
            String exprInner;
            if (!((exp = this.unwind(exp)) instanceof MemberExpr)) {
                return null;
            }
            Member member = ((MemberExpr)exp).getMember();
            if (!(member instanceof RolapStoredMeasure)) {
                return null;
            }
            RolapStoredMeasure measure = (RolapStoredMeasure)member;
            if (measure.isCalculated()) {
                return null;
            }
            if (!RolapNativeSql.this.saveStoredMeasure(measure)) {
                return null;
            }
            RolapAggregator aggregator = measure.getAggregator();
            if (RolapNativeSql.this.aggStar != null && measure.getStarMeasure() instanceof RolapStar.Column) {
                RolapStar.Column column = (RolapStar.Column)measure.getStarMeasure();
                int bitPos = column.getBitPosition();
                AggStar.Table.Column aggColumn = RolapNativeSql.this.aggStar.lookupColumn(bitPos);
                exprInner = aggColumn.generateExprString(RolapNativeSql.this.sqlQuery);
                if (aggColumn instanceof AggStar.FactTable.Measure) {
                    RolapAggregator aggTableAggregator = ((AggStar.FactTable.Measure)aggColumn).getAggregator();
                    aggregator = (RolapAggregator)aggTableAggregator.getRollup();
                }
            } else {
                MondrianDef.Expression defExp = measure.getMondrianDefExpression();
                exprInner = defExp == null ? "*" : defExp.getExpression(RolapNativeSql.this.sqlQuery);
            }
            String expr = aggregator.getExpression(exprInner);
            if (RolapNativeSql.this.dialect.getDatabaseProduct().getFamily() == Dialect.DatabaseProduct.DB2) {
                expr = "FLOAT(" + expr + ")";
            }
            return expr;
        }

        public String toString() {
            return "StoredMeasureSqlCompiler";
        }
    }

    abstract class MemberSqlCompiler
    implements SqlCompiler {
        MemberSqlCompiler() {
        }

        protected Exp unwind(Exp exp) {
            return exp;
        }
    }

    class NumberSqlCompiler
    implements SqlCompiler {
        NumberSqlCompiler() {
        }

        @Override
        public String compile(Exp exp) {
            if (!(exp instanceof Literal)) {
                return null;
            }
            if ((exp.getCategory() & 7) == 0) {
                return null;
            }
            Literal literal = (Literal)exp;
            String expr = String.valueOf(literal.getValue());
            if (!DECIMAL.matcher(expr).matches()) {
                throw new MondrianEvaluationException("Expected to get decimal, but got " + expr);
            }
            if (RolapNativeSql.this.dialect.getDatabaseProduct().getFamily() == Dialect.DatabaseProduct.DB2) {
                expr = "FLOAT(" + expr + ")";
            }
            return expr;
        }

        public String toString() {
            return "NumberSqlCompiler";
        }
    }

    static class CompositeSqlCompiler
    implements SqlCompiler {
        List<SqlCompiler> compilers = new ArrayList<SqlCompiler>();

        CompositeSqlCompiler() {
        }

        public void add(SqlCompiler compiler) {
            this.compilers.add(compiler);
        }

        @Override
        public String compile(Exp exp) {
            for (SqlCompiler compiler : this.compilers) {
                String s = compiler.compile(exp);
                if (s == null) continue;
                return s;
            }
            return null;
        }

        public String toString() {
            return this.compilers.toString();
        }
    }

    static interface SqlCompiler {
        public String compile(Exp var1);
    }
}

