/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mondrian.calc.Calc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Annotation;
import mondrian.olap.Dimension;
import mondrian.olap.DimensionType;
import mondrian.olap.Exp;
import mondrian.olap.Hierarchy;
import mondrian.olap.Id;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.MemberBase;
import mondrian.olap.MondrianProperties;
import mondrian.olap.OlapElement;
import mondrian.olap.Property;
import mondrian.olap.Schema;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.olap.fun.AggregateFunDef;
import mondrian.olap.fun.VisualTotalsFunDef;
import mondrian.rolap.HierarchyUsage;
import mondrian.rolap.RolapCalculatedMember;
import mondrian.rolap.RolapCubeLevel;
import mondrian.rolap.RolapCubeMember;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapEvaluatorRoot;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMeasure;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapProperty;
import mondrian.rolap.RolapSchema;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.ScenarioImpl;
import mondrian.server.Locus;
import mondrian.spi.PropertyFormatter;
import mondrian.util.CreationException;
import mondrian.util.ObjectFactory;
import org.apache.commons.collections.map.Flat3Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eigenbase.util.property.StringProperty;

public class RolapMemberBase
extends MemberBase
implements RolapMember {
    private Comparable orderKey;
    private Boolean isParentChildLeaf;
    private static final Logger LOGGER = LogManager.getLogger(RolapMember.class);
    private int ordinal;
    private final Object key;
    private Map<String, Object> mapPropertyNameToValue;
    private Boolean containsAggregateFunction = null;
    private Object captionValue;

    void setParentMember(RolapMember parentMember) {
        RolapMember previousParentMember = this.getParentMember();
        if (previousParentMember.getLevel() != parentMember.getLevel()) {
            throw new IllegalArgumentException("new parent belongs to different level than old");
        }
        this.parentMember = parentMember;
    }

    protected RolapMemberBase(RolapMember parentMember, RolapLevel level, Object key, String name, Member.MemberType memberType) {
        super(parentMember, level, memberType);
        assert (key != null);
        assert (!(parentMember instanceof RolapCubeMember) || this instanceof RolapCalculatedMember || this instanceof VisualTotalsFunDef.VisualTotalMember);
        this.key = key instanceof byte[] ? new String((byte[])key) : key;
        this.ordinal = -1;
        this.mapPropertyNameToValue = Collections.emptyMap();
        if (!(name == null || key != null && name.equals(key.toString()))) {
            this.setProperty(Property.NAME.name, name);
        } else if (key != null) {
            this.setUniqueName(key);
        }
    }

    protected RolapMemberBase() {
        this.key = RolapUtil.sqlNullValue;
    }

    RolapMemberBase(RolapMember parentMember, RolapLevel level, Object value) {
        this(parentMember, level, value, null, Member.MemberType.REGULAR);
        assert (!(level instanceof RolapCubeLevel));
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    @Override
    public RolapLevel getLevel() {
        return (RolapLevel)this.level;
    }

    @Override
    public RolapHierarchy getHierarchy() {
        return (RolapHierarchy)this.level.getHierarchy();
    }

    @Override
    public RolapMember getParentMember() {
        return (RolapMember)super.getParentMember();
    }

    public Object getCaptionValue() {
        if (this.captionValue != null) {
            return this.captionValue;
        }
        Object name = this.getPropertyValue(Property.NAME.name);
        return name != null ? name : this.key;
    }

    public void setCaptionValue(Object captionValue) {
        this.captionValue = captionValue;
    }

    @Override
    public Map<String, Annotation> getAnnotationMap() {
        return Collections.emptyMap();
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof RolapMemberBase && this.equals((RolapMemberBase)o)) {
            return true;
        }
        return o instanceof RolapCubeMember && this.equals(((RolapCubeMember)o).getRolapMember());
    }

    @Override
    public boolean equals(OlapElement o) {
        return o instanceof RolapMemberBase && this.equals((RolapMemberBase)o);
    }

    private boolean equals(RolapMemberBase that) {
        assert (that != null);
        return this.getUniqueName().equals(that.getUniqueName());
    }

    void makeUniqueName(HierarchyUsage hierarchyUsage) {
        String n;
        if (this.parentMember == null && this.key != null && (n = hierarchyUsage.getName()) != null) {
            String name = RolapMemberBase.keyToString(this.key);
            n = Util.quoteMdxIdentifier(n);
            this.uniqueName = Util.makeFqName(n, name);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("RolapMember.makeUniqueName: uniqueName=" + this.uniqueName);
            }
        }
    }

    protected void setUniqueName(Object key) {
        String name = RolapMemberBase.keyToString(key);
        if (this.parentMember == null || this.parentMember.isAll() && (!this.isCalculated() || this instanceof VisualTotalsFunDef.VisualTotalMember || this.getDataMember() != null)) {
            RolapHierarchy hierarchy = this.getHierarchy();
            Dimension dimension = hierarchy.getDimension();
            RolapLevel level = this.getLevel();
            this.uniqueName = dimension.getDimensionType() != null && dimension.getDimensionType().equals((Object)DimensionType.MeasuresDimension) && hierarchy.getName().equals(dimension.getName()) ? Util.makeFqName(dimension, name) : (name.equals(level.getName()) ? Util.makeFqName(Util.makeFqName(hierarchy.getUniqueName(), level.getName()), name) : Util.makeFqName(hierarchy, name));
        } else {
            this.uniqueName = Util.makeFqName(this.parentMember, name);
        }
    }

    @Override
    public boolean isCalculatedInQuery() {
        return false;
    }

    @Override
    public String getName() {
        Object name = this.getPropertyValue(Property.NAME.name);
        return name != null ? String.valueOf(name) : RolapMemberBase.keyToString(this.key);
    }

    @Override
    public void setName(String name) {
        throw new Error("unsupported");
    }

    @Override
    public synchronized void setProperty(String name, Object value) {
        if (name.equals(Property.CAPTION.name)) {
            this.setCaption((String)value);
            return;
        }
        if (this.mapPropertyNameToValue.isEmpty()) {
            PropertyValueMapFactory factory = PropertyValueMapFactoryFactory.getPropertyValueMapFactory();
            this.mapPropertyNameToValue = factory.create(this);
        }
        if (name.equals(Property.NAME.name)) {
            if (value == null) {
                value = RolapUtil.mdxNullLiteral();
            }
            this.setUniqueName(value);
        }
        if (name.equals(Property.MEMBER_ORDINAL.name)) {
            String ordinal = (String)value;
            if (ordinal.startsWith("\"") && ordinal.endsWith("\"")) {
                ordinal = ordinal.substring(1, ordinal.length() - 1);
            }
            double d = Double.parseDouble(ordinal);
            this.setOrdinal((int)d);
        }
        this.mapPropertyNameToValue.put(name, value);
    }

    @Override
    public Object getPropertyValue(String propertyName) {
        return this.getPropertyValue(propertyName, true);
    }

    @Override
    public Object getPropertyValue(String propertyName, boolean matchCase) {
        Property property = Property.lookup(propertyName, matchCase);
        if (property != null) {
            switch (property.ordinal) {
                case 2: {
                    break;
                }
                case 3: {
                    return this.getCaption();
                }
                case 4: {
                    ArrayList<RolapMember> list = new ArrayList<RolapMember>();
                    this.getHierarchy().getMemberReader().getMemberChildren(this, list);
                    return list;
                }
                case 10: {
                    break;
                }
                case 11: {
                    Schema schema = this.getHierarchy().getDimension().getSchema();
                    return schema.getName();
                }
                case 12: {
                    break;
                }
                case 13: {
                    return this.getHierarchy().getDimension().getUniqueName();
                }
                case 14: {
                    return this.getHierarchy().getUniqueName();
                }
                case 15: {
                    return this.getLevel().getUniqueName();
                }
                case 16: {
                    return this.getLevel().getDepth();
                }
                case 19: {
                    return this.getUniqueName();
                }
                case 18: {
                    return this.getName();
                }
                case 20: {
                    return this.getMemberType().ordinal();
                }
                case 21: {
                    return null;
                }
                case 22: {
                    return this.getCaption();
                }
                case 17: {
                    return this.getOrdinal();
                }
                case 23: {
                    return Locus.execute(((RolapSchema)this.level.getDimension().getSchema()).getInternalConnection(), "Member.CHILDREN_CARDINALITY", new Locus.Action<Integer>(){

                        @Override
                        public Integer execute() {
                            if (RolapMemberBase.this.isAll() && RolapMemberBase.this.childLevelHasApproxRowCount()) {
                                return RolapMemberBase.this.getLevel().getChildLevel().getApproxRowCount();
                            }
                            ArrayList<RolapMember> list = new ArrayList<RolapMember>();
                            RolapMemberBase.this.getHierarchy().getMemberReader().getMemberChildren(RolapMemberBase.this, list);
                            return list.size();
                        }
                    });
                }
                case 24: {
                    RolapMember parentMember = this.getParentMember();
                    return parentMember == null ? 0 : parentMember.getLevel().getDepth();
                }
                case 25: {
                    RolapMember parentMember = this.getParentMember();
                    return parentMember == null ? null : parentMember.getUniqueName();
                }
                case 26: {
                    RolapMember parentMember = this.getParentMember();
                    return parentMember == null ? 0 : 1;
                }
                case 28: {
                    Object visProp = this.getPropertyFromMap(propertyName, matchCase);
                    if (visProp != null) {
                        return visProp;
                    }
                    return this.isVisible();
                }
                case 45: 
                case 46: {
                    return this == this.getHierarchy().getAllMember() ? Integer.valueOf(0) : this.getKey();
                }
                case 48: {
                    return ScenarioImpl.forMember(this);
                }
            }
        }
        return this.getPropertyFromMap(propertyName, matchCase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getPropertyFromMap(String propertyName, boolean matchCase) {
        RolapMemberBase rolapMemberBase = this;
        synchronized (rolapMemberBase) {
            if (matchCase) {
                return this.mapPropertyNameToValue.get(propertyName);
            }
            for (String key : this.mapPropertyNameToValue.keySet()) {
                if (!key.equalsIgnoreCase(propertyName)) continue;
                return this.mapPropertyNameToValue.get(key);
            }
            return null;
        }
    }

    protected boolean childLevelHasApproxRowCount() {
        return this.getLevel().getChildLevel().getApproxRowCount() > Integer.MIN_VALUE;
    }

    @Override
    public boolean isAllMember() {
        return this.getLevel().getHierarchy().hasAll() && this.getLevel().getDepth() == 0;
    }

    @Override
    public Property[] getProperties() {
        return this.getLevel().getInheritedProperties();
    }

    @Override
    public int getOrdinal() {
        return this.ordinal;
    }

    @Override
    public Comparable getOrderKey() {
        return this.orderKey;
    }

    void setOrdinal(int ordinal) {
        if (this.ordinal == -1) {
            this.ordinal = ordinal;
        }
    }

    protected void setOrdinal(int ordinal, boolean forced) {
        if (forced) {
            this.ordinal = ordinal;
        } else {
            this.setOrdinal(ordinal);
        }
    }

    void setOrderKey(Comparable orderKey) {
        this.orderKey = orderKey;
    }

    private void resetOrdinal() {
        this.ordinal = -1;
    }

    @Override
    public Object getKey() {
        return this.key;
    }

    public int compareTo(Object o) {
        RolapMemberBase other = (RolapMemberBase)o;
        assert (this.key != null && other.key != null);
        if (this.key == RolapUtil.sqlNullValue && other.key == RolapUtil.sqlNullValue) {
            return this.getName().compareTo(other.getName());
        }
        if (other.key == RolapUtil.sqlNullValue) {
            return 1;
        }
        if (this.key == RolapUtil.sqlNullValue) {
            return -1;
        }
        if (this.key.getClass().equals(other.key.getClass())) {
            if (this.key instanceof String) {
                return Util.caseSensitiveCompareName((String)this.key, (String)other.key);
            }
            return Util.compareKey(this.key, other.key);
        }
        return this.getUniqueName().compareTo(other.getUniqueName());
    }

    @Override
    public boolean isHidden() {
        RolapLevel rolapLevel = this.getLevel();
        switch (rolapLevel.getHideMemberCondition()) {
            case Never: {
                return false;
            }
            case IfBlankName: {
                String name = this.getName();
                return name.equals(RolapUtil.mdxNullLiteral()) || Util.isBlank(name);
            }
            case IfParentsName: {
                RolapMember parentMember = this.getParentMember();
                if (parentMember == null) {
                    return false;
                }
                String parentName = parentMember.getName();
                String name = this.getName();
                return (parentName == null ? "" : parentName).equals(name == null ? "" : name);
            }
        }
        throw Util.badValue(rolapLevel.getHideMemberCondition());
    }

    @Override
    public int getDepth() {
        return this.getLevel().getDepth();
    }

    @Override
    public String getPropertyFormattedValue(String propertyName) {
        PropertyFormatter pf;
        RolapProperty[] props = this.getLevel().getProperties();
        Property prop = null;
        for (RolapProperty prop1 : props) {
            if (!prop1.getName().equals(propertyName)) continue;
            prop = prop1;
            break;
        }
        Object propertyValue = this.getPropertyValue(propertyName);
        if (prop != null && (pf = prop.getFormatter()) != null) {
            return pf.formatProperty(this, propertyName, propertyValue);
        }
        return propertyValue == null ? null : propertyValue.toString();
    }

    @Override
    public boolean isParentChildLeaf() {
        if (this.isParentChildLeaf == null) {
            this.isParentChildLeaf = this.getLevel().isParentChild() && this.getDimension().getSchema().getSchemaReader().getMemberChildren(this).size() == 0;
        }
        return this.isParentChildLeaf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<List<Member>> getAllMembers(SchemaReader schemaReader, Hierarchy hierarchy) {
        long start = System.currentTimeMillis();
        try {
            Level[] levels;
            ArrayList<List<Member>> list = new ArrayList<List<Member>>();
            for (Level level : levels = hierarchy.getLevels()) {
                List<Member> members = schemaReader.getLevelMembers(level, true);
                if (members == null) continue;
                list.add(members);
            }
            ArrayList<List<Member>> arrayList = list;
            return arrayList;
        }
        finally {
            if (LOGGER.isDebugEnabled()) {
                long end = System.currentTimeMillis();
                LOGGER.debug("RolapMember.getAllMembers: time=" + (end - start));
            }
        }
    }

    public static int getHierarchyCardinality(SchemaReader schemaReader, Hierarchy hierarchy) {
        Level[] levels;
        int cardinality = 0;
        for (Level level1 : levels = hierarchy.getLevels()) {
            cardinality += schemaReader.getLevelCardinality(level1, true, true);
        }
        return cardinality;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setOrdinals(SchemaReader schemaReader, Member seedMember) {
        seedMember = RolapUtil.strip((RolapMember)seedMember);
        long start = System.currentTimeMillis();
        try {
            Hierarchy hierarchy = seedMember.getHierarchy();
            int ordinal = hierarchy.hasAll() ? 1 : 0;
            List<List<Member>> levelMembers = RolapMemberBase.getAllMembers(schemaReader, hierarchy);
            List<Member> leafMembers = levelMembers.get(levelMembers.size() - 1);
            levelMembers = levelMembers.subList(0, levelMembers.size() - 1);
            for (Member child : leafMembers) {
                ordinal = RolapMemberBase.bottomUpSetParentOrdinals(ordinal, child);
                ordinal = RolapMemberBase.setOrdinal(child, ordinal);
            }
            boolean needsFullTopDown = RolapMemberBase.needsFullTopDown(levelMembers);
            if (needsFullTopDown) {
                for (List<Member> members : levelMembers) {
                    for (Member member : members) {
                        if (!(member instanceof RolapMemberBase)) continue;
                        ((RolapMemberBase)member).resetOrdinal();
                    }
                }
                RolapMemberBase.setOrdinalsTopDown(schemaReader, seedMember);
            }
        }
        finally {
            if (LOGGER.isDebugEnabled()) {
                long end = System.currentTimeMillis();
                LOGGER.debug("RolapMember.setOrdinals: time=" + (end - start));
            }
        }
    }

    private static boolean needsFullTopDown(List<List<Member>> levelMembers) {
        for (List<Member> members : levelMembers) {
            for (Member member : members) {
                if (member.getOrdinal() != -1) continue;
                return true;
            }
        }
        return false;
    }

    private static int bottomUpSetParentOrdinals(int ordinal, Member child) {
        Member parent = child.getParentMember();
        if (parent != null && parent.getOrdinal() == -1) {
            ordinal = RolapMemberBase.bottomUpSetParentOrdinals(ordinal, parent);
            ordinal = RolapMemberBase.setOrdinal(parent, ordinal);
        }
        return ordinal;
    }

    private static int setOrdinal(Member member, int ordinal) {
        if (member instanceof RolapMemberBase) {
            ((RolapMemberBase)member).setOrdinal(ordinal++);
        } else {
            LOGGER.warn("RolapMember.setAllChildren: NOT RolapMember member.name=" + member.getName() + ", member.class=" + member.getClass().getName() + ", ordinal=" + ordinal);
            ++ordinal;
        }
        return ordinal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setOrdinalsTopDown(SchemaReader schemaReader, Member member) {
        long start = System.currentTimeMillis();
        try {
            Member parent = schemaReader.getMemberParent(member);
            if (parent == null) {
                int ordinal = 0;
                List<Member> siblings = schemaReader.getHierarchyRootMembers(member.getHierarchy());
                for (Member sibling : siblings) {
                    ordinal = RolapMemberBase.setAllChildren(ordinal, schemaReader, sibling);
                }
            } else {
                RolapMemberBase.setOrdinalsTopDown(schemaReader, parent);
            }
        }
        finally {
            if (LOGGER.isDebugEnabled()) {
                long end = System.currentTimeMillis();
                LOGGER.debug("RolapMember.setOrdinalsTopDown: time=" + (end - start));
            }
        }
    }

    private static int setAllChildren(int ordinal, SchemaReader schemaReader, Member member) {
        ordinal = RolapMemberBase.setOrdinal(member, ordinal);
        List<Member> children = schemaReader.getMemberChildren(member);
        for (Member child : children) {
            ordinal = RolapMemberBase.setAllChildren(ordinal, schemaReader, child);
        }
        return ordinal;
    }

    protected static String keyToString(Object key) {
        String name = key == null || RolapUtil.sqlNullValue.equals(key) ? RolapUtil.mdxNullLiteral() : (key instanceof Id.NameSegment ? ((Id.NameSegment)key).name : key.toString());
        if (key instanceof Number && name.endsWith(".0")) {
            name = name.substring(0, name.length() - 2);
        }
        return name;
    }

    @Override
    public boolean containsAggregateFunction() {
        if (this.containsAggregateFunction == null) {
            this.containsAggregateFunction = RolapMemberBase.foundAggregateFunction(this.getExpression());
        }
        return this.containsAggregateFunction;
    }

    private static boolean foundAggregateFunction(Exp exp) {
        if (exp instanceof ResolvedFunCall) {
            ResolvedFunCall resolvedFunCall = (ResolvedFunCall)exp;
            if (resolvedFunCall.getFunDef() instanceof AggregateFunDef) {
                return true;
            }
            for (Exp argExp : resolvedFunCall.getArgs()) {
                if (!RolapMemberBase.foundAggregateFunction(argExp)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Calc getCompiledExpression(RolapEvaluatorRoot root) {
        return root.getCompiled(this.getExpression(), true, null);
    }

    @Override
    public int getHierarchyOrdinal() {
        return this.getHierarchy().getOrdinalInCube();
    }

    @Override
    public void setContextIn(RolapEvaluator evaluator) {
        RolapMember defaultMember = evaluator.root.defaultMembers[this.getHierarchyOrdinal()];
        evaluator.setContext(defaultMember);
        evaluator.setExpanding(this);
    }

    public static final class PropertyValueMapFactoryFactory
    extends ObjectFactory.Singleton<PropertyValueMapFactory> {
        private static final PropertyValueMapFactoryFactory factory = new PropertyValueMapFactoryFactory();

        public static PropertyValueMapFactory getPropertyValueMapFactory() {
            return (PropertyValueMapFactory)factory.getObject();
        }

        private PropertyValueMapFactoryFactory() {
            super(PropertyValueMapFactory.class);
        }

        @Override
        protected StringProperty getStringProperty() {
            return MondrianProperties.instance().PropertyValueMapFactoryClass;
        }

        @Override
        protected PropertyValueMapFactory getDefault(Class[] parameterTypes, Object[] parameterValues) throws CreationException {
            return new DefaultPropertyValueMapFactory();
        }
    }

    public static final class DefaultPropertyValueMapFactory
    implements PropertyValueMapFactory {
        @Override
        public Map<String, Object> create(Member member) {
            assert (member != null);
            Property[] props = member.getProperties();
            if (member instanceof RolapMeasure || props == null || props.length > 3) {
                return new HashMap<String, Object>();
            }
            return new Flat3Map();
        }
    }

    public static interface PropertyValueMapFactory {
        public Map<String, Object> create(Member var1);
    }
}

