/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun.sort;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import mondrian.calc.Calc;
import mondrian.olap.Evaluator;
import mondrian.olap.Member;
import mondrian.olap.Util;
import mondrian.olap.fun.sort.Sorter;
import mondrian.olap.fun.sort.TupleComparator;
import mondrian.rolap.agg.CellRequestQuantumExceededException;
import mondrian.util.CancellationChecker;

abstract class TupleExpMemoComparator
extends TupleComparator.TupleExpComparator {
    Cache<List<Member>, Object> valueCache = CacheBuilder.newBuilder().maximumSize(100000L).build();
    private int[] dependentHierarchiesIndices;
    private int count = 0;

    TupleExpMemoComparator(Evaluator e, Calc calc, int arity) {
        super(e, calc, arity);
    }

    protected Object eval(List<Member> key) {
        try {
            return this.valueCache.get(key, () -> this.evaluateCalc(key));
        }
        catch (UncheckedExecutionException e) {
            if (e.getCause() instanceof CellRequestQuantumExceededException) {
                throw CellRequestQuantumExceededException.INSTANCE;
            }
            throw e;
        }
        catch (ExecutionException e) {
            return this.evaluateCalc(key);
        }
    }

    private List<Member> dependentMembers(List<Member> tuple) {
        this.getDependentHierarchiesIndices(tuple);
        return Arrays.stream(this.dependentHierarchiesIndices).mapToObj(tuple::get).collect(Collectors.toList());
    }

    private void getDependentHierarchiesIndices(List<Member> tuple) {
        if (this.dependentHierarchiesIndices == null) {
            this.dependentHierarchiesIndices = new int[tuple.size()];
            int curPos = 0;
            for (int i = 0; i < tuple.size(); ++i) {
                if (!this.calc.dependsOn(tuple.get(i).getHierarchy())) continue;
                this.dependentHierarchiesIndices[curPos++] = i;
            }
            this.dependentHierarchiesIndices = Arrays.copyOf(this.dependentHierarchiesIndices, curPos);
        }
    }

    @Override
    public int compare(List<Member> a1, List<Member> a2) {
        CancellationChecker.checkCancelOrTimeout(this.count++, this.evaluator.getQuery().getStatement().getCurrentExecution());
        List<Member> a1Members = this.dependentMembers(a1);
        List<Member> a2Members = this.dependentMembers(a2);
        return Sorter.listEquals(a1Members, a2Members) ? 0 : this.nonEqualCompare(a1Members, a2Members);
    }

    protected abstract int nonEqualCompare(List<Member> var1, List<Member> var2);

    private Object evaluateCalc(List<Member> tuple) {
        this.evaluator.setContext(tuple);
        Object val = this.calc.evaluate(this.evaluator);
        return val == null ? Util.nullValue : val;
    }

    static class BreakTupleComparator
    extends TupleExpMemoComparator {
        BreakTupleComparator(Evaluator e, Calc calc, int arity) {
            super(e, calc, arity);
        }

        @Override
        protected int nonEqualCompare(List<Member> a1, List<Member> a2) {
            return Sorter.compareValues(this.eval(a1), this.eval(a2));
        }
    }
}

