/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.ListCalc;
import mondrian.calc.StringCalc;
import mondrian.calc.TupleList;
import mondrian.calc.impl.AbstractListCalc;
import mondrian.calc.impl.UnaryTupleList;
import mondrian.mdx.MemberExpr;
import mondrian.mdx.ResolvedFunCall;
import mondrian.mdx.UnresolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.Member;
import mondrian.olap.Property;
import mondrian.olap.Syntax;
import mondrian.olap.Validator;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.ReflectiveMultiResolver;
import mondrian.olap.fun.Resolver;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.SetType;
import mondrian.olap.type.Type;
import mondrian.resource.MondrianResource;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapMemberBase;
import mondrian.rolap.RolapUtil;

public class VisualTotalsFunDef
extends FunDefBase {
    static final Resolver Resolver = new ReflectiveMultiResolver("VisualTotals", "VisualTotals(<Set>[, <Pattern>])", "Dynamically totals child members specified in a set using a pattern for the total label in the result set.", new String[]{"fxx", "fxxS"}, VisualTotalsFunDef.class);

    public VisualTotalsFunDef(FunDef dummyFunDef) {
        super(dummyFunDef);
    }

    @Override
    protected Exp validateArg(Validator validator, Exp[] args, int i, int category) {
        SetType setType;
        Type elementType;
        Exp validatedArg = super.validateArg(validator, args, i, category);
        if (i == 0 && !((elementType = (setType = (SetType)validatedArg.getType()).getElementType()) instanceof MemberType)) {
            throw MondrianResource.instance().VisualTotalsAppliedToTuples.ex();
        }
        return validatedArg;
    }

    @Override
    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        ListCalc listCalc = compiler.compileList(call.getArg(0));
        StringCalc stringCalc = call.getArgCount() > 1 ? compiler.compileString(call.getArg(1)) : null;
        return new CalcImpl(call, listCalc, stringCalc);
    }

    static String substitute(String namePattern, String name) {
        StringBuilder buf = new StringBuilder(256);
        int namePatternLen = namePattern.length();
        int startIndex = 0;
        while (true) {
            int endIndex;
            if ((endIndex = namePattern.indexOf(42, startIndex)) == -1) break;
            if (++endIndex < namePatternLen && namePattern.charAt(endIndex) == '*') {
                buf.append(namePattern.substring(startIndex, endIndex));
            } else {
                buf.append(namePattern.substring(startIndex, endIndex - 1));
                buf.append(name);
            }
            startIndex = ++endIndex;
        }
        buf.append(namePattern.substring(startIndex));
        return buf.toString();
    }

    public static class VisualTotalMember
    extends RolapMemberBase {
        private final Member member;
        private Exp exp;
        private String caption;

        VisualTotalMember(Member member, String name, String caption, Exp exp) {
            super((RolapMember)member.getParentMember(), (RolapLevel)member.getLevel(), RolapUtil.sqlNullValue, name, Member.MemberType.FORMULA);
            this.member = member;
            this.caption = caption;
            this.exp = exp;
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof VisualTotalMember && this.member.equals(((VisualTotalMember)o).member) && this.exp.equals(((VisualTotalMember)o).exp) || o instanceof Member && this.member.equals(o);
        }

        @Override
        public int compareTo(Object o) {
            if (o instanceof VisualTotalMember) {
                return this.getMember().compareTo(((VisualTotalMember)o).getMember());
            }
            return super.compareTo(o);
        }

        @Override
        public int hashCode() {
            return this.member.hashCode();
        }

        @Override
        public String getCaption() {
            return this.caption;
        }

        @Override
        protected boolean computeCalculated(Member.MemberType memberType) {
            return true;
        }

        @Override
        public int getSolveOrder() {
            return 99;
        }

        @Override
        public Exp getExpression() {
            return this.exp;
        }

        public void setExpression(Exp exp) {
            this.exp = exp;
        }

        public void setExpression(Evaluator evaluator, List<Member> childMembers) {
            Exp exp = this.makeExpr(childMembers);
            Validator validator = evaluator.getQuery().createValidator();
            Exp validatedExp = exp.accept(validator);
            this.setExpression(validatedExp);
        }

        private Exp makeExpr(List childMemberList) {
            Exp[] memberExprs = new Exp[childMemberList.size()];
            for (int i = 0; i < childMemberList.size(); ++i) {
                Member childMember = (Member)childMemberList.get(i);
                memberExprs[i] = new MemberExpr(childMember);
            }
            return new UnresolvedFunCall("Aggregate", new Exp[]{new UnresolvedFunCall("{}", Syntax.Braces, memberExprs)});
        }

        @Override
        public int getOrdinal() {
            return this.member.getOrdinal();
        }

        @Override
        public Member getDataMember() {
            return this.member;
        }

        @Override
        public String getQualifiedName() {
            throw new UnsupportedOperationException();
        }

        public Member getMember() {
            return this.member;
        }

        @Override
        public Object getPropertyValue(String propertyName, boolean matchCase) {
            Property property = Property.lookup(propertyName, matchCase);
            if (property == null) {
                return null;
            }
            switch (property.ordinal) {
                case 23: {
                    return this.member.getPropertyValue(propertyName, matchCase);
                }
            }
            return super.getPropertyValue(propertyName, matchCase);
        }
    }

    private static class CalcImpl
    extends AbstractListCalc {
        private final ListCalc listCalc;
        private final StringCalc stringCalc;

        public CalcImpl(ResolvedFunCall call, ListCalc listCalc, StringCalc stringCalc) {
            super(call, new Calc[]{listCalc, stringCalc});
            this.listCalc = listCalc;
            this.stringCalc = stringCalc;
        }

        @Override
        public TupleList evaluateList(Evaluator evaluator) {
            Iterable list = this.listCalc.evaluateList(evaluator).slice(0);
            ArrayList<Member> resultList = new ArrayList<Member>((Collection<Member>)list);
            int memberCount = list.size();
            for (int i = memberCount - 1; i >= 0; --i) {
                Member nextMember;
                Member member = (Member)list.get(i);
                if (i + 1 >= memberCount || (nextMember = (Member)resultList.get(i + 1)) == member || !nextMember.isChildOrEqualTo(member)) continue;
                resultList.set(i, this.createMember(member, i, resultList, evaluator));
            }
            return new UnaryTupleList(resultList);
        }

        private VisualTotalMember createMember(Member member, int i, List<Member> list, Evaluator evaluator) {
            String caption;
            String name;
            if (this.stringCalc != null) {
                String namePattern = this.stringCalc.evaluateString(evaluator);
                caption = name = VisualTotalsFunDef.substitute(namePattern, member.getName());
            } else {
                name = member.getName();
                caption = member.getCaption();
            }
            List<Member> childMemberList = this.followingDescendants(member, i + 1, list);
            Exp exp = this.makeExpr(childMemberList);
            Validator validator = evaluator.getQuery().createValidator();
            Exp validatedExp = exp.accept(validator);
            return new VisualTotalMember(member, name, caption, validatedExp);
        }

        private List<Member> followingDescendants(Member member, int i, List<Member> list) {
            Member descendant;
            ArrayList<Member> childMemberList = new ArrayList<Member>();
            while (i < list.size() && !(descendant = list.get(i)).equals(member) && descendant.isChildOrEqualTo(member)) {
                if (descendant instanceof VisualTotalMember) {
                    VisualTotalMember visualTotalMember = (VisualTotalMember)descendant;
                    childMemberList.add(visualTotalMember);
                    i = this.lastChildIndex(visualTotalMember.member, i, list);
                    continue;
                }
                childMemberList.add(descendant);
                ++i;
            }
            return childMemberList;
        }

        private int lastChildIndex(Member member, int start, List list) {
            Member descendant;
            int i = start;
            while (++i < list.size() && !(descendant = (Member)list.get(i)).equals(member) && descendant.isChildOrEqualTo(member)) {
            }
            return i;
        }

        private Exp makeExpr(List childMemberList) {
            Exp[] memberExprs = new Exp[childMemberList.size()];
            for (int i = 0; i < childMemberList.size(); ++i) {
                Member childMember = (Member)childMemberList.get(i);
                memberExprs[i] = new MemberExpr(childMember);
            }
            return new UnresolvedFunCall("Aggregate", new Exp[]{new UnresolvedFunCall("{}", Syntax.Braces, memberExprs)});
        }
    }
}

