/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import mondrian.calc.Calc;
import mondrian.calc.DummyExp;
import mondrian.calc.ExpCompiler;
import mondrian.calc.IterCalc;
import mondrian.calc.MemberCalc;
import mondrian.calc.ResultStyle;
import mondrian.calc.TupleIterable;
import mondrian.calc.TupleList;
import mondrian.calc.impl.AbstractCalc;
import mondrian.calc.impl.AbstractListCalc;
import mondrian.calc.impl.ArrayTupleList;
import mondrian.calc.impl.ConstantCalc;
import mondrian.calc.impl.GenericIterCalc;
import mondrian.calc.impl.MemberArrayValueCalc;
import mondrian.calc.impl.MemberValueCalc;
import mondrian.calc.impl.UnaryTupleList;
import mondrian.calc.impl.ValueCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.Hierarchy;
import mondrian.olap.Member;
import mondrian.olap.Syntax;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.MemberOrderKeyFunDef;
import mondrian.olap.fun.Resolver;
import mondrian.olap.fun.ResolverBase;
import mondrian.olap.fun.sort.SortKeySpec;
import mondrian.olap.fun.sort.Sorter;

class OrderFunDef
extends FunDefBase {
    static final ResolverImpl Resolver = new ResolverImpl();
    private static final String TIMING_NAME = OrderFunDef.class.getSimpleName();

    public OrderFunDef(ResolverBase resolverBase, int type, int[] types) {
        super(resolverBase, type, types);
    }

    @Override
    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        Calc expCalc;
        IterCalc listCalc = compiler.compileIter(call.getArg(0));
        ArrayList<SortKeySpec> keySpecList = new ArrayList<SortKeySpec>();
        this.buildKeySpecList(keySpecList, call, compiler);
        int keySpecCount = keySpecList.size();
        Calc[] calcList = new Calc[keySpecCount + 1];
        calcList[0] = listCalc;
        assert (keySpecCount >= 1);
        calcList[1] = expCalc = ((SortKeySpec)keySpecList.get(0)).getKey();
        if (keySpecCount == 1 && (expCalc.isWrapperFor(MemberValueCalc.class) || expCalc.isWrapperFor(MemberArrayValueCalc.class))) {
            MemberCalc[] calcs;
            ArrayList<MemberCalc> constantList = new ArrayList<MemberCalc>();
            ArrayList<MemberCalc> variableList = new ArrayList<MemberCalc>();
            for (MemberCalc memberCalc : calcs = (MemberCalc[])((AbstractCalc)expCalc).getCalcs()) {
                if (memberCalc.isWrapperFor(ConstantCalc.class) && !listCalc.dependsOn(memberCalc.getType().getHierarchy())) {
                    constantList.add(memberCalc);
                    continue;
                }
                variableList.add(memberCalc);
            }
            if (!constantList.isEmpty()) {
                if (variableList.isEmpty()) {
                    calcList[1] = new ValueCalc(new DummyExp(expCalc.getType()));
                    return new ContextCalc(calcs, new CalcImpl(call, calcList, keySpecList));
                }
                calcList[1] = MemberValueCalc.create(new DummyExp(expCalc.getType()), variableList.toArray(new MemberCalc[variableList.size()]), compiler.getEvaluator().mightReturnNullForUnrelatedDimension());
                return new ContextCalc(constantList.toArray(new MemberCalc[constantList.size()]), new CalcImpl(call, calcList, keySpecList));
            }
        }
        for (int i = 1; i < keySpecCount; ++i) {
            Calc expCalcs;
            calcList[i + 1] = expCalcs = ((SortKeySpec)keySpecList.get(i)).getKey();
        }
        return new CalcImpl(call, calcList, keySpecList);
    }

    private void buildKeySpecList(List<SortKeySpec> keySpecList, ResolvedFunCall call, ExpCompiler compiler) {
        int argCount = call.getArgs().length;
        int j = 1;
        while (j < argCount) {
            Sorter.Flag dir;
            Exp arg = call.getArg(j);
            Calc key = compiler.compileScalar(arg, true);
            if (++j >= argCount || call.getArg(j).getCategory() != 11) {
                dir = Sorter.Flag.ASC;
            } else {
                dir = OrderFunDef.getLiteralArg(call, j, Sorter.Flag.ASC, Sorter.Flag.class);
                ++j;
            }
            keySpecList.add(new SortKeySpec(key, dir));
        }
    }

    private static class ResolverImpl
    extends ResolverBase {
        private final String[] reservedWords = Sorter.Flag.getNames();
        static int[] argTypes;

        private ResolverImpl() {
            super("Order", "Order(<Set> {, <Key Specification>}...)", "Arranges members of a set, optionally preserving or breaking the hierarchy.", Syntax.Function);
        }

        @Override
        public FunDef resolve(Exp[] args, Validator validator, List<Resolver.Conversion> conversions) {
            argTypes = new int[args.length];
            if (args.length < 2) {
                return null;
            }
            if (!validator.canConvert(0, args[0], 8, conversions)) {
                return null;
            }
            ResolverImpl.argTypes[0] = 8;
            int i = 1;
            while (i < args.length) {
                if (!validator.canConvert(i, args[i], 13, conversions)) {
                    return null;
                }
                ResolverImpl.argTypes[i] = 13;
                if (++i == args.length || !validator.canConvert(i, args[i], 11, conversions)) continue;
                ResolverImpl.argTypes[i] = 11;
                ++i;
            }
            return new OrderFunDef(this, 8, argTypes);
        }

        @Override
        public String[] getReservedWords() {
            if (this.reservedWords != null) {
                return this.reservedWords;
            }
            return super.getReservedWords();
        }
    }

    private static class ContextCalc
    extends GenericIterCalc {
        private final MemberCalc[] memberCalcs;
        private final CalcWithDual calc;
        private final Member[] members;

        protected ContextCalc(MemberCalc[] memberCalcs, CalcWithDual calc) {
            super(new DummyExp(calc.getType()), ContextCalc.xx(memberCalcs, calc));
            this.memberCalcs = memberCalcs;
            this.calc = calc;
            this.members = new Member[memberCalcs.length];
        }

        private static Calc[] xx(MemberCalc[] memberCalcs, CalcWithDual calc) {
            Calc[] calcs = new Calc[memberCalcs.length + 1];
            System.arraycopy(memberCalcs, 0, calcs, 0, memberCalcs.length);
            calcs[calcs.length - 1] = calc;
            return calcs;
        }

        @Override
        public Object evaluate(Evaluator evaluator) {
            for (int i = 0; i < this.memberCalcs.length; ++i) {
                this.members[i] = this.memberCalcs[i].evaluateMember(evaluator);
            }
            Evaluator subEval = evaluator.push(this.members);
            return this.calc.evaluateDual(evaluator, subEval);
        }

        @Override
        public boolean dependsOn(Hierarchy hierarchy) {
            if (ContextCalc.anyDepends(this.memberCalcs, hierarchy)) {
                return true;
            }
            for (MemberCalc memberCalc : this.memberCalcs) {
                if (!memberCalc.getType().usesHierarchy(hierarchy, true)) continue;
                return false;
            }
            return this.calc.dependsOn(hierarchy);
        }

        @Override
        public ResultStyle getResultStyle() {
            return this.calc.getResultStyle();
        }
    }

    private static class CalcImpl
    extends AbstractListCalc
    implements CalcWithDual {
        private final IterCalc iterCalc;
        private final Calc sortKeyCalc;
        private final List<SortKeySpec> keySpecList;
        private final int originalKeySpecCount;
        private final int arity;

        public CalcImpl(ResolvedFunCall call, Calc[] calcList, List<SortKeySpec> keySpecList) {
            super(call, calcList);
            this.iterCalc = (IterCalc)calcList[0];
            this.sortKeyCalc = calcList[1];
            this.keySpecList = keySpecList;
            this.originalKeySpecCount = keySpecList.size();
            this.arity = this.getType().getArity();
        }

        @Override
        public TupleList evaluateDual(Evaluator rootEvaluator, Evaluator subEvaluator) {
            assert (this.originalKeySpecCount == 1);
            TupleIterable iterable = this.iterCalc.evaluateIterable(rootEvaluator);
            if (iterable instanceof ArrayTupleList) {
                // empty if block
            }
            TupleList list = null;
            Util.discard((Object)((Object)this.iterCalc.getResultStyle()));
            return this.handleSortWithOneKeySpec(subEvaluator, iterable, list);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public TupleList evaluateList(Evaluator evaluator) {
            evaluator.getTiming().markStart(TIMING_NAME);
            try {
                TupleIterable iterable = this.iterCalc.evaluateIterable(evaluator);
                if (iterable instanceof ArrayTupleList) {
                    // empty if block
                }
                TupleList list = null;
                if (this.originalKeySpecCount == 1) {
                    TupleList tupleList = this.handleSortWithOneKeySpec(evaluator, iterable, list);
                    return tupleList;
                }
                this.purgeKeySpecList(this.keySpecList, list);
                if (this.keySpecList.isEmpty()) {
                    TupleList tupleList = list;
                    return tupleList;
                }
                int savepoint = evaluator.savepoint();
                try {
                    evaluator.setNonEmpty(false);
                    TupleList tupleList = this.arity == 1 ? new UnaryTupleList(Sorter.sortMembers(evaluator, iterable.slice(0), (List<Member>)(list == null ? null : list.slice(0)), this.keySpecList)) : Sorter.sortTuples(evaluator, iterable, list, this.keySpecList, this.arity);
                    TupleList tupleList2 = tupleList;
                    evaluator.restore(savepoint);
                    return tupleList2;
                }
                catch (Throwable throwable) {
                    evaluator.restore(savepoint);
                    throw throwable;
                }
            }
            finally {
                evaluator.getTiming().markEnd(TIMING_NAME);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private TupleList handleSortWithOneKeySpec(Evaluator evaluator, TupleIterable iterable, TupleList list) {
            Sorter.Flag sortKeyDir = this.keySpecList.get(0).getDirection();
            int savepoint = evaluator.savepoint();
            try {
                evaluator.setNonEmpty(false);
                TupleList tupleList = this.arity == 1 ? new UnaryTupleList(Sorter.sortMembers(evaluator, iterable.slice(0), (List<Member>)(list == null ? null : list.slice(0)), this.sortKeyCalc, sortKeyDir.descending, sortKeyDir.brk)) : Sorter.sortTuples(evaluator, iterable, list, this.sortKeyCalc, sortKeyDir.descending, sortKeyDir.brk, this.arity);
                TupleList tupleList2 = tupleList;
                return tupleList2;
            }
            finally {
                evaluator.restore(savepoint);
            }
        }

        @Override
        public void collectArguments(Map<String, Object> arguments) {
            super.collectArguments(arguments);
            StringBuilder result = new StringBuilder();
            for (SortKeySpec spec : this.keySpecList) {
                if (result.length() > 0) {
                    result.append(",");
                }
                Sorter.Flag sortKeyDir = spec.getDirection();
                result.append((Object)(sortKeyDir.descending ? (sortKeyDir.brk ? Sorter.Flag.BDESC : Sorter.Flag.DESC) : (sortKeyDir.brk ? Sorter.Flag.BASC : Sorter.Flag.ASC)));
            }
            arguments.put("direction", result.toString());
        }

        @Override
        public boolean dependsOn(Hierarchy hierarchy) {
            return CalcImpl.anyDependsButFirst(this.getCalcs(), hierarchy);
        }

        private void purgeKeySpecList(List<SortKeySpec> keySpecList, TupleList list) {
            if (list == null || list.isEmpty()) {
                return;
            }
            if (keySpecList.size() == 1) {
                return;
            }
            ArrayList<Hierarchy> listHierarchies = new ArrayList<Hierarchy>(list.getArity());
            for (Member member : (List)list.get(0)) {
                listHierarchies.add(member.getHierarchy());
            }
            ListIterator<SortKeySpec> iter = keySpecList.listIterator();
            while (iter.hasNext()) {
                Calc[] calcs;
                MemberCalc memberCalc;
                SortKeySpec key = iter.next();
                Calc expCalc = key.getKey();
                if (!(expCalc instanceof MemberOrderKeyFunDef.CalcImpl) || !((memberCalc = (MemberCalc)(calcs = ((MemberOrderKeyFunDef.CalcImpl)expCalc).getCalcs())[0]) instanceof ConstantCalc) && listHierarchies.contains(memberCalc.getType().getHierarchy())) continue;
                iter.remove();
            }
        }
    }

    private static interface CalcWithDual
    extends Calc {
        public TupleList evaluateDual(Evaluator var1, Evaluator var2);
    }
}

