/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.hdfs.vfs;

import org.pentaho.di.core.Props;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.hadoop.shim.api.cluster.NamedCluster;

public class HadoopVfsConnection {
    private static final String COLON = ":";
    private static final String EMPTY = "";
    private static final String SCHEME_NAME = "hdfs";
    private String hostname;
    private String port;
    private String username;
    private String password;

    public HadoopVfsConnection(String ncHostname, String ncPort, String ncUsername, String ncPassword) {
        this.hostname = ncHostname;
        this.port = ncPort;
        this.username = ncUsername;
        this.password = ncPassword;
    }

    public HadoopVfsConnection() {
        this(EMPTY, EMPTY, EMPTY, EMPTY);
    }

    public HadoopVfsConnection(NamedCluster nCluster, VariableSpace vs) {
        this(EMPTY, EMPTY, EMPTY, EMPTY);
        this.loadNamedCluster(nCluster, vs);
    }

    public String getConnectionString(String schemeName) {
        if ("maprfs".equals(schemeName)) {
            return "maprfs".concat("://");
        }
        StringBuffer urlString = new StringBuffer(!Utils.isEmpty((CharSequence)schemeName) ? schemeName : SCHEME_NAME).append("://");
        if (!Utils.isEmpty((CharSequence)this.getUsername())) {
            urlString.append(this.getUsername()).append(COLON).append(this.getPassword()).append("@");
        }
        urlString.append(this.getHostname());
        if (!Utils.isEmpty((CharSequence)this.getPort())) {
            urlString.append(COLON).append(this.getPort());
        }
        return urlString.toString();
    }

    private void loadNamedCluster(NamedCluster nCluster, VariableSpace vs) {
        if (nCluster != null) {
            this.hostname = nCluster.getHdfsHost() != null ? nCluster.getHdfsHost() : EMPTY;
            this.port = nCluster.getHdfsPort() != null ? nCluster.getHdfsPort() : EMPTY;
            this.username = nCluster.getHdfsUsername() != null ? nCluster.getHdfsUsername() : EMPTY;
            this.password = nCluster.getHdfsPassword() != null ? nCluster.decodePassword(nCluster.getHdfsPassword()) : EMPTY;
            this.hostname = vs.environmentSubstitute(this.hostname);
            this.port = vs.environmentSubstitute(this.port);
            this.username = vs.environmentSubstitute(this.username);
            this.password = vs.environmentSubstitute(this.password);
        }
    }

    public void setCustomParameters(Props pr) {
        pr.setCustomParameter("HadoopVfsFileChooserDialog.host", this.getHostname());
        pr.setCustomParameter("HadoopVfsFileChooserDialog.port", this.getPort());
        pr.setCustomParameter("HadoopVfsFileChooserDialog.user", this.getUsername());
        pr.setCustomParameter("HadoopVfsFileChooserDialog.password", this.getPassword());
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getPort() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }
}

