/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.hdfs.trans;

import java.net.URI;
import java.net.URISyntaxException;
import java.security.InvalidParameterException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.apache.commons.vfs2.FileName;
import org.pentaho.big.data.kettle.plugins.hdfs.trans.HadoopFileMeta;
import org.pentaho.di.core.annotations.Step;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.fileinput.FileInputList;
import org.pentaho.di.core.injection.Injection;
import org.pentaho.di.core.injection.InjectionSupported;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.steps.fileinput.text.TextFileInputMeta;
import org.pentaho.hadoop.shim.api.cluster.NamedCluster;
import org.pentaho.hadoop.shim.api.cluster.NamedClusterService;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

@Step(id="HadoopFileInputPlugin", image="HDI.svg", name="HadoopFileInputPlugin.Name", description="HadoopFileInputPlugin.Description", documentationUrl="Products/Hadoop_File_Input", categoryDescription="i18n:org.pentaho.di.trans.step:BaseStep.Category.BigData", i18nPackageName="org.pentaho.di.trans.steps.hadoopfileinput")
@InjectionSupported(localizationPrefix="HadoopFileInput.Injection.", groups={"FILENAME_LINES", "FIELDS", "FILTERS"})
public class HadoopFileInputMeta
extends TextFileInputMeta
implements HadoopFileMeta {
    private VariableSpace variableSpace;
    private Map<String, String> namedClusterURLMapping = null;
    public static final String SOURCE_CONFIGURATION_NAME = "source_configuration_name";
    public static final String LOCAL_SOURCE_FILE = "LOCAL-SOURCE-FILE-";
    public static final String STATIC_SOURCE_FILE = "STATIC-SOURCE-FILE-";
    public static final String S3_SOURCE_FILE = "S3-SOURCE-FILE-";
    public static final String S3_DEST_FILE = "S3-DEST-FILE-";
    private final NamedClusterService namedClusterService;
    @Injection(name="ENVIRONMENT", group="FILENAME_LINES")
    public String[] environment = new String[0];

    public HadoopFileInputMeta() {
        this(null);
    }

    public HadoopFileInputMeta(NamedClusterService namedClusterService) {
        this.namedClusterService = namedClusterService;
        this.namedClusterURLMapping = new HashMap<String, String>();
    }

    protected String loadSource(Node filenode, Node filenamenode, int i, IMetaStore metaStore) {
        String source_filefolder = XMLHandler.getNodeValue((Node)filenamenode);
        Node sourceNode = XMLHandler.getSubNodeByNr((Node)filenode, (String)SOURCE_CONFIGURATION_NAME, (int)i);
        String source = XMLHandler.getNodeValue((Node)sourceNode);
        try {
            return source_filefolder == null ? null : this.loadUrl(this.encryptDecryptPassword(source_filefolder, EncryptDirection.DECRYPT), source, metaStore, this.namedClusterURLMapping);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void saveSource(StringBuilder retVal, String source) {
        String namedCluster = this.namedClusterURLMapping.get(source);
        retVal.append("      ").append(XMLHandler.addTagValue((String)"name", (String)this.encryptDecryptPassword(source, EncryptDirection.ENCRYPT)));
        retVal.append("          ").append(XMLHandler.addTagValue((String)SOURCE_CONFIGURATION_NAME, (String)namedCluster));
    }

    protected String loadSourceRep(Repository rep, ObjectId id_step, int i, IMetaStore metaStore) throws KettleException {
        String source_filefolder = rep.getStepAttributeString(id_step, i, "file_name");
        String ncName = rep.getJobEntryAttributeString(id_step, i, SOURCE_CONFIGURATION_NAME);
        return this.loadUrl(this.encryptDecryptPassword(source_filefolder, EncryptDirection.DECRYPT), ncName, metaStore, this.namedClusterURLMapping);
    }

    protected void saveSourceRep(Repository rep, ObjectId id_transformation, ObjectId id_step, int i, String fileName) throws KettleException {
        String namedCluster = this.namedClusterURLMapping.get(fileName);
        rep.saveStepAttribute(id_transformation, id_step, i, "file_name", this.encryptDecryptPassword(fileName, EncryptDirection.ENCRYPT));
        rep.saveStepAttribute(id_transformation, id_step, i, SOURCE_CONFIGURATION_NAME, namedCluster);
    }

    public String loadUrl(String url, String ncName, IMetaStore metastore, Map<String, String> mappings) {
        NamedCluster c = this.namedClusterService.getNamedClusterByName(ncName, metastore);
        if (c != null) {
            url = c.processURLsubstitution(url, metastore, (VariableSpace)new Variables());
        }
        if (!Utils.isEmpty((CharSequence)ncName) && !Utils.isEmpty((CharSequence)url) && mappings != null) {
            mappings.put(url, ncName);
            try {
                mappings.put(this.getFriendlyUri(url).toString(), ncName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return url;
    }

    public void setNamedClusterURLMapping(Map<String, String> mappings) {
        this.namedClusterURLMapping = mappings;
    }

    public Map<String, String> getNamedClusterURLMapping() {
        return this.namedClusterURLMapping;
    }

    @Override
    public String getClusterName(String url) {
        String clusterName = null;
        try {
            URI friendlyUri = this.getFriendlyUri(url);
            clusterName = this.getClusterNameBy(friendlyUri.toString());
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return clusterName;
    }

    private URI getFriendlyUri(String url) throws URISyntaxException {
        URI origUri = new URI(url);
        return new URI(origUri.getScheme(), null, origUri.getHost(), origUri.getPort(), origUri.getPath(), origUri.getQuery(), origUri.getFragment());
    }

    public String getClusterNameBy(String url) {
        return this.namedClusterURLMapping.get(url);
    }

    @Override
    public String getUrlPath(String incomingURL) {
        String path = null;
        FileName fileName = this.getUrlFileName(incomingURL);
        if (fileName != null) {
            String root = fileName.getRootURI();
            path = incomingURL.substring(root.length() - 1);
        }
        return path;
    }

    public void setVariableSpace(VariableSpace variableSpace) {
        this.variableSpace = variableSpace;
    }

    public NamedClusterService getNamedClusterService() {
        return this.namedClusterService;
    }

    public FileInputList getFileInputList(VariableSpace space) {
        this.inputFiles.normalizeAllocation(this.inputFiles.fileName.length);
        for (int i = 0; i < this.environment.length; ++i) {
            if (this.inputFiles.fileName[i].contains("://")) continue;
            String sourceNc = this.environment[i];
            sourceNc = sourceNc.equals("Local") ? LOCAL_SOURCE_FILE + i : sourceNc;
            sourceNc = sourceNc.equals("<Static>") ? STATIC_SOURCE_FILE + i : sourceNc;
            sourceNc = sourceNc.equals("S3") ? S3_SOURCE_FILE + i : sourceNc;
            String source = this.inputFiles.fileName[i];
            this.inputFiles.fileName[i] = !Utils.isEmpty((CharSequence)source) ? this.loadUrl(source, sourceNc, this.getParentStepMeta().getParentTransMeta().getMetaStore(), null) : "";
        }
        return this.createFileList(space);
    }

    FileInputList createFileList(VariableSpace space) {
        return FileInputList.createFileList((VariableSpace)space, (String[])this.inputFiles.fileName, (String[])this.inputFiles.fileMask, (String[])this.inputFiles.excludeFileMask, (String[])this.inputFiles.fileRequired, (boolean[])this.inputFiles.includeSubFolderBoolean());
    }

    protected String encryptDecryptPassword(String source, EncryptDirection direction) {
        Validate.notNull((Object)((Object)direction), (String)"'direction' must not be null");
        try {
            URI uri = new URI(source);
            String userInfo = uri.getUserInfo();
            if (userInfo != null) {
                String processedPassword;
                String[] userInfoArray = userInfo.split(":", 2);
                if (userInfoArray.length < 2) {
                    return source;
                }
                String password = userInfoArray[1];
                switch (direction) {
                    case ENCRYPT: {
                        processedPassword = Encr.encryptPasswordIfNotUsingVariables((String)password);
                        break;
                    }
                    case DECRYPT: {
                        processedPassword = Encr.decryptPasswordOptionallyEncrypted((String)password);
                        break;
                    }
                    default: {
                        throw new InvalidParameterException("direction must be 'ENCODE' or 'DECODE'");
                    }
                }
                URI encryptedUri = new URI(uri.getScheme(), userInfoArray[0] + ":" + processedPassword, uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
                return encryptedUri.toString();
            }
        }
        catch (URISyntaxException e) {
            return source;
        }
        return source;
    }

    static enum EncryptDirection {
        ENCRYPT,
        DECRYPT;

    }
}

