/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.amazon.s3;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class S3Util {
    public static final String ENDPOINT_SYSTEM_PROPERTY = "aws.endpoint";
    public static final String SIGNATURE_VERSION_SYSTEM_PROPERTY = "aws.endpoint";
    public static final String ACCESS_KEY_SYSTEM_PROPERTY = "aws.accessKeyId";
    public static final String SECRET_KEY_SYSTEM_PROPERTY = "aws.secretKey";
    public static final String AWS_REGION = "AWS_REGION";
    public static final String AWS_CONFIG_FILE = "AWS_CONFIG_FILE";
    public static final String AWS_FOLDER = ".aws";
    public static final String CONFIG_FILE = "config";
    private static final String URI_AWS_CREDENTIALS_REGEX = "(s3[an]?:\\/)?\\/(?<fullkeys>(?<keys>.*:.*)@)?s3[an]?\\/?((?<bucket>[^\\/]+)(?<path>.*))?";
    private static final String URI_AWS_FULL_KEYS_GROUP = "fullkeys";
    private static final String URI_AWS_KEYS_GROUP = "keys";
    private static final String URI_AWS_BUCKET_GROUP = "bucket";
    private static final String URI_AWS_PATH_GROUP = "path";

    public static boolean hasChanged(String previousValue, String currentValue) {
        if (!S3Util.isEmpty(previousValue) && S3Util.isEmpty(currentValue)) {
            return true;
        }
        if (S3Util.isEmpty(previousValue) && !S3Util.isEmpty(currentValue)) {
            return true;
        }
        return !S3Util.isEmpty(previousValue) && !S3Util.isEmpty(currentValue) && !currentValue.equals(previousValue);
    }

    public static boolean isEmpty(String value) {
        return value == null || value.length() == 0;
    }

    public static String getFullKeysFromURI(String uri) {
        Matcher match = Pattern.compile(URI_AWS_CREDENTIALS_REGEX).matcher(uri);
        return match.find() ? match.group(URI_AWS_FULL_KEYS_GROUP) : null;
    }

    public static S3Keys getKeysFromURI(String uri) {
        Matcher match = Pattern.compile(URI_AWS_CREDENTIALS_REGEX).matcher(uri);
        return match.find() && match.group(URI_AWS_KEYS_GROUP) != null ? new S3Keys(match.group(URI_AWS_KEYS_GROUP)) : null;
    }

    private S3Util() {
    }

    public static class S3Keys {
        private String accessKey;
        private String secretKey;

        private S3Keys(String keys) {
            String[] splitKeys = keys.split(":");
            this.accessKey = splitKeys[0];
            this.secretKey = splitKeys[1];
        }

        public String getAccessKey() {
            return this.accessKey;
        }

        public String getSecretKey() {
            return this.secretKey;
        }
    }
}

