/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.formats.impl.parquet.output;

import java.io.IOException;
import org.pentaho.big.data.kettle.plugins.formats.impl.output.PvfsFileAliaser;
import org.pentaho.big.data.kettle.plugins.formats.impl.parquet.output.ParquetOutputData;
import org.pentaho.big.data.kettle.plugins.formats.impl.parquet.output.ParquetOutputMeta;
import org.pentaho.big.data.kettle.plugins.formats.parquet.output.ParquetOutputMetaBase;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.hadoop.shim.api.cluster.ClusterInitializationException;
import org.pentaho.hadoop.shim.api.cluster.NamedCluster;
import org.pentaho.hadoop.shim.api.format.FormatService;
import org.pentaho.hadoop.shim.api.format.IPentahoParquetOutputFormat;
import org.pentaho.hadoop.shim.api.format.IPvfsAliasGenerator;

public class ParquetOutput
extends BaseStep
implements StepInterface {
    private ParquetOutputMeta meta;
    private ParquetOutputData data;
    private PvfsFileAliaser pvfsFileAliaser;

    public ParquetOutput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public synchronized boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        try {
            Object[] currentRow;
            if (this.data.output == null) {
                this.init(this.getInputRowMeta());
            }
            if ((currentRow = this.getRow()) != null) {
                RowMetaAndData row = new RowMetaAndData(this.getInputRowMeta(), currentRow);
                this.data.writer.write(row);
                this.incrementLinesOutput();
                this.putRow(row.getRowMeta(), row.getData());
                return true;
            }
            this.closeWriter();
            this.pvfsFileAliaser.copyFileToFinalDestination();
            this.pvfsFileAliaser.deleteTempFileAndFolder();
            this.setOutputDone();
            return false;
        }
        catch (KettleException ex) {
            try {
                this.closeWriter();
                this.pvfsFileAliaser.deleteTempFileAndFolder();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw ex;
        }
        catch (IllegalStateException e) {
            this.getLogChannel().logError(e.getMessage());
            this.setErrors(1L);
            this.pvfsFileAliaser.deleteTempFileAndFolder();
            this.setOutputDone();
            return false;
        }
        catch (Exception ex) {
            try {
                this.closeWriter();
                this.pvfsFileAliaser.deleteTempFileAndFolder();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new KettleException((Throwable)ex);
        }
    }

    public void init(RowMetaInterface rowMeta) throws Exception {
        IPentahoParquetOutputFormat.COMPRESSION compression;
        FormatService formatService;
        try {
            formatService = (FormatService)this.meta.getNamedClusterResolver().getNamedClusterServiceLocator().getService(this.getNamedCluster(), FormatService.class);
        }
        catch (ClusterInitializationException e) {
            throw new KettleException("can't get service format shim ", (Throwable)e);
        }
        if (this.meta.getFilename() == null) {
            throw new KettleException("No output files defined");
        }
        this.data.output = (IPentahoParquetOutputFormat)formatService.createOutputFormat(IPentahoParquetOutputFormat.class, this.getNamedCluster());
        String outputFileName = this.environmentSubstitute(this.meta.constructOutputFilename());
        this.pvfsFileAliaser = new PvfsFileAliaser(outputFileName, (VariableSpace)this.getTransMeta(), (IPvfsAliasGenerator)this.data.output, this.meta.overrideOutput, this.getLogChannel());
        this.data.output.setOutputFile(this.pvfsFileAliaser.generateAlias(), this.meta.overrideOutput);
        this.data.output.setFields(this.meta.getOutputFields());
        try {
            compression = IPentahoParquetOutputFormat.COMPRESSION.valueOf((String)this.meta.getCompressionType(this.variables).name().toUpperCase());
        }
        catch (Exception ex) {
            compression = IPentahoParquetOutputFormat.COMPRESSION.UNCOMPRESSED;
        }
        this.data.output.setCompression(compression);
        this.data.output.setVersion(ParquetOutputMetaBase.ParquetVersion.PARQUET_1.equals((Object)this.meta.getParquetVersion(this.variables)) ? IPentahoParquetOutputFormat.VERSION.VERSION_1_0 : IPentahoParquetOutputFormat.VERSION.VERSION_2_0);
        if (this.meta.getRowGroupSize(this.variables) > 0) {
            this.data.output.setRowGroupSize(this.meta.getRowGroupSize(this.variables) * 1024 * 1024);
        }
        if (this.meta.getDataPageSize(this.variables) > 0) {
            this.data.output.setDataPageSize(this.meta.getDataPageSize(this.variables) * 1024);
        }
        this.data.output.enableDictionary(this.meta.enableDictionary);
        if (this.meta.getDictPageSize(this.variables) > 0) {
            this.data.output.setDictionaryPageSize(this.meta.getDictPageSize(this.variables) * 1024);
        }
        this.data.writer = this.data.output.createRecordWriter();
    }

    private NamedCluster getNamedCluster() {
        return this.meta.getNamedClusterResolver().resolveNamedCluster(this.environmentSubstitute(this.meta.getFilename()));
    }

    public void closeWriter() throws KettleException {
        try {
            this.data.writer.close();
        }
        catch (IOException e) {
            throw new KettleException((Throwable)e);
        }
        this.data.output = null;
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (ParquetOutputMeta)smi;
        this.data = (ParquetOutputData)sdi;
        if (!super.init(smi, sdi)) {
            return false;
        }
        if (this.getTransMeta().getNamedClusterEmbedManager() != null) {
            this.getTransMeta().getNamedClusterEmbedManager().passEmbeddedMetastoreKey((VariableSpace)this.getTransMeta(), this.getTransMeta().getEmbeddedMetastoreProviderKey());
        }
        return true;
    }
}

