/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.formats.impl.parquet.input;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.pentaho.big.data.kettle.plugins.formats.FormatInputFile;
import org.pentaho.big.data.kettle.plugins.formats.impl.parquet.BaseParquetStepDialog;
import org.pentaho.big.data.kettle.plugins.formats.impl.parquet.input.ParquetInput;
import org.pentaho.big.data.kettle.plugins.formats.impl.parquet.input.ParquetInputMeta;
import org.pentaho.big.data.kettle.plugins.formats.parquet.input.ParquetInputField;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.TransPreviewFactory;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.ui.core.dialog.EnterNumberDialog;
import org.pentaho.di.ui.core.dialog.EnterTextDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.dialog.PreviewRowsDialog;
import org.pentaho.di.ui.core.events.dialog.SelectionOperation;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.ColumnsResizer;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.trans.dialog.TransPreviewProgressDialog;
import org.pentaho.hadoop.shim.api.format.IParquetInputField;
import org.pentaho.hadoop.shim.api.format.ParquetSpec;

public class ParquetInputDialog
extends BaseParquetStepDialog<ParquetInputMeta> {
    private static final int SHELL_WIDTH = 526;
    private static final int SHELL_HEIGHT = 506;
    private static final int PARQUET_PATH_COLUMN_INDEX = 1;
    private static final int FIELD_NAME_COLUMN_INDEX = 2;
    private static final int FIELD_TYPE_COLUMN_INDEX = 3;
    private static final int FORMAT_COLUMN_INDEX = 4;
    private static final int FIELD_SOURCE_TYPE_COLUMN_INDEX = 5;
    private static final String UNABLE_TO_LOAD_SCHEMA_FROM_CONTAINER_FILE = "ParquetInput.Error.UnableToLoadSchemaFromContainerFile";
    private TableView wInputFields;
    private Button wPassThruFields;
    private Button wIgnoreEmptyFolder;

    public ParquetInputDialog(Shell parent, Object in, TransMeta transMeta, String sname) {
        super(parent, (ParquetInputMeta)((Object)in), transMeta, sname);
    }

    @Override
    protected void createUI() {
        Label prev = this.createHeader();
        prev = this.addFileWidgets((Control)prev);
        this.createFooter((Composite)this.shell);
        Label separator = new Label((Composite)this.shell, 258);
        FormData fdSpacer = new FormData();
        fdSpacer.height = 2;
        fdSpacer.left = new FormAttachment(0, 0);
        fdSpacer.bottom = new FormAttachment((Control)this.wCancel, -15);
        fdSpacer.right = new FormAttachment(100, 0);
        separator.setLayoutData((Object)fdSpacer);
        this.wIgnoreEmptyFolder = new Button((Composite)this.shell, 32);
        this.wIgnoreEmptyFolder.setText(BaseMessages.getString((Class)this.parquetStepDialogClass, (String)"ParquetInputDialog.IgnoreEmptyFolder.Label", (String[])new String[0]));
        this.wIgnoreEmptyFolder.setToolTipText(BaseMessages.getString((Class)this.parquetStepDialogClass, (String)"ParquetInputDialog.IgnoreEmptyFolder.Tooltip", (String[])new String[0]));
        this.wIgnoreEmptyFolder.setOrientation(0x2000000);
        this.props.setLook((Control)this.wIgnoreEmptyFolder);
        new BaseParquetStepDialog.FD((Control)this.wIgnoreEmptyFolder).left(0, 0).top((Control)prev, 15).apply();
        Group fieldsContainer = new Group((Composite)this.shell, 4);
        fieldsContainer.setLayout((Layout)new FormLayout());
        fieldsContainer.setText(BaseMessages.getString((Class)this.parquetStepDialogClass, (String)"ParquetInputDialog.Fields.Label", (String[])new String[0]));
        new BaseParquetStepDialog.FD((Control)fieldsContainer).left(0, 0).top((Control)this.wIgnoreEmptyFolder, 15).right(100, 0).bottom((Control)separator, -15).apply();
        this.wPassThruFields = new Button((Composite)fieldsContainer, 32);
        this.wPassThruFields.setText(BaseMessages.getString((Class)this.parquetStepDialogClass, (String)"ParquetInputDialog.PassThruFields.Label", (String[])new String[0]));
        this.wPassThruFields.setToolTipText(BaseMessages.getString((Class)this.parquetStepDialogClass, (String)"ParquetInputDialog.PassThruFields.Tooltip", (String[])new String[0]));
        this.wPassThruFields.setOrientation(0x2000000);
        this.props.setLook((Control)this.wPassThruFields);
        new BaseParquetStepDialog.FD((Control)this.wPassThruFields).left(0, 15).top(0, 15).apply();
        this.lsGet = e -> this.populateFieldsTable();
        Button wGetFields = new Button((Composite)fieldsContainer, 8);
        wGetFields.setText(BaseMessages.getString((Class)this.parquetStepDialogClass, (String)"ParquetInputDialog.Fields.Get", (String[])new String[0]));
        this.props.setLook((Control)wGetFields);
        new BaseParquetStepDialog.FD((Control)wGetFields).bottom(100, -10).right(100, -15).apply();
        wGetFields.addListener(13, this.lsGet);
        ColumnInfo parquetPathColumnInfo = new ColumnInfo(BaseMessages.getString((Class)this.parquetStepDialogClass, (String)"ParquetInputDialog.Fields.column.Path", (String[])new String[0]), 1, false, true);
        ColumnInfo nameColumnInfo = new ColumnInfo(BaseMessages.getString((Class)this.parquetStepDialogClass, (String)"ParquetInputDialog.Fields.column.Name", (String[])new String[0]), 1, false, false);
        ColumnInfo typeColumnInfo = new ColumnInfo(BaseMessages.getString((Class)this.parquetStepDialogClass, (String)"ParquetInputDialog.Fields.column.Type", (String[])new String[0]), 2, ValueMetaFactory.getValueMetaNames());
        ColumnInfo formatColumnInfo = new ColumnInfo(BaseMessages.getString((Class)this.parquetStepDialogClass, (String)"ParquetInputDialog.Fields.column.Format", (String[])new String[0]), 2, Const.getDateFormats());
        ColumnInfo sourceTypeColumnInfo = new ColumnInfo(BaseMessages.getString((Class)this.parquetStepDialogClass, (String)"ParquetInputDialog.Fields.column.SourceType", (String[])new String[0]), 1, ValueMetaFactory.getValueMetaNames(), true);
        ColumnInfo[] parameterColumns = new ColumnInfo[]{parquetPathColumnInfo, nameColumnInfo, typeColumnInfo, formatColumnInfo, sourceTypeColumnInfo};
        parameterColumns[0].setAutoResize(false);
        parameterColumns[1].setUsingVariables(true);
        parameterColumns[3].setAutoResize(false);
        this.wInputFields = new TableView((VariableSpace)this.transMeta, (Composite)fieldsContainer, 68116, parameterColumns, 7, null, this.props);
        ColumnsResizer resizer = new ColumnsResizer(new int[]{0, 40, 20, 20, 20, 0});
        this.wInputFields.getTable().addListener(11, (Listener)resizer);
        this.props.setLook((Control)this.wInputFields);
        new BaseParquetStepDialog.FD((Control)this.wInputFields).left(0, 15).right(100, -15).top((Control)this.wPassThruFields, 10).bottom((Control)wGetFields, -10).apply();
        this.wInputFields.setRowNums();
        this.wInputFields.optWidth(true);
        for (ColumnInfo col : parameterColumns) {
            col.setAutoResize(false);
        }
        resizer.addColumnResizeListeners(this.wInputFields.getTable());
        this.setTruncatedColumn(this.wInputFields.getTable(), 1);
        if (!Const.isWindows()) {
            this.addColumnTooltip(this.wInputFields.getTable(), 1);
        }
    }

    protected void populateFieldsTable() {
        try {
            List<? extends IParquetInputField> inputFields = this.getInputFieldsFromParquetFile(false);
            this.wInputFields.clearAll();
            for (IParquetInputField iParquetInputField : inputFields) {
                TableItem item = new TableItem(this.wInputFields.table, 0);
                if (iParquetInputField == null) continue;
                this.setField(item, this.concatenateParquetNameAndType(iParquetInputField), 1);
                this.setField(item, iParquetInputField.getPentahoFieldName(), 2);
                this.setField(item, ValueMetaFactory.getValueMetaName((int)iParquetInputField.getPentahoType()), 3);
                this.setField(item, iParquetInputField.getStringFormat(), 4);
                this.setField(item, ParquetSpec.DataType.getDataType((int)iParquetInputField.getFormatType()).getName(), 5);
            }
            this.wInputFields.removeEmptyRows();
            this.wInputFields.setRowNums();
            this.wInputFields.optWidth(true);
        }
        catch (Exception ex) {
            this.logError(BaseMessages.getString((Class)this.parquetStepDialogClass, (String)UNABLE_TO_LOAD_SCHEMA_FROM_CONTAINER_FILE, (String[])new String[0]), ex);
            new ErrorDialog(this.shell, this.stepname, BaseMessages.getString((Class)this.parquetStepDialogClass, (String)UNABLE_TO_LOAD_SCHEMA_FROM_CONTAINER_FILE, (String[])new String[]{this.getProcessedFileName()}), ex);
        }
    }

    private String getProcessedFileName() {
        return this.transMeta.environmentSubstitute(this.wPath.getText());
    }

    private List<? extends IParquetInputField> getInputFieldsFromParquetFile(boolean failQuietly) {
        List<? extends IParquetInputField> inputFields;
        block2: {
            String parquetFileName = this.getProcessedFileName();
            inputFields = null;
            try {
                inputFields = ParquetInput.retrieveSchema(((ParquetInputMeta)this.meta).getNamedClusterResolver().getNamedClusterServiceLocator(), ((ParquetInputMeta)this.meta).getNamedClusterResolver().resolveNamedCluster(parquetFileName), parquetFileName);
            }
            catch (Exception ex) {
                if (failQuietly) break block2;
                this.logError(BaseMessages.getString((Class)this.parquetStepDialogClass, (String)UNABLE_TO_LOAD_SCHEMA_FROM_CONTAINER_FILE, (String[])new String[0]), ex);
                new ErrorDialog(this.shell, this.stepname, BaseMessages.getString((Class)this.parquetStepDialogClass, (String)UNABLE_TO_LOAD_SCHEMA_FROM_CONTAINER_FILE, (String[])new String[]{parquetFileName}), ex);
            }
        }
        return inputFields;
    }

    private void setField(TableItem item, String fieldValue, int fieldIndex) {
        if (!Utils.isEmpty((CharSequence)fieldValue)) {
            item.setText(fieldIndex, fieldValue);
        }
    }

    @Override
    protected void getData(ParquetInputMeta meta) {
        if (meta.getFilename() != null && meta.getFilename().length() > 0) {
            this.wPath.setText(meta.getFilename());
        }
        this.wPassThruFields.setSelection(((FormatInputFile)meta.inputFiles).passingThruFields);
        this.wIgnoreEmptyFolder.setSelection(meta.isIgnoreEmptyFolder());
        int itemIndex = 0;
        for (ParquetInputField inputField : meta.getInputFields()) {
            TableItem item = null;
            item = itemIndex < this.wInputFields.table.getItemCount() ? this.wInputFields.table.getItem(itemIndex) : new TableItem(this.wInputFields.table, 0);
            if (inputField.getFormatFieldName() != null) {
                item.setText(1, this.concatenateParquetNameAndType((IParquetInputField)inputField));
            }
            if (inputField.getPentahoFieldName() != null) {
                item.setText(2, inputField.getPentahoFieldName());
            }
            if (this.getTypeDesc(inputField.getPentahoType()) != null) {
                item.setText(3, this.getTypeDesc(inputField.getPentahoType()));
            }
            if (this.getSourceTypeDesc(inputField.getFormatType()) != null) {
                item.setText(5, this.getSourceTypeDesc(inputField.getFormatType()));
            }
            if (inputField.getStringFormat() != null) {
                item.setText(4, inputField.getStringFormat());
            } else {
                item.setText(4, "");
            }
            ++itemIndex;
        }
    }

    public String getTypeDesc(int type) {
        return ValueMetaFactory.getValueMetaName((int)type);
    }

    public String getSourceTypeDesc(int type) {
        return ParquetSpec.DataType.getDataType((int)type).getName();
    }

    @Override
    protected void getInfo(ParquetInputMeta meta, boolean preview) {
        String filePath = this.wPath.getText();
        if (filePath != null && !filePath.isEmpty()) {
            meta.allocateFiles(1);
            meta.setFilename(this.wPath.getText().trim());
        }
        ((FormatInputFile)meta.inputFiles).passingThruFields = this.wPassThruFields.getSelection();
        meta.setIgnoreEmptyFolder(this.wIgnoreEmptyFolder.getSelection());
        List<? extends IParquetInputField> actualParquetFileInputFields = this.getInputFieldsFromParquetFile(true);
        int nrFields = this.wInputFields.nrNonEmpty();
        meta.setInputFields(new ParquetInputField[nrFields]);
        for (int i = 0; i < nrFields; ++i) {
            TableItem item = this.wInputFields.getNonEmpty(i);
            ParquetInputField field = new ParquetInputField();
            field.setFormatFieldName(this.extractFieldName(item.getText(1)));
            if (actualParquetFileInputFields != null) {
                IParquetInputField actualParquetField = actualParquetFileInputFields.stream().filter(x -> field.getFormatFieldName().equals(x.getFormatFieldName())).findFirst().orElse(null);
                if (actualParquetField != null) {
                    field.setFormatType(actualParquetField.getFormatType());
                } else {
                    ParquetSpec.DataType sourceType = this.extractParquetType(item.getText(1));
                    if (sourceType == null) {
                        String uiTypeTrimmed = item.getText(5).trim();
                        for (ParquetSpec.DataType temp : ParquetSpec.DataType.values()) {
                            if (!temp.getName().equalsIgnoreCase(uiTypeTrimmed)) continue;
                            sourceType = temp;
                        }
                    }
                    field.setFormatType(sourceType.getId());
                    item.setText(this.concatenateParquetNameAndType((IParquetInputField)field));
                }
            }
            field.setPentahoFieldName(item.getText(2));
            field.setPentahoType(ValueMetaFactory.getIdForValueMeta((String)item.getText(3)));
            field.setStringFormat(item.getText(4));
            ((ParquetInputField[])meta.inputFields)[i] = field;
        }
    }

    private ParquetSpec.DataType extractParquetType(String parquetNameTypeFromUI) {
        String uiType;
        if (parquetNameTypeFromUI != null && (uiType = StringUtils.substringBetween((String)parquetNameTypeFromUI, (String)"(", (String)")")) != null) {
            String uiTypeTrimmed = uiType.trim();
            for (ParquetSpec.DataType temp : ParquetSpec.DataType.values()) {
                if (!temp.getName().equalsIgnoreCase(uiTypeTrimmed)) continue;
                return temp;
            }
        }
        return null;
    }

    private String extractFieldName(String parquetNameTypeFromUI) {
        if (parquetNameTypeFromUI != null) {
            return StringUtils.substringBefore((String)parquetNameTypeFromUI, (String)"(").trim();
        }
        return parquetNameTypeFromUI;
    }

    private String concatenateParquetNameAndType(IParquetInputField field) {
        ParquetSpec.DataType parquetDataType = ParquetSpec.DataType.getDataType((int)field.getFormatType());
        String typeName = parquetDataType == null ? "unknown" : ParquetSpec.DataType.getDataType((int)field.getFormatType()).getName();
        return field.getFormatFieldName() + " (" + typeName + ")";
    }

    private void doPreview() {
        this.getInfo((ParquetInputMeta)this.meta, true);
        TransMeta previewMeta = TransPreviewFactory.generatePreviewTransformation((VariableSpace)this.transMeta, (StepMetaInterface)((StepMetaInterface)this.meta), (String)this.wStepname.getText());
        this.transMeta.getVariable("Internal.Transformation.Filename.Directory");
        previewMeta.getVariable("Internal.Transformation.Filename.Directory");
        EnterNumberDialog numberDialog = new EnterNumberDialog(this.shell, this.props.getDefaultPreviewSize(), BaseMessages.getString((Class)this.parquetStepDialogClass, (String)"ParquetInputDialog.PreviewSize.DialogTitle", (String[])new String[0]), BaseMessages.getString((Class)this.parquetStepDialogClass, (String)"ParquetInputDialog.PreviewSize.DialogMessage", (String[])new String[0]));
        int previewSize = numberDialog.open();
        if (previewSize > 0) {
            TransPreviewProgressDialog progressDialog = new TransPreviewProgressDialog(this.shell, previewMeta, new String[]{this.wStepname.getText()}, new int[]{previewSize});
            progressDialog.open();
            Trans trans = progressDialog.getTrans();
            String loggingText = progressDialog.getLoggingText();
            if (!progressDialog.isCancelled() && trans.getResult() != null && trans.getResult().getNrErrors() > 0L) {
                EnterTextDialog etd = new EnterTextDialog(this.shell, BaseMessages.getString((Class)this.parquetStepDialogClass, (String)"System.Dialog.PreviewError.Title", (String[])new String[0]), BaseMessages.getString((Class)this.parquetStepDialogClass, (String)"System.Dialog.PreviewError.Message", (String[])new String[0]), loggingText, true);
                etd.setReadOnly();
                etd.open();
            }
            PreviewRowsDialog prd = new PreviewRowsDialog(this.shell, (VariableSpace)this.transMeta, 0, this.wStepname.getText(), progressDialog.getPreviewRowsMeta(this.wStepname.getText()), progressDialog.getPreviewRows(this.wStepname.getText()), loggingText);
            prd.open();
        }
    }

    @Override
    protected int getWidth() {
        return 526;
    }

    @Override
    protected int getHeight() {
        return 506;
    }

    @Override
    protected String getStepTitle() {
        return BaseMessages.getString((Class)this.parquetStepDialogClass, (String)"ParquetInputDialog.Shell.Title", (String[])new String[0]);
    }

    @Override
    protected Listener getPreview() {
        return e -> this.doPreview();
    }

    @Override
    protected SelectionOperation selectionOperation() {
        return SelectionOperation.FILE_OR_FOLDER;
    }
}

