/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.formats.impl.output;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileAlreadyExistsException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.AliasedFileObject;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.hadoop.shim.api.format.IPvfsAliasGenerator;

public class PvfsFileAliaser {
    private String finalFilePath;
    private String temporaryFilePath;
    private VariableSpace variableSpace;
    private IPvfsAliasGenerator aliasGenerator;
    private boolean isOverwriteOutput;
    private LogChannelInterface log;

    public PvfsFileAliaser(String finalFilePath, VariableSpace variableSpace, IPvfsAliasGenerator aliasGenerator, boolean isOverwriteOutput, LogChannelInterface log) {
        this.finalFilePath = finalFilePath;
        this.variableSpace = variableSpace;
        this.aliasGenerator = aliasGenerator;
        this.isOverwriteOutput = isOverwriteOutput;
        this.log = log;
    }

    public String generateAlias() throws KettleFileException, FileSystemException, FileAlreadyExistsException {
        FileObject pvfsFileObject = KettleVFS.getFileObject((String)this.finalFilePath, (VariableSpace)this.variableSpace);
        if (AliasedFileObject.isAliasedFile((FileObject)pvfsFileObject)) {
            this.finalFilePath = ((AliasedFileObject)pvfsFileObject).getOriginalURIString();
        }
        String aliasedFile = this.aliasGenerator.generateAlias(this.finalFilePath);
        this.temporaryFilePath = this.finalFilePath;
        if (aliasedFile != null) {
            if (pvfsFileObject.exists()) {
                if (this.isOverwriteOutput) {
                    pvfsFileObject.delete();
                } else {
                    throw new FileAlreadyExistsException(this.temporaryFilePath);
                }
            }
            this.temporaryFilePath = aliasedFile;
        }
        return this.temporaryFilePath;
    }

    public void copyFileToFinalDestination() throws KettleFileException, IOException {
        if (this.aliasingIsActive()) {
            FileObject srcFile = KettleVFS.getFileObject((String)this.temporaryFilePath, (VariableSpace)this.variableSpace);
            FileObject destFile = KettleVFS.getFileObject((String)this.finalFilePath, (VariableSpace)this.variableSpace);
            try (InputStream in = KettleVFS.getInputStream((FileObject)srcFile);
                 OutputStream out = KettleVFS.getOutputStream((FileObject)destFile, (boolean)false);){
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
        }
    }

    public void deleteTempFileAndFolder() {
        try {
            if (this.aliasingIsActive()) {
                FileObject srcFile = KettleVFS.getFileObject((String)this.temporaryFilePath, (VariableSpace)this.variableSpace);
                srcFile.getParent().deleteAll();
            }
        }
        catch (FileSystemException | KettleFileException e) {
            this.log.logError(e.getMessage(), e);
        }
    }

    private boolean aliasingIsActive() {
        return !this.finalFilePath.equals(this.temporaryFilePath) && this.temporaryFilePath != null && !this.s3nSwitchedTos3a();
    }

    private boolean s3nSwitchedTos3a() {
        return this.finalFilePath != null && this.temporaryFilePath != null && this.finalFilePath.startsWith("s3n") && this.temporaryFilePath.startsWith("s3a");
    }
}

