/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.formats.impl.orc.output;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.pentaho.big.data.kettle.plugins.formats.impl.NullableValuesEnum;
import org.pentaho.big.data.kettle.plugins.formats.impl.orc.BaseOrcStepDialog;
import org.pentaho.big.data.kettle.plugins.formats.impl.orc.output.OrcOutputMeta;
import org.pentaho.big.data.kettle.plugins.formats.orc.OrcTypeConverter;
import org.pentaho.big.data.kettle.plugins.formats.orc.output.OrcOutputField;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.events.dialog.SelectionOperation;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.ColumnsResizer;
import org.pentaho.di.ui.core.widget.ComboVar;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.trans.step.TableItemInsertListener;
import org.pentaho.hadoop.shim.api.format.OrcSpec;

public class OrcOutputDialog
extends BaseOrcStepDialog<OrcOutputMeta>
implements StepDialogInterface {
    private static final Class<?> PKG = OrcOutputMeta.class;
    private static final int SHELL_WIDTH = 698;
    private static final int SHELL_HEIGHT = 554;
    private ComboVar wCompression;
    private TextVar wStripeSize;
    private TextVar wCompressSize;
    private Button wInlineIndexes;
    private TextVar wRowsBetweenEntries;
    private Button wDateInFileName;
    private Button wTimeInFileName;
    private Button wOverwriteExistingFile;
    private Button wSpecifyDateTimeFormat;
    private ComboVar wDateTimeFormat;
    private int startingRowsBetweenEntries = 10000;
    private TableView wOutputFields;

    public OrcOutputDialog(Shell parent, Object orcOutputMeta, TransMeta transMeta, String sname) {
        this(parent, (OrcOutputMeta)((Object)orcOutputMeta), transMeta, sname);
    }

    public OrcOutputDialog(Shell parent, OrcOutputMeta orcOutputMeta, TransMeta transMeta, String sname) {
        super(parent, orcOutputMeta, transMeta, sname);
        this.meta = orcOutputMeta;
    }

    @Override
    protected void createUI() {
        Label prev = this.createHeader();
        prev = this.addFileWidgets((Control)prev);
        this.createFooter((Composite)this.shell);
        Label separator = new Label((Composite)this.shell, 258);
        FormData fdSpacer = new FormData();
        fdSpacer.height = 2;
        fdSpacer.left = new FormAttachment(0, 0);
        fdSpacer.bottom = new FormAttachment((Control)this.wCancel, -15);
        fdSpacer.right = new FormAttachment(100, 0);
        separator.setLayoutData((Object)fdSpacer);
        Composite tabContainer = new Composite((Composite)this.shell, 0);
        tabContainer.setLayout((Layout)new FormLayout());
        new BaseOrcStepDialog.FD((Control)tabContainer).left(0, 0).top((Control)prev, 0).right(100, 0).bottom((Control)separator, -15).apply();
        this.wOverwriteExistingFile = new Button(tabContainer, 32);
        this.wOverwriteExistingFile.setText(BaseMessages.getString(PKG, (String)"OrcOutputDialog.OverwriteFile.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wOverwriteExistingFile);
        new BaseOrcStepDialog.FD((Control)this.wOverwriteExistingFile).left(0, 0).top((Control)tabContainer, 10).apply();
        this.wOverwriteExistingFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((OrcOutputMeta)OrcOutputDialog.this.meta).setChanged();
            }
        });
        CTabFolder wTabFolder = new CTabFolder(tabContainer, 2048);
        this.props.setLook((Control)wTabFolder, 5);
        wTabFolder.setSimple(false);
        this.addFieldsTab(wTabFolder);
        this.addOptionsTab(wTabFolder);
        new BaseOrcStepDialog.FD((Control)wTabFolder).left(0, 0).top((Control)this.wOverwriteExistingFile, 15).right(100, 0).bottom(100, 0).apply();
        wTabFolder.setSelection(0);
    }

    @Override
    protected String getStepTitle() {
        return BaseMessages.getString(PKG, (String)"OrcOutputDialog.Shell.Title", (String[])new String[0]);
    }

    private void addFieldsTab(CTabFolder wTabFolder) {
        CTabItem wTab = new CTabItem(wTabFolder, 0);
        wTab.setText(BaseMessages.getString(PKG, (String)"OrcOutputDialog.FieldsTab.TabTitle", (String[])new String[0]));
        Composite wComp = new Composite((Composite)wTabFolder, 0);
        this.props.setLook((Control)wComp);
        FormLayout layout = new FormLayout();
        layout.marginWidth = 15;
        layout.marginHeight = 15;
        wComp.setLayout((Layout)layout);
        this.lsGet = e -> this.getFields();
        Button wGetFields = new Button(wComp, 8);
        wGetFields.setText(BaseMessages.getString(PKG, (String)"OrcOutputDialog.Fields.Get", (String[])new String[0]));
        this.props.setLook((Control)wGetFields);
        new BaseOrcStepDialog.FD((Control)wGetFields).bottom(100, 0).right(100, 0).apply();
        wGetFields.addListener(13, this.lsGet);
        ColumnInfo[] parameterColumns = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"OrcOutputDialog.Fields.column.Path", (String[])new String[0]), 1, false, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"OrcOutputDialog.Fields.column.Name", (String[])new String[0]), 1, false, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"OrcOutputDialog.Fields.column.Type", (String[])new String[0]), 2, OrcSpec.DataType.getDisplayableTypeNames()), new ColumnInfo(BaseMessages.getString(PKG, (String)"OrcOutputDialog.Fields.column.Precision", (String[])new String[0]), 1, false, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"OrcOutputDialog.Fields.column.Scale", (String[])new String[0]), 1, false, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"OrcOutputDialog.Fields.column.Default", (String[])new String[0]), 1, false, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"OrcOutputDialog.Fields.column.Null", (String[])new String[0]), 2, NullableValuesEnum.getValuesArr(), true)};
        parameterColumns[0].setAutoResize(false);
        parameterColumns[1].setUsingVariables(true);
        this.wOutputFields = new TableView((VariableSpace)this.transMeta, wComp, 68116, parameterColumns, 7, this.lsMod, this.props);
        ColumnsResizer resizer = new ColumnsResizer(new int[]{0, 30, 20, 10, 10, 10, 15, 5});
        this.wOutputFields.getTable().addListener(11, (Listener)resizer);
        this.props.setLook((Control)this.wOutputFields);
        new BaseOrcStepDialog.FD((Control)this.wOutputFields).left(0, 0).right(100, 0).top((Control)wComp, 0).bottom((Control)wGetFields, -10).apply();
        this.wOutputFields.setRowNums();
        this.wOutputFields.optWidth(true);
        new BaseOrcStepDialog.FD((Control)wComp).left(0, 0).top(0, 0).right(100, 0).bottom(100, 0).apply();
        wTab.setControl((Control)wComp);
        for (ColumnInfo col : parameterColumns) {
            col.setAutoResize(false);
        }
        resizer.addColumnResizeListeners(this.wOutputFields.getTable());
        this.setTruncatedColumn(this.wOutputFields.getTable(), 1);
        if (!Const.isWindows()) {
            this.addColumnTooltip(this.wOutputFields.getTable(), 1);
        }
    }

    private void addOptionsTab(CTabFolder wTabFolder) {
        CTabItem wTab = new CTabItem(wTabFolder, 0);
        wTab.setText(BaseMessages.getString(PKG, (String)"OrcOutputDialog.Options.TabTitle", (String[])new String[0]));
        Composite wGrid = new Composite((Composite)wTabFolder, 0);
        wTab.setControl((Control)wGrid);
        this.props.setLook((Control)wGrid);
        FormLayout formLayout = new FormLayout();
        formLayout.marginHeight = 15;
        formLayout.marginWidth = 15;
        wGrid.setLayout((Layout)formLayout);
        Label wLabel = this.createLabel(wGrid, "OrcOutputDialog.Options.Compression");
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 0);
        wLabel.setLayoutData((Object)formData);
        this.wCompression = this.createComboVar(wGrid, ((OrcOutputMeta)this.meta).getCompressionTypes());
        formData = new FormData();
        formData.top = new FormAttachment((Control)wLabel, 5);
        formData.width = 150 + VAR_EXTRA_WIDTH;
        this.wCompression.setLayoutData((Object)formData);
        this.props.setLook((Control)this.wCompression);
        wLabel = this.createLabel(wGrid, "OrcOutputDialog.Options.StripeSize");
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.wCompression, 10);
        wLabel.setLayoutData((Object)formData);
        this.wStripeSize = new TextVar((VariableSpace)this.transMeta, wGrid, 18436);
        this.props.setLook((Control)this.wStripeSize);
        formData = new FormData();
        formData.top = new FormAttachment((Control)wLabel, 5);
        formData.width = 150 + VAR_EXTRA_WIDTH;
        this.wStripeSize.setLayoutData((Object)formData);
        this.setIntegerOnly(this.wStripeSize);
        this.wStripeSize.addModifyListener(this.lsMod);
        wLabel = this.createLabel(wGrid, "OrcOutputDialog.Options.CompressSize");
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.wStripeSize, 10);
        wLabel.setLayoutData((Object)formData);
        this.wCompressSize = new TextVar((VariableSpace)this.transMeta, wGrid, 18436);
        this.props.setLook((Control)this.wCompressSize);
        formData = new FormData();
        formData.top = new FormAttachment((Control)wLabel, 5);
        formData.width = 150 + VAR_EXTRA_WIDTH;
        this.wCompressSize.setLayoutData((Object)formData);
        this.wCompressSize.getTextWidget().addModifyListener(this.lsMod);
        this.setIntegerOnly(this.wCompressSize);
        this.wCompressSize.addModifyListener(this.lsMod);
        this.wInlineIndexes = new Button(wGrid, 32);
        this.props.setLook((Control)this.wInlineIndexes);
        this.wInlineIndexes.setText(BaseMessages.getString(PKG, (String)"OrcOutputDialog.Options.InlineIndexes", (String[])new String[0]));
        formData = new FormData();
        formData.top = new FormAttachment(0, 0);
        formData.left = new FormAttachment((Control)this.wCompressSize, 50);
        this.wInlineIndexes.setLayoutData((Object)formData);
        this.wInlineIndexes.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((OrcOutputMeta)OrcOutputDialog.this.meta).setChanged();
                boolean isSelected = OrcOutputDialog.this.wInlineIndexes.getSelection();
                if (isSelected) {
                    OrcOutputDialog.this.wRowsBetweenEntries.setEnabled(true);
                    OrcOutputDialog.this.wRowsBetweenEntries.setText(Integer.toString(OrcOutputDialog.this.startingRowsBetweenEntries));
                } else {
                    OrcOutputDialog.this.wRowsBetweenEntries.setEnabled(false);
                    OrcOutputDialog.this.wRowsBetweenEntries.setText("");
                }
            }
        });
        wLabel = this.createLabel(wGrid, "OrcOutputDialog.Options.RowsBetweenEntries");
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.wInlineIndexes, 10);
        formData.left = new FormAttachment((Control)this.wCompressSize, 70);
        wLabel.setLayoutData((Object)formData);
        this.wRowsBetweenEntries = new TextVar((VariableSpace)this.transMeta, wGrid, 18436);
        this.props.setLook((Control)this.wRowsBetweenEntries);
        formData = new FormData();
        formData.top = new FormAttachment((Control)wLabel, 5);
        formData.left = new FormAttachment((Control)this.wCompressSize, 70);
        formData.width = 150 + VAR_EXTRA_WIDTH;
        this.wRowsBetweenEntries.setLayoutData((Object)formData);
        this.setIntegerOnly(this.wRowsBetweenEntries);
        this.wRowsBetweenEntries.addModifyListener(this.lsMod);
        this.wDateInFileName = new Button(wGrid, 32);
        this.props.setLook((Control)this.wDateInFileName);
        this.wDateInFileName.setText(BaseMessages.getString(PKG, (String)"OrcOutputDialog.Options.DateInFileName", (String[])new String[0]));
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.wRowsBetweenEntries, 10);
        formData.left = new FormAttachment((Control)this.wCompressSize, 50);
        this.wDateInFileName.setLayoutData((Object)formData);
        this.wDateInFileName.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((OrcOutputMeta)OrcOutputDialog.this.meta).setChanged();
                boolean isSelected = OrcOutputDialog.this.wDateInFileName.getSelection();
                if (isSelected) {
                    OrcOutputDialog.this.wSpecifyDateTimeFormat.setSelection(false);
                    OrcOutputDialog.this.wDateTimeFormat.setText("");
                    OrcOutputDialog.this.wDateTimeFormat.setEnabled(false);
                }
            }
        });
        this.wTimeInFileName = new Button(wGrid, 32);
        this.props.setLook((Control)this.wTimeInFileName);
        this.wTimeInFileName.setText(BaseMessages.getString(PKG, (String)"OrcOutputDialog.Options.TimeInFileName", (String[])new String[0]));
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.wDateInFileName, 10);
        formData.left = new FormAttachment((Control)this.wCompressSize, 50);
        this.wTimeInFileName.setLayoutData((Object)formData);
        this.wTimeInFileName.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((OrcOutputMeta)OrcOutputDialog.this.meta).setChanged();
                boolean isSelected = OrcOutputDialog.this.wTimeInFileName.getSelection();
                if (isSelected) {
                    OrcOutputDialog.this.wSpecifyDateTimeFormat.setSelection(false);
                    OrcOutputDialog.this.wDateTimeFormat.setText("");
                    OrcOutputDialog.this.wDateTimeFormat.setEnabled(false);
                }
            }
        });
        this.wSpecifyDateTimeFormat = new Button(wGrid, 32);
        this.wSpecifyDateTimeFormat.setText(BaseMessages.getString(PKG, (String)"OrcOutputDialog.Options.SpecifyDateTimeFormat", (String[])new String[0]));
        this.props.setLook((Control)this.wSpecifyDateTimeFormat);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.wTimeInFileName, 10);
        formData.left = new FormAttachment((Control)this.wCompressSize, 50);
        this.wSpecifyDateTimeFormat.setLayoutData((Object)formData);
        this.wSpecifyDateTimeFormat.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((OrcOutputMeta)OrcOutputDialog.this.meta).setChanged();
                boolean isSelected = OrcOutputDialog.this.wSpecifyDateTimeFormat.getSelection();
                OrcOutputDialog.this.wDateTimeFormat.setEnabled(isSelected);
                if (!isSelected) {
                    OrcOutputDialog.this.wDateTimeFormat.setText("");
                    OrcOutputDialog.this.wTimeInFileName.setEnabled(true);
                    OrcOutputDialog.this.wDateInFileName.setEnabled(true);
                } else {
                    OrcOutputDialog.this.wTimeInFileName.setSelection(false);
                    OrcOutputDialog.this.wDateInFileName.setSelection(false);
                    OrcOutputDialog.this.wTimeInFileName.setEnabled(false);
                    OrcOutputDialog.this.wDateInFileName.setEnabled(false);
                }
            }
        });
        String[] dates = Const.getDateFormats();
        dates = (String[])Arrays.stream(dates).filter(d -> d.indexOf(47) < 0 && d.indexOf(92) < 0 && d.indexOf(58) < 0).toArray(String[]::new);
        this.wDateTimeFormat = this.createComboVar(wGrid, dates);
        this.props.setLook((Control)this.wDateTimeFormat);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.wSpecifyDateTimeFormat, 5);
        formData.left = new FormAttachment((Control)this.wCompressSize, 70);
        this.wDateTimeFormat.setLayoutData((Object)formData);
    }

    protected ComboVar createComboVar(Composite container, String[] options) {
        ComboVar combo = new ComboVar((VariableSpace)this.transMeta, container, 18432);
        combo.setItems(options);
        combo.addModifyListener(this.lsMod);
        return combo;
    }

    protected String getComboVarValue(ComboVar combo) {
        String text = combo.getText();
        String data = (String)combo.getData(text);
        return data != null ? data : text;
    }

    private Label createLabel(Composite container, String labelRef) {
        Label label = new Label(container, 0);
        label.setText(BaseMessages.getString(PKG, (String)labelRef, (String[])new String[0]));
        this.props.setLook((Control)label);
        return label;
    }

    @Override
    protected void ok() {
        if (Utils.isEmpty((CharSequence)this.wStepname.getText())) {
            return;
        }
        this.stepname = this.wStepname.getText();
        List<String> validationErrorFields = this.validateOutputFields(this.wOutputFields);
        if (validationErrorFields != null && !validationErrorFields.isEmpty()) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"OrcOutput.MissingDefaultFields.Title", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"OrcOutput.MissingDefaultFields.Msg", (String[])new String[0]));
            mb.open();
            return;
        }
        this.getInfo((OrcOutputMeta)this.meta, false);
        this.dispose();
    }

    @Override
    protected void getData(OrcOutputMeta meta) {
        if (meta.getFilename() != null) {
            this.wPath.setText(meta.getFilename());
        }
        this.wOverwriteExistingFile.setSelection(meta.isOverrideOutput());
        this.populateFieldsUI(meta, this.wOutputFields);
        this.wCompression.setText(meta.getCompressionType());
        this.wCompressSize.setText(meta.getCompressSize() > 0 ? Integer.toString(meta.getCompressSize()) : Integer.toString(256));
        int rowsBetweenEntries = meta.getRowsBetweenEntries();
        if (rowsBetweenEntries != 0) {
            this.startingRowsBetweenEntries = rowsBetweenEntries;
            this.wInlineIndexes.setSelection(true);
            this.wRowsBetweenEntries.setText(Integer.toString(rowsBetweenEntries));
            this.wRowsBetweenEntries.setEnabled(true);
        } else {
            this.startingRowsBetweenEntries = 10000;
            this.wInlineIndexes.setSelection(false);
            this.wRowsBetweenEntries.setText("");
            this.wRowsBetweenEntries.setEnabled(false);
        }
        this.wStripeSize.setText(Integer.toString(meta.getStripeSize()));
        String dateTimeFormat = this.coalesce(meta.getDateTimeFormat());
        if (!dateTimeFormat.isEmpty()) {
            this.wTimeInFileName.setSelection(false);
            this.wDateInFileName.setSelection(false);
            this.wTimeInFileName.setEnabled(false);
            this.wDateInFileName.setEnabled(false);
            this.wSpecifyDateTimeFormat.setSelection(true);
            this.wDateTimeFormat.setText(dateTimeFormat);
            this.wDateTimeFormat.setEnabled(true);
        } else {
            this.wTimeInFileName.setEnabled(true);
            this.wDateInFileName.setEnabled(true);
            this.wTimeInFileName.setSelection(meta.isTimeInFileName());
            this.wDateInFileName.setSelection(meta.isDateInFileName());
            this.wSpecifyDateTimeFormat.setSelection(false);
            this.wDateTimeFormat.setEnabled(false);
            this.wDateTimeFormat.setText("");
        }
    }

    @Override
    protected void getInfo(OrcOutputMeta meta, boolean preview) {
        meta.setFilename(this.wPath.getText());
        meta.setOverrideOutput(this.wOverwriteExistingFile.getSelection());
        meta.setCompressionType(this.wCompression.getText());
        int compressSize = this.wCompressSize.getText().length() > 0 ? Integer.parseInt(this.wCompressSize.getText()) : 256;
        meta.setCompressSize(compressSize);
        int stripeSize = this.wStripeSize.getText().length() > 0 ? Integer.parseInt(this.wStripeSize.getText()) : 64;
        meta.setStripeSize(stripeSize);
        int rowsBetweenEntries = this.wRowsBetweenEntries.getText().length() > 0 ? Integer.parseInt(this.wRowsBetweenEntries.getText()) : 0;
        meta.setRowsBetweenEntries(rowsBetweenEntries);
        if (this.wSpecifyDateTimeFormat.getSelection()) {
            meta.setTimeInFileName(false);
            meta.setDateInFileName(false);
            meta.setDateTimeFormat(this.wDateTimeFormat.getText().trim());
        } else {
            meta.setTimeInFileName(this.wTimeInFileName.getSelection());
            meta.setDateInFileName(this.wDateInFileName.getSelection());
            meta.setDateTimeFormat("");
        }
        this.saveOutputFields(this.wOutputFields, meta);
    }

    private void saveOutputFields(TableView wFields, OrcOutputMeta meta) {
        int nrFields = wFields.nrNonEmpty();
        ArrayList<OrcOutputField> outputFields = new ArrayList<OrcOutputField>();
        for (int i = 0; i < nrFields; ++i) {
            TableItem item = wFields.getNonEmpty(i);
            int j = 1;
            OrcOutputField field = new OrcOutputField();
            field.setFormatFieldName(item.getText(j++));
            field.setPentahoFieldName(item.getText(j++));
            field.setFormatType(item.getText(j++));
            if (field.getOrcType().equals((Object)OrcSpec.DataType.DECIMAL)) {
                field.setPrecision(item.getText(j++));
                field.setScale(item.getText(j++));
            } else if (field.getOrcType().equals((Object)OrcSpec.DataType.FLOAT) || field.getOrcType().equals((Object)OrcSpec.DataType.DOUBLE)) {
                int n = ++j;
                field.setScale(item.getText(n));
            } else {
                j += 2;
            }
            int n = ++j;
            field.setDefaultValue(item.getText(n));
            int n2 = ++j;
            ++j;
            field.setAllowNull(this.getNullableValue(item.getText(n2)));
            outputFields.add(field);
        }
        meta.setOutputFields(outputFields);
    }

    private List<String> validateOutputFields(TableView wFields) {
        int nrFields = wFields.nrNonEmpty();
        ArrayList<String> validationErrorFields = new ArrayList<String>();
        for (int i = 0; i < nrFields; ++i) {
            String nullString;
            String scale;
            String precision;
            TableItem item = wFields.getNonEmpty(i);
            int j = 1;
            String path = item.getText(j++);
            String name = item.getText(j++);
            String type = item.getText(j++);
            if ((precision = item.getText(j++)) == null || precision.trim().isEmpty()) {
                item.setText(4, Integer.toString(20));
            }
            if ((scale = item.getText(j++)) == null || scale.trim().isEmpty()) {
                item.setText(5, Integer.toString(10));
            }
            String defaultValue = item.getText(j++);
            if (!(nullString = this.getNullableValue(item.getText(j++))).equals(NullableValuesEnum.NO.getValue()) || defaultValue != null && !defaultValue.trim().isEmpty()) continue;
            validationErrorFields.add(name);
        }
        return validationErrorFields;
    }

    private String getNullableValue(String nullString) {
        return nullString != null && !nullString.isEmpty() ? nullString : NullableValuesEnum.getDefaultValue().getValue();
    }

    private void populateFieldsUI(OrcOutputMeta meta, TableView wOutputFields) {
        this.populateFieldsUI(meta.getOutputFields(), wOutputFields, (field, item) -> {
            int i = 1;
            item.setText(i++, this.coalesce(field.getFormatFieldName()));
            item.setText(i++, this.coalesce(field.getPentahoFieldName()));
            item.setText(i++, this.coalesce(field.getOrcType().getName()));
            if (field.getOrcType().equals((Object)OrcSpec.DataType.DECIMAL)) {
                item.setText(i++, this.coalesce(String.valueOf(field.getPrecision())));
                item.setText(i++, this.coalesce(String.valueOf(field.getScale())));
            } else if (field.getOrcType().equals((Object)OrcSpec.DataType.FLOAT) || field.getOrcType().equals((Object)OrcSpec.DataType.DOUBLE)) {
                int n = ++i;
                ++i;
                item.setText(n, field.getScale() > 0 ? String.valueOf(field.getScale()) : "");
            } else {
                i += 2;
            }
            item.setText(i++, this.coalesce(field.getDefaultValue()));
            item.setText(i++, field.getAllowNull() ? NullableValuesEnum.YES.getValue() : NullableValuesEnum.NO.getValue());
        });
    }

    private String coalesce(String value) {
        return value == null ? "" : value;
    }

    private void populateFieldsUI(List<OrcOutputField> fields, TableView wFields, BiConsumer<OrcOutputField, TableItem> converter) {
        int nrFields = fields.size();
        for (int i = 0; i < nrFields; ++i) {
            TableItem item = null;
            item = i < wFields.table.getItemCount() ? wFields.table.getItem(i) : new TableItem(wFields.table, 0);
            converter.accept(fields.get(i), item);
        }
    }

    protected void getFields() {
        try {
            RowMetaInterface r = this.transMeta.getPrevStepFields(this.stepname);
            if (r != null) {
                TableItemInsertListener listener = (tableItem, v) -> true;
                this.getFieldsFromPreviousStep(r, this.wOutputFields, 1, new int[]{1, 2}, new int[]{3}, 4, 5, true, listener);
            }
        }
        catch (KettleException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private MessageDialog getFieldsChoiceDialog(Shell shell, int existingFields, int newFields) {
        MessageDialog messageDialog = new MessageDialog(shell, BaseMessages.getString(PKG, (String)"OrcOutputDialog.GetFieldsChoice.Title", (String[])new String[0]), null, BaseMessages.getString(PKG, (String)"OrcOutputDialog.GetFieldsChoice.Message", (String[])new String[]{"" + existingFields, "" + newFields}), 4, new String[]{BaseMessages.getString(PKG, (String)"OrcOutputDialog.AddNew", (String[])new String[0]), BaseMessages.getString(PKG, (String)"OrcOutputDialog.Add", (String[])new String[0]), BaseMessages.getString(PKG, (String)"OrcOutputDialog.ClearAndAdd", (String[])new String[0]), BaseMessages.getString(PKG, (String)"OrcOutputDialog.Cancel", (String[])new String[0])}, 0);
        MessageDialog.setDefaultImage((Image)GUIResource.getInstance().getImageSpoon());
        return messageDialog;
    }

    private void getFieldsFromPreviousStep(RowMetaInterface row, TableView tableView, int keyColumn, int[] nameColumn, int[] dataTypeColumn, int lengthColumn, int precisionColumn, boolean optimizeWidth, TableItemInsertListener listener) {
        if (row == null || row.size() == 0) {
            return;
        }
        Table table = tableView.table;
        ArrayList<String> keys = new ArrayList<String>();
        for (int i = 0; i < table.getItemCount(); ++i) {
            TableItem tableItem = table.getItem(i);
            String key = tableItem.getText(keyColumn);
            if (Utils.isEmpty((CharSequence)key) || keys.indexOf(key) >= 0) continue;
            keys.add(key);
        }
        int choice = 0;
        if (!keys.isEmpty()) {
            MessageDialog getFieldsChoiceDialog = this.getFieldsChoiceDialog(tableView.getShell(), keys.size(), row.size());
            int idx = getFieldsChoiceDialog.open();
            choice = idx & 0xFF;
        }
        if (choice == 3 || choice == 255) {
            return;
        }
        if (choice == 2) {
            tableView.clearAll(false);
        }
        for (int i = 0; i < row.size(); ++i) {
            ValueMetaInterface v = row.getValueMeta(i);
            boolean add = true;
            if (choice == 0 && keys.indexOf(v.getName()) >= 0) {
                add = false;
            }
            if (!add) continue;
            TableItem tableItem = new TableItem(table, 0);
            for (int c = 0; c < nameColumn.length; ++c) {
                tableItem.setText(nameColumn[c], Const.NVL((String)v.getName(), (String)""));
            }
            String orcTypeName = OrcTypeConverter.convertToOrcType((int)v.getType());
            if (dataTypeColumn != null) {
                for (int c = 0; c < dataTypeColumn.length; ++c) {
                    tableItem.setText(dataTypeColumn[c], orcTypeName);
                }
            }
            if (orcTypeName.equals(OrcSpec.DataType.DECIMAL.getName())) {
                if (lengthColumn > 0 && v.getLength() > 0) {
                    tableItem.setText(lengthColumn, Integer.toString(v.getLength()));
                } else {
                    tableItem.setText(lengthColumn, Integer.toString(20));
                }
                if (precisionColumn > 0 && v.getPrecision() >= 0) {
                    tableItem.setText(precisionColumn, Integer.toString(v.getPrecision()));
                } else {
                    tableItem.setText(precisionColumn, Integer.toString(10));
                }
            } else if ((orcTypeName.equals(OrcSpec.DataType.FLOAT.getName()) || orcTypeName.equals(OrcSpec.DataType.DOUBLE.getName())) && precisionColumn > 0 && v.getPrecision() > 0) {
                tableItem.setText(precisionColumn, Integer.toString(v.getPrecision()));
            }
            if (listener == null || listener.tableItemInserted(tableItem, v)) continue;
            tableItem.dispose();
        }
        tableView.removeEmptyRows();
        tableView.setRowNums();
        if (optimizeWidth) {
            tableView.optWidth(true);
        }
    }

    @Override
    protected int getWidth() {
        return 698;
    }

    @Override
    protected int getHeight() {
        return 554;
    }

    @Override
    protected Listener getPreview() {
        return null;
    }

    @Override
    protected SelectionOperation selectionOperation() {
        return SelectionOperation.SAVE_TO_FILE_FOLDER;
    }
}

