/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.formats.impl.avro.output;

import java.io.IOException;
import org.pentaho.big.data.kettle.plugins.formats.avro.output.AvroOutputField;
import org.pentaho.big.data.kettle.plugins.formats.impl.avro.output.AvroOutputData;
import org.pentaho.big.data.kettle.plugins.formats.impl.avro.output.AvroOutputMeta;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.hadoop.shim.api.cluster.ClusterInitializationException;
import org.pentaho.hadoop.shim.api.cluster.NamedCluster;
import org.pentaho.hadoop.shim.api.format.FormatService;
import org.pentaho.hadoop.shim.api.format.IPentahoAvroOutputFormat;

public class AvroOutput
extends BaseStep
implements StepInterface {
    private AvroOutputMeta meta;
    private AvroOutputData data;

    public AvroOutput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public synchronized boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        try {
            Object[] currentRow;
            this.meta = (AvroOutputMeta)smi;
            this.data = (AvroOutputData)sdi;
            if (this.data.output == null) {
                try {
                    this.init();
                }
                catch (UnsupportedOperationException e) {
                    this.getLogChannel().logError(e.getMessage());
                    this.setErrors(1L);
                    this.setOutputDone();
                    return false;
                }
                catch (Exception e) {
                    String error = e.getMessage().replaceAll("TRANS_NAME", this.getTrans().getName());
                    error = error.replaceAll("STEP_NAME", this.getStepname());
                    this.getLogChannel().logError(error);
                    this.setErrors(1L);
                    this.setOutputDone();
                    return false;
                }
            }
            if ((currentRow = this.getRow()) != null) {
                RowMeta outputRMI = new RowMeta();
                Object[] outputData = new Object[this.meta.getOutputFields().size()];
                for (int i = 0; i < this.meta.getOutputFields().size(); ++i) {
                    int inputRowIndex = this.getInputRowMeta().indexOfValue(((AvroOutputField)this.meta.getOutputFields().get(i)).getPentahoFieldName());
                    if (inputRowIndex == -1) {
                        throw new KettleException("Field name [" + ((AvroOutputField)this.meta.getOutputFields().get(i)).getPentahoFieldName() + " ] couldn't be found in the input stream!");
                    }
                    ValueMetaInterface vmi = ValueMetaFactory.cloneValueMeta((ValueMetaInterface)this.getInputRowMeta().getValueMeta(inputRowIndex));
                    outputRMI.addValueMeta(i, vmi);
                    outputData[i] = currentRow[inputRowIndex];
                }
                RowMetaAndData row = new RowMetaAndData((RowMetaInterface)outputRMI, outputData);
                this.data.writer.write(row);
                this.putRow(row.getRowMeta(), row.getData());
                return true;
            }
            this.closeWriter();
            this.setOutputDone();
            return false;
        }
        catch (KettleException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new KettleException((Throwable)ex);
        }
    }

    public void init() throws Exception {
        IPentahoAvroOutputFormat.COMPRESSION compression;
        FormatService formatService;
        if (this.getTransMeta().getNamedClusterEmbedManager() != null) {
            this.getTransMeta().getNamedClusterEmbedManager().passEmbeddedMetastoreKey((VariableSpace)this.getTransMeta(), this.getTransMeta().getEmbeddedMetastoreProviderKey());
        }
        NamedCluster namedCluster = this.getNamedCluster();
        try {
            formatService = (FormatService)this.meta.getNamedClusterResolver().getNamedClusterServiceLocator().getService(namedCluster, FormatService.class);
        }
        catch (ClusterInitializationException e) {
            throw new KettleException("can't get service format shim ", (Throwable)e);
        }
        TransMeta parentTransMeta = this.meta.getParentStepMeta().getParentTransMeta();
        this.data.output = (IPentahoAvroOutputFormat)formatService.createOutputFormat(IPentahoAvroOutputFormat.class, namedCluster);
        this.data.output.setOutputFile(parentTransMeta.environmentSubstitute(this.meta.constructOutputFilename(this.meta.getFilename())), this.meta.isOverrideOutput());
        this.data.output.setFields(this.meta.getOutputFields());
        this.data.output.setVariableSpace((VariableSpace)parentTransMeta);
        try {
            compression = IPentahoAvroOutputFormat.COMPRESSION.valueOf((String)parentTransMeta.environmentSubstitute(this.meta.getCompressionType()).toUpperCase());
        }
        catch (Exception ex) {
            compression = IPentahoAvroOutputFormat.COMPRESSION.UNCOMPRESSED;
        }
        this.data.output.setCompression(compression);
        this.data.output.setNameSpace(parentTransMeta.environmentSubstitute(this.meta.getNamespace()));
        this.data.output.setRecordName(parentTransMeta.environmentSubstitute(this.meta.getRecordName()));
        this.data.output.setDocValue(parentTransMeta.environmentSubstitute(this.meta.getDocValue()));
        if (this.meta.getSchemaFilename() != null && this.meta.getSchemaFilename().length() != 0) {
            this.data.output.setSchemaFilename(parentTransMeta.environmentSubstitute(this.meta.constructOutputFilename(this.meta.getSchemaFilename())));
        }
        this.data.writer = this.data.output.createRecordWriter();
    }

    private NamedCluster getNamedCluster() {
        return this.meta.getNamedClusterResolver().resolveNamedCluster(this.environmentSubstitute(this.meta.getFilename()), this.meta.getParentStepMeta().getParentTransMeta().getEmbeddedMetastoreProviderKey());
    }

    public void closeWriter() throws KettleException {
        try {
            this.data.writer.close();
        }
        catch (IOException e) {
            throw new KettleException((Throwable)e);
        }
        this.data.output = null;
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (AvroOutputMeta)smi;
        this.data = (AvroOutputData)sdi;
        return super.init(smi, sdi);
    }
}

