/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.formats.impl.avro.input;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.pentaho.big.data.kettle.plugins.formats.avro.input.AvroInputField;
import org.pentaho.big.data.kettle.plugins.formats.avro.input.AvroInputMetaBase;
import org.pentaho.big.data.kettle.plugins.formats.avro.input.AvroLookupField;
import org.pentaho.big.data.kettle.plugins.formats.impl.avro.BaseAvroStepDialog;
import org.pentaho.big.data.kettle.plugins.formats.impl.avro.input.AvroInput;
import org.pentaho.big.data.kettle.plugins.formats.impl.avro.input.AvroInputMeta;
import org.pentaho.di.base.AbstractMeta;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.TransPreviewFactory;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.ui.core.FormDataBuilder;
import org.pentaho.di.ui.core.dialog.EnterNumberDialog;
import org.pentaho.di.ui.core.dialog.EnterTextDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.dialog.PreviewRowsDialog;
import org.pentaho.di.ui.core.events.dialog.SelectionAdapterFileDialogTextVar;
import org.pentaho.di.ui.core.events.dialog.SelectionAdapterOptions;
import org.pentaho.di.ui.core.events.dialog.SelectionOperation;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.ColumnsResizer;
import org.pentaho.di.ui.core.widget.ComboVar;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.trans.dialog.TransPreviewProgressDialog;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.hadoop.shim.api.format.IAvroInputField;

public class AvroInputDialog
extends BaseAvroStepDialog {
    private static final Class<?> PKG = AvroInputMeta.class;
    private static final int SHELL_WIDTH = 698;
    private static final int SHELL_HEIGHT = 554;
    private static final int RADIO_BUTTON_WIDTH = 150;
    private static final int AVRO_ORIGINAL_PATH_COLUMN_INDEX = 1;
    private static final int AVRO_DISPLAY_PATH_COLUMN_INDEX = 2;
    private static final int AVRO_TYPE_COLUMN_INDEX = 3;
    private static final int AVRO_INDEXED_VALUES_COLUMN_INDEX = 4;
    private static final int FIELD_NAME_COLUMN_INDEX = 5;
    private static final int FIELD_TYPE_COLUMN_INDEX = 6;
    private static final int FORMAT_COLUMN_INDEX = 7;
    private TableView wInputFields;
    protected Button wbSchemaBrowse;
    protected Composite wSchemaFileComposite;
    protected Composite wSchemaFieldComposite;
    protected Group wSourceGroup;
    Button wbGetSchemaFromFile;
    Button wbGetSchemaFromField;
    ComboVar wSchemaFieldNameCombo;
    private TableView wLookupView;
    private AvroInputMeta meta;
    private Button wPassThruFields;
    private Button wAllowNullValues;
    private TextVar wSchemaPath;

    public AvroInputDialog(Shell parent, Object in, TransMeta transMeta, String sname) {
        super(parent, (BaseStepMeta)((AvroInputMeta)((Object)in)), transMeta, sname);
        this.meta = (AvroInputMeta)((Object)in);
    }

    @Override
    protected Control createAfterFile(Composite afterFile) {
        CTabFolder wTabFolder = new CTabFolder(afterFile, 2048);
        wTabFolder.setSimple(false);
        this.addSourceTab(wTabFolder);
        this.addFieldsTab(wTabFolder);
        this.addLookupFieldsTab(wTabFolder);
        wTabFolder.setLayoutData((Object)new FormDataBuilder().left().top(0, 15).right().bottom().result());
        wTabFolder.setSelection(0);
        return wTabFolder;
    }

    protected void populateNestedFieldsTable() {
        String schemaFileName = this.wSchemaPath.getText();
        schemaFileName = this.transMeta.environmentSubstitute(schemaFileName);
        String avroFileName = this.wPath.getText();
        avroFileName = this.transMeta.environmentSubstitute(avroFileName);
        try {
            List<? extends IAvroInputField> defaultFields = AvroInput.getLeafFields(this.meta.getNamedClusterResolver().getNamedClusterServiceLocator(), this.meta.getNamedClusterResolver().resolveNamedCluster(avroFileName), schemaFileName, avroFileName, (VariableSpace)this.transMeta);
            if (defaultFields != null) {
                this.wInputFields.clearAll();
                for (IAvroInputField iAvroInputField : defaultFields) {
                    TableItem item = new TableItem(this.wInputFields.table, 0);
                    if (iAvroInputField == null) continue;
                    this.setField(item, iAvroInputField.getDisplayableAvroFieldName(), 1);
                    this.setField(item, this.clearIndexFromFieldName(iAvroInputField.getDisplayableAvroFieldName()), 2);
                    this.setField(item, iAvroInputField.getAvroType().getName(), 3);
                    this.setField(item, iAvroInputField.getIndexedValues(), 4);
                    this.setField(item, iAvroInputField.getPentahoFieldName(), 5);
                    this.setField(item, ValueMetaFactory.getValueMetaName((int)iAvroInputField.getPentahoType()), 6);
                    this.setField(item, iAvroInputField.getStringFormat(), 7);
                }
                this.wInputFields.removeEmptyRows();
                this.wInputFields.setRowNums();
                this.wInputFields.optWidth(true);
            }
        }
        catch (Exception ex) {
            this.logError(BaseMessages.getString(PKG, (String)"AvroInput.Error.UnableToLoadSchemaFromContainerFile", (String[])new String[0]), ex);
            new ErrorDialog(this.shell, this.stepname, BaseMessages.getString(PKG, (String)"AvroInput.Error.UnableToLoadSchemaFromContainerFile", (String[])new String[]{avroFileName}), ex);
        }
    }

    private void setField(TableItem item, String fieldValue, int fieldIndex) {
        if (!Utils.isEmpty((CharSequence)fieldValue)) {
            item.setText(fieldIndex, fieldValue);
        }
    }

    private void addLookupFieldsTab(CTabFolder wTabFolder) {
        CTabItem wVarsTab = new CTabItem(wTabFolder, 0);
        wVarsTab.setText(BaseMessages.getString(PKG, (String)"AvroInputDialog.VarsTab.Title", (String[])new String[0]));
        Composite wVarsComp = new Composite((Composite)wTabFolder, 0);
        FormLayout varsLayout = new FormLayout();
        varsLayout.marginWidth = 15;
        varsLayout.marginHeight = 15;
        wVarsComp.setLayout((Layout)varsLayout);
        Button wGetLookupFieldsBut = new Button(wVarsComp, 0x1000008);
        wGetLookupFieldsBut.setText(BaseMessages.getString(PKG, (String)"AvroInputDialog.Button.GetLookupFields", (String[])new String[0]));
        wGetLookupFieldsBut.setLayoutData((Object)new FormDataBuilder().bottom(100, -8).right().result());
        wGetLookupFieldsBut.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AvroInputDialog.this.getIncomingFields();
            }
        });
        ColumnInfo[] colinf2 = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"AvroInputDialog.Fields.LOOKUP_NAME", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"AvroInputDialog.Fields.LOOKUP_VARIABLE", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"AvroInputDialog.Fields.LOOKUP_DEFAULT_VALUE", (String[])new String[0]), 1, false)};
        colinf2[0].setAutoResize(false);
        colinf2[1].setAutoResize(false);
        colinf2[2].setAutoResize(false);
        this.wLookupView = new TableView((VariableSpace)this.transMeta, wVarsComp, 67586, colinf2, 1, this.lsMod, this.props);
        this.wLookupView.setLayoutData((Object)new FormDataBuilder().top(0, 8).bottom((Control)wGetLookupFieldsBut, -8).left().right().result());
        ColumnsResizer resizer = new ColumnsResizer(new int[]{0, 33, 33, 34});
        resizer.addColumnResizeListeners(this.wLookupView.getTable());
        this.wLookupView.getTable().addListener(11, (Listener)resizer);
        this.wLookupView.optWidth(true);
        wVarsTab.setControl((Control)wVarsComp);
    }

    private void getIncomingFields() {
        try {
            RowMetaInterface r = this.transMeta.getPrevStepFields(this.stepname);
            if (r != null) {
                BaseStepDialog.getFieldsFromPrevious((RowMetaInterface)r, (TableView)this.wLookupView, (int)1, (int[])new int[]{1}, null, (int)-1, (int)-1, null);
            }
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]), (Exception)((Object)e));
        }
    }

    private void addFieldsTab(CTabFolder wTabFolder) {
        CTabItem wTab = new CTabItem(wTabFolder, 0);
        wTab.setText(BaseMessages.getString(PKG, (String)"AvroInputDialog.FieldsTab.TabTitle", (String[])new String[0]));
        Composite wComp = new Composite((Composite)wTabFolder, 0);
        FormLayout layout = new FormLayout();
        layout.marginWidth = 15;
        layout.marginHeight = 15;
        layout.marginBottom = 15;
        wComp.setLayout((Layout)layout);
        this.lsGet = e -> this.populateNestedFieldsTable();
        Button wGetFields = new Button(wComp, 8);
        wGetFields.setText(BaseMessages.getString(PKG, (String)"AvroInputDialog.Fields.Get", (String[])new String[0]));
        wGetFields.setLayoutData((Object)new FormDataBuilder().bottom().right().result());
        wGetFields.addListener(13, this.lsGet);
        ColumnInfo avroOriginalPathColumnInfo = new ColumnInfo("Original Avro Path", 1, false, true);
        ColumnInfo avroDisplayPathColumnInfo = new ColumnInfo(BaseMessages.getString(PKG, (String)"AvroInputDialog.Fields.column.Path", (String[])new String[0]), 0, false, true);
        ColumnInfo avroTypeColumnInfo = new ColumnInfo(BaseMessages.getString(PKG, (String)"AvroInputDialog.Fields.column.avro.type", (String[])new String[0]), 1, false, true);
        ColumnInfo avroIndexColumnInfo = new ColumnInfo(BaseMessages.getString(PKG, (String)"AvroInputDialog.Fields.column.avro.indexedValues", (String[])new String[0]), 1, false, false);
        ColumnInfo nameColumnInfo = new ColumnInfo(BaseMessages.getString(PKG, (String)"AvroInputDialog.Fields.column.Name", (String[])new String[0]), 1, false, false);
        ColumnInfo typeColumnInfo = new ColumnInfo(BaseMessages.getString(PKG, (String)"AvroInputDialog.Fields.column.Type", (String[])new String[0]), 2, ValueMetaFactory.getValueMetaNames());
        ColumnInfo formatColumnInfo = new ColumnInfo(BaseMessages.getString(PKG, (String)"AvroInputDialog.Fields.column.Format", (String[])new String[0]), 2, Const.getDateFormats());
        ColumnInfo[] parameterColumns = new ColumnInfo[]{avroOriginalPathColumnInfo, avroDisplayPathColumnInfo, avroTypeColumnInfo, avroIndexColumnInfo, nameColumnInfo, typeColumnInfo, formatColumnInfo};
        parameterColumns[1].setAutoResize(false);
        parameterColumns[3].setAutoResize(false);
        parameterColumns[4].setUsingVariables(true);
        parameterColumns[6].setAutoResize(false);
        this.wInputFields = new TableView((VariableSpace)this.transMeta, wComp, 68116, parameterColumns, 8, null, this.props);
        ColumnsResizer resizer = new ColumnsResizer(new int[]{0, 0, 20, 15, 15, 20, 15, 15});
        this.wInputFields.getTable().addListener(11, (Listener)resizer);
        this.wInputFields.setLayoutData((Object)new FormDataBuilder().left().right().top(0, 8).bottom((Control)wGetFields, -10).result());
        this.wInputFields.setRowNums();
        this.wInputFields.optWidth(true);
        this.wPassThruFields = new Button(wComp, 32);
        this.wPassThruFields.setText(BaseMessages.getString(PKG, (String)"AvroInputDialog.PassThruFields.Label", (String[])new String[0]));
        this.wPassThruFields.setToolTipText(BaseMessages.getString(PKG, (String)"AvroInputDialog.PassThruFields.Tooltip", (String[])new String[0]));
        this.wPassThruFields.setOrientation(0x2000000);
        this.wPassThruFields.setLayoutData((Object)new FormDataBuilder().left().top((Control)this.wInputFields, 10).result());
        this.wAllowNullValues = new Button(wComp, 32);
        this.wAllowNullValues.setText(BaseMessages.getString(PKG, (String)"AvroInputDialog.AllowNullValues.Label", (String[])new String[0]));
        this.wAllowNullValues.setOrientation(0x2000000);
        this.wAllowNullValues.setLayoutData((Object)new FormDataBuilder().left().top((Control)this.wPassThruFields, 5).result());
        wComp.setLayoutData((Object)new FormDataBuilder().left().top().right().bottom().result());
        wTab.setControl((Control)wComp);
        for (ColumnInfo col : parameterColumns) {
            col.setAutoResize(false);
        }
        resizer.addColumnResizeListeners(this.wInputFields.getTable());
        this.setTruncatedColumn(this.wInputFields.getTable(), 1);
        if (!Const.isWindows()) {
            this.addColumnTooltip(this.wInputFields.getTable(), 1);
        }
        this.wInputFields.getColumns()[4].setAutoResize(true);
    }

    protected void addSourceTab(CTabFolder wTabFolder) {
        CTabItem wTab = new CTabItem(wTabFolder, 0);
        wTab.setText(this.getBaseMsg("AvroDialog.File.TabTitle"));
        Composite wTabComposite = new Composite((Composite)wTabFolder, 0);
        wTab.setControl((Control)wTabComposite);
        FormLayout formLayout = new FormLayout();
        formLayout.marginHeight = 15;
        wTabComposite.setLayout((Layout)formLayout);
        Label encodingLabel = new Label(wTabComposite, 0);
        encodingLabel.setText(this.getBaseMsg("AvroDialog.Encoding.Label"));
        encodingLabel.setLayoutData((Object)new FormDataBuilder().top().right(100, -15).left(0, 15).result());
        this.encodingCombo = new CCombo(wTabComposite, 2056);
        String[] availFormats = new String[]{BaseMessages.getString(PKG, (String)"AvroInputDialog.AvroFile.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"AvroInputDialog.JsonDatum.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"AvroInputDialog.BinaryDatum.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"AvroInputDialog.AvroFile.AlternateSchema.Label", (String[])new String[0])};
        this.encodingCombo.setItems(availFormats);
        this.encodingCombo.select(0);
        this.encodingCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AvroInputDialog.this.wSourceGroup.setVisible(AvroInputDialog.this.encodingCombo.getSelectionIndex() > 0);
            }
        });
        this.encodingCombo.setLayoutData((Object)new FormDataBuilder().top((Control)encodingLabel, 5).left(0, 15).right(0, 215).result());
        Group wFileSettingsGroup = new Group(wTabComposite, 32);
        wFileSettingsGroup.setText(this.getBaseMsg("AvroDialog.File.FileSettingsTitle"));
        FormLayout layout = new FormLayout();
        layout.marginHeight = 15;
        layout.marginWidth = 15;
        wFileSettingsGroup.setLayout((Layout)layout);
        wFileSettingsGroup.setLayoutData((Object)new FormDataBuilder().top((Control)encodingLabel, 35).left(0, 15).right(100, -15).result());
        Label separator = new Label((Composite)wFileSettingsGroup, 514);
        separator.setLayoutData((Object)new FormDataBuilder().left(0, 150).top().bottom().result());
        this.wbGetDataFromFile = new Button((Composite)wFileSettingsGroup, 16);
        this.wbGetDataFromFile.setText(this.getBaseMsg("AvroDialog.File.SpecifyFileName"));
        this.wbGetDataFromFile.setLayoutData((Object)new FormDataBuilder().left().top().width(150).result());
        this.wbGetDataFromField = new Button((Composite)wFileSettingsGroup, 16);
        this.wbGetDataFromField.setText(this.getBaseMsg("AvroDialog.File.GetDataFromField"));
        this.wbGetDataFromField.setLayoutData((Object)new FormDataBuilder().left().top((Control)this.wbGetDataFromFile, 10).width(150).result());
        Composite wFileSettingsDynamicArea = new Composite((Composite)wFileSettingsGroup, 0);
        FormLayout fileSettingsDynamicAreaLayout = new FormLayout();
        wFileSettingsDynamicArea.setLayout((Layout)fileSettingsDynamicAreaLayout);
        wFileSettingsDynamicArea.setLayoutData((Object)new FormDataBuilder().right().left((Control)this.wbGetDataFromFile, 15).top(0, -15).result());
        this.wDataFileComposite = new Composite(wFileSettingsDynamicArea, 0);
        this.wDataFileComposite.setLayout((Layout)new FormLayout());
        this.wDataFileComposite.setLayoutData((Object)new FormDataBuilder().left().right().top().result());
        this.addFileWidgets(this.wDataFileComposite, (Control)this.wDataFileComposite);
        this.wDataFieldComposite = new Composite(wFileSettingsDynamicArea, 0);
        FormLayout fieldNameLayout = new FormLayout();
        fieldNameLayout.marginHeight = 15;
        this.wDataFieldComposite.setLayout((Layout)fieldNameLayout);
        this.wDataFieldComposite.setLayoutData((Object)new FormDataBuilder().left().top().result());
        Label fieldNameLabel = new Label(this.wDataFieldComposite, 0);
        fieldNameLabel.setText(this.getBaseMsg("AvroDialog.FieldName.Label"));
        fieldNameLabel.setLayoutData((Object)new FormDataBuilder().left().top((Control)this.wDataFieldComposite, 0).result());
        this.wFieldNameCombo = new ComboVar((VariableSpace)this.transMeta, this.wDataFieldComposite, 18432);
        this.updateIncomingFieldList(this.wFieldNameCombo);
        this.wFieldNameCombo.setLayoutData((Object)new FormDataBuilder().left().top((Control)fieldNameLabel).width(250).result());
        SelectionAdapter fileSettingRadioSelectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AvroInputDialog.this.wDataFileComposite.setVisible(!AvroInputDialog.this.wbGetDataFromField.getSelection());
                AvroInputDialog.this.wDataFieldComposite.setVisible(AvroInputDialog.this.wbGetDataFromField.getSelection());
            }
        };
        this.wbGetDataFromFile.addSelectionListener((SelectionListener)fileSettingRadioSelectionAdapter);
        this.wbGetDataFromField.addSelectionListener((SelectionListener)fileSettingRadioSelectionAdapter);
        this.wbGetDataFromFile.setSelection(this.meta.getDataLocationType() == AvroInputMetaBase.LocationDescriptor.FILE_NAME);
        this.wbGetDataFromField.setSelection(this.meta.getDataLocationType() != AvroInputMetaBase.LocationDescriptor.FILE_NAME);
        fileSettingRadioSelectionAdapter.widgetSelected(null);
        this.wFieldNameCombo.setText(this.meta.getDataLocationType() != AvroInputMetaBase.LocationDescriptor.FIELD_NAME ? "" : this.meta.getDataLocation());
        this.wSourceGroup = new Group(wTabComposite, 32);
        this.wSourceGroup.setText(BaseMessages.getString(PKG, (String)"AvroInputDialog.Schema.SourceTitle", (String[])new String[0]));
        FormLayout schemaLayout = new FormLayout();
        schemaLayout.marginWidth = 15;
        schemaLayout.marginHeight = 15;
        this.wSourceGroup.setLayout((Layout)schemaLayout);
        this.wSourceGroup.setLayoutData((Object)new FormDataBuilder().top((Control)wFileSettingsGroup, 10).right(100, -15).left(0, 15).result());
        Label schemaSeparator = new Label((Composite)this.wSourceGroup, 514);
        schemaSeparator.setLayoutData((Object)new FormDataBuilder().left(0, 150).top().bottom().result());
        this.wbGetSchemaFromFile = new Button((Composite)this.wSourceGroup, 16);
        this.wbGetSchemaFromFile.setText(this.getBaseMsg("AvroDialog.File.SpecifyFileName"));
        this.wbGetSchemaFromFile.setLayoutData((Object)new FormDataBuilder().left().top().width(150).result());
        this.wbGetSchemaFromField = new Button((Composite)this.wSourceGroup, 16);
        this.wbGetSchemaFromField.setText(this.getBaseMsg("AvroDialog.File.GetDataFromField"));
        this.wbGetSchemaFromField.setLayoutData((Object)new FormDataBuilder().left().top((Control)this.wbGetSchemaFromFile, 10).width(150).result());
        Composite wSchemaSettingsDynamicArea = new Composite((Composite)this.wSourceGroup, 0);
        FormLayout fileSettingsDynamicAreaSchemaLayout = new FormLayout();
        wSchemaSettingsDynamicArea.setLayout((Layout)fileSettingsDynamicAreaSchemaLayout);
        wSchemaSettingsDynamicArea.setLayoutData((Object)new FormDataBuilder().right().left((Control)this.wbGetSchemaFromFile, 15).top(0, -15).result());
        this.wSchemaFileComposite = new Composite(wSchemaSettingsDynamicArea, 0);
        FormLayout schemaFileLayout = new FormLayout();
        this.wSchemaFileComposite.setLayout((Layout)schemaFileLayout);
        this.wSchemaFileComposite.setLayoutData((Object)new FormDataBuilder().left().right().top().result());
        Label wlSchemaPath = new Label(this.wSchemaFileComposite, 131072);
        wlSchemaPath.setText(BaseMessages.getString(PKG, (String)"AvroInputDialog.Schema.FileName", (String[])new String[0]));
        wlSchemaPath.setLayoutData((Object)new FormDataBuilder().left().top(0, 15).result());
        this.wbSchemaBrowse = new Button(this.wSchemaFileComposite, 8);
        this.wbSchemaBrowse.setText(BaseMessages.getString((String)"System.Button.Browse"));
        this.wbSchemaBrowse.setLayoutData((Object)new FormDataBuilder().top((Control)wlSchemaPath).right().result());
        this.wSchemaPath = new TextVar((VariableSpace)this.transMeta, this.wSchemaFileComposite, 18436);
        this.wSchemaPath.setLayoutData((Object)new FormDataBuilder().left().right((Control)this.wbSchemaBrowse, -5).top((Control)wlSchemaPath).result());
        this.wbSchemaBrowse.addSelectionListener((SelectionListener)new SelectionAdapterFileDialogTextVar((LogChannelInterface)this.log, this.wSchemaPath, (AbstractMeta)this.transMeta, new SelectionAdapterOptions(this.selectionOperation())));
        this.wSchemaFieldComposite = new Composite(wSchemaSettingsDynamicArea, 0);
        FormLayout schemaFieldLayout = new FormLayout();
        this.wSchemaFieldComposite.setLayout((Layout)schemaFieldLayout);
        this.wSchemaFieldComposite.setLayoutData((Object)new FormDataBuilder().left().right(100, 150).top().result());
        Label fieldNameSchemaLabel = new Label(this.wSchemaFieldComposite, 0);
        fieldNameSchemaLabel.setText(this.getBaseMsg("AvroDialog.FieldName.Label"));
        fieldNameSchemaLabel.setLayoutData((Object)new FormDataBuilder().left().top(0, 15).result());
        this.wSchemaFieldNameCombo = new ComboVar((VariableSpace)this.transMeta, this.wSchemaFieldComposite, 18432);
        this.updateIncomingFieldList(this.wSchemaFieldNameCombo);
        this.wSchemaFieldNameCombo.setLayoutData((Object)new FormDataBuilder().left().top((Control)fieldNameSchemaLabel).width(250).result());
        SelectionAdapter fileSettingRadioSelectionSchemaAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AvroInputDialog.this.wSchemaFileComposite.setVisible(!AvroInputDialog.this.wbGetSchemaFromField.getSelection());
                AvroInputDialog.this.wSchemaFieldComposite.setVisible(AvroInputDialog.this.wbGetSchemaFromField.getSelection());
            }
        };
        this.wbGetSchemaFromFile.addSelectionListener((SelectionListener)fileSettingRadioSelectionSchemaAdapter);
        this.wbGetSchemaFromField.addSelectionListener((SelectionListener)fileSettingRadioSelectionSchemaAdapter);
        this.wbGetSchemaFromFile.setSelection(true);
        this.wbGetSchemaFromField.setSelection(false);
        this.wSchemaFileComposite.setVisible(true);
        this.wSchemaFieldComposite.setVisible(false);
        this.wSourceGroup.setVisible(false);
    }

    @Override
    protected void getData() {
        AvroInputMeta avroInputMeta = (AvroInputMeta)this.getStepMeta();
        this.wPath.setText("");
        this.wFieldNameCombo.setText("");
        this.wSchemaPath.setText("");
        this.wbGetDataFromFile.setSelection(true);
        this.wbGetDataFromField.setSelection(false);
        this.wDataFileComposite.setVisible(true);
        this.wDataFieldComposite.setVisible(false);
        this.encodingCombo.select(avroInputMeta.getFormat());
        this.wbGetSchemaFromFile.setSelection(true);
        this.wbGetSchemaFromField.setSelection(false);
        this.wSchemaFileComposite.setVisible(true);
        this.wSchemaFieldComposite.setVisible(false);
        this.wSourceGroup.setVisible(avroInputMeta.getFormat() > 0);
        if (avroInputMeta.getDataLocation() != null) {
            if (avroInputMeta.getDataLocationType() == AvroInputMetaBase.LocationDescriptor.FILE_NAME) {
                this.wPath.setText(avroInputMeta.getDataLocation());
            } else if (avroInputMeta.getDataLocationType() == AvroInputMetaBase.LocationDescriptor.FIELD_NAME) {
                this.wFieldNameCombo.setText(avroInputMeta.getDataLocation());
                this.wbGetDataFromFile.setSelection(false);
                this.wbGetDataFromField.setSelection(true);
                this.wDataFileComposite.setVisible(false);
                this.wDataFieldComposite.setVisible(true);
            }
        }
        if (avroInputMeta.getSchemaLocation() != null) {
            if (avroInputMeta.getSchemaLocationType() == AvroInputMetaBase.LocationDescriptor.FILE_NAME) {
                this.wSchemaPath.setText(avroInputMeta.getSchemaLocation());
            } else if (avroInputMeta.getSchemaLocationType() == AvroInputMetaBase.LocationDescriptor.FIELD_NAME) {
                this.wSchemaFieldNameCombo.setText(avroInputMeta.getSchemaLocation());
                this.wbGetSchemaFromFile.setSelection(false);
                this.wbGetSchemaFromField.setSelection(true);
                this.wSchemaFileComposite.setVisible(false);
                this.wSchemaFieldComposite.setVisible(true);
            }
        }
        this.wPassThruFields.setSelection(avroInputMeta.passingThruFields);
        this.wAllowNullValues.setSelection(avroInputMeta.isAllowNullForMissingFields());
        int itemIndex = 0;
        for (AvroInputField inputField : avroInputMeta.getInputFields()) {
            TableItem item = itemIndex < this.wInputFields.table.getItemCount() ? this.wInputFields.table.getItem(itemIndex) : new TableItem(this.wInputFields.table, 0);
            if (inputField.getAvroFieldName() != null) {
                item.setText(1, inputField.getDisplayableAvroFieldName());
                item.setText(2, this.clearIndexFromFieldName(inputField.getDisplayableAvroFieldName()));
            }
            if (inputField.getAvroType() != null) {
                item.setText(3, inputField.getAvroType().getName());
            }
            if (inputField.getIndexedValues() != null) {
                item.setText(4, inputField.getIndexedValues());
            }
            if (inputField.getPentahoFieldName() != null) {
                item.setText(5, inputField.getPentahoFieldName());
            }
            if (inputField.getTypeDesc() != null) {
                item.setText(6, inputField.getTypeDesc());
            }
            if (inputField.getStringFormat() != null) {
                item.setText(7, inputField.getStringFormat());
            } else {
                item.setText(7, "");
            }
            ++itemIndex;
        }
        this.setVariableTableFields(avroInputMeta.getLookupFields());
    }

    protected void setVariableTableFields(List<AvroLookupField> fields) {
        this.wLookupView.clearAll();
        for (AvroLookupField f : fields) {
            TableItem item = new TableItem(this.wLookupView.table, 0);
            if (!Utils.isEmpty((CharSequence)f.fieldName)) {
                item.setText(1, f.fieldName);
            }
            if (!Utils.isEmpty((CharSequence)f.variableName)) {
                item.setText(2, f.variableName);
            }
            if (Utils.isEmpty((CharSequence)f.defaultValue)) continue;
            item.setText(3, f.defaultValue);
        }
        this.wLookupView.removeEmptyRows();
        this.wLookupView.setRowNums();
        this.wLookupView.optWidth(true);
    }

    @Override
    protected void getInfo(boolean preview) {
        if (this.wbGetDataFromField.getSelection()) {
            this.meta.setDataLocation(this.wFieldNameCombo.getText(), AvroInputMetaBase.LocationDescriptor.FIELD_NAME);
        } else {
            this.meta.setDataLocation(this.wPath.getText(), AvroInputMetaBase.LocationDescriptor.FILE_NAME);
        }
        if (this.wbGetSchemaFromField.getSelection()) {
            this.meta.setSchemaLocation(this.wSchemaFieldNameCombo.getText(), AvroInputMetaBase.LocationDescriptor.FIELD_NAME);
        } else {
            this.meta.setSchemaLocation(this.wSchemaPath.getText(), AvroInputMetaBase.LocationDescriptor.FILE_NAME);
            this.meta.setCacheSchemas(false);
        }
        this.meta.passingThruFields = this.wPassThruFields.getSelection();
        this.meta.setAllowNullForMissingFields(this.wAllowNullValues.getSelection());
        this.meta.setFormat(this.encodingCombo.getSelectionIndex());
        int nrFields = this.wInputFields.nrNonEmpty();
        this.meta.inputFields = new AvroInputField[nrFields];
        for (int i = 0; i < nrFields; ++i) {
            TableItem item = this.wInputFields.getNonEmpty(i);
            AvroInputField field = new AvroInputField();
            String formatFieldName = this.extractFieldName(item.getText(1));
            formatFieldName = this.fixPath(formatFieldName, item);
            field.setFormatFieldName(formatFieldName);
            field.setAvroType(item.getText(3));
            field.setIndexedValues(item.getText(4));
            field.setPentahoFieldName(item.getText(5));
            field.setPentahoType(ValueMetaFactory.getIdForValueMeta((String)item.getText(6)));
            field.setStringFormat(item.getText(7));
            this.meta.inputFields[i] = field;
        }
        nrFields = this.wLookupView.nrNonEmpty();
        if (nrFields > 0) {
            ArrayList<AvroLookupField> varFields = new ArrayList<AvroLookupField>();
            for (int i = 0; i < nrFields; ++i) {
                TableItem item = this.wLookupView.getNonEmpty(i);
                AvroLookupField newField = new AvroLookupField();
                boolean add = false;
                newField.fieldName = item.getText(1).trim();
                if (!Utils.isEmpty((CharSequence)item.getText(2))) {
                    newField.variableName = item.getText(2).trim();
                    add = true;
                    if (!Utils.isEmpty((CharSequence)item.getText(3))) {
                        newField.defaultValue = item.getText(3).trim();
                    }
                }
                if (!add) continue;
                varFields.add(newField);
            }
            this.meta.setLookupFields(varFields);
        }
    }

    private String fixPath(String formatFieldName, TableItem item) {
        String value = formatFieldName;
        Pattern p = Pattern.compile("\\[(.*?)\\]");
        Matcher m = p.matcher(value);
        while (m.find()) {
            if (m.end() - m.start() < 3) {
                value = new StringBuilder(value).insert(m.start() + 1, item.getText(4)).toString();
                continue;
            }
            value = value.replace(m.group(1), item.getText(4));
        }
        return value;
    }

    private String extractFieldName(String parquetNameTypeFromUI) {
        if (parquetNameTypeFromUI != null && parquetNameTypeFromUI.indexOf(40) >= 0) {
            return StringUtils.substringBefore((String)parquetNameTypeFromUI, (String)"(").trim();
        }
        return parquetNameTypeFromUI;
    }

    private void doPreview() {
        this.getInfo(true);
        TransMeta previewMeta = TransPreviewFactory.generatePreviewTransformation((VariableSpace)this.transMeta, (StepMetaInterface)this.meta, (String)this.wStepname.getText());
        this.transMeta.getVariable("Internal.Transformation.Filename.Directory");
        previewMeta.getVariable("Internal.Transformation.Filename.Directory");
        EnterNumberDialog numberDialog = new EnterNumberDialog(this.shell, this.props.getDefaultPreviewSize(), BaseMessages.getString(PKG, (String)"AvroInputDialog.PreviewSize.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"AvroInputDialog.PreviewSize.DialogMessage", (String[])new String[0]));
        int previewSize = numberDialog.open();
        if (previewSize > 0) {
            TransPreviewProgressDialog progressDialog = new TransPreviewProgressDialog(this.shell, previewMeta, new String[]{this.wStepname.getText()}, new int[]{previewSize});
            progressDialog.open();
            Trans trans = progressDialog.getTrans();
            String loggingText = progressDialog.getLoggingText();
            if (!progressDialog.isCancelled() && trans.getResult() != null && trans.getResult().getNrErrors() > 0L) {
                EnterTextDialog etd = new EnterTextDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Message", (String[])new String[0]), loggingText, true);
                etd.setReadOnly();
                etd.open();
            }
            PreviewRowsDialog prd = new PreviewRowsDialog(this.shell, (VariableSpace)this.transMeta, 0, this.wStepname.getText(), progressDialog.getPreviewRowsMeta(this.wStepname.getText()), progressDialog.getPreviewRows(this.wStepname.getText()), loggingText);
            prd.open();
        }
    }

    private String clearIndexFromFieldName(String fieldName) {
        String cleanFieldName = fieldName;
        int bracketPos = cleanFieldName.indexOf(91);
        if (bracketPos > -1) {
            int closeBracketPos = cleanFieldName.indexOf(93);
            cleanFieldName = cleanFieldName.substring(0, bracketPos + 1) + cleanFieldName.substring(closeBracketPos);
        }
        return cleanFieldName;
    }

    @Override
    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 2160);
        this.setShellImage(this.shell, (StepMetaInterface)this.meta);
        this.lsMod = e -> this.meta.setChanged();
        this.changed = this.meta.hasChanged();
        this.createUI();
        this.props.setLook((Control)this.shell);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                AvroInputDialog.this.cancel();
            }
        });
        int height = Math.max(this.getMinHeight((Composite)this.shell, this.getWidth()), this.getHeight());
        this.shell.setMinimumSize(this.getWidth(), height);
        this.shell.setSize(this.getWidth(), height);
        this.getData();
        this.shell.open();
        this.wStepname.setFocus();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    @Override
    protected int getWidth() {
        return 698;
    }

    @Override
    protected int getHeight() {
        return 554;
    }

    @Override
    protected String getStepTitle() {
        return BaseMessages.getString(PKG, (String)"AvroInputDialog.Shell.Title", (String[])new String[0]);
    }

    @Override
    protected Listener getPreview() {
        return e -> this.doPreview();
    }

    @Override
    protected SelectionOperation selectionOperation() {
        return SelectionOperation.FILE_OR_FOLDER;
    }
}

