/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.formats.impl.avro.input;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.big.data.kettle.plugins.formats.avro.input.AvroInputField;
import org.pentaho.big.data.kettle.plugins.formats.avro.input.AvroInputMetaBase;
import org.pentaho.big.data.kettle.plugins.formats.avro.input.AvroLookupField;
import org.pentaho.big.data.kettle.plugins.formats.impl.avro.input.AvroInputData;
import org.pentaho.big.data.kettle.plugins.formats.impl.avro.input.AvroInputMeta;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.file.IBaseFileInputReader;
import org.pentaho.hadoop.shim.api.cluster.ClusterInitializationException;
import org.pentaho.hadoop.shim.api.cluster.NamedCluster;
import org.pentaho.hadoop.shim.api.cluster.NamedClusterServiceLocator;
import org.pentaho.hadoop.shim.api.format.FormatService;
import org.pentaho.hadoop.shim.api.format.IAvroInputField;
import org.pentaho.hadoop.shim.api.format.IAvroLookupField;
import org.pentaho.hadoop.shim.api.format.IPentahoAvroInputFormat;

public class AvroInput
extends BaseStep {
    private Object[] inputToStepRow;
    protected AvroInputMeta meta;
    protected AvroInputData data;

    public AvroInput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    private IndexedLookupField resolveLookupField(IAvroLookupField lookupField) {
        IndexedLookupField indexedLookupField = new IndexedLookupField();
        RowMetaInterface inputRowMeta = this.getInputRowMeta();
        int index = inputRowMeta.indexOfValue(lookupField.getFieldName());
        if (index < 0) {
            return null;
        }
        indexedLookupField.setIndex(index);
        String variableName = lookupField.getVariableName();
        if (Utils.isEmpty((CharSequence)variableName)) {
            return null;
        }
        indexedLookupField.setVariableName(variableName.replaceAll("\\.", "_"));
        indexedLookupField.setFieldName(this.environmentSubstitute(lookupField.getFieldName()));
        indexedLookupField.setDefaultValue(this.environmentSubstitute(lookupField.getDefaultValue()));
        return indexedLookupField;
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (AvroInputMeta)smi;
        this.data = (AvroInputData)sdi;
        do {
            try {
                if ((this.data.input == null || this.data.reader == null || this.data.rowIterator == null) && !this.initializeSource()) break;
                if (this.data.rowIterator.hasNext()) {
                    this.updateVariableSpaceWithLookupFields(this.getInputRowMeta());
                    RowMetaAndData row = this.data.rowIterator.next();
                    this.putRow(row.getRowMeta(), row.getData());
                    return true;
                }
                this.fileFinishedHousekeeping();
            }
            catch (KettleException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new KettleException((Throwable)ex);
            }
        } while (this.meta.getDataLocationType() == AvroInputMetaBase.LocationDescriptor.FIELD_NAME);
        this.setOutputDone();
        return false;
    }

    private void updateVariableSpaceWithLookupFields(RowMetaInterface rowMeta) {
        for (IAvroLookupField lookupField : this.data.input.getLookupFields()) {
            String valueToSet = "";
            try {
                ValueMetaInterface valueMeta = rowMeta.getValueMeta(((IndexedLookupField)lookupField).getIndex());
                valueToSet = valueMeta.isNull(this.inputToStepRow[((IndexedLookupField)lookupField).getIndex()]) ? (!Utils.isEmpty((CharSequence)lookupField.getDefaultValue()) ? lookupField.getDefaultValue() : "null") : valueMeta.getString(this.inputToStepRow[((IndexedLookupField)lookupField).getIndex()]);
            }
            catch (Exception e) {
                valueToSet = "null";
            }
            this.setVariable(lookupField.getVariableName(), valueToSet);
        }
    }

    private void fileFinishedHousekeeping() {
        try {
            if (this.data.reader != null) {
                this.data.reader.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.data.reader = null;
        this.data.input = null;
    }

    public static List<? extends IAvroInputField> getLeafFields(NamedClusterServiceLocator namedClusterServiceLocator, NamedCluster namedCluster, String schemaPath, String dataPath, VariableSpace variableSpace) throws Exception {
        FormatService formatService = (FormatService)namedClusterServiceLocator.getService(namedCluster, FormatService.class);
        IPentahoAvroInputFormat in = (IPentahoAvroInputFormat)formatService.createInputFormat(IPentahoAvroInputFormat.class, namedCluster);
        in.setVariableSpace(variableSpace);
        in.setInputSchemaFile(schemaPath);
        in.setInputFile(dataPath);
        return in.getLeafFields();
    }

    private boolean initializeSource() throws Exception {
        FormatService formatService;
        try {
            formatService = (FormatService)this.meta.getNamedClusterResolver().getNamedClusterServiceLocator().getService(this.getNamedCluster(), FormatService.class);
            this.inputToStepRow = this.getRow();
            if (this.inputToStepRow == null && this.meta.getDataLocationType() == AvroInputMetaBase.LocationDescriptor.FIELD_NAME) {
                this.fileFinishedHousekeeping();
                return false;
            }
        }
        catch (ClusterInitializationException e) {
            throw new KettleException("can't get service format shim ", (Throwable)e);
        }
        if (this.meta.getDataLocation() == null) {
            throw new KettleException("No data location defined");
        }
        Object outRowMeta = null;
        outRowMeta = this.getInputRowMeta();
        outRowMeta = outRowMeta != null ? outRowMeta.clone() : new RowMeta();
        this.data.input = (IPentahoAvroInputFormat)formatService.createInputFormat(IPentahoAvroInputFormat.class, this.getNamedCluster());
        this.meta.getFields((RowMetaInterface)outRowMeta, this.getStepname(), null, null, (VariableSpace)this, null, null);
        this.data.input.setIncomingRowMeta(this.getInputRowMeta());
        this.data.input.setOutputRowMeta(outRowMeta);
        Boolean isDatum = false;
        Boolean useFieldAsSchema = false;
        String inputSchemaFileName = null;
        String inputFileName = null;
        this.data.input.setVariableSpace((VariableSpace)this.getTransMeta());
        AvroInputMetaBase.SourceFormat sourceFormat = AvroInputMetaBase.SourceFormat.values[this.meta.getFormat()];
        if (sourceFormat == AvroInputMetaBase.SourceFormat.DATUM_BINARY || sourceFormat == AvroInputMetaBase.SourceFormat.DATUM_JSON) {
            isDatum = true;
        }
        if (sourceFormat != AvroInputMetaBase.SourceFormat.DATUM_JSON) {
            this.data.input.setIsDataBinaryEncoded(true);
        }
        if (this.meta.getDataLocationType() == AvroInputMetaBase.LocationDescriptor.FILE_NAME) {
            inputFileName = this.meta.getParentStepMeta().getParentTransMeta().environmentSubstitute(this.meta.getDataLocation());
        }
        if (this.meta.getSchemaLocationType() == AvroInputMetaBase.LocationDescriptor.FILE_NAME) {
            inputSchemaFileName = this.meta.getParentStepMeta().getParentTransMeta().environmentSubstitute(this.meta.getSchemaLocation());
            this.data.input.setInputSchemaFile(inputSchemaFileName);
        } else {
            useFieldAsSchema = true;
            this.data.input.setSchemaFieldName(this.meta.getSchemaLocation());
        }
        this.data.input.setDatum(isDatum.booleanValue());
        this.data.input.setUseFieldAsSchema(useFieldAsSchema.booleanValue());
        if (!isDatum.booleanValue() && inputFileName != null) {
            this.checkForLegacyFieldNames(inputSchemaFileName, inputFileName);
        }
        this.data.input.setInputFields(Arrays.asList(this.meta.getInputFields()));
        ArrayList<IndexedLookupField> lookupFields = new ArrayList<IndexedLookupField>();
        if (this.getInputRowMeta() != null) {
            for (AvroLookupField lookupField : this.meta.getLookupFields()) {
                IndexedLookupField indexedLookupField = this.resolveLookupField((IAvroLookupField)lookupField);
                if (indexedLookupField == null) continue;
                lookupFields.add(indexedLookupField);
            }
        }
        this.data.input.setLookupFields(lookupFields);
        if (inputFileName != null) {
            this.data.input.setInputFile(inputFileName);
            this.data.input.setInputStreamFieldName(null);
        } else if (this.meta.getDataLocationType() == AvroInputMetaBase.LocationDescriptor.FIELD_NAME) {
            this.data.input.setInputStreamFieldName(this.meta.getDataLocation());
            this.data.input.setUseFieldAsInputStream(true);
            int fieldIndex = this.getInputRowMeta().indexOfValue(this.data.input.getInputStreamFieldName());
            if (fieldIndex == -1) {
                throw new KettleException("Field '" + this.data.input.getInputStreamFieldName() + "' was not found in step's input fields");
            }
            this.data.input.setInputStream((InputStream)new ByteArrayInputStream(this.getInputRowMeta().getBinary(this.inputToStepRow, fieldIndex)));
        } else {
            throw new KettleException("Unknown field location type");
        }
        this.data.input.setIncomingFields(this.inputToStepRow);
        this.data.reader = this.data.input.createRecordReader(null);
        this.data.rowIterator = this.data.reader.iterator();
        return true;
    }

    private NamedCluster getNamedCluster() {
        return this.meta.getNamedClusterResolver().resolveNamedCluster(this.environmentSubstitute(this.meta.getDataLocation()));
    }

    public void checkForLegacyFieldNames(String schemaFileName, String avroFileName) {
        try {
            if (!this.data.input.isUseFieldAsInputStream()) {
                List<? extends IAvroInputField> rawAvroFields = AvroInput.getLeafFields(this.meta.getNamedClusterResolver().getNamedClusterServiceLocator(), this.getNamedCluster(), schemaFileName, avroFileName, (VariableSpace)this.getTransMeta());
                HashMap<String, String> hackedFieldNames = new HashMap<String, String>();
                for (IAvroInputField iAvroInputField : rawAvroFields) {
                    String fieldName = iAvroInputField.getAvroFieldName();
                    int pointer = fieldName.indexOf("_delimiter_");
                    if (pointer < 0) continue;
                    hackedFieldNames.put(fieldName.substring(0, pointer), fieldName);
                }
                if (hackedFieldNames.size() > 0) {
                    rawAvroFields.stream().forEach(rawField -> {
                        if (hackedFieldNames.containsKey(rawField.getAvroFieldName())) {
                            hackedFieldNames.remove(rawField.getAvroFieldName());
                        }
                    });
                }
                if (hackedFieldNames.size() > 0) {
                    for (AvroInputField field : this.meta.getInputFields()) {
                        if (!hackedFieldNames.containsKey(field.getName())) continue;
                        field.setAvroFieldName((String)hackedFieldNames.get(field.getName()));
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected boolean init() {
        return true;
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        if (this.getTransMeta().getNamedClusterEmbedManager() != null) {
            this.getTransMeta().getNamedClusterEmbedManager().passEmbeddedMetastoreKey((VariableSpace)this.getTransMeta(), this.getTransMeta().getEmbeddedMetastoreProviderKey());
        }
        return super.init(smi, sdi);
    }

    protected IBaseFileInputReader createReader(AvroInputMeta meta, AvroInputData data, FileObject file) throws Exception {
        return null;
    }

    public class IndexedLookupField
    extends AvroLookupField {
        int index = -1;

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }
    }
}

