/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.formats.impl;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.osgi.api.MetastoreLocatorOsgi;
import org.pentaho.hadoop.shim.api.cluster.NamedCluster;
import org.pentaho.hadoop.shim.api.cluster.NamedClusterService;
import org.pentaho.hadoop.shim.api.cluster.NamedClusterServiceLocator;

public class NamedClusterResolver {
    private final NamedClusterServiceLocator namedClusterServiceLocator;
    private final NamedClusterService namedClusterService;
    private MetastoreLocatorOsgi metaStoreService;
    private static final LogChannelInterface LOG = LogChannel.GENERAL;

    public NamedClusterResolver(NamedClusterServiceLocator namedClusterServiceLocator, NamedClusterService namedClusterService, MetastoreLocatorOsgi metaStore) {
        this.namedClusterServiceLocator = namedClusterServiceLocator;
        this.namedClusterService = namedClusterService;
        this.metaStoreService = metaStore;
    }

    public NamedCluster resolveNamedCluster(String fileName) {
        return this.resolveNamedCluster(fileName, null);
    }

    public NamedCluster resolveNamedCluster(String fileName, String embeddedMetastoreKey) {
        NamedCluster namedCluster = null;
        Optional<URI> uri = this.fileUri(fileName);
        if (uri.isPresent()) {
            String scheme = uri.get().getScheme();
            String hostName = uri.get().getHost();
            if (scheme != null && scheme.equals("hc")) {
                namedCluster = this.namedClusterService.getNamedClusterByName(hostName, this.metaStoreService.getMetastore());
                if (namedCluster == null && embeddedMetastoreKey != null) {
                    namedCluster = this.namedClusterService.getNamedClusterByName(hostName, this.metaStoreService.getExplicitMetastore(embeddedMetastoreKey));
                }
            } else {
                namedCluster = this.namedClusterService.getNamedClusterByHost(hostName, this.metaStoreService.getMetastore(embeddedMetastoreKey));
                if (namedCluster == null && embeddedMetastoreKey != null) {
                    namedCluster = this.namedClusterService.getNamedClusterByHost(hostName, this.metaStoreService.getExplicitMetastore(embeddedMetastoreKey));
                }
            }
        }
        return namedCluster;
    }

    private Optional<URI> fileUri(String fileName) {
        try {
            return Optional.of(new URI(fileName));
        }
        catch (URISyntaxException e) {
            LOG.logDebug(String.format("Couldn't parse %s as a URI.", fileName));
            return Optional.empty();
        }
    }

    public NamedClusterServiceLocator getNamedClusterServiceLocator() {
        return this.namedClusterServiceLocator;
    }
}

