/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.hbase.rowdecoder;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.big.data.kettle.plugins.hbase.MappingDefinition;
import org.pentaho.big.data.kettle.plugins.hbase.NamedClusterLoadSaveUtil;
import org.pentaho.big.data.kettle.plugins.hbase.mapping.MappingUtils;
import org.pentaho.big.data.kettle.plugins.hbase.rowdecoder.HBaseRowDecoder;
import org.pentaho.big.data.kettle.plugins.hbase.rowdecoder.HBaseRowDecoderData;
import org.pentaho.big.data.kettle.plugins.hbase.rowdecoder.HBaseRowDecoderDialog;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.annotations.Step;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.injection.Injection;
import org.pentaho.di.core.injection.InjectionDeep;
import org.pentaho.di.core.injection.InjectionSupported;
import org.pentaho.di.core.osgi.api.MetastoreLocatorOsgi;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaBase;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.hadoop.shim.api.cluster.ClusterInitializationException;
import org.pentaho.hadoop.shim.api.cluster.NamedCluster;
import org.pentaho.hadoop.shim.api.cluster.NamedClusterService;
import org.pentaho.hadoop.shim.api.cluster.NamedClusterServiceLocator;
import org.pentaho.hadoop.shim.api.hbase.HBaseService;
import org.pentaho.hadoop.shim.api.hbase.mapping.Mapping;
import org.pentaho.hadoop.shim.api.hbase.meta.HBaseValueMetaInterface;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.runtime.test.RuntimeTester;
import org.pentaho.runtime.test.action.RuntimeTestActionService;
import org.w3c.dom.Node;

@Step(id="HBaseRowDecoder", image="HBRD.svg", name="HBaseRowDecoder.Name", description="HBaseRowDecoder.Description", categoryDescription="i18n:org.pentaho.di.trans.step:BaseStep.Category.BigData", documentationUrl="Products/HBase_Row_Decoder", i18nPackageName="org.pentaho.di.trans.steps.hbaserowdecoder")
@InjectionSupported(localizationPrefix="HBaseRowDecoder.Injection.", groups={"MAPPING"})
public class HBaseRowDecoderMeta
extends BaseStepMeta
implements StepMetaInterface {
    public static final String INCOMING_KEY_FIELD = "incoming_key_field";
    public static final String INCOMING_RESULT_FIELD = "incoming_result_field";
    protected NamedCluster namedCluster;
    @Injection(name="KEY_FIELD")
    protected String mIncomingKeyField = "";
    @Injection(name="HBASE_RESULT_FIELD")
    protected String mIncomingResultField = "";
    protected Mapping mMapping;
    @InjectionDeep
    protected MappingDefinition mappingDefinition;
    private MetastoreLocatorOsgi metaStoreService;
    private final NamedClusterServiceLocator namedClusterServiceLocator;
    private final NamedClusterService namedClusterService;
    private final RuntimeTestActionService runtimeTestActionService;
    private final RuntimeTester runtimeTester;
    private final NamedClusterLoadSaveUtil namedClusterLoadSaveUtil;

    public HBaseRowDecoderMeta(NamedClusterServiceLocator namedClusterServiceLocator, NamedClusterService namedClusterService, RuntimeTestActionService runtimeTestActionService, RuntimeTester runtimeTester, MetastoreLocatorOsgi metaStore) {
        this.namedClusterServiceLocator = namedClusterServiceLocator;
        this.namedClusterService = namedClusterService;
        this.runtimeTestActionService = runtimeTestActionService;
        this.runtimeTester = runtimeTester;
        this.namedClusterLoadSaveUtil = new NamedClusterLoadSaveUtil();
        this.metaStoreService = metaStore;
    }

    public void setNamedCluster(NamedCluster namedCluster) {
        this.namedCluster = namedCluster;
    }

    public NamedCluster getNamedCluster() {
        return this.namedCluster;
    }

    public void setIncomingKeyField(String inKey) {
        this.mIncomingKeyField = inKey;
    }

    public String getIncomingKeyField() {
        return this.mIncomingKeyField;
    }

    public void setIncomingResultField(String inResult) {
        this.mIncomingResultField = inResult;
    }

    public String getIncomingResultField() {
        return this.mIncomingResultField;
    }

    public void setMapping(Mapping m) {
        this.mMapping = m;
    }

    public Mapping getMapping() {
        return this.mMapping;
    }

    public MappingDefinition getMappingDefinition() {
        return this.mappingDefinition;
    }

    public void setMappingDefinition(MappingDefinition mappingDefinition) {
        this.mappingDefinition = mappingDefinition;
    }

    public void setDefault() {
        this.mIncomingKeyField = "";
        this.mIncomingResultField = "";
        this.namedCluster = this.namedClusterService.getClusterTemplate();
    }

    public void getFields(RowMetaInterface rowMeta, String origin, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) throws KettleStepException {
        rowMeta.clear();
        if (this.mMapping != null) {
            int kettleType = this.mMapping.getKeyType() == Mapping.KeyType.DATE || this.mMapping.getKeyType() == Mapping.KeyType.UNSIGNED_DATE ? 3 : (this.mMapping.getKeyType() == Mapping.KeyType.STRING ? 2 : (this.mMapping.getKeyType() == Mapping.KeyType.BINARY ? 8 : 5));
            ValueMetaBase keyMeta = new ValueMetaBase(this.mMapping.getKeyName(), kettleType);
            keyMeta.setOrigin(origin);
            rowMeta.addValueMeta((ValueMetaInterface)keyMeta);
            Map mappedColumnsByAlias = this.mMapping.getMappedColumns();
            Set aliasSet = mappedColumnsByAlias.keySet();
            for (String alias : aliasSet) {
                HBaseValueMetaInterface columnMeta = (HBaseValueMetaInterface)mappedColumnsByAlias.get(alias);
                columnMeta.setOrigin(origin);
                rowMeta.addValueMeta((ValueMetaInterface)columnMeta);
            }
        }
    }

    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        CheckResult cr;
        if (prev == null || prev.size() == 0) {
            cr = new CheckResult(3, "Not receiving any fields from previous steps!", (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, "Step is connected to previous one, receiving " + prev.size() + " fields", (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, "Step is receiving info from other steps.", (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, "No input received from other steps!", (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    void applyInjection() throws KettleException {
        if (this.namedCluster == null) {
            throw new KettleException("Named cluster was not initialized!");
        }
        try {
            HBaseService hBaseService = (HBaseService)this.namedClusterServiceLocator.getService(this.namedCluster, HBaseService.class);
            Mapping tempMapping = null;
            if (this.mappingDefinition != null) {
                this.mMapping = tempMapping = MappingUtils.getMapping(this.mappingDefinition, hBaseService);
            }
        }
        catch (ClusterInitializationException e) {
            throw new KettleException((Throwable)e);
        }
    }

    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        return new HBaseRowDecoder(stepMeta, stepDataInterface, copyNr, transMeta, trans, this.namedClusterServiceLocator);
    }

    public StepDataInterface getStepData() {
        return new HBaseRowDecoderData();
    }

    public String getXML() {
        try {
            this.applyInjection();
        }
        catch (KettleException e) {
            this.log.logError("Error occurred while injecting metadata. Transformation meta could be incorrect!", (Throwable)e);
        }
        StringBuilder retval = new StringBuilder();
        if (StringUtils.isNotEmpty((String)this.mIncomingKeyField)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)INCOMING_KEY_FIELD, (String)this.mIncomingKeyField));
        }
        if (StringUtils.isNotEmpty((String)this.mIncomingResultField)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)INCOMING_RESULT_FIELD, (String)this.mIncomingResultField));
        }
        this.namedClusterLoadSaveUtil.getXml(retval, this.namedClusterService, this.namedCluster, this.repository == null ? null : this.repository.getMetaStore(), this.log);
        if (this.mMapping != null) {
            retval.append(this.mMapping.getXML());
        }
        return retval.toString();
    }

    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        if (metaStore == null) {
            metaStore = this.metaStoreService.getMetastore();
        }
        this.mIncomingKeyField = XMLHandler.getTagValue((Node)stepnode, (String)INCOMING_KEY_FIELD);
        this.mIncomingResultField = XMLHandler.getTagValue((Node)stepnode, (String)INCOMING_RESULT_FIELD);
        this.namedCluster = this.namedClusterLoadSaveUtil.loadClusterConfig(this.namedClusterService, null, this.repository, metaStore, stepnode, this.log);
        try {
            HBaseService hbaseService = (HBaseService)this.namedClusterServiceLocator.getService(this.namedCluster, HBaseService.class);
            this.mMapping = hbaseService == null ? null : hbaseService.getMappingFactory().createMapping();
        }
        catch (ClusterInitializationException e) {
            throw new KettleXMLException((Throwable)e);
        }
        if (this.mMapping != null) {
            this.mMapping.loadXML(stepnode);
        }
    }

    public void readRep(Repository rep, IMetaStore metaStore, ObjectId idStep, List<DatabaseMeta> databases) throws KettleException {
        this.mIncomingKeyField = rep.getStepAttributeString(idStep, 0, INCOMING_KEY_FIELD);
        this.mIncomingResultField = rep.getStepAttributeString(idStep, 0, INCOMING_RESULT_FIELD);
        this.namedCluster = this.namedClusterLoadSaveUtil.loadClusterConfig(this.namedClusterService, idStep, rep, metaStore, null, this.log);
        try {
            this.mMapping = ((HBaseService)this.namedClusterServiceLocator.getService(this.namedCluster, HBaseService.class)).getMappingFactory().createMapping();
        }
        catch (ClusterInitializationException e) {
            throw new KettleXMLException((Throwable)e);
        }
        this.mMapping.readRep(rep, idStep);
    }

    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId idTransformation, ObjectId idStep) throws KettleException {
        if (StringUtils.isNotEmpty((String)this.mIncomingKeyField)) {
            rep.saveStepAttribute(idTransformation, idStep, 0, INCOMING_KEY_FIELD, this.mIncomingKeyField);
        }
        if (StringUtils.isNotEmpty((String)this.mIncomingResultField)) {
            rep.saveStepAttribute(idTransformation, idStep, 0, INCOMING_RESULT_FIELD, this.mIncomingResultField);
        }
        this.namedClusterLoadSaveUtil.saveRep(rep, metaStore, idTransformation, idStep, this.namedClusterService, this.namedCluster, this.log);
        if (this.mMapping != null) {
            this.mMapping.saveRep(rep, idTransformation, idStep);
        }
    }

    public StepDialogInterface getDialog(Shell shell, StepMetaInterface meta, TransMeta transMeta, String name) {
        return new HBaseRowDecoderDialog(shell, meta, transMeta, name, this.namedClusterService, this.runtimeTestActionService, this.runtimeTester, this.namedClusterServiceLocator);
    }
}

