/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.hbase.rowdecoder;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.pentaho.big.data.kettle.plugins.hbase.mapping.HBaseRowToKettleTuple;
import org.pentaho.big.data.kettle.plugins.hbase.rowdecoder.HBaseRowDecoderData;
import org.pentaho.big.data.kettle.plugins.hbase.rowdecoder.HBaseRowDecoderMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.hadoop.shim.api.cluster.NamedClusterServiceLocator;
import org.pentaho.hadoop.shim.api.hbase.ByteConversionUtil;
import org.pentaho.hadoop.shim.api.hbase.HBaseService;
import org.pentaho.hadoop.shim.api.hbase.mapping.Mapping;
import org.pentaho.hadoop.shim.api.hbase.meta.HBaseValueMetaInterface;

public class HBaseRowDecoder
extends BaseStep
implements StepInterface {
    public static final String HBASE_ROW_DECODER_ERROR_NOT_RESULT = "HBaseRowDecoder.Error.NotResult";
    public static final String HBASE_ROW_DECODER_ERROR_NOT_IMMUTABLE_BYTES_WRITABLE = "HBaseRowDecoder.Error.NotImmutableBytesWritable";
    private static Class<?> hBaseRowDecoderMetaClass = HBaseRowDecoderMeta.class;
    private final NamedClusterServiceLocator namedClusterServiceLocator;
    protected HBaseRowDecoderMeta hBaseRowDecoderMeta;
    protected HBaseRowDecoderData hBaseRowDecoderData;
    private HBaseService hBaseService;
    protected Mapping mTableMapping;
    protected HBaseValueMetaInterface[] mOutputColumns;
    protected int mKeyInIndex = -1;
    protected int mResultInIndex = -1;
    protected HBaseRowToKettleTuple mTupleHandler;
    protected ByteConversionUtil mBytesUtil;

    public HBaseRowDecoder(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans, NamedClusterServiceLocator namedClusterServiceLocator) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
        this.namedClusterServiceLocator = namedClusterServiceLocator;
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        Object[] inputRow = this.getRow();
        if (inputRow == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            this.hBaseRowDecoderMeta = (HBaseRowDecoderMeta)smi;
            this.hBaseRowDecoderData = (HBaseRowDecoderData)sdi;
            try {
                this.hBaseService = (HBaseService)this.namedClusterServiceLocator.getService(this.hBaseRowDecoderMeta.getNamedCluster(), HBaseService.class);
                this.mBytesUtil = this.hBaseService.getByteConversionUtil();
            }
            catch (Exception ex) {
                throw new KettleException(ex.getMessage(), (Throwable)ex);
            }
            this.mTableMapping = this.hBaseRowDecoderMeta.getMapping();
            if (this.mTableMapping == null || StringUtils.isEmpty((String)this.mTableMapping.getKeyName())) {
                throw new KettleException(BaseMessages.getString(hBaseRowDecoderMetaClass, (String)"HBaseRowDecoder.Error.NoMappingInfo", (String[])new String[0]));
            }
            if (this.mTableMapping.isTupleMapping()) {
                this.mTupleHandler = new HBaseRowToKettleTuple(this.mBytesUtil);
            }
            this.mOutputColumns = new HBaseValueMetaInterface[this.mTableMapping.getMappedColumns().keySet().size()];
            int k = 0;
            for (String alias : this.mTableMapping.getMappedColumns().keySet()) {
                this.mOutputColumns[k++] = (HBaseValueMetaInterface)this.mTableMapping.getMappedColumns().get(alias);
            }
            this.hBaseRowDecoderData.setOutputRowMeta(this.getInputRowMeta().clone());
            this.hBaseRowDecoderMeta.getFields(this.hBaseRowDecoderData.getOutputRowMeta(), this.getStepname(), null, null, (VariableSpace)this);
            RowMetaInterface inputMeta = this.getInputRowMeta();
            String inKey = this.environmentSubstitute(this.hBaseRowDecoderMeta.getIncomingKeyField());
            this.mKeyInIndex = inputMeta.indexOfValue(inKey);
            if (this.mKeyInIndex == -1) {
                throw new KettleException(BaseMessages.getString(hBaseRowDecoderMetaClass, (String)"HBaseRowDecoder.Error.UnableToFindHBaseKey", (String[])new String[]{inKey}));
            }
            try {
                inputRow[this.mKeyInIndex] = this.mBytesUtil.convertToImmutableBytesWritable(inputRow[this.mKeyInIndex]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new KettleException(BaseMessages.getString(hBaseRowDecoderMetaClass, (String)HBASE_ROW_DECODER_ERROR_NOT_IMMUTABLE_BYTES_WRITABLE, (String[])new String[]{this.hBaseRowDecoderMeta.getIncomingKeyField()}));
            }
            if (!this.mBytesUtil.isImmutableBytesWritable(inputRow[this.mKeyInIndex])) {
                throw new KettleException(BaseMessages.getString(hBaseRowDecoderMetaClass, (String)HBASE_ROW_DECODER_ERROR_NOT_IMMUTABLE_BYTES_WRITABLE, (String[])new String[]{this.hBaseRowDecoderMeta.getIncomingKeyField()}));
            }
            String inResult = this.environmentSubstitute(this.hBaseRowDecoderMeta.getIncomingResultField());
            this.mResultInIndex = inputMeta.indexOfValue(inResult);
            if (this.mResultInIndex == -1) {
                throw new KettleException(BaseMessages.getString(hBaseRowDecoderMetaClass, (String)"HBaseRowDecoder.Error.UnableToFindHBaseRow", (String[])new String[]{inResult}));
            }
        }
        try {
            inputRow[this.mKeyInIndex] = this.mBytesUtil.convertToImmutableBytesWritable(inputRow[this.mKeyInIndex]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new KettleException(BaseMessages.getString(hBaseRowDecoderMetaClass, (String)HBASE_ROW_DECODER_ERROR_NOT_IMMUTABLE_BYTES_WRITABLE, (String[])new String[]{this.hBaseRowDecoderMeta.getIncomingKeyField()}));
        }
        Object hRow = inputRow[this.mResultInIndex];
        if (inputRow[this.mKeyInIndex] != null && hRow != null) {
            if (this.mTableMapping.isTupleMapping()) {
                List<Object[]> hrowToKettleRow = this.mTupleHandler.hbaseRowToKettleTupleMode(this.hBaseService.getHBaseValueMetaInterfaceFactory(), hRow, this.mTableMapping, this.mTableMapping.getMappedColumns(), this.hBaseRowDecoderData.getOutputRowMeta());
                for (Object[] tuple : hrowToKettleRow) {
                    this.putRow(this.hBaseRowDecoderData.getOutputRowMeta(), tuple);
                }
            } else {
                Object decodedKey;
                Object[] outputRowData = RowDataUtil.allocateRowData((int)(this.mOutputColumns.length + 1));
                byte[] rowKey = null;
                try {
                    rowKey = (byte[])hRow.getClass().getMethod("getRow", new Class[0]).invoke(hRow, new Object[0]);
                }
                catch (Exception ex) {
                    throw new KettleException(BaseMessages.getString(hBaseRowDecoderMetaClass, (String)"HBaseRowDecoder.Error.UnableToGetRowKey", (String[])new String[0]), (Throwable)ex);
                }
                outputRowData[0] = decodedKey = this.mTableMapping.decodeKeyValue(rowKey);
                for (int i = 0; i < this.mOutputColumns.length; ++i) {
                    Object decodedVal;
                    HBaseValueMetaInterface current = this.mOutputColumns[i];
                    byte[] colFamilyName = current.getColumnFamily().getBytes();
                    byte[] qualifier = current.getColumnName().getBytes();
                    byte[] kv = null;
                    try {
                        kv = (byte[])hRow.getClass().getMethod("getValue", byte[].class, byte[].class).invoke(hRow, colFamilyName, qualifier);
                    }
                    catch (Exception ex) {
                        throw new KettleException(BaseMessages.getString(hBaseRowDecoderMetaClass, (String)"HBaseRowDecoder.Error.UnableToGetColumnValue", (String[])new String[0]), (Throwable)ex);
                    }
                    outputRowData[i + 1] = decodedVal = current.decodeColumnValue(kv == null ? null : kv);
                }
                this.putRow(this.hBaseRowDecoderData.getOutputRowMeta(), outputRowData);
            }
        }
        return true;
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        if (super.init(smi, sdi)) {
            HBaseRowDecoderMeta meta = (HBaseRowDecoderMeta)smi;
            try {
                meta.applyInjection();
                return true;
            }
            catch (KettleException e) {
                this.logError("Error while injecting properties", e);
            }
        }
        return false;
    }
}

